// ui/accessibility/mojom/ax_event_intent.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_event_intent.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_event_intent.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/ax_enums.mojom-forward.h"
#include <string>
#include <vector>




#include "ui/accessibility/mojom/ax_event_intent_mojom_traits.h"




namespace ax::mojom {





class  EventIntent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EventIntent, T>::value>;
  using DataView = EventIntentDataView;
  using Data_ = internal::EventIntent_Data;

  template <typename... Args>
  static EventIntentPtr New(Args&&... args) {
    return EventIntentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventIntentPtr From(const U& u) {
    return mojo::TypeConverter<EventIntentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventIntent>::Convert(*this);
  }


  EventIntent();

  EventIntent(
      ::ax::mojom::Command command,
      ::ax::mojom::InputEventType input_event_type,
      ::ax::mojom::TextBoundary text_boundary,
      ::ax::mojom::MoveDirection move_direction);


  ~EventIntent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventIntentPtr>
  EventIntentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EventIntent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EventIntent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EventIntent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventIntent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventIntent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventIntent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EventIntent_UnserializedMessageContext<
            UserType, EventIntent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EventIntent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EventIntent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EventIntent_UnserializedMessageContext<
            UserType, EventIntent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EventIntent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ax::mojom::Command command;
  
  ::ax::mojom::InputEventType input_event_type;
  
  ::ax::mojom::TextBoundary text_boundary;
  
  ::ax::mojom::MoveDirection move_direction;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EventIntent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EventIntent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EventIntent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EventIntent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
EventIntentPtr EventIntent::Clone() const {
  return New(
      mojo::Clone(command),
      mojo::Clone(input_event_type),
      mojo::Clone(text_boundary),
      mojo::Clone(move_direction)
  );
}

template <typename T, EventIntent::EnableIfSame<T>*>
bool EventIntent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->command, other_struct.command))
    return false;
  if (!mojo::Equals(this->input_event_type, other_struct.input_event_type))
    return false;
  if (!mojo::Equals(this->text_boundary, other_struct.text_boundary))
    return false;
  if (!mojo::Equals(this->move_direction, other_struct.move_direction))
    return false;
  return true;
}

template <typename T, EventIntent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.command < rhs.command)
    return true;
  if (rhs.command < lhs.command)
    return false;
  if (lhs.input_event_type < rhs.input_event_type)
    return true;
  if (rhs.input_event_type < lhs.input_event_type)
    return false;
  if (lhs.text_boundary < rhs.text_boundary)
    return true;
  if (rhs.text_boundary < lhs.text_boundary)
    return false;
  if (lhs.move_direction < rhs.move_direction)
    return true;
  if (rhs.move_direction < lhs.move_direction)
    return false;
  return false;
}


}  // ax::mojom

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::EventIntent::DataView,
                                         ::ax::mojom::EventIntentPtr> {
  static bool IsNull(const ::ax::mojom::EventIntentPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::EventIntentPtr* output) { output->reset(); }

  static decltype(::ax::mojom::EventIntent::command) command(
      const ::ax::mojom::EventIntentPtr& input) {
    return input->command;
  }

  static decltype(::ax::mojom::EventIntent::input_event_type) input_event_type(
      const ::ax::mojom::EventIntentPtr& input) {
    return input->input_event_type;
  }

  static decltype(::ax::mojom::EventIntent::text_boundary) text_boundary(
      const ::ax::mojom::EventIntentPtr& input) {
    return input->text_boundary;
  }

  static decltype(::ax::mojom::EventIntent::move_direction) move_direction(
      const ::ax::mojom::EventIntentPtr& input) {
    return input->move_direction;
  }

  static bool Read(::ax::mojom::EventIntent::DataView input, ::ax::mojom::EventIntentPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_EVENT_INTENT_MOJOM_H_