// third_party/blink/public/mojom/webaudio/audio_context_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUDIO_AUDIO_CONTEXT_MANAGER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUDIO_AUDIO_CONTEXT_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webaudio/audio_context_manager.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webaudio/audio_context_manager.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webaudio/audio_context_manager.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class AudioContextManagerProxy;

template <typename ImplRefTraits>
class AudioContextManagerStub;

class AudioContextManagerRequestValidator;


class BLINK_COMMON_EXPORT AudioContextManager
    : public AudioContextManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AudioContextManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioContextManagerInterfaceBase;
  using Proxy_ = AudioContextManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioContextManagerStub<ImplRefTraits>;

  using RequestValidator_ = AudioContextManagerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAudioContextAudiblePlaybackStartedMinVersion = 0,
    kAudioContextAudiblePlaybackStoppedMinVersion = 0,
    kAudioContextCreatedMinVersion = 0,
    kAudioContextClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AudioContextAudiblePlaybackStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AudioContextAudiblePlaybackStopped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AudioContextCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AudioContextClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioContextManager() = default;

  virtual void AudioContextAudiblePlaybackStarted(uint32_t id) = 0;

  virtual void AudioContextAudiblePlaybackStopped(uint32_t id) = 0;

  virtual void AudioContextCreated(uint32_t id) = 0;

  virtual void AudioContextClosed(uint32_t id) = 0;
};



class BLINK_COMMON_EXPORT AudioContextManagerProxy
    : public AudioContextManager {
 public:
  using InterfaceType = AudioContextManager;

  explicit AudioContextManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AudioContextAudiblePlaybackStarted(uint32_t id) final;
  
  void AudioContextAudiblePlaybackStopped(uint32_t id) final;
  
  void AudioContextCreated(uint32_t id) final;
  
  void AudioContextClosed(uint32_t id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT AudioContextManagerStubDispatch {
 public:
  static bool Accept(AudioContextManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioContextManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioContextManager>>
class AudioContextManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioContextManagerStub() = default;
  ~AudioContextManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioContextManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioContextManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT AudioContextManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUDIO_AUDIO_CONTEXT_MANAGER_MOJOM_H_