// third_party/blink/public/mojom/shared_storage/shared_storage.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/shared_storage.mojom.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class SharedStorageWorkletHostProxy;

template <typename ImplRefTraits>
class SharedStorageWorkletHostStub;

class SharedStorageWorkletHostRequestValidator;
class SharedStorageWorkletHostResponseValidator;


class BLINK_COMMON_EXPORT SharedStorageWorkletHost
    : public SharedStorageWorkletHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedStorageWorkletHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedStorageWorkletHostInterfaceBase;
  using Proxy_ = SharedStorageWorkletHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedStorageWorkletHostStub<ImplRefTraits>;

  using RequestValidator_ = SharedStorageWorkletHostRequestValidator;
  using ResponseValidator_ = SharedStorageWorkletHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSelectURLMinVersion = 0,
    kRunMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SelectURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Run_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedStorageWorkletHost() = default;

  using SelectURLCallback = base::OnceCallback<void(bool, const std::string&, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>&)>;
  using SelectURLMojoCallback = base::OnceCallback<void(bool, const std::string&, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>&)>;

  virtual void SelectURL(const std::string& name, std::vector<SharedStorageUrlWithMetadataPtr> urls_with_metadata, ::blink::CloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, bool resolve_to_config, const ::std::u16string& saved_query_name, ::base::TimeTicks start_time, SelectURLCallback callback) = 0;

  using RunCallback = base::OnceCallback<void(bool, const std::string&)>;
  using RunMojoCallback = base::OnceCallback<void(bool, const std::string&)>;

  virtual void Run(const std::string& name, ::blink::CloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, ::base::TimeTicks start_time, RunCallback callback) = 0;
};

class SharedStorageDocumentServiceProxy;

template <typename ImplRefTraits>
class SharedStorageDocumentServiceStub;

class SharedStorageDocumentServiceRequestValidator;
class SharedStorageDocumentServiceResponseValidator;


class BLINK_COMMON_EXPORT SharedStorageDocumentService
    : public SharedStorageDocumentServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedStorageDocumentService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedStorageDocumentServiceInterfaceBase;
  using Proxy_ = SharedStorageDocumentServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedStorageDocumentServiceStub<ImplRefTraits>;

  using RequestValidator_ = SharedStorageDocumentServiceRequestValidator;
  using ResponseValidator_ = SharedStorageDocumentServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateWorkletMinVersion = 0,
    kSharedStorageGetMinVersion = 0,
    kSharedStorageUpdateMinVersion = 0,
    kSharedStorageBatchUpdateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateWorklet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageGet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageBatchUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedStorageDocumentService() = default;

  using CreateWorkletCallback = base::OnceCallback<void(bool, const std::string&)>;
  using CreateWorkletMojoCallback = base::OnceCallback<void(bool, const std::string&)>;

  virtual void CreateWorklet(const ::GURL& script_source_url, const ::url::Origin& data_origin, SharedStorageDataOriginType data_origin_type, ::network::mojom::CredentialsMode credentials_mode, SharedStorageWorkletCreationMethod creation_method, const std::vector<::blink::mojom::OriginTrialFeature>& origin_trial_features, ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost> worklet_host, CreateWorkletCallback callback) = 0;

  using SharedStorageGetCallback = base::OnceCallback<void(SharedStorageGetStatus, const std::string&, const ::std::u16string&)>;
  using SharedStorageGetMojoCallback = base::OnceCallback<void(SharedStorageGetStatus, const std::string&, const ::std::u16string&)>;

  virtual void SharedStorageGet(const ::std::u16string& key, SharedStorageGetCallback callback) = 0;

  using SharedStorageUpdateCallback = base::OnceCallback<void(const std::string&)>;
  using SharedStorageUpdateMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void SharedStorageUpdate(::network::mojom::SharedStorageModifierMethodWithOptionsPtr method_with_options, SharedStorageUpdateCallback callback) = 0;

  using SharedStorageBatchUpdateCallback = base::OnceCallback<void(const std::string&)>;
  using SharedStorageBatchUpdateMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void SharedStorageBatchUpdate(::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, SharedStorageBatchUpdateCallback callback) = 0;
};



class BLINK_COMMON_EXPORT SharedStorageWorkletHostProxy
    : public SharedStorageWorkletHost {
 public:
  using InterfaceType = SharedStorageWorkletHost;

  explicit SharedStorageWorkletHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SelectURL(const std::string& name, std::vector<SharedStorageUrlWithMetadataPtr> urls_with_metadata, ::blink::CloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, bool resolve_to_config, const ::std::u16string& saved_query_name, ::base::TimeTicks start_time, SelectURLCallback callback) final;
  
  void Run(const std::string& name, ::blink::CloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, ::base::TimeTicks start_time, RunCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT SharedStorageDocumentServiceProxy
    : public SharedStorageDocumentService {
 public:
  using InterfaceType = SharedStorageDocumentService;

  explicit SharedStorageDocumentServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateWorklet(const ::GURL& script_source_url, const ::url::Origin& data_origin, SharedStorageDataOriginType data_origin_type, ::network::mojom::CredentialsMode credentials_mode, SharedStorageWorkletCreationMethod creation_method, const std::vector<::blink::mojom::OriginTrialFeature>& origin_trial_features, ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost> worklet_host, CreateWorkletCallback callback) final;
  
  void SharedStorageGet(const ::std::u16string& key, SharedStorageGetCallback callback) final;
  
  void SharedStorageUpdate(::network::mojom::SharedStorageModifierMethodWithOptionsPtr method_with_options, SharedStorageUpdateCallback callback) final;
  
  void SharedStorageBatchUpdate(::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, SharedStorageBatchUpdateCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletHostStubDispatch {
 public:
  static bool Accept(SharedStorageWorkletHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedStorageWorkletHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedStorageWorkletHost>>
class SharedStorageWorkletHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedStorageWorkletHostStub() = default;
  ~SharedStorageWorkletHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageWorkletHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageWorkletHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SharedStorageDocumentServiceStubDispatch {
 public:
  static bool Accept(SharedStorageDocumentService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedStorageDocumentService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedStorageDocumentService>>
class SharedStorageDocumentServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedStorageDocumentServiceStub() = default;
  ~SharedStorageDocumentServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageDocumentServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageDocumentServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SharedStorageDocumentServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SharedStorageWorkletHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT SharedStorageDocumentServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT SharedStorageUrlWithMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageUrlWithMetadata, T>::value>;
  using DataView = SharedStorageUrlWithMetadataDataView;
  using Data_ = internal::SharedStorageUrlWithMetadata_Data;

  template <typename... Args>
  static SharedStorageUrlWithMetadataPtr New(Args&&... args) {
    return SharedStorageUrlWithMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageUrlWithMetadataPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageUrlWithMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageUrlWithMetadata>::Convert(*this);
  }


  SharedStorageUrlWithMetadata();

  SharedStorageUrlWithMetadata(
      const ::GURL& url,
      const base::flat_map<std::string, ::GURL>& reporting_metadata);


  ~SharedStorageUrlWithMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageUrlWithMetadataPtr>
  SharedStorageUrlWithMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageUrlWithMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageUrlWithMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageUrlWithMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageUrlWithMetadata_UnserializedMessageContext<
            UserType, SharedStorageUrlWithMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageUrlWithMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageUrlWithMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageUrlWithMetadata_UnserializedMessageContext<
            UserType, SharedStorageUrlWithMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageUrlWithMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  base::flat_map<std::string, ::GURL> reporting_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PrivateAggregationConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrivateAggregationConfig, T>::value>;
  using DataView = PrivateAggregationConfigDataView;
  using Data_ = internal::PrivateAggregationConfig_Data;

  template <typename... Args>
  static PrivateAggregationConfigPtr New(Args&&... args) {
    return PrivateAggregationConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrivateAggregationConfigPtr From(const U& u) {
    return mojo::TypeConverter<PrivateAggregationConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrivateAggregationConfig>::Convert(*this);
  }


  PrivateAggregationConfig();

  PrivateAggregationConfig(
      const std::optional<::url::Origin>& aggregation_coordinator_origin,
      const std::optional<std::string>& context_id,
      uint32_t filtering_id_max_bytes,
      std::optional<uint16_t> max_contributions);


  ~PrivateAggregationConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrivateAggregationConfigPtr>
  PrivateAggregationConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateAggregationConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateAggregationConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrivateAggregationConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrivateAggregationConfig_UnserializedMessageContext<
            UserType, PrivateAggregationConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrivateAggregationConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrivateAggregationConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrivateAggregationConfig_UnserializedMessageContext<
            UserType, PrivateAggregationConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrivateAggregationConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::url::Origin> aggregation_coordinator_origin;
  
  std::optional<std::string> context_id;
  
  uint32_t filtering_id_max_bytes;
  
  std::optional<uint16_t> max_contributions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedStorageUrlWithMetadataPtr SharedStorageUrlWithMetadata::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(reporting_metadata)
  );
}

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>*>
bool SharedStorageUrlWithMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->reporting_metadata, other_struct.reporting_metadata))
    return false;
  return true;
}

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.reporting_metadata < rhs.reporting_metadata)
    return true;
  if (rhs.reporting_metadata < lhs.reporting_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
PrivateAggregationConfigPtr PrivateAggregationConfig::Clone() const {
  return New(
      mojo::Clone(aggregation_coordinator_origin),
      mojo::Clone(context_id),
      mojo::Clone(filtering_id_max_bytes),
      mojo::Clone(max_contributions)
  );
}

template <typename T, PrivateAggregationConfig::EnableIfSame<T>*>
bool PrivateAggregationConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->aggregation_coordinator_origin, other_struct.aggregation_coordinator_origin))
    return false;
  if (!mojo::Equals(this->context_id, other_struct.context_id))
    return false;
  if (!mojo::Equals(this->filtering_id_max_bytes, other_struct.filtering_id_max_bytes))
    return false;
  if (!mojo::Equals(this->max_contributions, other_struct.max_contributions))
    return false;
  return true;
}

template <typename T, PrivateAggregationConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.aggregation_coordinator_origin < rhs.aggregation_coordinator_origin)
    return true;
  if (rhs.aggregation_coordinator_origin < lhs.aggregation_coordinator_origin)
    return false;
  if (lhs.context_id < rhs.context_id)
    return true;
  if (rhs.context_id < lhs.context_id)
    return false;
  if (lhs.filtering_id_max_bytes < rhs.filtering_id_max_bytes)
    return true;
  if (rhs.filtering_id_max_bytes < lhs.filtering_id_max_bytes)
    return false;
  if (lhs.max_contributions < rhs.max_contributions)
    return true;
  if (rhs.max_contributions < lhs.max_contributions)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SharedStorageUrlWithMetadata::DataView,
                                         ::blink::mojom::SharedStorageUrlWithMetadataPtr> {
  static bool IsNull(const ::blink::mojom::SharedStorageUrlWithMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SharedStorageUrlWithMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SharedStorageUrlWithMetadata::url)& url(
      const ::blink::mojom::SharedStorageUrlWithMetadataPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::SharedStorageUrlWithMetadata::reporting_metadata)& reporting_metadata(
      const ::blink::mojom::SharedStorageUrlWithMetadataPtr& input) {
    return input->reporting_metadata;
  }

  static bool Read(::blink::mojom::SharedStorageUrlWithMetadata::DataView input, ::blink::mojom::SharedStorageUrlWithMetadataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PrivateAggregationConfig::DataView,
                                         ::blink::mojom::PrivateAggregationConfigPtr> {
  static bool IsNull(const ::blink::mojom::PrivateAggregationConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PrivateAggregationConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PrivateAggregationConfig::aggregation_coordinator_origin)& aggregation_coordinator_origin(
      const ::blink::mojom::PrivateAggregationConfigPtr& input) {
    return input->aggregation_coordinator_origin;
  }

  static const decltype(::blink::mojom::PrivateAggregationConfig::context_id)& context_id(
      const ::blink::mojom::PrivateAggregationConfigPtr& input) {
    return input->context_id;
  }

  static decltype(::blink::mojom::PrivateAggregationConfig::filtering_id_max_bytes) filtering_id_max_bytes(
      const ::blink::mojom::PrivateAggregationConfigPtr& input) {
    return input->filtering_id_max_bytes;
  }

  static decltype(::blink::mojom::PrivateAggregationConfig::max_contributions) max_contributions(
      const ::blink::mojom::PrivateAggregationConfigPtr& input) {
    return input->max_contributions;
  }

  static bool Read(::blink::mojom::PrivateAggregationConfig::DataView input, ::blink::mojom::PrivateAggregationConfigPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_H_