// third_party/blink/public/mojom/shared_storage/shared_storage.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/shared_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class SharedStorageUrlWithMetadataDataView;

class PrivateAggregationConfigDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SharedStorageUrlWithMetadataDataView> {
  using Data = ::blink::mojom::internal::SharedStorageUrlWithMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PrivateAggregationConfigDataView> {
  using Data = ::blink::mojom::internal::PrivateAggregationConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class SharedStorageGetStatus : int32_t {
  
  kSuccess = 0,
  
  kNotFound = 1,
  
  kError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SharedStorageGetStatus value);
inline bool IsKnownEnumValue(SharedStorageGetStatus value) {
  return internal::SharedStorageGetStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SharedStorageWorkletCreationMethod : int32_t {
  
  kAddModule = 0,
  
  kCreateWorklet = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SharedStorageWorkletCreationMethod value);
inline bool IsKnownEnumValue(SharedStorageWorkletCreationMethod value) {
  return internal::SharedStorageWorkletCreationMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SharedStorageDataOriginType : int32_t {
  
  kContextOrigin = 0,
  
  kScriptOrigin = 1,
  
  kCustomOrigin = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SharedStorageDataOriginType value);
inline bool IsKnownEnumValue(SharedStorageDataOriginType value) {
  return internal::SharedStorageDataOriginType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SharedStorageWorkletHostInterfaceBase {};

using SharedStorageWorkletHostPtrDataView =
    mojo::InterfacePtrDataView<SharedStorageWorkletHostInterfaceBase>;
using SharedStorageWorkletHostRequestDataView =
    mojo::InterfaceRequestDataView<SharedStorageWorkletHostInterfaceBase>;
using SharedStorageWorkletHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SharedStorageWorkletHostInterfaceBase>;
using SharedStorageWorkletHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SharedStorageWorkletHostInterfaceBase>;
class SharedStorageDocumentServiceInterfaceBase {};

using SharedStorageDocumentServicePtrDataView =
    mojo::InterfacePtrDataView<SharedStorageDocumentServiceInterfaceBase>;
using SharedStorageDocumentServiceRequestDataView =
    mojo::InterfaceRequestDataView<SharedStorageDocumentServiceInterfaceBase>;
using SharedStorageDocumentServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SharedStorageDocumentServiceInterfaceBase>;
using SharedStorageDocumentServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SharedStorageDocumentServiceInterfaceBase>;


class SharedStorageUrlWithMetadataDataView {
 public:
  SharedStorageUrlWithMetadataDataView() = default;

  SharedStorageUrlWithMetadataDataView(
      internal::SharedStorageUrlWithMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReportingMetadataDataView(
      mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingMetadata(UserType* output) {
    
    auto* pointer = data_->reporting_metadata.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SharedStorageUrlWithMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrivateAggregationConfigDataView {
 public:
  PrivateAggregationConfigDataView() = default;

  PrivateAggregationConfigDataView(
      internal::PrivateAggregationConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAggregationCoordinatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `aggregation_coordinator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregationCoordinatorOrigin` instead "
    "of `ReadAggregationCoordinatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetContextIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContextId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `context_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContextId` instead "
    "of `ReadContextId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->context_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t filtering_id_max_bytes() const {
    return data_->filtering_id_max_bytes;
  }
  std::optional<uint16_t> max_contributions() const {

    return data_->max_contributions_$flag
        ? std::make_optional(data_->max_contributions_$value)
        : std::nullopt;
  }
 private:
  internal::PrivateAggregationConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_DATA_VIEW_H_