// third_party/blink/public/mojom/messaging/transferable_message.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-forward.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom.h"
#include "third_party/blink/public/mojom/messaging/delegated_capability.mojom-forward.h"
#include "third_party/blink/public/mojom/messaging/message_port_descriptor.mojom.h"
#include "third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom.h"
#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/messaging/message_port_channel.h"
#include "third_party/blink/public/common/messaging/transferable_message.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT TransferableMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransferableMessage, T>::value>;
  using DataView = TransferableMessageDataView;
  using Data_ = internal::TransferableMessage_Data;

  template <typename... Args>
  static TransferableMessagePtr New(Args&&... args) {
    return TransferableMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransferableMessagePtr From(const U& u) {
    return mojo::TypeConverter<TransferableMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransferableMessage>::Convert(*this);
  }


  TransferableMessage();

  TransferableMessage(
      ::blink::CloneableMessage message,
      std::vector<::blink::MessagePortDescriptor> ports,
      std::vector<::blink::MessagePortDescriptor> stream_channels,
      std::vector<::blink::mojom::SerializedArrayBufferContentsPtr> array_buffer_contents_array,
      std::vector<::blink::mojom::SerializedStaticBitmapImagePtr> image_bitmap_contents_array,
      ::blink::mojom::UserActivationSnapshotPtr user_activation,
      ::blink::mojom::DelegatedCapability delegated_capability,
      std::optional<::blink::scheduler::TaskAttributionId> task_state_id);

TransferableMessage(const TransferableMessage&) = delete;
TransferableMessage& operator=(const TransferableMessage&) = delete;

  ~TransferableMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransferableMessagePtr>
  TransferableMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransferableMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransferableMessage_UnserializedMessageContext<
            UserType, TransferableMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransferableMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransferableMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransferableMessage_UnserializedMessageContext<
            UserType, TransferableMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransferableMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::CloneableMessage message;
  
  std::vector<::blink::MessagePortDescriptor> ports;
  
  std::vector<::blink::MessagePortDescriptor> stream_channels;
  
  std::vector<::blink::mojom::SerializedArrayBufferContentsPtr> array_buffer_contents_array;
  
  std::vector<::blink::mojom::SerializedStaticBitmapImagePtr> image_bitmap_contents_array;
  
  ::blink::mojom::UserActivationSnapshotPtr user_activation;
  
  ::blink::mojom::DelegatedCapability delegated_capability;
  
  std::optional<::blink::scheduler::TaskAttributionId> task_state_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TransferableMessagePtr TransferableMessage::Clone() const {
  return New(
      mojo::Clone(message),
      mojo::Clone(ports),
      mojo::Clone(stream_channels),
      mojo::Clone(array_buffer_contents_array),
      mojo::Clone(image_bitmap_contents_array),
      mojo::Clone(user_activation),
      mojo::Clone(delegated_capability),
      mojo::Clone(task_state_id)
  );
}

template <typename T, TransferableMessage::EnableIfSame<T>*>
bool TransferableMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->ports, other_struct.ports))
    return false;
  if (!mojo::Equals(this->stream_channels, other_struct.stream_channels))
    return false;
  if (!mojo::Equals(this->array_buffer_contents_array, other_struct.array_buffer_contents_array))
    return false;
  if (!mojo::Equals(this->image_bitmap_contents_array, other_struct.image_bitmap_contents_array))
    return false;
  if (!mojo::Equals(this->user_activation, other_struct.user_activation))
    return false;
  if (!mojo::Equals(this->delegated_capability, other_struct.delegated_capability))
    return false;
  if (!mojo::Equals(this->task_state_id, other_struct.task_state_id))
    return false;
  return true;
}

template <typename T, TransferableMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.ports < rhs.ports)
    return true;
  if (rhs.ports < lhs.ports)
    return false;
  if (lhs.stream_channels < rhs.stream_channels)
    return true;
  if (rhs.stream_channels < lhs.stream_channels)
    return false;
  if (lhs.array_buffer_contents_array < rhs.array_buffer_contents_array)
    return true;
  if (rhs.array_buffer_contents_array < lhs.array_buffer_contents_array)
    return false;
  if (lhs.image_bitmap_contents_array < rhs.image_bitmap_contents_array)
    return true;
  if (rhs.image_bitmap_contents_array < lhs.image_bitmap_contents_array)
    return false;
  if (lhs.user_activation < rhs.user_activation)
    return true;
  if (rhs.user_activation < lhs.user_activation)
    return false;
  if (lhs.delegated_capability < rhs.delegated_capability)
    return true;
  if (rhs.delegated_capability < lhs.delegated_capability)
    return false;
  if (lhs.task_state_id < rhs.task_state_id)
    return true;
  if (rhs.task_state_id < lhs.task_state_id)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::TransferableMessage::DataView,
                                         ::blink::mojom::TransferableMessagePtr> {
  static bool IsNull(const ::blink::mojom::TransferableMessagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::TransferableMessagePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::TransferableMessage::message)& message(
       ::blink::mojom::TransferableMessagePtr& input) {
    return input->message;
  }

  static  decltype(::blink::mojom::TransferableMessage::ports)& ports(
       ::blink::mojom::TransferableMessagePtr& input) {
    return input->ports;
  }

  static  decltype(::blink::mojom::TransferableMessage::stream_channels)& stream_channels(
       ::blink::mojom::TransferableMessagePtr& input) {
    return input->stream_channels;
  }

  static  decltype(::blink::mojom::TransferableMessage::array_buffer_contents_array)& array_buffer_contents_array(
       ::blink::mojom::TransferableMessagePtr& input) {
    return input->array_buffer_contents_array;
  }

  static  decltype(::blink::mojom::TransferableMessage::image_bitmap_contents_array)& image_bitmap_contents_array(
       ::blink::mojom::TransferableMessagePtr& input) {
    return input->image_bitmap_contents_array;
  }

  static const decltype(::blink::mojom::TransferableMessage::user_activation)& user_activation(
      const ::blink::mojom::TransferableMessagePtr& input) {
    return input->user_activation;
  }

  static decltype(::blink::mojom::TransferableMessage::delegated_capability) delegated_capability(
      const ::blink::mojom::TransferableMessagePtr& input) {
    return input->delegated_capability;
  }

  static const decltype(::blink::mojom::TransferableMessage::task_state_id)& task_state_id(
      const ::blink::mojom::TransferableMessagePtr& input) {
    return input->task_state_id;
  }

  static bool Read(::blink::mojom::TransferableMessage::DataView input, ::blink::mojom::TransferableMessagePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_H_