// third_party/blink/public/mojom/mediastream/media_stream.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "media/mojo/mojom/display_media_information.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared.h"


namespace blink::mojom {
class SearchOnlyByDeviceIdDataView;

class SearchBySessionIdDataView;

class MediaStreamDeviceDataView;

class TrackControlsDataView;

class StreamControlsDataView;

class GetOpenDeviceResponseDataView;

class CapturedWheelActionDataView;

class StreamDevicesDataView;

class StreamDevicesSetDataView;

class StreamSelectionInfoDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SearchOnlyByDeviceIdDataView> {
  using Data = ::blink::mojom::internal::SearchOnlyByDeviceId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SearchBySessionIdDataView> {
  using Data = ::blink::mojom::internal::SearchBySessionId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MediaStreamDeviceDataView> {
  using Data = ::blink::mojom::internal::MediaStreamDevice_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TrackControlsDataView> {
  using Data = ::blink::mojom::internal::TrackControls_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StreamControlsDataView> {
  using Data = ::blink::mojom::internal::StreamControls_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetOpenDeviceResponseDataView> {
  using Data = ::blink::mojom::internal::GetOpenDeviceResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CapturedWheelActionDataView> {
  using Data = ::blink::mojom::internal::CapturedWheelAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StreamDevicesDataView> {
  using Data = ::blink::mojom::internal::StreamDevices_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StreamDevicesSetDataView> {
  using Data = ::blink::mojom::internal::StreamDevicesSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::StreamSelectionInfoDataView> {
  using Data = ::blink::mojom::internal::StreamSelectionInfo_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class MediaStreamType : int32_t {
  
  NO_SERVICE = 0,
  
  DEVICE_AUDIO_CAPTURE = 1,
  
  DEVICE_VIDEO_CAPTURE = 2,
  
  GUM_TAB_AUDIO_CAPTURE = 3,
  
  GUM_TAB_VIDEO_CAPTURE = 4,
  
  GUM_DESKTOP_VIDEO_CAPTURE = 5,
  
  GUM_DESKTOP_AUDIO_CAPTURE = 6,
  
  DISPLAY_VIDEO_CAPTURE = 7,
  
  DISPLAY_AUDIO_CAPTURE = 8,
  
  DISPLAY_VIDEO_CAPTURE_THIS_TAB = 9,
  
  DISPLAY_VIDEO_CAPTURE_SET = 10,
  
  NUM_MEDIA_TYPES = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaStreamType value);
inline bool IsKnownEnumValue(MediaStreamType value) {
  return internal::MediaStreamType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaStreamRequestResult : int32_t {
  
  OK = 0,
  
  PERMISSION_DENIED = 1,
  
  PERMISSION_DISMISSED = 2,
  
  INVALID_STATE = 3,
  
  NO_HARDWARE = 4,
  
  INVALID_SECURITY_ORIGIN = 5,
  
  TAB_CAPTURE_FAILURE = 6,
  
  SCREEN_CAPTURE_FAILURE = 7,
  
  CAPTURE_FAILURE = 8,
  
  CONSTRAINT_NOT_SATISFIED = 9,
  
  TRACK_START_FAILURE_AUDIO = 10,
  
  TRACK_START_FAILURE_VIDEO = 11,
  
  NOT_SUPPORTED = 12,
  
  FAILED_DUE_TO_SHUTDOWN = 13,
  
  KILL_SWITCH_ON = 14,
  
  PERMISSION_DENIED_BY_SYSTEM = 15,
  
  DEVICE_IN_USE = 16,
  
  REQUEST_CANCELLED = 17,
  
  START_TIMEOUT = 18,
  
  PERMISSION_DENIED_BY_USER = 19,
  
  NUM_MEDIA_REQUEST_RESULTS = 20,
  kMinValue = 0,
  kMaxValue = 20,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaStreamRequestResult value);
inline bool IsKnownEnumValue(MediaStreamRequestResult value) {
  return internal::MediaStreamRequestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaStreamStateChange : int32_t {
  
  PLAY = 0,
  
  PAUSE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaStreamStateChange value);
inline bool IsKnownEnumValue(MediaStreamStateChange value) {
  return internal::MediaStreamStateChange_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PreferredDisplaySurface : int32_t {
  
  NO_PREFERENCE = 0,
  
  MONITOR = 1,
  
  WINDOW = 2,
  
  BROWSER = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PreferredDisplaySurface value);
inline bool IsKnownEnumValue(PreferredDisplaySurface value) {
  return internal::PreferredDisplaySurface_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CapturedSurfaceControlResult : int32_t {
  
  kSuccess = 0,
  
  kUnknownError = 1,
  
  kNoPermissionError = 2,
  
  kCapturerNotFoundError = 3,
  
  kCapturedSurfaceNotFoundError = 4,
  
  kDisallowedForSelfCaptureError = 5,
  
  kCapturerNotFocusedError = 6,
  
  kMinZoomLevel = 7,
  
  kMaxZoomLevel = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CapturedSurfaceControlResult value);
inline bool IsKnownEnumValue(CapturedSurfaceControlResult value) {
  return internal::CapturedSurfaceControlResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ZoomLevelAction : int32_t {
  
  kIncrease = 0,
  
  kDecrease = 1,
  
  kReset = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ZoomLevelAction value);
inline bool IsKnownEnumValue(ZoomLevelAction value) {
  return internal::ZoomLevelAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WindowAudioPreference : int32_t {
  
  kSystem = 0,
  
  kWindow = 1,
  
  kExclude = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WindowAudioPreference value);
inline bool IsKnownEnumValue(WindowAudioPreference value) {
  return internal::WindowAudioPreference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaStreamDeviceObserverInterfaceBase {};

using MediaStreamDeviceObserverPtrDataView =
    mojo::InterfacePtrDataView<MediaStreamDeviceObserverInterfaceBase>;
using MediaStreamDeviceObserverRequestDataView =
    mojo::InterfaceRequestDataView<MediaStreamDeviceObserverInterfaceBase>;
using MediaStreamDeviceObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaStreamDeviceObserverInterfaceBase>;
using MediaStreamDeviceObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaStreamDeviceObserverInterfaceBase>;
class MediaStreamDispatcherHostInterfaceBase {};

using MediaStreamDispatcherHostPtrDataView =
    mojo::InterfacePtrDataView<MediaStreamDispatcherHostInterfaceBase>;
using MediaStreamDispatcherHostRequestDataView =
    mojo::InterfaceRequestDataView<MediaStreamDispatcherHostInterfaceBase>;
using MediaStreamDispatcherHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaStreamDispatcherHostInterfaceBase>;
using MediaStreamDispatcherHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaStreamDispatcherHostInterfaceBase>;
class MediaStreamTrackMetricsHostInterfaceBase {};

using MediaStreamTrackMetricsHostPtrDataView =
    mojo::InterfacePtrDataView<MediaStreamTrackMetricsHostInterfaceBase>;
using MediaStreamTrackMetricsHostRequestDataView =
    mojo::InterfaceRequestDataView<MediaStreamTrackMetricsHostInterfaceBase>;
using MediaStreamTrackMetricsHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaStreamTrackMetricsHostInterfaceBase>;
using MediaStreamTrackMetricsHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaStreamTrackMetricsHostInterfaceBase>;


class SearchOnlyByDeviceIdDataView {
 public:
  SearchOnlyByDeviceIdDataView() = default;

  SearchOnlyByDeviceIdDataView(
      internal::SearchOnlyByDeviceId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SearchOnlyByDeviceId_Data* data_ = nullptr;
};


class SearchBySessionIdDataView {
 public:
  SearchBySessionIdDataView() = default;

  SearchBySessionIdDataView(
      internal::SearchBySessionId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionIdMap(UserType* output) {
    
    auto* pointer = data_->session_id_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SearchBySessionId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStreamDeviceDataView {
 public:
  MediaStreamDeviceDataView() = default;

  MediaStreamDeviceDataView(
      internal::MediaStreamDevice_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamType>(
        data_value, output);
  }
  MediaStreamType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamType>(data_->type));
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t display_id() const {
    return data_->display_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVideoFacing(UserType* output) const {
    auto data_value = data_->video_facing;
    return mojo::internal::Deserialize<::media::mojom::VideoFacingMode>(
        data_value, output);
  }
  ::media::mojom::VideoFacingMode video_facing() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoFacingMode>(data_->video_facing));
  }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `group_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGroupId` instead "
    "of `ReadGroupId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMatchedOutputDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchedOutputDeviceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `matched_output_device_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMatchedOutputDeviceId` instead "
    "of `ReadMatchedOutputDeviceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->matched_output_device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInputDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = data_->input.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  inline void GetSessionIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `session_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSessionId` instead "
    "of `ReadSessionId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayMediaInfoDataView(
      ::media::mojom::DisplayMediaInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayMediaInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::DisplayMediaInformationDataView, UserType>(),
    "Attempting to read the optional `display_media_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisplayMediaInfo` instead "
    "of `ReadDisplayMediaInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->display_media_info.Get();
    return mojo::internal::Deserialize<::media::mojom::DisplayMediaInformationDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaStreamDevice_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrackControlsDataView {
 public:
  TrackControlsDataView() = default;

  TrackControlsDataView(
      internal::TrackControls_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStreamType(UserType* output) const {
    auto data_value = data_->stream_type;
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamType>(
        data_value, output);
  }
  MediaStreamType stream_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaStreamType>(data_->stream_type));
  }
  inline void GetDeviceIdsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceIds(UserType* output) {
    
    auto* pointer = data_->device_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TrackControls_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StreamControlsDataView {
 public:
  StreamControlsDataView() = default;

  StreamControlsDataView(
      internal::StreamControls_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAudioDataView(
      TrackControlsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudio(UserType* output) {
    
    auto* pointer = data_->audio.Get();
    return mojo::internal::Deserialize<::blink::mojom::TrackControlsDataView>(
        pointer, output, message_);
  }
  inline void GetVideoDataView(
      TrackControlsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideo(UserType* output) {
    
    auto* pointer = data_->video.Get();
    return mojo::internal::Deserialize<::blink::mojom::TrackControlsDataView>(
        pointer, output, message_);
  }
  bool hotword_enabled() const {
    return data_->hotword_enabled;
  }
  bool disable_local_echo() const {
    return data_->disable_local_echo;
  }
  bool suppress_local_audio_playback() const {
    return data_->suppress_local_audio_playback;
  }
  bool restrict_own_audio() const {
    return data_->restrict_own_audio;
  }
  bool exclude_system_audio() const {
    return data_->exclude_system_audio;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWindowAudioPreference(UserType* output) const {
    auto data_value = data_->window_audio_preference;
    return mojo::internal::Deserialize<::blink::mojom::WindowAudioPreference>(
        data_value, output);
  }
  WindowAudioPreference window_audio_preference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WindowAudioPreference>(data_->window_audio_preference));
  }
  bool exclude_self_browser_surface() const {
    return data_->exclude_self_browser_surface;
  }
  bool request_pan_tilt_zoom_permission() const {
    return data_->request_pan_tilt_zoom_permission;
  }
  bool request_all_screens() const {
    return data_->request_all_screens;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredDisplaySurface(UserType* output) const {
    auto data_value = data_->preferred_display_surface;
    return mojo::internal::Deserialize<::blink::mojom::PreferredDisplaySurface>(
        data_value, output);
  }
  PreferredDisplaySurface preferred_display_surface() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredDisplaySurface>(data_->preferred_display_surface));
  }
  bool dynamic_surface_switching_requested() const {
    return data_->dynamic_surface_switching_requested;
  }
  bool exclude_monitor_type_surfaces() const {
    return data_->exclude_monitor_type_surfaces;
  }
 private:
  internal::StreamControls_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetOpenDeviceResponseDataView {
 public:
  GetOpenDeviceResponseDataView() = default;

  GetOpenDeviceResponseDataView(
      internal::GetOpenDeviceResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
  bool pan_tilt_zoom_allowed() const {
    return data_->pan_tilt_zoom_allowed;
  }
 private:
  internal::GetOpenDeviceResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CapturedWheelActionDataView {
 public:
  CapturedWheelActionDataView() = default;

  CapturedWheelActionDataView(
      internal::CapturedWheelAction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double relative_x() const {
    return data_->relative_x;
  }
  double relative_y() const {
    return data_->relative_y;
  }
  int32_t wheel_delta_x() const {
    return data_->wheel_delta_x;
  }
  int32_t wheel_delta_y() const {
    return data_->wheel_delta_y;
  }
 private:
  internal::CapturedWheelAction_Data* data_ = nullptr;
};


class StreamDevicesDataView {
 public:
  StreamDevicesDataView() = default;

  StreamDevicesDataView(
      internal::StreamDevices_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAudioDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioDevice(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MediaStreamDeviceDataView, UserType>(),
    "Attempting to read the optional `audio_device` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAudioDevice` instead "
    "of `ReadAudioDevice if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->audio_device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
  inline void GetVideoDeviceDataView(
      MediaStreamDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoDevice(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MediaStreamDeviceDataView, UserType>(),
    "Attempting to read the optional `video_device` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVideoDevice` instead "
    "of `ReadVideoDevice if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->video_device.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaStreamDeviceDataView>(
        pointer, output, message_);
  }
 private:
  internal::StreamDevices_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StreamDevicesSetDataView {
 public:
  StreamDevicesSetDataView() = default;

  StreamDevicesSetDataView(
      internal::StreamDevicesSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStreamDevicesDataView(
      mojo::ArrayDataView<StreamDevicesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreamDevices(UserType* output) {
    
    auto* pointer = data_->stream_devices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::StreamDevicesDataView>>(
        pointer, output, message_);
  }
 private:
  internal::StreamDevicesSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StreamSelectionInfoDataView {
 public:
  using Tag = internal::StreamSelectionInfo_Data::StreamSelectionInfo_Tag;

  StreamSelectionInfoDataView() = default;

  StreamSelectionInfoDataView(
      internal::StreamSelectionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_search_only_by_device_id() const { return data_->tag == Tag::kSearchOnlyByDeviceId; }
  inline void GetSearchOnlyByDeviceIdDataView(
      SearchOnlyByDeviceIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSearchOnlyByDeviceId(UserType* output) const {
    
    CHECK(is_search_only_by_device_id());
    return mojo::internal::Deserialize<::blink::mojom::SearchOnlyByDeviceIdDataView>(
        data_->data.f_search_only_by_device_id.Get(), output, message_);
  }
  bool is_search_by_session_id() const { return data_->tag == Tag::kSearchBySessionId; }
  inline void GetSearchBySessionIdDataView(
      SearchBySessionIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSearchBySessionId(UserType* output) const {
    
    CHECK(is_search_by_session_id());
    return mojo::internal::Deserialize<::blink::mojom::SearchBySessionIdDataView>(
        data_->data.f_search_by_session_id.Get(), output, message_);
  }

 private:
  internal::StreamSelectionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_DATA_VIEW_H_