// third_party/blink/public/mojom/blob/blob.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/blob/blob.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/blob/blob.mojom-params-data.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/blob/blob.mojom-import-headers.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

BlobReaderClient::IPCStableHashFunction BlobReaderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BlobReaderClient>(message.name())) {
    case messages::BlobReaderClient::kOnCalculatedSize: {
      return &BlobReaderClient::OnCalculatedSize_Sym::IPCStableHash;
    }
    case messages::BlobReaderClient::kOnComplete: {
      return &BlobReaderClient::OnComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BlobReaderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BlobReaderClient>(message.name())) {
      case messages::BlobReaderClient::kOnCalculatedSize:
            return "Receive blink::mojom::BlobReaderClient::OnCalculatedSize";
      case messages::BlobReaderClient::kOnComplete:
            return "Receive blink::mojom::BlobReaderClient::OnComplete";
    }
  } else {
    switch (static_cast<messages::BlobReaderClient>(message.name())) {
      case messages::BlobReaderClient::kOnCalculatedSize:
            return "Receive reply blink::mojom::BlobReaderClient::OnCalculatedSize";
      case messages::BlobReaderClient::kOnComplete:
            return "Receive reply blink::mojom::BlobReaderClient::OnComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BlobReaderClient::OnCalculatedSize_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44ea970c;  // IPCStableHash for blink::mojom::BlobReaderClient::OnCalculatedSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobReaderClient::OnComplete_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65f2f603;  // IPCStableHash for blink::mojom::BlobReaderClient::OnComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BlobReaderClientProxy::BlobReaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobReaderClientProxy::OnCalculatedSize(
    uint64_t in_total_size, uint64_t in_expected_content_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobReaderClient::OnCalculatedSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_size"), in_total_size,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_content_size"), in_expected_content_size,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobReaderClient::kOnCalculatedSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobReaderClient_OnCalculatedSize_Params_Data> params(
          message);
  params.Allocate();

  params->total_size = in_total_size;

  params->expected_content_size = in_expected_content_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobReaderClient::Name_);
  message.set_method_name("OnCalculatedSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobReaderClientProxy::OnComplete(
    int32_t in_status, uint64_t in_data_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobReaderClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_length"), in_data_length,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobReaderClient::kOnComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobReaderClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();

  params->status = in_status;

  params->data_length = in_data_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobReaderClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BlobReaderClientStubDispatch::Accept(
    BlobReaderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BlobReaderClient>(message->header()->name)) {
    case messages::BlobReaderClient::kOnCalculatedSize: {
      DCHECK(message->is_serialized());
      internal::BlobReaderClient_OnCalculatedSize_Params_Data* params =
          reinterpret_cast<internal::BlobReaderClient_OnCalculatedSize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BlobReaderClient.0
      bool success = true;
      uint64_t p_total_size{};
      uint64_t p_expected_content_size{};
      BlobReaderClient_OnCalculatedSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_size = input_data_view.total_size();
      if (success)
        p_expected_content_size = input_data_view.expected_content_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobReaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCalculatedSize(        
        std::move(p_total_size), 
        std::move(p_expected_content_size));
      return true;
    }
    case messages::BlobReaderClient::kOnComplete: {
      DCHECK(message->is_serialized());
      internal::BlobReaderClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::BlobReaderClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BlobReaderClient.1
      bool success = true;
      int32_t p_status{};
      uint64_t p_data_length{};
      BlobReaderClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_status = input_data_view.status();
      if (success)
        p_data_length = input_data_view.data_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobReaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(        
        std::move(p_status), 
        std::move(p_data_length));
      return true;
    }
  }
  return false;
}

// static
bool BlobReaderClientStubDispatch::AcceptWithResponder(
    BlobReaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BlobReaderClient>(message->header()->name)) {
    case messages::BlobReaderClient::kOnCalculatedSize: {
      break;
    }
    case messages::BlobReaderClient::kOnComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBlobReaderClientValidationInfo[] = {
    { &internal::BlobReaderClient_OnCalculatedSize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BlobReaderClient_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool BlobReaderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::BlobReaderClient::Name_,
    kBlobReaderClientValidationInfo);
}

// The declaration includes the definition on other builds.

Blob::IPCStableHashFunction Blob::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Blob>(message.name())) {
    case messages::Blob::kClone: {
      return &Blob::Clone_Sym::IPCStableHash;
    }
    case messages::Blob::kAsDataPipeGetter: {
      return &Blob::AsDataPipeGetter_Sym::IPCStableHash;
    }
    case messages::Blob::kReadAll: {
      return &Blob::ReadAll_Sym::IPCStableHash;
    }
    case messages::Blob::kReadRange: {
      return &Blob::ReadRange_Sym::IPCStableHash;
    }
    case messages::Blob::kLoad: {
      return &Blob::Load_Sym::IPCStableHash;
    }
    case messages::Blob::kReadSideData: {
      return &Blob::ReadSideData_Sym::IPCStableHash;
    }
    case messages::Blob::kCaptureSnapshot: {
      return &Blob::CaptureSnapshot_Sym::IPCStableHash;
    }
    case messages::Blob::kGetInternalUUID: {
      return &Blob::GetInternalUUID_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Blob::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Blob>(message.name())) {
      case messages::Blob::kClone:
            return "Receive blink::mojom::Blob::Clone";
      case messages::Blob::kAsDataPipeGetter:
            return "Receive blink::mojom::Blob::AsDataPipeGetter";
      case messages::Blob::kReadAll:
            return "Receive blink::mojom::Blob::ReadAll";
      case messages::Blob::kReadRange:
            return "Receive blink::mojom::Blob::ReadRange";
      case messages::Blob::kLoad:
            return "Receive blink::mojom::Blob::Load";
      case messages::Blob::kReadSideData:
            return "Receive blink::mojom::Blob::ReadSideData";
      case messages::Blob::kCaptureSnapshot:
            return "Receive blink::mojom::Blob::CaptureSnapshot";
      case messages::Blob::kGetInternalUUID:
            return "Receive blink::mojom::Blob::GetInternalUUID";
    }
  } else {
    switch (static_cast<messages::Blob>(message.name())) {
      case messages::Blob::kClone:
            return "Receive reply blink::mojom::Blob::Clone";
      case messages::Blob::kAsDataPipeGetter:
            return "Receive reply blink::mojom::Blob::AsDataPipeGetter";
      case messages::Blob::kReadAll:
            return "Receive reply blink::mojom::Blob::ReadAll";
      case messages::Blob::kReadRange:
            return "Receive reply blink::mojom::Blob::ReadRange";
      case messages::Blob::kLoad:
            return "Receive reply blink::mojom::Blob::Load";
      case messages::Blob::kReadSideData:
            return "Receive reply blink::mojom::Blob::ReadSideData";
      case messages::Blob::kCaptureSnapshot:
            return "Receive reply blink::mojom::Blob::CaptureSnapshot";
      case messages::Blob::kGetInternalUUID:
            return "Receive reply blink::mojom::Blob::GetInternalUUID";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Blob::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc28e063d;  // IPCStableHash for blink::mojom::Blob::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Blob::AsDataPipeGetter_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d7bf67a;  // IPCStableHash for blink::mojom::Blob::AsDataPipeGetter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Blob::ReadAll_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9a6d834;  // IPCStableHash for blink::mojom::Blob::ReadAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Blob::ReadRange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbecf43fe;  // IPCStableHash for blink::mojom::Blob::ReadRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Blob::Load_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x86948bdd;  // IPCStableHash for blink::mojom::Blob::Load
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Blob::ReadSideData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa814efe2;  // IPCStableHash for blink::mojom::Blob::ReadSideData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Blob::CaptureSnapshot_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a13c5e9;  // IPCStableHash for blink::mojom::Blob::CaptureSnapshot
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Blob::GetInternalUUID_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb14f9794;  // IPCStableHash for blink::mojom::Blob::GetInternalUUID
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool Blob::CaptureSnapshot(uint64_t* out_length, std::optional<::base::Time>* out_modification_time) {
  NOTREACHED();
}

class Blob_ReadSideData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Blob_ReadSideData_ForwardToCallback(
      Blob::ReadSideDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  Blob_ReadSideData_ForwardToCallback(const Blob_ReadSideData_ForwardToCallback&) = delete;
  Blob_ReadSideData_ForwardToCallback& operator=(const Blob_ReadSideData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Blob::ReadSideDataCallback callback_;
};
class Blob_CaptureSnapshot_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Blob_CaptureSnapshot_HandleSyncResponse(
      bool* result, uint64_t* out_length, std::optional<::base::Time>* out_modification_time)
      : result_(result), out_length_(out_length), out_modification_time_(out_modification_time) {
    DCHECK(!*result_);
  }

  Blob_CaptureSnapshot_HandleSyncResponse(const Blob_CaptureSnapshot_HandleSyncResponse&) = delete;
  Blob_CaptureSnapshot_HandleSyncResponse& operator=(const Blob_CaptureSnapshot_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint64_t* out_length_;
  std::optional<::base::Time>* out_modification_time_;};

class Blob_CaptureSnapshot_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Blob_CaptureSnapshot_ForwardToCallback(
      Blob::CaptureSnapshotCallback callback
      ) : callback_(std::move(callback)) {
  }

  Blob_CaptureSnapshot_ForwardToCallback(const Blob_CaptureSnapshot_ForwardToCallback&) = delete;
  Blob_CaptureSnapshot_ForwardToCallback& operator=(const Blob_CaptureSnapshot_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Blob::CaptureSnapshotCallback callback_;
};

class Blob_GetInternalUUID_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Blob_GetInternalUUID_ForwardToCallback(
      Blob::GetInternalUUIDCallback callback
      ) : callback_(std::move(callback)) {
  }

  Blob_GetInternalUUID_ForwardToCallback(const Blob_GetInternalUUID_ForwardToCallback&) = delete;
  Blob_GetInternalUUID_ForwardToCallback& operator=(const Blob_GetInternalUUID_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Blob::GetInternalUUIDCallback callback_;
};

BlobProxy::BlobProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobProxy::Clone(
    ::mojo::PendingReceiver<Blob> in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Blob::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<Blob>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
    in_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in Blob.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobProxy::AsDataPipeGetter(
    ::mojo::PendingReceiver<::network::mojom::DataPipeGetter> in_data_pipe_getter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Blob::AsDataPipeGetter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe_getter"), in_data_pipe_getter,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::DataPipeGetter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kAsDataPipeGetter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_AsDataPipeGetter_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::DataPipeGetterInterfaceBase>>(
    in_data_pipe_getter,
    &params->data_pipe_getter,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->data_pipe_getter)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid data_pipe_getter in Blob.AsDataPipeGetter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("AsDataPipeGetter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobProxy::ReadAll(
    ::mojo::ScopedDataPipeProducerHandle in_pipe, ::mojo::PendingRemote<BlobReaderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Blob::ReadAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<BlobReaderClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kReadAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_ReadAll_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_pipe,
    &params->pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pipe in Blob.ReadAll request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobReaderClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("ReadAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobProxy::ReadRange(
    uint64_t in_offset, uint64_t in_length, ::mojo::ScopedDataPipeProducerHandle in_pipe, ::mojo::PendingRemote<BlobReaderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Blob::ReadRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<BlobReaderClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kReadRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_ReadRange_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;

  params->length = in_length;

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_pipe,
    &params->pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pipe in Blob.ReadRange request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobReaderClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("ReadRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobProxy::Load(
    ::mojo::PendingReceiver<::network::mojom::URLLoader> in_loader, const std::string& in_request_method, const ::net::HttpRequestHeaders& in_headers, ::mojo::PendingRemote<::network::mojom::URLLoaderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Blob::Load", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("loader"), in_loader,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::URLLoader>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_method"), in_request_method,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_Load_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderInterfaceBase>>(
    in_loader,
    &params->loader,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->loader)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid loader in Blob.Load request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_method)::BaseType> request_method_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_request_method,
    request_method_fragment);

  params->request_method.Set(
      request_method_fragment.is_null() ? nullptr : request_method_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_method.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_method in Blob.Load request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
    in_headers,
    headers_fragment);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in Blob.Load request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in Blob.Load request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("Load");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobProxy::ReadSideData(
    ReadSideDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Blob::ReadSideData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kReadSideData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_ReadSideData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("ReadSideData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Blob_ReadSideData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool BlobProxy::CaptureSnapshot(
    uint64_t* out_param_length, std::optional<::base::Time>* out_param_modification_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call blink::mojom::Blob::CaptureSnapshot (sync)");
#else
  TRACE_EVENT0("mojom", "Blob::CaptureSnapshot");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kCaptureSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_CaptureSnapshot_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("CaptureSnapshot");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Blob_CaptureSnapshot_HandleSyncResponse(
          &result, out_param_length, out_param_modification_time));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Blob::CaptureSnapshot", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), out_param_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modification_time"), out_param_modification_time,
                        "<value of type std::optional<::base::Time>>");
   });
#endif
  return result;
}

void BlobProxy::CaptureSnapshot(
    CaptureSnapshotCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Blob::CaptureSnapshot");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kCaptureSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_CaptureSnapshot_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("CaptureSnapshot");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Blob_CaptureSnapshot_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BlobProxy::GetInternalUUID(
    GetInternalUUIDCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Blob::GetInternalUUID");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kGetInternalUUID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_GetInternalUUID_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("GetInternalUUID");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Blob_GetInternalUUID_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Blob_ReadSideData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Blob::ReadSideDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Blob_ReadSideData_ProxyToResponder> proxy(
        new Blob_ReadSideData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Blob_ReadSideData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Blob_ReadSideData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Blob_ReadSideData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Blob::ReadSideDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_data);
};

bool Blob_ReadSideData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Blob_ReadSideData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Blob_ReadSideData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Blob.5
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_data{};
  Blob_ReadSideData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Blob::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void Blob_ReadSideData_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Blob::ReadSideData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kReadSideData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_ReadSideData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("ReadSideData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Blob_CaptureSnapshot_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Blob::CaptureSnapshotCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Blob_CaptureSnapshot_ProxyToResponder> proxy(
        new Blob_CaptureSnapshot_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Blob_CaptureSnapshot_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Blob_CaptureSnapshot_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Blob_CaptureSnapshot_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Blob::CaptureSnapshotCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_length, std::optional<::base::Time> in_modification_time);
};

bool Blob_CaptureSnapshot_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Blob_CaptureSnapshot_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Blob_CaptureSnapshot_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Blob.6
  bool success = true;
  uint64_t p_length{};
  std::optional<::base::Time> p_modification_time{};
  Blob_CaptureSnapshot_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_length = input_data_view.length();
  if (success && !input_data_view.ReadModificationTime(&p_modification_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Blob::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_length), 
std::move(p_modification_time));
  }
  return true;
}

void Blob_CaptureSnapshot_ProxyToResponder::Run(
    uint64_t in_length, std::optional<::base::Time> in_modification_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Blob::CaptureSnapshot", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modification_time"), in_modification_time,
                        "<value of type std::optional<::base::Time>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kCaptureSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_CaptureSnapshot_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->length = in_length;
  mojo::internal::MessageFragment<
      typename decltype(params->modification_time)::BaseType> modification_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_modification_time,
    modification_time_fragment);

  params->modification_time.Set(
      modification_time_fragment.is_null() ? nullptr : modification_time_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("CaptureSnapshot");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Blob_CaptureSnapshot_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Blob_CaptureSnapshot_ResponseParams_Data* params =
      reinterpret_cast<internal::Blob_CaptureSnapshot_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Blob.6
  bool success = true;
  uint64_t p_length{};
  std::optional<::base::Time> p_modification_time{};
  Blob_CaptureSnapshot_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_length = input_data_view.length();
  if (success && !input_data_view.ReadModificationTime(&p_modification_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Blob::Name_, 6, true);
    return false;
  }
  *out_length_ = std::move(p_length);
  *out_modification_time_ = std::move(p_modification_time);
  *result_ = true;
  return true;
}
class Blob_GetInternalUUID_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Blob::GetInternalUUIDCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Blob_GetInternalUUID_ProxyToResponder> proxy(
        new Blob_GetInternalUUID_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Blob_GetInternalUUID_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Blob_GetInternalUUID_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Blob_GetInternalUUID_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Blob::GetInternalUUIDCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_uuid);
};

bool Blob_GetInternalUUID_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Blob_GetInternalUUID_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Blob_GetInternalUUID_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Blob.7
  bool success = true;
  std::string p_uuid{};
  Blob_GetInternalUUID_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUuid(&p_uuid))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Blob::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_uuid));
  }
  return true;
}

void Blob_GetInternalUUID_ProxyToResponder::Run(
    const std::string& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Blob::GetInternalUUID", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Blob::kGetInternalUUID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_GetInternalUUID_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("GetInternalUUID");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobStubDispatch::Accept(
    Blob* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Blob>(message->header()->name)) {
    case messages::Blob::kClone: {
      DCHECK(message->is_serialized());
      internal::Blob_Clone_Params_Data* params =
          reinterpret_cast<internal::Blob_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Blob.0
      bool success = true;
      ::mojo::PendingReceiver<Blob> p_blob{};
      Blob_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_blob));
      return true;
    }
    case messages::Blob::kAsDataPipeGetter: {
      DCHECK(message->is_serialized());
      internal::Blob_AsDataPipeGetter_Params_Data* params =
          reinterpret_cast<internal::Blob_AsDataPipeGetter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Blob.1
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::DataPipeGetter> p_data_pipe_getter{};
      Blob_AsDataPipeGetter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_data_pipe_getter =
            input_data_view.TakeDataPipeGetter<decltype(p_data_pipe_getter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AsDataPipeGetter(        
        std::move(p_data_pipe_getter));
      return true;
    }
    case messages::Blob::kReadAll: {
      DCHECK(message->is_serialized());
      internal::Blob_ReadAll_Params_Data* params =
          reinterpret_cast<internal::Blob_ReadAll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Blob.2
      bool success = true;
      ::mojo::ScopedDataPipeProducerHandle p_pipe{};
      ::mojo::PendingRemote<BlobReaderClient> p_client{};
      Blob_ReadAll_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadAll(        
        std::move(p_pipe), 
        std::move(p_client));
      return true;
    }
    case messages::Blob::kReadRange: {
      DCHECK(message->is_serialized());
      internal::Blob_ReadRange_Params_Data* params =
          reinterpret_cast<internal::Blob_ReadRange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Blob.3
      bool success = true;
      uint64_t p_offset{};
      uint64_t p_length{};
      ::mojo::ScopedDataPipeProducerHandle p_pipe{};
      ::mojo::PendingRemote<BlobReaderClient> p_client{};
      Blob_ReadRange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadRange(        
        std::move(p_offset), 
        std::move(p_length), 
        std::move(p_pipe), 
        std::move(p_client));
      return true;
    }
    case messages::Blob::kLoad: {
      DCHECK(message->is_serialized());
      internal::Blob_Load_Params_Data* params =
          reinterpret_cast<internal::Blob_Load_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Blob.4
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::URLLoader> p_loader{};
      std::string p_request_method{};
      ::net::HttpRequestHeaders p_headers{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderClient> p_client{};
      Blob_Load_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_loader =
            input_data_view.TakeLoader<decltype(p_loader)>();
      }
      if (success && !input_data_view.ReadRequestMethod(&p_request_method))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Load(        
        std::move(p_loader), 
        std::move(p_request_method), 
        std::move(p_headers), 
        std::move(p_client));
      return true;
    }
    case messages::Blob::kReadSideData: {
      break;
    }
    case messages::Blob::kCaptureSnapshot: {
      break;
    }
    case messages::Blob::kGetInternalUUID: {
      break;
    }
  }
  return false;
}

// static
bool BlobStubDispatch::AcceptWithResponder(
    Blob* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Blob>(message->header()->name)) {
    case messages::Blob::kClone: {
      break;
    }
    case messages::Blob::kAsDataPipeGetter: {
      break;
    }
    case messages::Blob::kReadAll: {
      break;
    }
    case messages::Blob::kReadRange: {
      break;
    }
    case messages::Blob::kLoad: {
      break;
    }
    case messages::Blob::kReadSideData: {
      internal::Blob_ReadSideData_Params_Data* params =
          reinterpret_cast<
              internal::Blob_ReadSideData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Blob.5
      bool success = true;
      Blob_ReadSideData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 5, false);
        return false;
      }
      auto callback =
          Blob_ReadSideData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadSideData(std::move(callback));
      return true;
    }
    case messages::Blob::kCaptureSnapshot: {
      internal::Blob_CaptureSnapshot_Params_Data* params =
          reinterpret_cast<
              internal::Blob_CaptureSnapshot_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Blob.6
      bool success = true;
      Blob_CaptureSnapshot_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 6, false);
        return false;
      }
      auto callback =
          Blob_CaptureSnapshot_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CaptureSnapshot(std::move(callback));
      return true;
    }
    case messages::Blob::kGetInternalUUID: {
      internal::Blob_GetInternalUUID_Params_Data* params =
          reinterpret_cast<
              internal::Blob_GetInternalUUID_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Blob.7
      bool success = true;
      Blob_GetInternalUUID_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 7, false);
        return false;
      }
      auto callback =
          Blob_GetInternalUUID_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInternalUUID(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBlobValidationInfo[] = {
    { &internal::Blob_Clone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Blob_AsDataPipeGetter_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Blob_ReadAll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Blob_ReadRange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Blob_Load_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Blob_ReadSideData_Params_Data::Validate,
     &internal::Blob_ReadSideData_ResponseParams_Data::Validate},
    { &internal::Blob_CaptureSnapshot_Params_Data::Validate,
     &internal::Blob_CaptureSnapshot_ResponseParams_Data::Validate},
    { &internal::Blob_GetInternalUUID_Params_Data::Validate,
     &internal::Blob_GetInternalUUID_ResponseParams_Data::Validate},
};

bool BlobRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::Blob::Name_,
    kBlobValidationInfo);
}

bool BlobResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::Blob::Name_,
    kBlobValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void BlobReaderClientInterceptorForTesting::OnCalculatedSize(uint64_t total_size, uint64_t expected_content_size) {
  GetForwardingInterface()->OnCalculatedSize(
    std::move(total_size)
    , 
    std::move(expected_content_size)
    );
}
void BlobReaderClientInterceptorForTesting::OnComplete(int32_t status, uint64_t data_length) {
  GetForwardingInterface()->OnComplete(
    std::move(status)
    , 
    std::move(data_length)
    );
}
BlobReaderClientAsyncWaiter::BlobReaderClientAsyncWaiter(
    BlobReaderClient* proxy) : proxy_(proxy) {}

BlobReaderClientAsyncWaiter::~BlobReaderClientAsyncWaiter() = default;





void BlobInterceptorForTesting::Clone(::mojo::PendingReceiver<Blob> blob) {
  GetForwardingInterface()->Clone(
    std::move(blob)
    );
}
void BlobInterceptorForTesting::AsDataPipeGetter(::mojo::PendingReceiver<::network::mojom::DataPipeGetter> data_pipe_getter) {
  GetForwardingInterface()->AsDataPipeGetter(
    std::move(data_pipe_getter)
    );
}
void BlobInterceptorForTesting::ReadAll(::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) {
  GetForwardingInterface()->ReadAll(
    std::move(pipe)
    , 
    std::move(client)
    );
}
void BlobInterceptorForTesting::ReadRange(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) {
  GetForwardingInterface()->ReadRange(
    std::move(offset)
    , 
    std::move(length)
    , 
    std::move(pipe)
    , 
    std::move(client)
    );
}
void BlobInterceptorForTesting::Load(::mojo::PendingReceiver<::network::mojom::URLLoader> loader, const std::string& request_method, const ::net::HttpRequestHeaders& headers, ::mojo::PendingRemote<::network::mojom::URLLoaderClient> client) {
  GetForwardingInterface()->Load(
    std::move(loader)
    , 
    std::move(request_method)
    , 
    std::move(headers)
    , 
    std::move(client)
    );
}
void BlobInterceptorForTesting::ReadSideData(ReadSideDataCallback callback) {
  GetForwardingInterface()->ReadSideData(std::move(callback));
}
void BlobInterceptorForTesting::CaptureSnapshot(CaptureSnapshotCallback callback) {
  GetForwardingInterface()->CaptureSnapshot(std::move(callback));
}
void BlobInterceptorForTesting::GetInternalUUID(GetInternalUUIDCallback callback) {
  GetForwardingInterface()->GetInternalUUID(std::move(callback));
}
BlobAsyncWaiter::BlobAsyncWaiter(
    Blob* proxy) : proxy_(proxy) {}

BlobAsyncWaiter::~BlobAsyncWaiter() = default;


void BlobAsyncWaiter::ReadSideData(
    std::optional<::mojo_base::BigBuffer>* out_data) {
  base::RunLoop loop;
  proxy_->ReadSideData(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_data
,
             std::optional<::mojo_base::BigBuffer> data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

std::optional<::mojo_base::BigBuffer> BlobAsyncWaiter::ReadSideData(
    ) {
  std::optional<::mojo_base::BigBuffer> async_wait_result;
  ReadSideData(&async_wait_result);
  return async_wait_result;
}

void BlobAsyncWaiter::CaptureSnapshot(
    uint64_t* out_length, std::optional<::base::Time>* out_modification_time) {
  base::RunLoop loop;
  proxy_->CaptureSnapshot(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_length
,
             std::optional<::base::Time>* out_modification_time
,
             uint64_t length,
             std::optional<::base::Time> modification_time) {*out_length = std::move(length);*out_modification_time = std::move(modification_time);
            loop->Quit();
          },
          &loop,
          out_length,
          out_modification_time));
  loop.Run();
}



void BlobAsyncWaiter::GetInternalUUID(
    std::string* out_uuid) {
  base::RunLoop loop;
  proxy_->GetInternalUUID(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_uuid
,
             const std::string& uuid) {*out_uuid = std::move(uuid);
            loop->Quit();
          },
          &loop,
          out_uuid));
  loop.Run();
}

std::string BlobAsyncWaiter::GetInternalUUID(
    ) {
  std::string async_wait_result;
  GetInternalUUID(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif