// third_party/blink/public/mojom/ai/ai_language_model.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* AILanguageModelPromptRoleToStringHelper(AILanguageModelPromptRole value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AILanguageModelPromptRole::kSystem:
      return "kSystem";
    case AILanguageModelPromptRole::kUser:
      return "kUser";
    case AILanguageModelPromptRole::kAssistant:
      return "kAssistant";
    default:
      return nullptr;
  }
}

std::string AILanguageModelPromptRoleToString(AILanguageModelPromptRole value) {
  const char *str = AILanguageModelPromptRoleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AILanguageModelPromptRole value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AILanguageModelPromptRole value) {
  return os << AILanguageModelPromptRoleToString(value);
}

NOINLINE static const char* AILanguageModelPromptTypeToStringHelper(AILanguageModelPromptType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AILanguageModelPromptType::kText:
      return "kText";
    case AILanguageModelPromptType::kImage:
      return "kImage";
    case AILanguageModelPromptType::kAudio:
      return "kAudio";
    default:
      return nullptr;
  }
}

std::string AILanguageModelPromptTypeToString(AILanguageModelPromptType value) {
  const char *str = AILanguageModelPromptTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AILanguageModelPromptType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AILanguageModelPromptType value) {
  return os << AILanguageModelPromptTypeToString(value);
}

namespace internal {
// static
bool AILanguageModelPromptContent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AILanguageModelPromptContent_Data* object = static_cast<const AILanguageModelPromptContent_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AILanguageModelPromptContent_Tag::kText: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_text, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_text, validation_context,
                                             &text_validate_params)) {
        return false;
      }
      return true;
    }
    case AILanguageModelPromptContent_Tag::kBitmap: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bitmap, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_bitmap, validation_context))
        return false;
      return true;
    }
    case AILanguageModelPromptContent_Tag::kAudio: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_audio, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_audio, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AILanguageModelPromptContent");
      return false;
    }
  }
}


// static
bool AILanguageModelSamplingParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelSamplingParams_Data* object =
      static_cast<const AILanguageModelSamplingParams_Data*>(data);

  return true;
}

AILanguageModelSamplingParams_Data::AILanguageModelSamplingParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelParams_Data* object =
      static_cast<const AILanguageModelParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_sampling_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_sampling_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_sampling_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_sampling_params, validation_context))
    return false;

  return true;
}

AILanguageModelParams_Data::AILanguageModelParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelInstanceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelInstanceInfo_Data* object =
      static_cast<const AILanguageModelInstanceInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sampling_params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sampling_params, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& input_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AILanguageModelPromptType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->input_types, validation_context,
                                         &input_types_validate_params)) {
    return false;
  }

  return true;
}

AILanguageModelInstanceInfo_Data::AILanguageModelInstanceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelExpected_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelExpected_Data* object =
      static_cast<const AILanguageModelExpected_Data*>(data);


  if (!::blink::mojom::internal::AILanguageModelPromptType_Data
        ::Validate(object->type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->languages, validation_context,
                                         &languages_validate_params)) {
    return false;
  }

  return true;
}

AILanguageModelExpected_Data::AILanguageModelExpected_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelPrompt_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelPrompt_Data* object =
      static_cast<const AILanguageModelPrompt_Data*>(data);


  if (!::blink::mojom::internal::AILanguageModelPromptRole_Data
        ::Validate(object->role, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content, validation_context,
                                         &content_validate_params)) {
    return false;
  }

  return true;
}

AILanguageModelPrompt_Data::AILanguageModelPrompt_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelCreateOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelCreateOptions_Data* object =
      static_cast<const AILanguageModelCreateOptions_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->sampling_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initial_prompts, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& initial_prompts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->initial_prompts, validation_context,
                                         &initial_prompts_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& expected_inputs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->expected_inputs, validation_context,
                                         &expected_inputs_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& expected_outputs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->expected_outputs, validation_context,
                                         &expected_outputs_validate_params)) {
    return false;
  }

  return true;
}

AILanguageModelCreateOptions_Data::AILanguageModelCreateOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIManagerCreateLanguageModelClient_OnResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIManagerCreateLanguageModelClient_OnResult_Params_Data* object =
      static_cast<const AIManagerCreateLanguageModelClient_OnResult_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->language_model_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->language_model_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

AIManagerCreateLanguageModelClient_OnResult_Params_Data::AIManagerCreateLanguageModelClient_OnResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIManagerCreateLanguageModelClient_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIManagerCreateLanguageModelClient_OnError_Params_Data* object =
      static_cast<const AIManagerCreateLanguageModelClient_OnError_Params_Data*>(data);


  if (!::blink::mojom::internal::AIManagerCreateClientError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->quota_error_info, validation_context))
    return false;

  return true;
}

AIManagerCreateLanguageModelClient_OnError_Params_Data::AIManagerCreateLanguageModelClient_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_Prompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_Prompt_Params_Data* object =
      static_cast<const AILanguageModel_Prompt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prompts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prompts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prompts, validation_context,
                                         &prompts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->constraint, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_responder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AILanguageModel_Prompt_Params_Data::AILanguageModel_Prompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_Append_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_Append_Params_Data* object =
      static_cast<const AILanguageModel_Append_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prompts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prompts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prompts, validation_context,
                                         &prompts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AILanguageModel_Append_Params_Data::AILanguageModel_Append_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_Fork_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_Fork_Params_Data* object =
      static_cast<const AILanguageModel_Fork_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AILanguageModel_Fork_Params_Data::AILanguageModel_Fork_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_Destroy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_Destroy_Params_Data* object =
      static_cast<const AILanguageModel_Destroy_Params_Data*>(data);

  return true;
}

AILanguageModel_Destroy_Params_Data::AILanguageModel_Destroy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_MeasureInputUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_MeasureInputUsage_Params_Data* object =
      static_cast<const AILanguageModel_MeasureInputUsage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  return true;
}

AILanguageModel_MeasureInputUsage_Params_Data::AILanguageModel_MeasureInputUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_MeasureInputUsage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_MeasureInputUsage_ResponseParams_Data* object =
      static_cast<const AILanguageModel_MeasureInputUsage_ResponseParams_Data*>(data);

  return true;
}

AILanguageModel_MeasureInputUsage_ResponseParams_Data::AILanguageModel_MeasureInputUsage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AILanguageModelPromptRole>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AILanguageModelPromptRole value) {
  return std::move(context).WriteString(::blink::mojom::AILanguageModelPromptRoleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AILanguageModelPromptType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AILanguageModelPromptType value) {
  return std::move(context).WriteString(::blink::mojom::AILanguageModelPromptTypeToString(value));
}

} // namespace perfetto