// services/viz/public/mojom/compositing/animation.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/animation.mojom-shared-internal.h"
#include "cc/mojom/element_id.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace viz::mojom {
class CubicBezierTimingFunctionDataView;

class StepsTimingFunctionDataView;

class LinearEasingPointDataView;

class AxisAngleDataView;

class AnimationKeyframeDataView;

class AnimationKeyframeModelDataView;

class AnimationDataView;

class AnimationTimelineDataView;

class TimingFunctionDataView;
class TransformOperationDataView;
class AnimationKeyframeValueDataView;


}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CubicBezierTimingFunctionDataView> {
  using Data = ::viz::mojom::internal::CubicBezierTimingFunction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::StepsTimingFunctionDataView> {
  using Data = ::viz::mojom::internal::StepsTimingFunction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::LinearEasingPointDataView> {
  using Data = ::viz::mojom::internal::LinearEasingPoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AxisAngleDataView> {
  using Data = ::viz::mojom::internal::AxisAngle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationKeyframeDataView> {
  using Data = ::viz::mojom::internal::AnimationKeyframe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationKeyframeModelDataView> {
  using Data = ::viz::mojom::internal::AnimationKeyframeModel_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationDataView> {
  using Data = ::viz::mojom::internal::Animation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationTimelineDataView> {
  using Data = ::viz::mojom::internal::AnimationTimeline_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TimingFunctionDataView> {
  using Data = ::viz::mojom::internal::TimingFunction_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::viz::mojom::TransformOperationDataView> {
  using Data = ::viz::mojom::internal::TransformOperation_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationKeyframeValueDataView> {
  using Data = ::viz::mojom::internal::AnimationKeyframeValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class TimingStepPosition : int32_t {
  
  kStart = 0,
  
  kEnd = 1,
  
  kJumpBoth = 2,
  
  kJumpEnd = 3,
  
  kJumpNone = 4,
  
  kJumpStart = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, TimingStepPosition value);
inline bool IsKnownEnumValue(TimingStepPosition value) {
  return internal::TimingStepPosition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AnimationDirection : int32_t {
  
  kNormal = 0,
  
  kReverse = 1,
  
  kAlternateNormal = 2,
  
  kAlternateReverse = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, AnimationDirection value);
inline bool IsKnownEnumValue(AnimationDirection value) {
  return internal::AnimationDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AnimationFillMode : int32_t {
  
  kNone = 0,
  
  kForwards = 1,
  
  kBackwards = 2,
  
  kBoth = 3,
  
  kAuto = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, AnimationFillMode value);
inline bool IsKnownEnumValue(AnimationFillMode value) {
  return internal::AnimationFillMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CubicBezierTimingFunctionDataView {
 public:
  CubicBezierTimingFunctionDataView() = default;

  CubicBezierTimingFunctionDataView(
      internal::CubicBezierTimingFunction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double x1() const {
    return data_->x1;
  }
  double y1() const {
    return data_->y1;
  }
  double x2() const {
    return data_->x2;
  }
  double y2() const {
    return data_->y2;
  }
 private:
  internal::CubicBezierTimingFunction_Data* data_ = nullptr;
};


class StepsTimingFunctionDataView {
 public:
  StepsTimingFunctionDataView() = default;

  StepsTimingFunctionDataView(
      internal::StepsTimingFunction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t num_steps() const {
    return data_->num_steps;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStepPosition(UserType* output) const {
    auto data_value = data_->step_position;
    return mojo::internal::Deserialize<::viz::mojom::TimingStepPosition>(
        data_value, output);
  }
  TimingStepPosition step_position() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::TimingStepPosition>(data_->step_position));
  }
 private:
  internal::StepsTimingFunction_Data* data_ = nullptr;
};


class LinearEasingPointDataView {
 public:
  LinearEasingPointDataView() = default;

  LinearEasingPointDataView(
      internal::LinearEasingPoint_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double in() const {
    return data_->in;
  }
  double out() const {
    return data_->out;
  }
 private:
  internal::LinearEasingPoint_Data* data_ = nullptr;
};


class AxisAngleDataView {
 public:
  AxisAngleDataView() = default;

  AxisAngleDataView(
      internal::AxisAngle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAxisDataView(
      ::gfx::mojom::Vector3dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxis(UserType* output) {
    
    auto* pointer = data_->axis.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        pointer, output, message_);
  }
  float angle() const {
    return data_->angle;
  }
 private:
  internal::AxisAngle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnimationKeyframeDataView {
 public:
  AnimationKeyframeDataView() = default;

  AnimationKeyframeDataView(
      internal::AnimationKeyframe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      AnimationKeyframeValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::AnimationKeyframeValueDataView>(
        pointer, output, message_);
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTimingFunctionDataView(
      TimingFunctionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimingFunction(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::TimingFunctionDataView, UserType>(),
    "Attempting to read the optional `timing_function` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimingFunction` instead "
    "of `ReadTimingFunction if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->timing_function.is_null() ? &data_->timing_function : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::TimingFunctionDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnimationKeyframe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnimationKeyframeModelDataView {
 public:
  AnimationKeyframeModelDataView() = default;

  AnimationKeyframeModelDataView(
      internal::AnimationKeyframeModel_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t group_id() const {
    return data_->group_id;
  }
  int32_t target_property_type() const {
    return data_->target_property_type;
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetTimingFunctionDataView(
      TimingFunctionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimingFunction(UserType* output) {
    
    auto* pointer = !data_->timing_function.is_null() ? &data_->timing_function : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::TimingFunctionDataView>(
        pointer, output, message_);
  }
  inline void GetKeyframesDataView(
      mojo::ArrayDataView<AnimationKeyframeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyframes(UserType* output) {
    
    auto* pointer = data_->keyframes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnimationKeyframeDataView>>(
        pointer, output, message_);
  }
  double scaled_duration() const {
    return data_->scaled_duration;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::viz::mojom::AnimationDirection>(
        data_value, output);
  }
  AnimationDirection direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::AnimationDirection>(data_->direction));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFillMode(UserType* output) const {
    auto data_value = data_->fill_mode;
    return mojo::internal::Deserialize<::viz::mojom::AnimationFillMode>(
        data_value, output);
  }
  AnimationFillMode fill_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::AnimationFillMode>(data_->fill_mode));
  }
  double playback_rate() const {
    return data_->playback_rate;
  }
  double iterations() const {
    return data_->iterations;
  }
  double iteration_start() const {
    return data_->iteration_start;
  }
  inline void GetTimeOffsetDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeOffset(UserType* output) {
    
    auto* pointer = data_->time_offset.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnimationKeyframeModel_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnimationDataView {
 public:
  AnimationDataView() = default;

  AnimationDataView(
      internal::Animation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetKeyframeModelsDataView(
      mojo::ArrayDataView<AnimationKeyframeModelDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyframeModels(UserType* output) {
    
    auto* pointer = data_->keyframe_models.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnimationKeyframeModelDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Animation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnimationTimelineDataView {
 public:
  AnimationTimelineDataView() = default;

  AnimationTimelineDataView(
      internal::AnimationTimeline_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetNewAnimationsDataView(
      mojo::ArrayDataView<AnimationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewAnimations(UserType* output) {
    
    auto* pointer = data_->new_animations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnimationDataView>>(
        pointer, output, message_);
  }
  inline void GetRemovedAnimationsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemovedAnimations(UserType* output) {
    
    auto* pointer = data_->removed_animations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::AnimationTimeline_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TimingFunctionDataView {
 public:
  using Tag = internal::TimingFunction_Data::TimingFunction_Tag;

  TimingFunctionDataView() = default;

  TimingFunctionDataView(
      internal::TimingFunction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_cubic_bezier() const { return data_->tag == Tag::kCubicBezier; }
  inline void GetCubicBezierDataView(
      CubicBezierTimingFunctionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCubicBezier(UserType* output) const {
    
    CHECK(is_cubic_bezier());
    return mojo::internal::Deserialize<::viz::mojom::CubicBezierTimingFunctionDataView>(
        data_->data.f_cubic_bezier.Get(), output, message_);
  }
  bool is_steps() const { return data_->tag == Tag::kSteps; }
  inline void GetStepsDataView(
      StepsTimingFunctionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSteps(UserType* output) const {
    
    CHECK(is_steps());
    return mojo::internal::Deserialize<::viz::mojom::StepsTimingFunctionDataView>(
        data_->data.f_steps.Get(), output, message_);
  }
  bool is_linear() const { return data_->tag == Tag::kLinear; }
  inline void GetLinearDataView(
      mojo::ArrayDataView<LinearEasingPointDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLinear(UserType* output) const {
    
    CHECK(is_linear());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::LinearEasingPointDataView>>(
        data_->data.f_linear.Get(), output, message_);
  }

 private:
  internal::TimingFunction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TransformOperationDataView {
 public:
  using Tag = internal::TransformOperation_Data::TransformOperation_Tag;

  TransformOperationDataView() = default;

  TransformOperationDataView(
      internal::TransformOperation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_identity() const { return data_->tag == Tag::kIdentity; }
  bool identity() const {
    CHECK(is_identity());
    return data_->data.f_identity;
  }
  bool is_perspective_depth() const { return data_->tag == Tag::kPerspectiveDepth; }
  float perspective_depth() const {
    CHECK(is_perspective_depth());
    return data_->data.f_perspective_depth;
  }
  bool is_skew() const { return data_->tag == Tag::kSkew; }
  inline void GetSkewDataView(
      ::gfx::mojom::Vector2dFDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSkew(UserType* output) const {
    
    CHECK(is_skew());
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        data_->data.f_skew.Get(), output, message_);
  }
  bool is_scale() const { return data_->tag == Tag::kScale; }
  inline void GetScaleDataView(
      ::gfx::mojom::Vector3dFDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScale(UserType* output) const {
    
    CHECK(is_scale());
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        data_->data.f_scale.Get(), output, message_);
  }
  bool is_translate() const { return data_->tag == Tag::kTranslate; }
  inline void GetTranslateDataView(
      ::gfx::mojom::Vector3dFDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTranslate(UserType* output) const {
    
    CHECK(is_translate());
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        data_->data.f_translate.Get(), output, message_);
  }
  bool is_rotate() const { return data_->tag == Tag::kRotate; }
  inline void GetRotateDataView(
      AxisAngleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRotate(UserType* output) const {
    
    CHECK(is_rotate());
    return mojo::internal::Deserialize<::viz::mojom::AxisAngleDataView>(
        data_->data.f_rotate.Get(), output, message_);
  }
  bool is_matrix() const { return data_->tag == Tag::kMatrix; }
  inline void GetMatrixDataView(
      ::gfx::mojom::TransformDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMatrix(UserType* output) const {
    
    CHECK(is_matrix());
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        data_->data.f_matrix.Get(), output, message_);
  }

 private:
  internal::TransformOperation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AnimationKeyframeValueDataView {
 public:
  using Tag = internal::AnimationKeyframeValue_Data::AnimationKeyframeValue_Tag;

  AnimationKeyframeValueDataView() = default;

  AnimationKeyframeValueDataView(
      internal::AnimationKeyframeValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_scalar() const { return data_->tag == Tag::kScalar; }
  float scalar() const {
    CHECK(is_scalar());
    return data_->data.f_scalar;
  }
  bool is_color() const { return data_->tag == Tag::kColor; }
  inline void GetColorDataView(
      ::skia::mojom::SkColorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    
    CHECK(is_color());
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        data_->data.f_color.Get(), output, message_);
  }
  bool is_size() const { return data_->tag == Tag::kSize; }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeFDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) const {
    
    CHECK(is_size());
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        data_->data.f_size.Get(), output, message_);
  }
  bool is_rect() const { return data_->tag == Tag::kRect; }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) const {
    
    CHECK(is_rect());
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        data_->data.f_rect.Get(), output, message_);
  }
  bool is_transform() const { return data_->tag == Tag::kTransform; }
  inline void GetTransformDataView(
      mojo::ArrayDataView<TransformOperationDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransform(UserType* output) const {
    
    CHECK(is_transform());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TransformOperationDataView>>(
        data_->data.f_transform.Get(), output, message_);
  }

 private:
  internal::AnimationKeyframeValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_DATA_VIEW_H_