// services/viz/privileged/mojom/viz_main.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/privileged/mojom/viz_main.mojom-shared-internal.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-shared.h"
#include "components/viz/service/debugger/mojom/viz_debugger.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared.h"
#include "ui/gfx/mojom/font_render_params.mojom-shared.h"


namespace viz::mojom {
class FrameSinkManagerParamsDataView;

class GpuServiceCreationParamsDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FrameSinkManagerParamsDataView> {
  using Data = ::viz::mojom::internal::FrameSinkManagerParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::GpuServiceCreationParamsDataView> {
  using Data = ::viz::mojom::internal::GpuServiceCreationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {
// Interface base classes. They are used for type safety check.
class VizMainInterfaceBase {};

using VizMainPtrDataView =
    mojo::InterfacePtrDataView<VizMainInterfaceBase>;
using VizMainRequestDataView =
    mojo::InterfaceRequestDataView<VizMainInterfaceBase>;
using VizMainAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VizMainInterfaceBase>;
using VizMainAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VizMainInterfaceBase>;


class FrameSinkManagerParamsDataView {
 public:
  FrameSinkManagerParamsDataView() = default;

  FrameSinkManagerParamsDataView(
      internal::FrameSinkManagerParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t restart_id() const {
    return data_->restart_id;
  }
  bool use_activation_deadline() const {
    return data_->use_activation_deadline;
  }
  uint32_t activation_deadline_in_frames() const {
    return data_->activation_deadline_in_frames;
  }
  template <typename UserType>
  UserType TakeFrameSinkManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkManagerInterfaceBase>>(
            &data_->frame_sink_manager, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameSinkManagerClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkManagerClientInterfaceBase>>(
            &data_->frame_sink_manager_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDebugRendererSettingsDataView(
      ::viz::mojom::DebugRendererSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugRendererSettings(UserType* output) {
    
    auto* pointer = data_->debug_renderer_settings.Get();
    return mojo::internal::Deserialize<::viz::mojom::DebugRendererSettingsDataView>(
        pointer, output, message_);
  }
 private:
  internal::FrameSinkManagerParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuServiceCreationParamsDataView {
 public:
  GpuServiceCreationParamsDataView() = default;

  GpuServiceCreationParamsDataView(
      internal::GpuServiceCreationParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool supports_overlays() const {
    return data_->supports_overlays;
  }
 private:
  internal::GpuServiceCreationParams_Data* data_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_DATA_VIEW_H_