// services/network/public/mojom/url_loader_network_service_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader_network_service_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-params-data.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-import-headers.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
LoadInfo::LoadInfo()
    : timestamp(),
      host(),
      load_state(),
      state_param(),
      upload_position(),
      upload_size() {}

LoadInfo::LoadInfo(
    ::base::TimeTicks timestamp_in,
    const std::string& host_in,
    uint32_t load_state_in,
    const ::std::u16string& state_param_in,
    uint64_t upload_position_in,
    uint64_t upload_size_in)
    : timestamp(std::move(timestamp_in)),
      host(std::move(host_in)),
      load_state(std::move(load_state_in)),
      state_param(std::move(state_param_in)),
      upload_position(std::move(upload_position_in)),
      upload_size(std::move(upload_size_in)) {}

LoadInfo::~LoadInfo() = default;

void LoadInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_state"), this->load_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state_param"), this->state_param,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_position"), this->upload_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_size"), this->upload_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LoadInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ClientCertificateResponder::IPCStableHashFunction ClientCertificateResponder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ClientCertificateResponder>(message.name())) {
    case messages::ClientCertificateResponder::kContinueWithCertificate: {
      return &ClientCertificateResponder::ContinueWithCertificate_Sym::IPCStableHash;
    }
    case messages::ClientCertificateResponder::kContinueWithoutCertificate: {
      return &ClientCertificateResponder::ContinueWithoutCertificate_Sym::IPCStableHash;
    }
    case messages::ClientCertificateResponder::kCancelRequest: {
      return &ClientCertificateResponder::CancelRequest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ClientCertificateResponder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ClientCertificateResponder>(message.name())) {
      case messages::ClientCertificateResponder::kContinueWithCertificate:
            return "Receive network::mojom::ClientCertificateResponder::ContinueWithCertificate";
      case messages::ClientCertificateResponder::kContinueWithoutCertificate:
            return "Receive network::mojom::ClientCertificateResponder::ContinueWithoutCertificate";
      case messages::ClientCertificateResponder::kCancelRequest:
            return "Receive network::mojom::ClientCertificateResponder::CancelRequest";
    }
  } else {
    switch (static_cast<messages::ClientCertificateResponder>(message.name())) {
      case messages::ClientCertificateResponder::kContinueWithCertificate:
            return "Receive reply network::mojom::ClientCertificateResponder::ContinueWithCertificate";
      case messages::ClientCertificateResponder::kContinueWithoutCertificate:
            return "Receive reply network::mojom::ClientCertificateResponder::ContinueWithoutCertificate";
      case messages::ClientCertificateResponder::kCancelRequest:
            return "Receive reply network::mojom::ClientCertificateResponder::CancelRequest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ClientCertificateResponder::ContinueWithCertificate_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a33248f;  // IPCStableHash for network::mojom::ClientCertificateResponder::ContinueWithCertificate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClientCertificateResponder::ContinueWithoutCertificate_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7a2be46;  // IPCStableHash for network::mojom::ClientCertificateResponder::ContinueWithoutCertificate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClientCertificateResponder::CancelRequest_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ebd7b10;  // IPCStableHash for network::mojom::ClientCertificateResponder::CancelRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ClientCertificateResponderProxy::ClientCertificateResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ClientCertificateResponderProxy::ContinueWithCertificate(
    const ::scoped_refptr<::net::X509Certificate>& in_x509_certificate, const std::string& in_provider_name, const std::vector<uint16_t>& in_algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> in_ssl_private_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ClientCertificateResponder::ContinueWithCertificate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("x509_certificate"), in_x509_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider_name"), in_provider_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("algorithm_preferences"), in_algorithm_preferences,
                        "<value of type const std::vector<uint16_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ssl_private_key"), in_ssl_private_key,
                        "<value of type ::mojo::PendingRemote<SSLPrivateKey>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientCertificateResponder::kContinueWithCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->x509_certificate)::BaseType> x509_certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_x509_certificate,
    x509_certificate_fragment);

  params->x509_certificate.Set(
      x509_certificate_fragment.is_null() ? nullptr : x509_certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->x509_certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null x509_certificate in ClientCertificateResponder.ContinueWithCertificate request");
  mojo::internal::MessageFragment<
      typename decltype(params->provider_name)::BaseType> provider_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_provider_name,
    provider_name_fragment);

  params->provider_name.Set(
      provider_name_fragment.is_null() ? nullptr : provider_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->provider_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null provider_name in ClientCertificateResponder.ContinueWithCertificate request");
  mojo::internal::MessageFragment<
      typename decltype(params->algorithm_preferences)::BaseType>
      algorithm_preferences_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& algorithm_preferences_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
    in_algorithm_preferences,
    algorithm_preferences_fragment,
    &algorithm_preferences_validate_params);

  params->algorithm_preferences.Set(
      algorithm_preferences_fragment.is_null() ? nullptr : algorithm_preferences_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->algorithm_preferences.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null algorithm_preferences in ClientCertificateResponder.ContinueWithCertificate request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SSLPrivateKeyInterfaceBase>>(
    in_ssl_private_key,
    &params->ssl_private_key,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->ssl_private_key)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid ssl_private_key in ClientCertificateResponder.ContinueWithCertificate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("ContinueWithCertificate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClientCertificateResponderProxy::ContinueWithoutCertificate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::ClientCertificateResponder::ContinueWithoutCertificate");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientCertificateResponder::kContinueWithoutCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("ContinueWithoutCertificate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClientCertificateResponderProxy::CancelRequest(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::ClientCertificateResponder::CancelRequest");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientCertificateResponder::kCancelRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ClientCertificateResponder_CancelRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("CancelRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ClientCertificateResponderStubDispatch::Accept(
    ClientCertificateResponder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ClientCertificateResponder>(message->header()->name)) {
    case messages::ClientCertificateResponder::kContinueWithCertificate: {
      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClientCertificateResponder.0
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_x509_certificate{};
      std::string p_provider_name{};
      std::vector<uint16_t> p_algorithm_preferences{};
      ::mojo::PendingRemote<SSLPrivateKey> p_ssl_private_key{};
      ClientCertificateResponder_ContinueWithCertificate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadX509Certificate(&p_x509_certificate))
        success = false;
      if (success && !input_data_view.ReadProviderName(&p_provider_name))
        success = false;
      if (success && !input_data_view.ReadAlgorithmPreferences(&p_algorithm_preferences))
        success = false;
      if (success) {
        p_ssl_private_key =
            input_data_view.TakeSslPrivateKey<decltype(p_ssl_private_key)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContinueWithCertificate(        
        std::move(p_x509_certificate), 
        std::move(p_provider_name), 
        std::move(p_algorithm_preferences), 
        std::move(p_ssl_private_key));
      return true;
    }
    case messages::ClientCertificateResponder::kContinueWithoutCertificate: {
      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClientCertificateResponder.1
      bool success = true;
      ClientCertificateResponder_ContinueWithoutCertificate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContinueWithoutCertificate(        );
      return true;
    }
    case messages::ClientCertificateResponder::kCancelRequest: {
      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_CancelRequest_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_CancelRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClientCertificateResponder.2
      bool success = true;
      ClientCertificateResponder_CancelRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelRequest(        );
      return true;
    }
  }
  return false;
}

// static
bool ClientCertificateResponderStubDispatch::AcceptWithResponder(
    ClientCertificateResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ClientCertificateResponder>(message->header()->name)) {
    case messages::ClientCertificateResponder::kContinueWithCertificate: {
      break;
    }
    case messages::ClientCertificateResponder::kContinueWithoutCertificate: {
      break;
    }
    case messages::ClientCertificateResponder::kCancelRequest: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kClientCertificateResponderValidationInfo[] = {
    {base::to_underlying(messages::ClientCertificateResponder::kContinueWithCertificate),
     { &internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ClientCertificateResponder::kContinueWithoutCertificate),
     { &internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ClientCertificateResponder::kCancelRequest),
     { &internal::ClientCertificateResponder_CancelRequest_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ClientCertificateResponderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::ClientCertificateResponder::Name_,
    kClientCertificateResponderValidationInfo);
}

// The declaration includes the definition on other builds.

SSLPrivateKey::IPCStableHashFunction SSLPrivateKey::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SSLPrivateKey>(message.name())) {
    case messages::SSLPrivateKey::kSign: {
      return &SSLPrivateKey::Sign_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SSLPrivateKey::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SSLPrivateKey>(message.name())) {
      case messages::SSLPrivateKey::kSign:
            return "Receive network::mojom::SSLPrivateKey::Sign";
    }
  } else {
    switch (static_cast<messages::SSLPrivateKey>(message.name())) {
      case messages::SSLPrivateKey::kSign:
            return "Receive reply network::mojom::SSLPrivateKey::Sign";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SSLPrivateKey::Sign_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdbf1633b;  // IPCStableHash for network::mojom::SSLPrivateKey::Sign
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SSLPrivateKey_Sign_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SSLPrivateKey_Sign_ForwardToCallback(
      SSLPrivateKey::SignCallback callback
      ) : callback_(std::move(callback)) {
  }

  SSLPrivateKey_Sign_ForwardToCallback(const SSLPrivateKey_Sign_ForwardToCallback&) = delete;
  SSLPrivateKey_Sign_ForwardToCallback& operator=(const SSLPrivateKey_Sign_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SSLPrivateKey::SignCallback callback_;
};

SSLPrivateKeyProxy::SSLPrivateKeyProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SSLPrivateKeyProxy::Sign(
    uint16_t in_algorithm, const std::vector<uint8_t>& in_input, SignCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SSLPrivateKey::Sign", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("algorithm"), in_algorithm,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SSLPrivateKey::kSign), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SSLPrivateKey_Sign_Params_Data> params(
          message);
  params.Allocate();

  params->algorithm = in_algorithm;
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType>
      input_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_input,
    input_fragment,
    &input_validate_params);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in SSLPrivateKey.Sign request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLPrivateKey::Name_);
  message.set_method_name("Sign");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SSLPrivateKey_Sign_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SSLPrivateKey_Sign_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SSLPrivateKey::SignCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SSLPrivateKey_Sign_ProxyToResponder> proxy(
        new SSLPrivateKey_Sign_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SSLPrivateKey_Sign_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SSLPrivateKey_Sign_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SSLPrivateKey_Sign_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SSLPrivateKey::SignCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, const std::vector<uint8_t>& in_signature);
};

bool SSLPrivateKey_Sign_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SSLPrivateKey_Sign_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SSLPrivateKey_Sign_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SSLPrivateKey.0
  bool success = true;
  int32_t p_net_error{};
  std::vector<uint8_t> p_signature{};
  SSLPrivateKey_Sign_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadSignature(&p_signature))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SSLPrivateKey::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_signature));
  }
  return true;
}

void SSLPrivateKey_Sign_ProxyToResponder::Run(
    int32_t in_net_error, const std::vector<uint8_t>& in_signature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SSLPrivateKey::Sign", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signature"), in_signature,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SSLPrivateKey::kSign), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SSLPrivateKey_Sign_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->signature)::BaseType>
      signature_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_signature,
    signature_fragment,
    &signature_validate_params);

  params->signature.Set(
      signature_fragment.is_null() ? nullptr : signature_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->signature.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null signature in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLPrivateKey::Name_);
  message.set_method_name("Sign");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SSLPrivateKeyStubDispatch::Accept(
    SSLPrivateKey* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SSLPrivateKey>(message->header()->name)) {
    case messages::SSLPrivateKey::kSign: {
      break;
    }
  }
  return false;
}

// static
bool SSLPrivateKeyStubDispatch::AcceptWithResponder(
    SSLPrivateKey* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SSLPrivateKey>(message->header()->name)) {
    case messages::SSLPrivateKey::kSign: {
      internal::SSLPrivateKey_Sign_Params_Data* params =
          reinterpret_cast<
              internal::SSLPrivateKey_Sign_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SSLPrivateKey.0
      bool success = true;
      uint16_t p_algorithm{};
      std::vector<uint8_t> p_input{};
      SSLPrivateKey_Sign_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_algorithm = input_data_view.algorithm();
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SSLPrivateKey::Name_, 0, false);
        return false;
      }
      auto callback =
          SSLPrivateKey_Sign_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Sign(        
        std::move(p_algorithm), 
        std::move(p_input), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSSLPrivateKeyValidationInfo[] = {
    {base::to_underlying(messages::SSLPrivateKey::kSign),
     { &internal::SSLPrivateKey_Sign_Params_Data::Validate,
      &internal::SSLPrivateKey_Sign_ResponseParams_Data::Validate}},
};

bool SSLPrivateKeyRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::SSLPrivateKey::Name_,
    kSSLPrivateKeyValidationInfo);
}

bool SSLPrivateKeyResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::SSLPrivateKey::Name_,
    kSSLPrivateKeyValidationInfo);

}
// The declaration includes the definition on other builds.

AuthChallengeResponder::IPCStableHashFunction AuthChallengeResponder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AuthChallengeResponder>(message.name())) {
    case messages::AuthChallengeResponder::kOnAuthCredentials: {
      return &AuthChallengeResponder::OnAuthCredentials_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AuthChallengeResponder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AuthChallengeResponder>(message.name())) {
      case messages::AuthChallengeResponder::kOnAuthCredentials:
            return "Receive network::mojom::AuthChallengeResponder::OnAuthCredentials";
    }
  } else {
    switch (static_cast<messages::AuthChallengeResponder>(message.name())) {
      case messages::AuthChallengeResponder::kOnAuthCredentials:
            return "Receive reply network::mojom::AuthChallengeResponder::OnAuthCredentials";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AuthChallengeResponder::OnAuthCredentials_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5cb0275;  // IPCStableHash for network::mojom::AuthChallengeResponder::OnAuthCredentials
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AuthChallengeResponderProxy::AuthChallengeResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuthChallengeResponderProxy::OnAuthCredentials(
    const std::optional<::net::AuthCredentials>& in_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::AuthChallengeResponder::OnAuthCredentials", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials"), in_credentials,
                        "<value of type const std::optional<::net::AuthCredentials>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuthChallengeResponder::kOnAuthCredentials), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::AuthChallengeResponder_OnAuthCredentials_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credentials)::BaseType> credentials_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
    in_credentials,
    credentials_fragment);

  params->credentials.Set(
      credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuthChallengeResponder::Name_);
  message.set_method_name("OnAuthCredentials");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AuthChallengeResponderStubDispatch::Accept(
    AuthChallengeResponder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AuthChallengeResponder>(message->header()->name)) {
    case messages::AuthChallengeResponder::kOnAuthCredentials: {
      DCHECK(message->is_serialized());
      internal::AuthChallengeResponder_OnAuthCredentials_Params_Data* params =
          reinterpret_cast<internal::AuthChallengeResponder_OnAuthCredentials_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AuthChallengeResponder.0
      bool success = true;
      std::optional<::net::AuthCredentials> p_credentials{};
      AuthChallengeResponder_OnAuthCredentials_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCredentials(&p_credentials))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuthChallengeResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthCredentials(        
        std::move(p_credentials));
      return true;
    }
  }
  return false;
}

// static
bool AuthChallengeResponderStubDispatch::AcceptWithResponder(
    AuthChallengeResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AuthChallengeResponder>(message->header()->name)) {
    case messages::AuthChallengeResponder::kOnAuthCredentials: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAuthChallengeResponderValidationInfo[] = {
    {base::to_underlying(messages::AuthChallengeResponder::kOnAuthCredentials),
     { &internal::AuthChallengeResponder_OnAuthCredentials_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AuthChallengeResponderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::AuthChallengeResponder::Name_,
    kAuthChallengeResponderValidationInfo);
}

// The declaration includes the definition on other builds.

URLLoaderNetworkServiceObserver::IPCStableHashFunction URLLoaderNetworkServiceObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::URLLoaderNetworkServiceObserver>(message.name())) {
    case messages::URLLoaderNetworkServiceObserver::kOnSSLCertificateError: {
      return &URLLoaderNetworkServiceObserver::OnSSLCertificateError_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnCertificateRequested: {
      return &URLLoaderNetworkServiceObserver::OnCertificateRequested_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnAuthRequired: {
      return &URLLoaderNetworkServiceObserver::OnAuthRequired_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnLocalNetworkAccessPermissionRequired: {
      return &URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequired_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnClearSiteData: {
      return &URLLoaderNetworkServiceObserver::OnClearSiteData_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnLoadingStateUpdate: {
      return &URLLoaderNetworkServiceObserver::OnLoadingStateUpdate_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnDataUseUpdate: {
      return &URLLoaderNetworkServiceObserver::OnDataUseUpdate_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnSharedStorageHeaderReceived: {
      return &URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceived_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnAdAuctionEventRecordHeaderReceived: {
      return &URLLoaderNetworkServiceObserver::OnAdAuctionEventRecordHeaderReceived_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kClone: {
      return &URLLoaderNetworkServiceObserver::Clone_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnWebSocketConnectedToPrivateNetwork: {
      return &URLLoaderNetworkServiceObserver::OnWebSocketConnectedToPrivateNetwork_Sym::IPCStableHash;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnUrlLoaderConnectedToPrivateNetwork: {
      return &URLLoaderNetworkServiceObserver::OnUrlLoaderConnectedToPrivateNetwork_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* URLLoaderNetworkServiceObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::URLLoaderNetworkServiceObserver>(message.name())) {
      case messages::URLLoaderNetworkServiceObserver::kOnSSLCertificateError:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateError";
      case messages::URLLoaderNetworkServiceObserver::kOnCertificateRequested:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnCertificateRequested";
      case messages::URLLoaderNetworkServiceObserver::kOnAuthRequired:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnAuthRequired";
      case messages::URLLoaderNetworkServiceObserver::kOnLocalNetworkAccessPermissionRequired:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequired";
      case messages::URLLoaderNetworkServiceObserver::kOnClearSiteData:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteData";
      case messages::URLLoaderNetworkServiceObserver::kOnLoadingStateUpdate:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdate";
      case messages::URLLoaderNetworkServiceObserver::kOnDataUseUpdate:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnDataUseUpdate";
      case messages::URLLoaderNetworkServiceObserver::kOnSharedStorageHeaderReceived:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceived";
      case messages::URLLoaderNetworkServiceObserver::kOnAdAuctionEventRecordHeaderReceived:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnAdAuctionEventRecordHeaderReceived";
      case messages::URLLoaderNetworkServiceObserver::kClone:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::Clone";
      case messages::URLLoaderNetworkServiceObserver::kOnWebSocketConnectedToPrivateNetwork:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnWebSocketConnectedToPrivateNetwork";
      case messages::URLLoaderNetworkServiceObserver::kOnUrlLoaderConnectedToPrivateNetwork:
            return "Receive network::mojom::URLLoaderNetworkServiceObserver::OnUrlLoaderConnectedToPrivateNetwork";
    }
  } else {
    switch (static_cast<messages::URLLoaderNetworkServiceObserver>(message.name())) {
      case messages::URLLoaderNetworkServiceObserver::kOnSSLCertificateError:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateError";
      case messages::URLLoaderNetworkServiceObserver::kOnCertificateRequested:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnCertificateRequested";
      case messages::URLLoaderNetworkServiceObserver::kOnAuthRequired:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnAuthRequired";
      case messages::URLLoaderNetworkServiceObserver::kOnLocalNetworkAccessPermissionRequired:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequired";
      case messages::URLLoaderNetworkServiceObserver::kOnClearSiteData:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteData";
      case messages::URLLoaderNetworkServiceObserver::kOnLoadingStateUpdate:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdate";
      case messages::URLLoaderNetworkServiceObserver::kOnDataUseUpdate:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnDataUseUpdate";
      case messages::URLLoaderNetworkServiceObserver::kOnSharedStorageHeaderReceived:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceived";
      case messages::URLLoaderNetworkServiceObserver::kOnAdAuctionEventRecordHeaderReceived:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnAdAuctionEventRecordHeaderReceived";
      case messages::URLLoaderNetworkServiceObserver::kClone:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::Clone";
      case messages::URLLoaderNetworkServiceObserver::kOnWebSocketConnectedToPrivateNetwork:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnWebSocketConnectedToPrivateNetwork";
      case messages::URLLoaderNetworkServiceObserver::kOnUrlLoaderConnectedToPrivateNetwork:
            return "Receive reply network::mojom::URLLoaderNetworkServiceObserver::OnUrlLoaderConnectedToPrivateNetwork";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t URLLoaderNetworkServiceObserver::OnSSLCertificateError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0da13f2f;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnCertificateRequested_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6992b5d9;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnCertificateRequested
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnAuthRequired_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65dc9100;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnAuthRequired
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequired_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x53ca4916;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequired
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnClearSiteData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4894337f;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnLoadingStateUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba76eccb;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnDataUseUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29bb842d;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnDataUseUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceived_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67fa2679;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnAdAuctionEventRecordHeaderReceived_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12fba543;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnAdAuctionEventRecordHeaderReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x35f0b7e4;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnWebSocketConnectedToPrivateNetwork_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5176fa6f;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnWebSocketConnectedToPrivateNetwork
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t URLLoaderNetworkServiceObserver::OnUrlLoaderConnectedToPrivateNetwork_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9648a38;  // IPCStableHash for network::mojom::URLLoaderNetworkServiceObserver::OnUrlLoaderConnectedToPrivateNetwork
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback(
      URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback callback
      ) : callback_(std::move(callback)) {
  }

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback(const URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback&) = delete;
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback& operator=(const URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback callback_;
};

class URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ForwardToCallback(
      URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequiredCallback callback
      ) : callback_(std::move(callback)) {
  }

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ForwardToCallback(const URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ForwardToCallback&) = delete;
  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ForwardToCallback& operator=(const URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequiredCallback callback_;
};

class URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback(
      URLLoaderNetworkServiceObserver::OnClearSiteDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback(const URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback&) = delete;
  URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback& operator=(const URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderNetworkServiceObserver::OnClearSiteDataCallback callback_;
};

class URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback(
      URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback callback
      ) : callback_(std::move(callback)) {
  }

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback(const URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback&) = delete;
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback& operator=(const URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback callback_;
};

class URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ForwardToCallback(
      URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceivedCallback callback
      ) : callback_(std::move(callback)) {
  }

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ForwardToCallback(const URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ForwardToCallback&) = delete;
  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ForwardToCallback& operator=(const URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceivedCallback callback_;
};

URLLoaderNetworkServiceObserverProxy::URLLoaderNetworkServiceObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderNetworkServiceObserverProxy::OnSSLCertificateError(
    const ::GURL& in_url, int32_t in_net_error, const ::net::SSLInfo& in_ssl_info, bool in_fatal, OnSSLCertificateErrorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ssl_info"), in_ssl_info,
                        "<value of type const ::net::SSLInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fatal"), in_fatal,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnSSLCertificateError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in URLLoaderNetworkServiceObserver.OnSSLCertificateError request");

  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->ssl_info)::BaseType> ssl_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
    in_ssl_info,
    ssl_info_fragment);

  params->ssl_info.Set(
      ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ssl_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ssl_info in URLLoaderNetworkServiceObserver.OnSSLCertificateError request");

  params->fatal = in_fatal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnSSLCertificateError");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void URLLoaderNetworkServiceObserverProxy::OnCertificateRequested(
    const std::optional<::base::UnguessableToken>& in_window_id, const ::scoped_refptr<::net::SSLCertRequestInfo>& in_cert_info, ::mojo::PendingRemote<ClientCertificateResponder> in_cert_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnCertificateRequested", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_id"), in_window_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert_info"), in_cert_info,
                        "<value of type const ::scoped_refptr<::net::SSLCertRequestInfo>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert_responder"), in_cert_responder,
                        "<value of type ::mojo::PendingRemote<ClientCertificateResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnCertificateRequested), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_id)::BaseType> window_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_window_id,
    window_id_fragment);

  params->window_id.Set(
      window_id_fragment.is_null() ? nullptr : window_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->cert_info)::BaseType> cert_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SSLCertRequestInfoDataView>(
    in_cert_info,
    cert_info_fragment);

  params->cert_info.Set(
      cert_info_fragment.is_null() ? nullptr : cert_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cert_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cert_info in URLLoaderNetworkServiceObserver.OnCertificateRequested request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ClientCertificateResponderInterfaceBase>>(
    in_cert_responder,
    &params->cert_responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->cert_responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid cert_responder in URLLoaderNetworkServiceObserver.OnCertificateRequested request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnCertificateRequested");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderNetworkServiceObserverProxy::OnAuthRequired(
    const std::optional<::base::UnguessableToken>& in_window_id, int32_t in_request_id, const ::GURL& in_url, bool in_first_auth_attempt, const ::net::AuthChallengeInfo& in_auth_info, const ::scoped_refptr<::net::HttpResponseHeaders>& in_head_headers, ::mojo::PendingRemote<AuthChallengeResponder> in_auth_challenge_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnAuthRequired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_id"), in_window_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("first_auth_attempt"), in_first_auth_attempt,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auth_info"), in_auth_info,
                        "<value of type const ::net::AuthChallengeInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head_headers"), in_head_headers,
                        "<value of type const ::scoped_refptr<::net::HttpResponseHeaders>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auth_challenge_responder"), in_auth_challenge_responder,
                        "<value of type ::mojo::PendingRemote<AuthChallengeResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnAuthRequired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_id)::BaseType> window_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_window_id,
    window_id_fragment);

  params->window_id.Set(
      window_id_fragment.is_null() ? nullptr : window_id_fragment.data());

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in URLLoaderNetworkServiceObserver.OnAuthRequired request");

  params->first_auth_attempt = in_first_auth_attempt;
  mojo::internal::MessageFragment<
      typename decltype(params->auth_info)::BaseType> auth_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
    in_auth_info,
    auth_info_fragment);

  params->auth_info.Set(
      auth_info_fragment.is_null() ? nullptr : auth_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auth_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auth_info in URLLoaderNetworkServiceObserver.OnAuthRequired request");
  mojo::internal::MessageFragment<
      typename decltype(params->head_headers)::BaseType> head_headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
    in_head_headers,
    head_headers_fragment);

  params->head_headers.Set(
      head_headers_fragment.is_null() ? nullptr : head_headers_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::AuthChallengeResponderInterfaceBase>>(
    in_auth_challenge_responder,
    &params->auth_challenge_responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->auth_challenge_responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid auth_challenge_responder in URLLoaderNetworkServiceObserver.OnAuthRequired request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnAuthRequired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderNetworkServiceObserverProxy::OnLocalNetworkAccessPermissionRequired(
    OnLocalNetworkAccessPermissionRequiredCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequired");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnLocalNetworkAccessPermissionRequired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnLocalNetworkAccessPermissionRequired");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void URLLoaderNetworkServiceObserverProxy::OnClearSiteData(
    const ::GURL& in_url, const std::string& in_header_value, int32_t in_load_flags, const std::optional<::net::CookiePartitionKey>& in_cookie_partition_key, bool in_partitioned_state_allowed_only, OnClearSiteDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header_value"), in_header_value,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("load_flags"), in_load_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_partition_key"), in_cookie_partition_key,
                        "<value of type const std::optional<::net::CookiePartitionKey>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("partitioned_state_allowed_only"), in_partitioned_state_allowed_only,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnClearSiteData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in URLLoaderNetworkServiceObserver.OnClearSiteData request");
  mojo::internal::MessageFragment<
      typename decltype(params->header_value)::BaseType> header_value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_header_value,
    header_value_fragment);

  params->header_value.Set(
      header_value_fragment.is_null() ? nullptr : header_value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->header_value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null header_value in URLLoaderNetworkServiceObserver.OnClearSiteData request");

  params->load_flags = in_load_flags;
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_partition_key)::BaseType> cookie_partition_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookiePartitionKeyDataView>(
    in_cookie_partition_key,
    cookie_partition_key_fragment);

  params->cookie_partition_key.Set(
      cookie_partition_key_fragment.is_null() ? nullptr : cookie_partition_key_fragment.data());

  params->partitioned_state_allowed_only = in_partitioned_state_allowed_only;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnClearSiteData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void URLLoaderNetworkServiceObserverProxy::OnLoadingStateUpdate(
    LoadInfoPtr in_info, OnLoadingStateUpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type LoadInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnLoadingStateUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::LoadInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in URLLoaderNetworkServiceObserver.OnLoadingStateUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnLoadingStateUpdate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void URLLoaderNetworkServiceObserverProxy::OnDataUseUpdate(
    int32_t in_network_traffic_annotation_id_hash, int64_t in_recv_bytes, int64_t in_sent_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnDataUseUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_traffic_annotation_id_hash"), in_network_traffic_annotation_id_hash,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recv_bytes"), in_recv_bytes,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sent_bytes"), in_sent_bytes,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnDataUseUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data> params(
          message);
  params.Allocate();

  params->network_traffic_annotation_id_hash = in_network_traffic_annotation_id_hash;

  params->recv_bytes = in_recv_bytes;

  params->sent_bytes = in_sent_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnDataUseUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderNetworkServiceObserverProxy::OnSharedStorageHeaderReceived(
    const ::url::Origin& in_request_origin, ::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> in_methods_with_options, const std::optional<::std::string>& in_with_lock, OnSharedStorageHeaderReceivedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_origin"), in_request_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("methods_with_options"), in_methods_with_options,
                        "<value of type ::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("with_lock"), in_with_lock,
                        "<value of type const std::optional<::std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnSharedStorageHeaderReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_origin)::BaseType> request_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_request_origin,
    request_origin_fragment);

  params->request_origin.Set(
      request_origin_fragment.is_null() ? nullptr : request_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_origin in URLLoaderNetworkServiceObserver.OnSharedStorageHeaderReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->methods_with_options)::BaseType> methods_with_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView>(
    in_methods_with_options,
    methods_with_options_fragment);

  params->methods_with_options.Set(
      methods_with_options_fragment.is_null() ? nullptr : methods_with_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->methods_with_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null methods_with_options in URLLoaderNetworkServiceObserver.OnSharedStorageHeaderReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->with_lock)::BaseType> with_lock_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::LockNameDataView>(
    in_with_lock,
    with_lock_fragment);

  params->with_lock.Set(
      with_lock_fragment.is_null() ? nullptr : with_lock_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnSharedStorageHeaderReceived");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void URLLoaderNetworkServiceObserverProxy::OnAdAuctionEventRecordHeaderReceived(
    ::network::AdAuctionEventRecord in_ad_auction_event_record, const std::optional<::url::Origin>& in_top_frame_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnAdAuctionEventRecordHeaderReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_auction_event_record"), in_ad_auction_event_record,
                        "<value of type ::network::AdAuctionEventRecord>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const std::optional<::url::Origin>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnAdAuctionEventRecordHeaderReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ad_auction_event_record)::BaseType> ad_auction_event_record_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AdAuctionEventRecordDataView>(
    in_ad_auction_event_record,
    ad_auction_event_record_fragment);

  params->ad_auction_event_record.Set(
      ad_auction_event_record_fragment.is_null() ? nullptr : ad_auction_event_record_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ad_auction_event_record.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ad_auction_event_record in URLLoaderNetworkServiceObserver.OnAdAuctionEventRecordHeaderReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnAdAuctionEventRecordHeaderReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderNetworkServiceObserverProxy::Clone(
    ::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<URLLoaderNetworkServiceObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in URLLoaderNetworkServiceObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderNetworkServiceObserverProxy::OnWebSocketConnectedToPrivateNetwork(
    ::network::mojom::IPAddressSpace in_ip_address_space) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnWebSocketConnectedToPrivateNetwork", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ip_address_space"), in_ip_address_space,
                        "<value of type ::network::mojom::IPAddressSpace>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnWebSocketConnectedToPrivateNetwork), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
    in_ip_address_space,
    &params->ip_address_space);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnWebSocketConnectedToPrivateNetwork");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void URLLoaderNetworkServiceObserverProxy::OnUrlLoaderConnectedToPrivateNetwork(
    const ::GURL& in_request_url, ::network::mojom::IPAddressSpace in_response_address_space, ::network::mojom::IPAddressSpace in_client_address_space, ::network::mojom::IPAddressSpace in_target_address_space) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::URLLoaderNetworkServiceObserver::OnUrlLoaderConnectedToPrivateNetwork", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_url"), in_request_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_address_space"), in_response_address_space,
                        "<value of type ::network::mojom::IPAddressSpace>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_address_space"), in_client_address_space,
                        "<value of type ::network::mojom::IPAddressSpace>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_address_space"), in_target_address_space,
                        "<value of type ::network::mojom::IPAddressSpace>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnUrlLoaderConnectedToPrivateNetwork), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_url)::BaseType> request_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_request_url,
    request_url_fragment);

  params->request_url.Set(
      request_url_fragment.is_null() ? nullptr : request_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_url in URLLoaderNetworkServiceObserver.OnUrlLoaderConnectedToPrivateNetwork request");

  
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
    in_response_address_space,
    &params->response_address_space);

  
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
    in_client_address_space,
    &params->client_address_space);

  
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
    in_target_address_space,
    &params->target_address_space);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnUrlLoaderConnectedToPrivateNetwork");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder> proxy(
        new URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);
};

bool URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for URLLoaderNetworkServiceObserver.0
  bool success = true;
  int32_t p_net_error{};
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderNetworkServiceObserver::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_net_error));
  }
  return true;
}

void URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateError", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnSSLCertificateError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnSSLCertificateError");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequiredCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ProxyToResponder> proxy(
        new URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequiredCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_permission_granted);
};

bool URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for URLLoaderNetworkServiceObserver.3
  bool success = true;
  bool p_permission_granted{};
  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_permission_granted = input_data_view.permission_granted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderNetworkServiceObserver::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_permission_granted));
  }
  return true;
}

void URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ProxyToResponder::Run(
    bool in_permission_granted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::URLLoaderNetworkServiceObserver::OnLocalNetworkAccessPermissionRequired", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission_granted"), in_permission_granted,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnLocalNetworkAccessPermissionRequired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->permission_granted = in_permission_granted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnLocalNetworkAccessPermissionRequired");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static URLLoaderNetworkServiceObserver::OnClearSiteDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder> proxy(
        new URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderNetworkServiceObserver::OnClearSiteDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for URLLoaderNetworkServiceObserver.4
  bool success = true;
  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderNetworkServiceObserver::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteData");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnClearSiteData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnClearSiteData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder> proxy(
        new URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for URLLoaderNetworkServiceObserver.5
  bool success = true;
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderNetworkServiceObserver::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdate");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnLoadingStateUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnLoadingStateUpdate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceivedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ProxyToResponder> proxy(
        new URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceivedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for URLLoaderNetworkServiceObserver.7
  bool success = true;
  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderNetworkServiceObserver::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::URLLoaderNetworkServiceObserver::OnSharedStorageHeaderReceived");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnSharedStorageHeaderReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnSharedStorageHeaderReceived");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool URLLoaderNetworkServiceObserverStubDispatch::Accept(
    URLLoaderNetworkServiceObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::URLLoaderNetworkServiceObserver>(message->header()->name)) {
    case messages::URLLoaderNetworkServiceObserver::kOnSSLCertificateError: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnCertificateRequested: {
      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.1
      bool success = true;
      std::optional<::base::UnguessableToken> p_window_id{};
      ::scoped_refptr<::net::SSLCertRequestInfo> p_cert_info{};
      ::mojo::PendingRemote<ClientCertificateResponder> p_cert_responder{};
      URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowId(&p_window_id))
        success = false;
      if (success && !input_data_view.ReadCertInfo(&p_cert_info))
        success = false;
      if (success) {
        p_cert_responder =
            input_data_view.TakeCertResponder<decltype(p_cert_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCertificateRequested(        
        std::move(p_window_id), 
        std::move(p_cert_info), 
        std::move(p_cert_responder));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnAuthRequired: {
      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.2
      bool success = true;
      std::optional<::base::UnguessableToken> p_window_id{};
      int32_t p_request_id{};
      ::GURL p_url{};
      bool p_first_auth_attempt{};
      ::net::AuthChallengeInfo p_auth_info{};
      ::scoped_refptr<::net::HttpResponseHeaders> p_head_headers{};
      ::mojo::PendingRemote<AuthChallengeResponder> p_auth_challenge_responder{};
      URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowId(&p_window_id))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_first_auth_attempt = input_data_view.first_auth_attempt();
      if (success && !input_data_view.ReadAuthInfo(&p_auth_info))
        success = false;
      if (success && !input_data_view.ReadHeadHeaders(&p_head_headers))
        success = false;
      if (success) {
        p_auth_challenge_responder =
            input_data_view.TakeAuthChallengeResponder<decltype(p_auth_challenge_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthRequired(        
        std::move(p_window_id), 
        std::move(p_request_id), 
        std::move(p_url), 
        std::move(p_first_auth_attempt), 
        std::move(p_auth_info), 
        std::move(p_head_headers), 
        std::move(p_auth_challenge_responder));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnLocalNetworkAccessPermissionRequired: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnClearSiteData: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnLoadingStateUpdate: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnDataUseUpdate: {
      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.6
      bool success = true;
      int32_t p_network_traffic_annotation_id_hash{};
      int64_t p_recv_bytes{};
      int64_t p_sent_bytes{};
      URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_network_traffic_annotation_id_hash = input_data_view.network_traffic_annotation_id_hash();
      if (success)
        p_recv_bytes = input_data_view.recv_bytes();
      if (success)
        p_sent_bytes = input_data_view.sent_bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDataUseUpdate(        
        std::move(p_network_traffic_annotation_id_hash), 
        std::move(p_recv_bytes), 
        std::move(p_sent_bytes));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnSharedStorageHeaderReceived: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnAdAuctionEventRecordHeaderReceived: {
      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.8
      bool success = true;
      ::network::AdAuctionEventRecord p_ad_auction_event_record{};
      std::optional<::url::Origin> p_top_frame_origin{};
      URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAdAuctionEventRecord(&p_ad_auction_event_record))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAdAuctionEventRecordHeaderReceived(        
        std::move(p_ad_auction_event_record), 
        std::move(p_top_frame_origin));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kClone: {
      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.9
      bool success = true;
      ::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> p_listener{};
      URLLoaderNetworkServiceObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_listener));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnWebSocketConnectedToPrivateNetwork: {
      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.10
      bool success = true;
      ::network::mojom::IPAddressSpace p_ip_address_space{};
      URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIpAddressSpace(&p_ip_address_space))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebSocketConnectedToPrivateNetwork(        
        std::move(p_ip_address_space));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnUrlLoaderConnectedToPrivateNetwork: {
      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.11
      bool success = true;
      ::GURL p_request_url{};
      ::network::mojom::IPAddressSpace p_response_address_space{};
      ::network::mojom::IPAddressSpace p_client_address_space{};
      ::network::mojom::IPAddressSpace p_target_address_space{};
      URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestUrl(&p_request_url))
        success = false;
      if (success && !input_data_view.ReadResponseAddressSpace(&p_response_address_space))
        success = false;
      if (success && !input_data_view.ReadClientAddressSpace(&p_client_address_space))
        success = false;
      if (success && !input_data_view.ReadTargetAddressSpace(&p_target_address_space))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUrlLoaderConnectedToPrivateNetwork(        
        std::move(p_request_url), 
        std::move(p_response_address_space), 
        std::move(p_client_address_space), 
        std::move(p_target_address_space));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderNetworkServiceObserverStubDispatch::AcceptWithResponder(
    URLLoaderNetworkServiceObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::URLLoaderNetworkServiceObserver>(message->header()->name)) {
    case messages::URLLoaderNetworkServiceObserver::kOnSSLCertificateError: {
      internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.0
      bool success = true;
      ::GURL p_url{};
      int32_t p_net_error{};
      ::net::SSLInfo p_ssl_info{};
      bool p_fatal{};
      URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_net_error = input_data_view.net_error();
      if (success && !input_data_view.ReadSslInfo(&p_ssl_info))
        success = false;
      if (success)
        p_fatal = input_data_view.fatal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 0, false);
        return false;
      }
      auto callback =
          URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSSLCertificateError(        
        std::move(p_url), 
        std::move(p_net_error), 
        std::move(p_ssl_info), 
        std::move(p_fatal), std::move(callback));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnCertificateRequested: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnAuthRequired: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnLocalNetworkAccessPermissionRequired: {
      internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.3
      bool success = true;
      URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 3, false);
        return false;
      }
      auto callback =
          URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLocalNetworkAccessPermissionRequired(std::move(callback));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnClearSiteData: {
      internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.4
      bool success = true;
      ::GURL p_url{};
      std::string p_header_value{};
      int32_t p_load_flags{};
      std::optional<::net::CookiePartitionKey> p_cookie_partition_key{};
      bool p_partitioned_state_allowed_only{};
      URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHeaderValue(&p_header_value))
        success = false;
      if (success)
        p_load_flags = input_data_view.load_flags();
      if (success && !input_data_view.ReadCookiePartitionKey(&p_cookie_partition_key))
        success = false;
      if (success)
        p_partitioned_state_allowed_only = input_data_view.partitioned_state_allowed_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 4, false);
        return false;
      }
      auto callback =
          URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClearSiteData(        
        std::move(p_url), 
        std::move(p_header_value), 
        std::move(p_load_flags), 
        std::move(p_cookie_partition_key), 
        std::move(p_partitioned_state_allowed_only), std::move(callback));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnLoadingStateUpdate: {
      internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.5
      bool success = true;
      LoadInfoPtr p_info{};
      URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 5, false);
        return false;
      }
      auto callback =
          URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLoadingStateUpdate(        
        std::move(p_info), std::move(callback));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnDataUseUpdate: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnSharedStorageHeaderReceived: {
      internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for URLLoaderNetworkServiceObserver.7
      bool success = true;
      ::url::Origin p_request_origin{};
      ::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> p_methods_with_options{};
      std::optional<::std::string> p_with_lock{};
      URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestOrigin(&p_request_origin))
        success = false;
      if (success && !input_data_view.ReadMethodsWithOptions(&p_methods_with_options))
        success = false;
      if (success && !input_data_view.ReadWithLock(&p_with_lock))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 7, false);
        return false;
      }
      auto callback =
          URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSharedStorageHeaderReceived(        
        std::move(p_request_origin), 
        std::move(p_methods_with_options), 
        std::move(p_with_lock), std::move(callback));
      return true;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnAdAuctionEventRecordHeaderReceived: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kClone: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnWebSocketConnectedToPrivateNetwork: {
      break;
    }
    case messages::URLLoaderNetworkServiceObserver::kOnUrlLoaderConnectedToPrivateNetwork: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderNetworkServiceObserverValidationInfo[] = {
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnSSLCertificateError),
     { &internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data::Validate,
      &internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnCertificateRequested),
     { &internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnAuthRequired),
     { &internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnLocalNetworkAccessPermissionRequired),
     { &internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params_Data::Validate,
      &internal::URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnClearSiteData),
     { &internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data::Validate,
      &internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnLoadingStateUpdate),
     { &internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data::Validate,
      &internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnDataUseUpdate),
     { &internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnSharedStorageHeaderReceived),
     { &internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params_Data::Validate,
      &internal::URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnAdAuctionEventRecordHeaderReceived),
     { &internal::URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kClone),
     { &internal::URLLoaderNetworkServiceObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnWebSocketConnectedToPrivateNetwork),
     { &internal::URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::URLLoaderNetworkServiceObserver::kOnUrlLoaderConnectedToPrivateNetwork),
     { &internal::URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderNetworkServiceObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::URLLoaderNetworkServiceObserver::Name_,
    kURLLoaderNetworkServiceObserverValidationInfo);
}

bool URLLoaderNetworkServiceObserverResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::URLLoaderNetworkServiceObserver::Name_,
    kURLLoaderNetworkServiceObserverValidationInfo);

}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::LoadInfo::DataView, ::network::mojom::LoadInfoPtr>::Read(
    ::network::mojom::LoadInfo::DataView input,
    ::network::mojom::LoadInfoPtr* output) {
  bool success = true;
  ::network::mojom::LoadInfoPtr result(::network::mojom::LoadInfo::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->load_state = input.load_state();
      if (success && !input.ReadStateParam(&result->state_param))
        success = false;
      if (success)
        result->upload_position = input.upload_position();
      if (success)
        result->upload_size = input.upload_size();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void ClientCertificateResponderInterceptorForTesting::ContinueWithCertificate(const ::scoped_refptr<::net::X509Certificate>& x509_certificate, const std::string& provider_name, const std::vector<uint16_t>& algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> ssl_private_key) {
  GetForwardingInterface()->ContinueWithCertificate(
    std::move(x509_certificate)
    , 
    std::move(provider_name)
    , 
    std::move(algorithm_preferences)
    , 
    std::move(ssl_private_key)
    );
}
void ClientCertificateResponderInterceptorForTesting::ContinueWithoutCertificate() {
  GetForwardingInterface()->ContinueWithoutCertificate();
}
void ClientCertificateResponderInterceptorForTesting::CancelRequest() {
  GetForwardingInterface()->CancelRequest();
}
ClientCertificateResponderAsyncWaiter::ClientCertificateResponderAsyncWaiter(
    ClientCertificateResponder* proxy) : proxy_(proxy) {}

ClientCertificateResponderAsyncWaiter::~ClientCertificateResponderAsyncWaiter() = default;





void SSLPrivateKeyInterceptorForTesting::Sign(uint16_t algorithm, const std::vector<uint8_t>& input, SignCallback callback) {
  GetForwardingInterface()->Sign(
    std::move(algorithm)
    , 
    std::move(input)
    , std::move(callback));
}
SSLPrivateKeyAsyncWaiter::SSLPrivateKeyAsyncWaiter(
    SSLPrivateKey* proxy) : proxy_(proxy) {}

SSLPrivateKeyAsyncWaiter::~SSLPrivateKeyAsyncWaiter() = default;


void SSLPrivateKeyAsyncWaiter::Sign(
    uint16_t algorithm, const std::vector<uint8_t>& input, int32_t* out_net_error, std::vector<uint8_t>* out_signature) {
  base::RunLoop loop;
  proxy_->Sign(
      std::move(algorithm),
      std::move(input),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             std::vector<uint8_t>* out_signature
,
             int32_t net_error,
             const std::vector<uint8_t>& signature) {*out_net_error = std::move(net_error);*out_signature = std::move(signature);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_signature));
  loop.Run();
}






void AuthChallengeResponderInterceptorForTesting::OnAuthCredentials(const std::optional<::net::AuthCredentials>& credentials) {
  GetForwardingInterface()->OnAuthCredentials(
    std::move(credentials)
    );
}
AuthChallengeResponderAsyncWaiter::AuthChallengeResponderAsyncWaiter(
    AuthChallengeResponder* proxy) : proxy_(proxy) {}

AuthChallengeResponderAsyncWaiter::~AuthChallengeResponderAsyncWaiter() = default;





void URLLoaderNetworkServiceObserverInterceptorForTesting::OnSSLCertificateError(const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal, OnSSLCertificateErrorCallback callback) {
  GetForwardingInterface()->OnSSLCertificateError(
    std::move(url)
    , 
    std::move(net_error)
    , 
    std::move(ssl_info)
    , 
    std::move(fatal)
    , std::move(callback));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnCertificateRequested(const std::optional<::base::UnguessableToken>& window_id, const ::scoped_refptr<::net::SSLCertRequestInfo>& cert_info, ::mojo::PendingRemote<ClientCertificateResponder> cert_responder) {
  GetForwardingInterface()->OnCertificateRequested(
    std::move(window_id)
    , 
    std::move(cert_info)
    , 
    std::move(cert_responder)
    );
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnAuthRequired(const std::optional<::base::UnguessableToken>& window_id, int32_t request_id, const ::GURL& url, bool first_auth_attempt, const ::net::AuthChallengeInfo& auth_info, const ::scoped_refptr<::net::HttpResponseHeaders>& head_headers, ::mojo::PendingRemote<AuthChallengeResponder> auth_challenge_responder) {
  GetForwardingInterface()->OnAuthRequired(
    std::move(window_id)
    , 
    std::move(request_id)
    , 
    std::move(url)
    , 
    std::move(first_auth_attempt)
    , 
    std::move(auth_info)
    , 
    std::move(head_headers)
    , 
    std::move(auth_challenge_responder)
    );
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnLocalNetworkAccessPermissionRequired(OnLocalNetworkAccessPermissionRequiredCallback callback) {
  GetForwardingInterface()->OnLocalNetworkAccessPermissionRequired(std::move(callback));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnClearSiteData(const ::GURL& url, const std::string& header_value, int32_t load_flags, const std::optional<::net::CookiePartitionKey>& cookie_partition_key, bool partitioned_state_allowed_only, OnClearSiteDataCallback callback) {
  GetForwardingInterface()->OnClearSiteData(
    std::move(url)
    , 
    std::move(header_value)
    , 
    std::move(load_flags)
    , 
    std::move(cookie_partition_key)
    , 
    std::move(partitioned_state_allowed_only)
    , std::move(callback));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnLoadingStateUpdate(LoadInfoPtr info, OnLoadingStateUpdateCallback callback) {
  GetForwardingInterface()->OnLoadingStateUpdate(
    std::move(info)
    , std::move(callback));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnDataUseUpdate(int32_t network_traffic_annotation_id_hash, int64_t recv_bytes, int64_t sent_bytes) {
  GetForwardingInterface()->OnDataUseUpdate(
    std::move(network_traffic_annotation_id_hash)
    , 
    std::move(recv_bytes)
    , 
    std::move(sent_bytes)
    );
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnSharedStorageHeaderReceived(const ::url::Origin& request_origin, ::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, OnSharedStorageHeaderReceivedCallback callback) {
  GetForwardingInterface()->OnSharedStorageHeaderReceived(
    std::move(request_origin)
    , 
    std::move(methods_with_options)
    , 
    std::move(with_lock)
    , std::move(callback));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnAdAuctionEventRecordHeaderReceived(::network::AdAuctionEventRecord ad_auction_event_record, const std::optional<::url::Origin>& top_frame_origin) {
  GetForwardingInterface()->OnAdAuctionEventRecordHeaderReceived(
    std::move(ad_auction_event_record)
    , 
    std::move(top_frame_origin)
    );
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> listener) {
  GetForwardingInterface()->Clone(
    std::move(listener)
    );
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnWebSocketConnectedToPrivateNetwork(::network::mojom::IPAddressSpace ip_address_space) {
  GetForwardingInterface()->OnWebSocketConnectedToPrivateNetwork(
    std::move(ip_address_space)
    );
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnUrlLoaderConnectedToPrivateNetwork(const ::GURL& request_url, ::network::mojom::IPAddressSpace response_address_space, ::network::mojom::IPAddressSpace client_address_space, ::network::mojom::IPAddressSpace target_address_space) {
  GetForwardingInterface()->OnUrlLoaderConnectedToPrivateNetwork(
    std::move(request_url)
    , 
    std::move(response_address_space)
    , 
    std::move(client_address_space)
    , 
    std::move(target_address_space)
    );
}
URLLoaderNetworkServiceObserverAsyncWaiter::URLLoaderNetworkServiceObserverAsyncWaiter(
    URLLoaderNetworkServiceObserver* proxy) : proxy_(proxy) {}

URLLoaderNetworkServiceObserverAsyncWaiter::~URLLoaderNetworkServiceObserverAsyncWaiter() = default;


void URLLoaderNetworkServiceObserverAsyncWaiter::OnSSLCertificateError(
    const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->OnSSLCertificateError(
      std::move(url),
      std::move(net_error),
      std::move(ssl_info),
      std::move(fatal),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             int32_t net_error) {*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_net_error));
  loop.Run();
}

int32_t URLLoaderNetworkServiceObserverAsyncWaiter::OnSSLCertificateError(
    const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal) {
  int32_t async_wait_result;
  OnSSLCertificateError(std::move(url),std::move(net_error),std::move(ssl_info),std::move(fatal),&async_wait_result);
  return async_wait_result;
}

void URLLoaderNetworkServiceObserverAsyncWaiter::OnLocalNetworkAccessPermissionRequired(
    bool* out_permission_granted) {
  base::RunLoop loop;
  proxy_->OnLocalNetworkAccessPermissionRequired(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_permission_granted
,
             bool permission_granted) {*out_permission_granted = std::move(permission_granted);
            loop->Quit();
          },
          &loop,
          out_permission_granted));
  loop.Run();
}

bool URLLoaderNetworkServiceObserverAsyncWaiter::OnLocalNetworkAccessPermissionRequired(
    ) {
  bool async_wait_result;
  OnLocalNetworkAccessPermissionRequired(&async_wait_result);
  return async_wait_result;
}

void URLLoaderNetworkServiceObserverAsyncWaiter::OnClearSiteData(
    const ::GURL& url, const std::string& header_value, int32_t load_flags, const std::optional<::net::CookiePartitionKey>& cookie_partition_key, bool partitioned_state_allowed_only) {
  base::RunLoop loop;
  proxy_->OnClearSiteData(
      std::move(url),
      std::move(header_value),
      std::move(load_flags),
      std::move(cookie_partition_key),
      std::move(partitioned_state_allowed_only),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void URLLoaderNetworkServiceObserverAsyncWaiter::OnLoadingStateUpdate(
    LoadInfoPtr info) {
  base::RunLoop loop;
  proxy_->OnLoadingStateUpdate(
      std::move(info),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void URLLoaderNetworkServiceObserverAsyncWaiter::OnSharedStorageHeaderReceived(
    const ::url::Origin& request_origin, ::std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock) {
  base::RunLoop loop;
  proxy_->OnSharedStorageHeaderReceived(
      std::move(request_origin),
      std::move(methods_with_options),
      std::move(with_lock),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif