// services/network/public/mojom/url_loader_completion_status.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader_completion_status.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_loader_completion_status.mojom-params-data.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader_completion_status.mojom-import-headers.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
BlockedByResponseReasonWrapper::BlockedByResponseReasonWrapper()
    : reason() {}

BlockedByResponseReasonWrapper::BlockedByResponseReasonWrapper(
    ::network::mojom::BlockedByResponseReason reason_in)
    : reason(std::move(reason_in)) {}

BlockedByResponseReasonWrapper::~BlockedByResponseReasonWrapper() = default;
size_t BlockedByResponseReasonWrapper::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->reason);
  return seed;
}

void BlockedByResponseReasonWrapper::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reason"), this->reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::BlockedByResponseReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BlockedByResponseReasonWrapper::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLLoaderCompletionStatus::URLLoaderCompletionStatus()
    : error_code(0),
      extended_error_code(0),
      exists_in_cache(false),
      completion_time(),
      encoded_data_length(0),
      encoded_body_length(0),
      decoded_body_length(0),
      cors_error_status(),
      private_network_access_preflight_result(::network::mojom::PrivateNetworkAccessPreflightResult::kNone),
      trust_token_operation_status(::network::mojom::TrustTokenOperationStatus::kOk),
      ssl_info(),
      blocked_by_response_reason(),
      should_report_orb_blocking(false),
      resolve_error_info(),
      should_collapse_initiator(false) {}

URLLoaderCompletionStatus::URLLoaderCompletionStatus(
    int32_t error_code_in,
    int32_t extended_error_code_in,
    bool exists_in_cache_in,
    ::base::TimeTicks completion_time_in,
    int64_t encoded_data_length_in,
    int64_t encoded_body_length_in,
    int64_t decoded_body_length_in,
    const std::optional<::network::CorsErrorStatus>& cors_error_status_in,
    ::network::mojom::PrivateNetworkAccessPreflightResult private_network_access_preflight_result_in,
    ::network::mojom::TrustTokenOperationStatus trust_token_operation_status_in,
    const std::optional<::net::SSLInfo>& ssl_info_in,
    BlockedByResponseReasonWrapperPtr blocked_by_response_reason_in,
    bool should_report_orb_blocking_in,
    const ::net::ResolveErrorInfo& resolve_error_info_in,
    bool should_collapse_initiator_in)
    : error_code(std::move(error_code_in)),
      extended_error_code(std::move(extended_error_code_in)),
      exists_in_cache(std::move(exists_in_cache_in)),
      completion_time(std::move(completion_time_in)),
      encoded_data_length(std::move(encoded_data_length_in)),
      encoded_body_length(std::move(encoded_body_length_in)),
      decoded_body_length(std::move(decoded_body_length_in)),
      cors_error_status(std::move(cors_error_status_in)),
      private_network_access_preflight_result(std::move(private_network_access_preflight_result_in)),
      trust_token_operation_status(std::move(trust_token_operation_status_in)),
      ssl_info(std::move(ssl_info_in)),
      blocked_by_response_reason(std::move(blocked_by_response_reason_in)),
      should_report_orb_blocking(std::move(should_report_orb_blocking_in)),
      resolve_error_info(std::move(resolve_error_info_in)),
      should_collapse_initiator(std::move(should_collapse_initiator_in)) {}

URLLoaderCompletionStatus::~URLLoaderCompletionStatus() = default;

void URLLoaderCompletionStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_code"), this->error_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extended_error_code"), this->extended_error_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exists_in_cache"), this->exists_in_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "completion_time"), this->completion_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_data_length"), this->encoded_data_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_body_length"), this->encoded_body_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoded_body_length"), this->decoded_body_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_error_status"), this->cors_error_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::network::CorsErrorStatus>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_network_access_preflight_result"), this->private_network_access_preflight_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::PrivateNetworkAccessPreflightResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_operation_status"), this->trust_token_operation_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::TrustTokenOperationStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ssl_info"), this->ssl_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::SSLInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_by_response_reason"), this->blocked_by_response_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BlockedByResponseReasonWrapperPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_report_orb_blocking"), this->should_report_orb_blocking,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resolve_error_info"), this->resolve_error_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ResolveErrorInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_collapse_initiator"), this->should_collapse_initiator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLLoaderCompletionStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::BlockedByResponseReasonWrapper::DataView, ::network::mojom::BlockedByResponseReasonWrapperPtr>::Read(
    ::network::mojom::BlockedByResponseReasonWrapper::DataView input,
    ::network::mojom::BlockedByResponseReasonWrapperPtr* output) {
  bool success = true;
  ::network::mojom::BlockedByResponseReasonWrapperPtr result(::network::mojom::BlockedByResponseReasonWrapper::New());
  
      if (success && !input.ReadReason(&result->reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::URLLoaderCompletionStatus::DataView, ::network::mojom::URLLoaderCompletionStatusPtr>::Read(
    ::network::mojom::URLLoaderCompletionStatus::DataView input,
    ::network::mojom::URLLoaderCompletionStatusPtr* output) {
  bool success = true;
  ::network::mojom::URLLoaderCompletionStatusPtr result(::network::mojom::URLLoaderCompletionStatus::New());
  
      if (success)
        result->error_code = input.error_code();
      if (success)
        result->extended_error_code = input.extended_error_code();
      if (success)
        result->exists_in_cache = input.exists_in_cache();
      if (success && !input.ReadCompletionTime(&result->completion_time))
        success = false;
      if (success)
        result->encoded_data_length = input.encoded_data_length();
      if (success)
        result->encoded_body_length = input.encoded_body_length();
      if (success)
        result->decoded_body_length = input.decoded_body_length();
      if (success && !input.ReadCorsErrorStatus(&result->cors_error_status))
        success = false;
      if (success && !input.ReadPrivateNetworkAccessPreflightResult(&result->private_network_access_preflight_result))
        success = false;
      if (success && !input.ReadTrustTokenOperationStatus(&result->trust_token_operation_status))
        success = false;
      if (success && !input.ReadSslInfo(&result->ssl_info))
        success = false;
      if (success && !input.ReadBlockedByResponseReason(&result->blocked_by_response_reason))
        success = false;
      if (success)
        result->should_report_orb_blocking = input.should_report_orb_blocking();
      if (success && !input.ReadResolveErrorInfo(&result->resolve_error_info))
        success = false;
      if (success)
        result->should_collapse_initiator = input.should_collapse_initiator();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif