// services/network/public/mojom/trust_token_access_observer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/trust_token_access_observer.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"


namespace network::mojom {
class TrustTokenIssuanceDetailsDataView;

class TrustTokenRedemptionDetailsDataView;

class TrustTokenSigningDetailsDataView;

class TrustTokenAccessDetailsDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenIssuanceDetailsDataView> {
  using Data = ::network::mojom::internal::TrustTokenIssuanceDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenRedemptionDetailsDataView> {
  using Data = ::network::mojom::internal::TrustTokenRedemptionDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenSigningDetailsDataView> {
  using Data = ::network::mojom::internal::TrustTokenSigningDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenAccessDetailsDataView> {
  using Data = ::network::mojom::internal::TrustTokenAccessDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class TrustTokenAccessObserverInterfaceBase {};

using TrustTokenAccessObserverPtrDataView =
    mojo::InterfacePtrDataView<TrustTokenAccessObserverInterfaceBase>;
using TrustTokenAccessObserverRequestDataView =
    mojo::InterfaceRequestDataView<TrustTokenAccessObserverInterfaceBase>;
using TrustTokenAccessObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TrustTokenAccessObserverInterfaceBase>;
using TrustTokenAccessObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TrustTokenAccessObserverInterfaceBase>;


class TrustTokenIssuanceDetailsDataView {
 public:
  TrustTokenIssuanceDetailsDataView() = default;

  TrustTokenIssuanceDetailsDataView(
      internal::TrustTokenIssuanceDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetIssuerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `issuer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIssuer` instead "
    "of `ReadIssuer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->issuer.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool blocked() const {
    return data_->blocked;
  }
 private:
  internal::TrustTokenIssuanceDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustTokenRedemptionDetailsDataView {
 public:
  TrustTokenRedemptionDetailsDataView() = default;

  TrustTokenRedemptionDetailsDataView(
      internal::TrustTokenRedemptionDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetIssuerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `issuer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIssuer` instead "
    "of `ReadIssuer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->issuer.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool blocked() const {
    return data_->blocked;
  }
 private:
  internal::TrustTokenRedemptionDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustTokenSigningDetailsDataView {
 public:
  TrustTokenSigningDetailsDataView() = default;

  TrustTokenSigningDetailsDataView(
      internal::TrustTokenSigningDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool blocked() const {
    return data_->blocked;
  }
 private:
  internal::TrustTokenSigningDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TrustTokenAccessDetailsDataView {
 public:
  using Tag = internal::TrustTokenAccessDetails_Data::TrustTokenAccessDetails_Tag;

  TrustTokenAccessDetailsDataView() = default;

  TrustTokenAccessDetailsDataView(
      internal::TrustTokenAccessDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_issuance() const { return data_->tag == Tag::kIssuance; }
  inline void GetIssuanceDataView(
      TrustTokenIssuanceDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadIssuance(UserType* output) const {
    
    CHECK(is_issuance());
    return mojo::internal::Deserialize<::network::mojom::TrustTokenIssuanceDetailsDataView>(
        data_->data.f_issuance.Get(), output, message_);
  }
  bool is_redemption() const { return data_->tag == Tag::kRedemption; }
  inline void GetRedemptionDataView(
      TrustTokenRedemptionDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRedemption(UserType* output) const {
    
    CHECK(is_redemption());
    return mojo::internal::Deserialize<::network::mojom::TrustTokenRedemptionDetailsDataView>(
        data_->data.f_redemption.Get(), output, message_);
  }
  bool is_signing() const { return data_->tag == Tag::kSigning; }
  inline void GetSigningDataView(
      TrustTokenSigningDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSigning(UserType* output) const {
    
    CHECK(is_signing());
    return mojo::internal::Deserialize<::network::mojom::TrustTokenSigningDetailsDataView>(
        data_->data.f_signing.Get(), output, message_);
  }

 private:
  internal::TrustTokenAccessDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_