// services/network/public/mojom/proxy_config.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/proxy_config.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/proxy_config.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/proxy_config.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_string.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {











class  ProxyBypassRules {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyBypassRules, T>::value>;
  using DataView = ProxyBypassRulesDataView;
  using Data_ = internal::ProxyBypassRules_Data;

  template <typename... Args>
  static ProxyBypassRulesPtr New(Args&&... args) {
    return ProxyBypassRulesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyBypassRulesPtr From(const U& u) {
    return mojo::TypeConverter<ProxyBypassRulesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyBypassRules>::Convert(*this);
  }


  ProxyBypassRules();

  explicit ProxyBypassRules(
      ::blink::Vector<::blink::String> rules);


  ~ProxyBypassRules();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyBypassRulesPtr>
  ProxyBypassRulesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyBypassRules::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyBypassRules::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyBypassRules::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyBypassRules::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyBypassRules::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyBypassRules::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyBypassRules_UnserializedMessageContext<
            UserType, ProxyBypassRules::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyBypassRules::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyBypassRules::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyBypassRules_UnserializedMessageContext<
            UserType, ProxyBypassRules::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyBypassRules::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::String> rules;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyBypassRules::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyBypassRules::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyBypassRules::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyBypassRules::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProxyList {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyList, T>::value>;
  using DataView = ProxyListDataView;
  using Data_ = internal::ProxyList_Data;

  template <typename... Args>
  static ProxyListPtr New(Args&&... args) {
    return ProxyListPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyListPtr From(const U& u) {
    return mojo::TypeConverter<ProxyListPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyList>::Convert(*this);
  }


  ProxyList();

  explicit ProxyList(
      ::blink::Vector<::net::ProxyChain> proxies);


  ~ProxyList();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyListPtr>
  ProxyListPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyList::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyList::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyList::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyList_UnserializedMessageContext<
            UserType, ProxyList::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyList::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyList::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyList_UnserializedMessageContext<
            UserType, ProxyList::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyList::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::net::ProxyChain> proxies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProxyRules {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyRules, T>::value>;
  using DataView = ProxyRulesDataView;
  using Data_ = internal::ProxyRules_Data;

  template <typename... Args>
  static ProxyRulesPtr New(Args&&... args) {
    return ProxyRulesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyRulesPtr From(const U& u) {
    return mojo::TypeConverter<ProxyRulesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyRules>::Convert(*this);
  }


  ProxyRules();

  ProxyRules(
      ProxyBypassRulesPtr bypass_rules,
      bool reverse_bypass,
      ProxyRulesType type,
      ProxyListPtr single_proxies,
      ProxyListPtr proxies_for_http,
      ProxyListPtr proxies_for_https,
      ProxyListPtr proxies_for_ftp,
      ProxyListPtr fallback_proxies);

ProxyRules(const ProxyRules&) = delete;
ProxyRules& operator=(const ProxyRules&) = delete;

  ~ProxyRules();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyRulesPtr>
  ProxyRulesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyRules::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyRules::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyRules::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyRules_UnserializedMessageContext<
            UserType, ProxyRules::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyRules::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyRules::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyRules_UnserializedMessageContext<
            UserType, ProxyRules::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyRules::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ProxyBypassRulesPtr bypass_rules;
  
  bool reverse_bypass;
  
  ProxyRulesType type;
  
  ProxyListPtr single_proxies;
  
  ProxyListPtr proxies_for_http;
  
  ProxyListPtr proxies_for_https;
  
  ProxyListPtr proxies_for_ftp;
  
  ProxyListPtr fallback_proxies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProxyConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyConfig, T>::value>;
  using DataView = ProxyConfigDataView;
  using Data_ = internal::ProxyConfig_Data;

  template <typename... Args>
  static ProxyConfigPtr New(Args&&... args) {
    return ProxyConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyConfigPtr From(const U& u) {
    return mojo::TypeConverter<ProxyConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyConfig>::Convert(*this);
  }


  ProxyConfig();

  ProxyConfig(
      bool auto_detect,
      bool from_system,
      const ::blink::String& pac_url,
      bool pac_mandatory,
      ProxyRulesPtr proxy_rules);

ProxyConfig(const ProxyConfig&) = delete;
ProxyConfig& operator=(const ProxyConfig&) = delete;

  ~ProxyConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyConfigPtr>
  ProxyConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyConfig_UnserializedMessageContext<
            UserType, ProxyConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyConfig_UnserializedMessageContext<
            UserType, ProxyConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool auto_detect;
  
  bool from_system;
  
  ::blink::String pac_url;
  
  bool pac_mandatory;
  
  ProxyRulesPtr proxy_rules;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProxyBypassRulesPtr ProxyBypassRules::Clone() const {
  return New(
      mojo::Clone(rules)
  );
}

template <typename T, ProxyBypassRules::EnableIfSame<T>*>
bool ProxyBypassRules::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rules, other_struct.rules))
    return false;
  return true;
}

template <typename T, ProxyBypassRules::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rules < rhs.rules)
    return true;
  if (rhs.rules < lhs.rules)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyListPtr ProxyList::Clone() const {
  return New(
      mojo::Clone(proxies)
  );
}

template <typename T, ProxyList::EnableIfSame<T>*>
bool ProxyList::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->proxies, other_struct.proxies))
    return false;
  return true;
}

template <typename T, ProxyList::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.proxies < rhs.proxies)
    return true;
  if (rhs.proxies < lhs.proxies)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyRulesPtr ProxyRules::Clone() const {
  return New(
      mojo::Clone(bypass_rules),
      mojo::Clone(reverse_bypass),
      mojo::Clone(type),
      mojo::Clone(single_proxies),
      mojo::Clone(proxies_for_http),
      mojo::Clone(proxies_for_https),
      mojo::Clone(proxies_for_ftp),
      mojo::Clone(fallback_proxies)
  );
}

template <typename T, ProxyRules::EnableIfSame<T>*>
bool ProxyRules::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bypass_rules, other_struct.bypass_rules))
    return false;
  if (!mojo::Equals(this->reverse_bypass, other_struct.reverse_bypass))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->single_proxies, other_struct.single_proxies))
    return false;
  if (!mojo::Equals(this->proxies_for_http, other_struct.proxies_for_http))
    return false;
  if (!mojo::Equals(this->proxies_for_https, other_struct.proxies_for_https))
    return false;
  if (!mojo::Equals(this->proxies_for_ftp, other_struct.proxies_for_ftp))
    return false;
  if (!mojo::Equals(this->fallback_proxies, other_struct.fallback_proxies))
    return false;
  return true;
}

template <typename T, ProxyRules::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bypass_rules < rhs.bypass_rules)
    return true;
  if (rhs.bypass_rules < lhs.bypass_rules)
    return false;
  if (lhs.reverse_bypass < rhs.reverse_bypass)
    return true;
  if (rhs.reverse_bypass < lhs.reverse_bypass)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.single_proxies < rhs.single_proxies)
    return true;
  if (rhs.single_proxies < lhs.single_proxies)
    return false;
  if (lhs.proxies_for_http < rhs.proxies_for_http)
    return true;
  if (rhs.proxies_for_http < lhs.proxies_for_http)
    return false;
  if (lhs.proxies_for_https < rhs.proxies_for_https)
    return true;
  if (rhs.proxies_for_https < lhs.proxies_for_https)
    return false;
  if (lhs.proxies_for_ftp < rhs.proxies_for_ftp)
    return true;
  if (rhs.proxies_for_ftp < lhs.proxies_for_ftp)
    return false;
  if (lhs.fallback_proxies < rhs.fallback_proxies)
    return true;
  if (rhs.fallback_proxies < lhs.fallback_proxies)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyConfigPtr ProxyConfig::Clone() const {
  return New(
      mojo::Clone(auto_detect),
      mojo::Clone(from_system),
      mojo::Clone(pac_url),
      mojo::Clone(pac_mandatory),
      mojo::Clone(proxy_rules)
  );
}

template <typename T, ProxyConfig::EnableIfSame<T>*>
bool ProxyConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->auto_detect, other_struct.auto_detect))
    return false;
  if (!mojo::Equals(this->from_system, other_struct.from_system))
    return false;
  if (!mojo::Equals(this->pac_url, other_struct.pac_url))
    return false;
  if (!mojo::Equals(this->pac_mandatory, other_struct.pac_mandatory))
    return false;
  if (!mojo::Equals(this->proxy_rules, other_struct.proxy_rules))
    return false;
  return true;
}

template <typename T, ProxyConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.auto_detect < rhs.auto_detect)
    return true;
  if (rhs.auto_detect < lhs.auto_detect)
    return false;
  if (lhs.from_system < rhs.from_system)
    return true;
  if (rhs.from_system < lhs.from_system)
    return false;
  if (lhs.pac_url < rhs.pac_url)
    return true;
  if (rhs.pac_url < lhs.pac_url)
    return false;
  if (lhs.pac_mandatory < rhs.pac_mandatory)
    return true;
  if (rhs.pac_mandatory < lhs.pac_mandatory)
    return false;
  if (lhs.proxy_rules < rhs.proxy_rules)
    return true;
  if (rhs.proxy_rules < lhs.proxy_rules)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::network::mojom::blink::ProxyBypassRules::DataView,
                                         ::network::mojom::blink::ProxyBypassRulesPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyBypassRulesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyBypassRulesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyBypassRules::rules)& rules(
      const ::network::mojom::blink::ProxyBypassRulesPtr& input) {
    return input->rules;
  }

  static bool Read(::network::mojom::blink::ProxyBypassRules::DataView input, ::network::mojom::blink::ProxyBypassRulesPtr* output);
};


template <>
struct  StructTraits<::network::mojom::blink::ProxyList::DataView,
                                         ::network::mojom::blink::ProxyListPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyListPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyListPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyList::proxies)& proxies(
      const ::network::mojom::blink::ProxyListPtr& input) {
    return input->proxies;
  }

  static bool Read(::network::mojom::blink::ProxyList::DataView input, ::network::mojom::blink::ProxyListPtr* output);
};


template <>
struct  StructTraits<::network::mojom::blink::ProxyRules::DataView,
                                         ::network::mojom::blink::ProxyRulesPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyRulesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyRulesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyRules::bypass_rules)& bypass_rules(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->bypass_rules;
  }

  static decltype(::network::mojom::blink::ProxyRules::reverse_bypass) reverse_bypass(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->reverse_bypass;
  }

  static decltype(::network::mojom::blink::ProxyRules::type) type(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::blink::ProxyRules::single_proxies)& single_proxies(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->single_proxies;
  }

  static const decltype(::network::mojom::blink::ProxyRules::proxies_for_http)& proxies_for_http(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->proxies_for_http;
  }

  static const decltype(::network::mojom::blink::ProxyRules::proxies_for_https)& proxies_for_https(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->proxies_for_https;
  }

  static const decltype(::network::mojom::blink::ProxyRules::proxies_for_ftp)& proxies_for_ftp(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->proxies_for_ftp;
  }

  static const decltype(::network::mojom::blink::ProxyRules::fallback_proxies)& fallback_proxies(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->fallback_proxies;
  }

  static bool Read(::network::mojom::blink::ProxyRules::DataView input, ::network::mojom::blink::ProxyRulesPtr* output);
};


template <>
struct  StructTraits<::network::mojom::blink::ProxyConfig::DataView,
                                         ::network::mojom::blink::ProxyConfigPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyConfigPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::ProxyConfig::auto_detect) auto_detect(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->auto_detect;
  }

  static decltype(::network::mojom::blink::ProxyConfig::from_system) from_system(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->from_system;
  }

  static  decltype(::network::mojom::blink::ProxyConfig::pac_url)& pac_url(
       ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->pac_url;
  }

  static decltype(::network::mojom::blink::ProxyConfig::pac_mandatory) pac_mandatory(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->pac_mandatory;
  }

  static const decltype(::network::mojom::blink::ProxyConfig::proxy_rules)& proxy_rules(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->proxy_rules;
  }

  static bool Read(::network::mojom::blink::ProxyConfig::DataView input, ::network::mojom::blink::ProxyConfigPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_BLINK_H_