// services/network/public/mojom/network_interface_change_listener.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/network_interface_change_listener.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"


namespace network::mojom {
class IfAddrMsgDataView;

class AddressMapDataView;

class OnlineLinksDataView;

class InitialAddressMapDataView;

class NetworkInterfaceChangeParamsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::IfAddrMsgDataView> {
  using Data = ::network::mojom::internal::IfAddrMsg_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::AddressMapDataView> {
  using Data = ::network::mojom::internal::AddressMap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::OnlineLinksDataView> {
  using Data = ::network::mojom::internal::OnlineLinks_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::InitialAddressMapDataView> {
  using Data = ::network::mojom::internal::InitialAddressMap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkInterfaceChangeParamsDataView> {
  using Data = ::network::mojom::internal::NetworkInterfaceChangeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class NetworkInterfaceChangeListenerInterfaceBase {};

using NetworkInterfaceChangeListenerPtrDataView =
    mojo::InterfacePtrDataView<NetworkInterfaceChangeListenerInterfaceBase>;
using NetworkInterfaceChangeListenerRequestDataView =
    mojo::InterfaceRequestDataView<NetworkInterfaceChangeListenerInterfaceBase>;
using NetworkInterfaceChangeListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NetworkInterfaceChangeListenerInterfaceBase>;
using NetworkInterfaceChangeListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NetworkInterfaceChangeListenerInterfaceBase>;


class IfAddrMsgDataView {
 public:
  IfAddrMsgDataView() = default;

  IfAddrMsgDataView(
      internal::IfAddrMsg_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t ifa_family() const {
    return data_->ifa_family;
  }
  uint8_t ifa_prefixlen() const {
    return data_->ifa_prefixlen;
  }
  uint8_t ifa_flags() const {
    return data_->ifa_flags;
  }
  uint8_t ifa_scope() const {
    return data_->ifa_scope;
  }
  uint32_t ifa_index() const {
    return data_->ifa_index;
  }
 private:
  internal::IfAddrMsg_Data* data_ = nullptr;
};


class AddressMapDataView {
 public:
  AddressMapDataView() = default;

  AddressMapDataView(
      internal::AddressMap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressMapDataView(
      mojo::MapDataView<::network::mojom::IPAddressDataView, IfAddrMsgDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddressMap(UserType* output) {
    
    auto* pointer = data_->address_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::IPAddressDataView, ::network::mojom::IfAddrMsgDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AddressMap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OnlineLinksDataView {
 public:
  OnlineLinksDataView() = default;

  OnlineLinksDataView(
      internal::OnlineLinks_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOnlineLinksDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOnlineLinks(UserType* output) {
    
    auto* pointer = data_->online_links.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::OnlineLinks_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InitialAddressMapDataView {
 public:
  InitialAddressMapDataView() = default;

  InitialAddressMapDataView(
      internal::InitialAddressMap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressMapDataView(
      AddressMapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddressMap(UserType* output) {
    
    auto* pointer = data_->address_map.Get();
    return mojo::internal::Deserialize<::network::mojom::AddressMapDataView>(
        pointer, output, message_);
  }
  inline void GetOnlineLinksDataView(
      OnlineLinksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOnlineLinks(UserType* output) {
    
    auto* pointer = data_->online_links.Get();
    return mojo::internal::Deserialize<::network::mojom::OnlineLinksDataView>(
        pointer, output, message_);
  }
 private:
  internal::InitialAddressMap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkInterfaceChangeParamsDataView {
 public:
  NetworkInterfaceChangeParamsDataView() = default;

  NetworkInterfaceChangeParamsDataView(
      internal::NetworkInterfaceChangeParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressMapDataView(
      mojo::MapDataView<::network::mojom::IPAddressDataView, IfAddrMsgDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddressMap(UserType* output) {
    
    auto* pointer = data_->address_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::IPAddressDataView, ::network::mojom::IfAddrMsgDataView>>(
        pointer, output, message_);
  }
  inline void GetOnlineLinksDataView(
      mojo::MapDataView<int32_t, bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOnlineLinks(UserType* output) {
    
    auto* pointer = data_->online_links.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int32_t, bool>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkInterfaceChangeParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_DATA_VIEW_H_