// services/network/public/mojom/net_log.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/net_log.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/net_log.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* NetLogCaptureModeToStringHelper(NetLogCaptureMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NetLogCaptureMode::HEAVILY_REDACTED:
      return "HEAVILY_REDACTED";
    case NetLogCaptureMode::DEFAULT:
      return "DEFAULT";
    case NetLogCaptureMode::INCLUDE_PRIVACY_INFO:
      return "INCLUDE_PRIVACY_INFO";
    case NetLogCaptureMode::EVERYTHING:
      return "EVERYTHING";
    default:
      return nullptr;
  }
}

std::string NetLogCaptureModeToString(NetLogCaptureMode value) {
  const char *str = NetLogCaptureModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NetLogCaptureMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NetLogCaptureMode value) {
  return os << NetLogCaptureModeToString(value);
}

NOINLINE static const char* NetLogEventPhaseToStringHelper(NetLogEventPhase value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NetLogEventPhase::BEGIN:
      return "BEGIN";
    case NetLogEventPhase::END:
      return "END";
    case NetLogEventPhase::NONE:
      return "NONE";
    default:
      return nullptr;
  }
}

std::string NetLogEventPhaseToString(NetLogEventPhase value) {
  const char *str = NetLogEventPhaseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NetLogEventPhase value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NetLogEventPhase value) {
  return os << NetLogEventPhaseToString(value);
}

namespace internal {


// static
bool NetLogExporter_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetLogExporter_Start_Params_Data* object =
      static_cast<const NetLogExporter_Start_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destination, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_constants, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extra_constants, validation_context))
    return false;


  if (!::network::mojom::internal::NetLogCaptureMode_Data
        ::Validate(object->capture_mode, validation_context))
    return false;

  return true;
}

NetLogExporter_Start_Params_Data::NetLogExporter_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogExporter_Start_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetLogExporter_Start_ResponseParams_Data* object =
      static_cast<const NetLogExporter_Start_ResponseParams_Data*>(data);

  return true;
}

NetLogExporter_Start_ResponseParams_Data::NetLogExporter_Start_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogExporter_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetLogExporter_Stop_Params_Data* object =
      static_cast<const NetLogExporter_Stop_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->polled_values, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->polled_values, validation_context))
    return false;

  return true;
}

NetLogExporter_Stop_Params_Data::NetLogExporter_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogExporter_Stop_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetLogExporter_Stop_ResponseParams_Data* object =
      static_cast<const NetLogExporter_Stop_ResponseParams_Data*>(data);

  return true;
}

NetLogExporter_Stop_ResponseParams_Data::NetLogExporter_Stop_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogProxySource_UpdateCaptureModes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetLogProxySource_UpdateCaptureModes_Params_Data* object =
      static_cast<const NetLogProxySource_UpdateCaptureModes_Params_Data*>(data);

  return true;
}

NetLogProxySource_UpdateCaptureModes_Params_Data::NetLogProxySource_UpdateCaptureModes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogProxySink_AddEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetLogProxySink_AddEntry_Params_Data* object =
      static_cast<const NetLogProxySink_AddEntry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->net_log_source, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->net_log_source, validation_context))
    return false;


  if (!::network::mojom::internal::NetLogEventPhase_Data
        ::Validate(object->phase, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

NetLogProxySink_AddEntry_Params_Data::NetLogProxySink_AddEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NetLogCaptureMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::NetLogCaptureMode value) {
  return std::move(context).WriteString(::network::mojom::NetLogCaptureModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NetLogEventPhase>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::NetLogEventPhase value) {
  return std::move(context).WriteString(::network::mojom::NetLogEventPhaseToString(value));
}

} // namespace perfetto