// services/network/public/mojom/first_party_sets.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/first_party_sets.mojom-shared-internal.h"
#include "mojo/public/mojom/base/version.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"


namespace network::mojom {
class FirstPartySetEntryDataView;

class FirstPartySetMetadataDataView;

class FirstPartySetEntryOverrideDataView;

class FirstPartySetsContextConfigDataView;

class FirstPartySetsCacheFilterDataView;

class GlobalFirstPartySetsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::FirstPartySetEntryDataView> {
  using Data = ::network::mojom::internal::FirstPartySetEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::FirstPartySetMetadataDataView> {
  using Data = ::network::mojom::internal::FirstPartySetMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::FirstPartySetEntryOverrideDataView> {
  using Data = ::network::mojom::internal::FirstPartySetEntryOverride_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::FirstPartySetsContextConfigDataView> {
  using Data = ::network::mojom::internal::FirstPartySetsContextConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::FirstPartySetsCacheFilterDataView> {
  using Data = ::network::mojom::internal::FirstPartySetsCacheFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::GlobalFirstPartySetsDataView> {
  using Data = ::network::mojom::internal::GlobalFirstPartySets_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class SiteType : int32_t {
  
  kPrimary = 0,
  
  kAssociated = 1,
  
  kService = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SiteType value);
inline bool IsKnownEnumValue(SiteType value) {
  return internal::SiteType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FirstPartySetEntryDataView {
 public:
  FirstPartySetEntryDataView() = default;

  FirstPartySetEntryDataView(
      internal::FirstPartySetEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrimaryDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimary(UserType* output) {
    
    auto* pointer = data_->primary.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSiteType(UserType* output) const {
    auto data_value = data_->site_type;
    return mojo::internal::Deserialize<::network::mojom::SiteType>(
        data_value, output);
  }
  SiteType site_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SiteType>(data_->site_type));
  }
 private:
  internal::FirstPartySetEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FirstPartySetMetadataDataView {
 public:
  FirstPartySetMetadataDataView() = default;

  FirstPartySetMetadataDataView(
      internal::FirstPartySetMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameEntryDataView(
      FirstPartySetEntryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameEntry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::FirstPartySetEntryDataView, UserType>(),
    "Attempting to read the optional `frame_entry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameEntry` instead "
    "of `ReadFrameEntry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_entry.Get();
    return mojo::internal::Deserialize<::network::mojom::FirstPartySetEntryDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameEntryDataView(
      FirstPartySetEntryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameEntry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::FirstPartySetEntryDataView, UserType>(),
    "Attempting to read the optional `top_frame_entry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTopFrameEntry` instead "
    "of `ReadTopFrameEntry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->top_frame_entry.Get();
    return mojo::internal::Deserialize<::network::mojom::FirstPartySetEntryDataView>(
        pointer, output, message_);
  }
 private:
  internal::FirstPartySetMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FirstPartySetEntryOverrideDataView {
 public:
  FirstPartySetEntryOverrideDataView() = default;

  FirstPartySetEntryOverrideDataView(
      internal::FirstPartySetEntryOverride_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEntryDataView(
      FirstPartySetEntryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::FirstPartySetEntryDataView, UserType>(),
    "Attempting to read the optional `entry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEntry` instead "
    "of `ReadEntry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->entry.Get();
    return mojo::internal::Deserialize<::network::mojom::FirstPartySetEntryDataView>(
        pointer, output, message_);
  }
 private:
  internal::FirstPartySetEntryOverride_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FirstPartySetsContextConfigDataView {
 public:
  FirstPartySetsContextConfigDataView() = default;

  FirstPartySetsContextConfigDataView(
      internal::FirstPartySetsContextConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCustomizationsDataView(
      mojo::MapDataView<::network::mojom::SchemefulSiteDataView, FirstPartySetEntryOverrideDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomizations(UserType* output) {
    
    auto* pointer = data_->customizations.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::FirstPartySetEntryOverrideDataView>>(
        pointer, output, message_);
  }
  inline void GetAliasesDataView(
      mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAliases(UserType* output) {
    
    auto* pointer = data_->aliases.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FirstPartySetsContextConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FirstPartySetsCacheFilterDataView {
 public:
  FirstPartySetsCacheFilterDataView() = default;

  FirstPartySetsCacheFilterDataView(
      internal::FirstPartySetsCacheFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilterDataView(
      mojo::MapDataView<::network::mojom::SchemefulSiteDataView, int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilter(UserType* output) {
    
    auto* pointer = data_->filter.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, int64_t>>(
        pointer, output, message_);
  }
  int64_t browser_run_id() const {
    return data_->browser_run_id;
  }
 private:
  internal::FirstPartySetsCacheFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GlobalFirstPartySetsDataView {
 public:
  GlobalFirstPartySetsDataView() = default;

  GlobalFirstPartySetsDataView(
      internal::GlobalFirstPartySets_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPublicSetsVersionDataView(
      ::mojo_base::mojom::VersionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicSetsVersion(UserType* output) {
    
    auto* pointer = data_->public_sets_version.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::VersionDataView>(
        pointer, output, message_);
  }
  inline void GetSetsDataView(
      mojo::MapDataView<::network::mojom::SchemefulSiteDataView, FirstPartySetEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSets(UserType* output) {
    
    auto* pointer = data_->sets.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::FirstPartySetEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetAliasesDataView(
      mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAliases(UserType* output) {
    
    auto* pointer = data_->aliases.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>>(
        pointer, output, message_);
  }
  inline void GetManualConfigDataView(
      FirstPartySetsContextConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManualConfig(UserType* output) {
    
    auto* pointer = data_->manual_config.Get();
    return mojo::internal::Deserialize<::network::mojom::FirstPartySetsContextConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::GlobalFirstPartySets_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_DATA_VIEW_H_