// services/network/public/mojom/devtools_observer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/devtools_observer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_error.mojom-shared.h"
#include "services/network/public/mojom/sri_message_signature.mojom-shared.h"
#include "services/network/public/mojom/unencoded_digest.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "services/network/public/mojom/devtools_observer.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLRequestDevToolsInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLRequestDevToolsInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLRequestDevToolsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_method,
      method_fragment);

    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method in URLRequestDevToolsInfo struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in URLRequestDevToolsInfo struct");

    
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
      Traits::priority(input),
      &fragment->priority);

    
    mojo::internal::Serialize<::network::mojom::URLRequestReferrerPolicy>(
      Traits::referrer_policy(input),
      &fragment->referrer_policy);

    decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView>(
      in_trust_token_params,
      trust_token_params_fragment);

    fragment->trust_token_params.Set(
        trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());

    fragment->has_user_gesture = Traits::has_user_gesture(input);

    fragment->resource_type = Traits::resource_type(input);
  }

  static bool Deserialize(::network::mojom::internal::URLRequestDevToolsInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLRequestDevToolsInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLResponseHeadDevToolsInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLResponseHeadDevToolsInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLResponseHeadDevToolsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::response_time(input)) in_response_time = Traits::response_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_time)::BaseType> response_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_response_time,
      response_time_fragment);

    fragment->response_time.Set(
        response_time_fragment.is_null() ? nullptr : response_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->response_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_time in URLResponseHeadDevToolsInfo struct");

    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_headers,
      headers_fragment);

    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in URLResponseHeadDevToolsInfo struct");

    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type,
      mime_type_fragment);

    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in URLResponseHeadDevToolsInfo struct");

    decltype(Traits::charset(input)) in_charset = Traits::charset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->charset)::BaseType> charset_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_charset,
      charset_fragment);

    fragment->charset.Set(
        charset_fragment.is_null() ? nullptr : charset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->charset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null charset in URLResponseHeadDevToolsInfo struct");

    decltype(Traits::load_timing(input)) in_load_timing = Traits::load_timing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->load_timing)::BaseType> load_timing_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView>(
      in_load_timing,
      load_timing_fragment);

    fragment->load_timing.Set(
        load_timing_fragment.is_null() ? nullptr : load_timing_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->load_timing.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null load_timing in URLResponseHeadDevToolsInfo struct");

    fragment->cert_status = Traits::cert_status(input);

    fragment->encoded_data_length = Traits::encoded_data_length(input);

    fragment->was_in_prefetch_cache = Traits::was_in_prefetch_cache(input);

    fragment->was_fetched_via_service_worker = Traits::was_fetched_via_service_worker(input);

    decltype(Traits::cache_storage_cache_name(input)) in_cache_storage_cache_name = Traits::cache_storage_cache_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cache_storage_cache_name)::BaseType> cache_storage_cache_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_cache_storage_cache_name,
      cache_storage_cache_name_fragment);

    fragment->cache_storage_cache_name.Set(
        cache_storage_cache_name_fragment.is_null() ? nullptr : cache_storage_cache_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cache_storage_cache_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_storage_cache_name in URLResponseHeadDevToolsInfo struct");

    decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alpn_negotiated_protocol)::BaseType> alpn_negotiated_protocol_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_alpn_negotiated_protocol,
      alpn_negotiated_protocol_fragment);

    fragment->alpn_negotiated_protocol.Set(
        alpn_negotiated_protocol_fragment.is_null() ? nullptr : alpn_negotiated_protocol_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alpn_negotiated_protocol.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alpn_negotiated_protocol in URLResponseHeadDevToolsInfo struct");

    
    mojo::internal::Serialize<::network::mojom::AlternateProtocolUsage>(
      Traits::alternate_protocol_usage(input),
      &fragment->alternate_protocol_usage);

    fragment->was_fetched_via_spdy = Traits::was_fetched_via_spdy(input);

    
    mojo::internal::Serialize<::network::mojom::FetchResponseSource>(
      Traits::service_worker_response_source(input),
      &fragment->service_worker_response_source);

    decltype(Traits::service_worker_router_info(input)) in_service_worker_router_info = Traits::service_worker_router_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_router_info)::BaseType> service_worker_router_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ServiceWorkerRouterInfoDataView>(
      in_service_worker_router_info,
      service_worker_router_info_fragment);

    fragment->service_worker_router_info.Set(
        service_worker_router_info_fragment.is_null() ? nullptr : service_worker_router_info_fragment.data());

    decltype(Traits::ssl_info(input)) in_ssl_info = Traits::ssl_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ssl_info)::BaseType> ssl_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
      in_ssl_info,
      ssl_info_fragment);

    fragment->ssl_info.Set(
        ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());

    decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_endpoint)::BaseType> remote_endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_endpoint,
      remote_endpoint_fragment);

    fragment->remote_endpoint.Set(
        remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->remote_endpoint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_endpoint in URLResponseHeadDevToolsInfo struct");

    fragment->emitted_extra_info = Traits::emitted_extra_info(input);

    fragment->is_for_ip_protection = Traits::is_for_ip_protection(input);
  }

  static bool Deserialize(::network::mojom::internal::URLResponseHeadDevToolsInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLResponseHeadDevToolsInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::OtherPartitionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::OtherPartitionInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::OtherPartitionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->site_has_cookie_in_other_partition = Traits::site_has_cookie_in_other_partition(input);
  }

  static bool Deserialize(::network::mojom::internal::OtherPartitionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::OtherPartitionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void URLRequestDevToolsInfoDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDevToolsInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLRequestDevToolsInfoDataView::GetTrustTokenParamsDataView(
    ::network::mojom::TrustTokenParamsDataView* output) {
  auto pointer = data_->trust_token_params.Get();
  *output = ::network::mojom::TrustTokenParamsDataView(pointer, message_);
}


inline void URLResponseHeadDevToolsInfoDataView::GetResponseTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->response_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetCharsetDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->charset.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetLoadTimingDataView(
    ::network::mojom::LoadTimingInfoDataView* output) {
  auto pointer = data_->load_timing.Get();
  *output = ::network::mojom::LoadTimingInfoDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetCacheStorageCacheNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cache_storage_cache_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetAlpnNegotiatedProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->alpn_negotiated_protocol.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetServiceWorkerRouterInfoDataView(
    ::network::mojom::ServiceWorkerRouterInfoDataView* output) {
  auto pointer = data_->service_worker_router_info.Get();
  *output = ::network::mojom::ServiceWorkerRouterInfoDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetSslInfoDataView(
    ::network::mojom::SSLInfoDataView* output) {
  auto pointer = data_->ssl_info.Get();
  *output = ::network::mojom::SSLInfoDataView(pointer, message_);
}
inline void URLResponseHeadDevToolsInfoDataView::GetRemoteEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}





}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_SHARED_H_