// services/network/public/mojom/device_bound_sessions.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class DeviceBoundSessionKeyDataView;

class DeviceBoundSessionAccessDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionKeyDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionAccessDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionAccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class DeviceBoundSessionAccessType : int32_t {
  
  kCreation = 0,
  
  kUpdate = 1,
  
  kTermination = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionAccessType value);
inline bool IsKnownEnumValue(DeviceBoundSessionAccessType value) {
  return internal::DeviceBoundSessionAccessType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeviceBoundSessionUsage : int32_t {
  
  kUnknown = 0,
  
  kNoUsage = 1,
  
  kInScopeNotDeferred = 2,
  
  kDeferred = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionUsage value);
inline bool IsKnownEnumValue(DeviceBoundSessionUsage value) {
  return internal::DeviceBoundSessionUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeviceBoundSessionDeletionReason : int32_t {
  
  kExpired = 0,
  
  kFailedToRestoreKey = 1,
  
  kFailedToUnwrapKey = 2,
  
  kStoragePartitionCleared = 3,
  
  kClearBrowsingData = 4,
  
  kServerRequested = 5,
  
  kInvalidSessionParams = 6,
  
  kRefreshFatalError = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionDeletionReason value);
inline bool IsKnownEnumValue(DeviceBoundSessionDeletionReason value) {
  return internal::DeviceBoundSessionDeletionReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DeviceBoundSessionManagerInterfaceBase {};

using DeviceBoundSessionManagerPtrDataView =
    mojo::InterfacePtrDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerRequestDataView =
    mojo::InterfaceRequestDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceBoundSessionManagerInterfaceBase>;
class DeviceBoundSessionAccessObserverInterfaceBase {};

using DeviceBoundSessionAccessObserverPtrDataView =
    mojo::InterfacePtrDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverRequestDataView =
    mojo::InterfaceRequestDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceBoundSessionAccessObserverInterfaceBase>;


class DeviceBoundSessionKeyDataView {
 public:
  DeviceBoundSessionKeyDataView() = default;

  DeviceBoundSessionKeyDataView(
      internal::DeviceBoundSessionKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceBoundSessionAccessDataView {
 public:
  DeviceBoundSessionAccessDataView() = default;

  DeviceBoundSessionAccessDataView(
      internal::DeviceBoundSessionAccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAccessType(UserType* output) const {
    auto data_value = data_->access_type;
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionAccessType>(
        data_value, output);
  }
  DeviceBoundSessionAccessType access_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DeviceBoundSessionAccessType>(data_->access_type));
  }
  inline void GetSessionKeyDataView(
      DeviceBoundSessionKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionKey(UserType* output) {
    
    auto* pointer = data_->session_key.Get();
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionKeyDataView>(
        pointer, output, message_);
  }
  inline void GetCookiesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookies(UserType* output) {
    
    auto* pointer = data_->cookies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionAccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_DATA_VIEW_H_