// services/device/public/mojom/pressure_update.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_UPDATE_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_UPDATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/device/public/mojom/pressure_update.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace device::mojom {
class PressureUpdateDataView;

class PressureDataDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::PressureUpdateDataView> {
  using Data = ::device::mojom::internal::PressureUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::PressureDataDataView> {
  using Data = ::device::mojom::internal::PressureData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class PressureSource : int32_t {
  
  kCpu = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, PressureSource value);
inline bool IsKnownEnumValue(PressureSource value) {
  return internal::PressureSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PressureState : int32_t {
  
  kNominal = 0,
  
  kFair = 1,
  
  kSerious = 2,
  
  kCritical = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PressureState value);
inline bool IsKnownEnumValue(PressureState value) {
  return internal::PressureState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PressureUpdateDataView {
 public:
  PressureUpdateDataView() = default;

  PressureUpdateDataView(
      internal::PressureUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::device::mojom::PressureSource>(
        data_value, output);
  }
  PressureSource source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::PressureSource>(data_->source));
  }
  inline void GetDataDataView(
      PressureDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::device::mojom::PressureDataDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::PressureUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PressureDataDataView {
 public:
  PressureDataDataView() = default;

  PressureDataDataView(
      internal::PressureData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double cpu_utilization() const {
    return data_->cpu_utilization;
  }
  double own_contribution_estimate() const {
    return data_->own_contribution_estimate;
  }
 private:
  internal::PressureData_Data* data_ = nullptr;
};


}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_UPDATE_MOJOM_DATA_VIEW_H_