// services/device/public/mojom/input_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_INPUT_SERVICE_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_INPUT_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/device/public/mojom/input_service.mojom-shared-internal.h"


namespace device::mojom {
class InputDeviceInfoDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::InputDeviceInfoDataView> {
  using Data = ::device::mojom::internal::InputDeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class InputDeviceSubsystem : int32_t {
  
  SUBSYSTEM_HID = 0,
  
  SUBSYSTEM_INPUT = 1,
  
  SUBSYSTEM_UNKNOWN = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, InputDeviceSubsystem value);
inline bool IsKnownEnumValue(InputDeviceSubsystem value) {
  return internal::InputDeviceSubsystem_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InputDeviceType : int32_t {
  
  TYPE_BLUETOOTH = 0,
  
  TYPE_USB = 1,
  
  TYPE_SERIO = 2,
  
  TYPE_UNKNOWN = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, InputDeviceType value);
inline bool IsKnownEnumValue(InputDeviceType value) {
  return internal::InputDeviceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class InputDeviceManagerClientInterfaceBase {};

using InputDeviceManagerClientPtrDataView =
    mojo::InterfacePtrDataView<InputDeviceManagerClientInterfaceBase>;
using InputDeviceManagerClientRequestDataView =
    mojo::InterfaceRequestDataView<InputDeviceManagerClientInterfaceBase>;
using InputDeviceManagerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<InputDeviceManagerClientInterfaceBase>;
using InputDeviceManagerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<InputDeviceManagerClientInterfaceBase>;
class InputDeviceManagerInterfaceBase {};

using InputDeviceManagerPtrDataView =
    mojo::InterfacePtrDataView<InputDeviceManagerInterfaceBase>;
using InputDeviceManagerRequestDataView =
    mojo::InterfaceRequestDataView<InputDeviceManagerInterfaceBase>;
using InputDeviceManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<InputDeviceManagerInterfaceBase>;
using InputDeviceManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<InputDeviceManagerInterfaceBase>;


class InputDeviceInfoDataView {
 public:
  InputDeviceInfoDataView() = default;

  InputDeviceInfoDataView(
      internal::InputDeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSubsystem(UserType* output) const {
    auto data_value = data_->subsystem;
    return mojo::internal::Deserialize<::device::mojom::InputDeviceSubsystem>(
        data_value, output);
  }
  InputDeviceSubsystem subsystem() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::InputDeviceSubsystem>(data_->subsystem));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::device::mojom::InputDeviceType>(
        data_value, output);
  }
  InputDeviceType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::InputDeviceType>(data_->type));
  }
  bool is_accelerometer() const {
    return data_->is_accelerometer;
  }
  bool is_joystick() const {
    return data_->is_joystick;
  }
  bool is_key() const {
    return data_->is_key;
  }
  bool is_keyboard() const {
    return data_->is_keyboard;
  }
  bool is_mouse() const {
    return data_->is_mouse;
  }
  bool is_tablet() const {
    return data_->is_tablet;
  }
  bool is_touchpad() const {
    return data_->is_touchpad;
  }
  bool is_touchscreen() const {
    return data_->is_touchscreen;
  }
 private:
  internal::InputDeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_INPUT_SERVICE_MOJOM_DATA_VIEW_H_