// qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-params-data.h"
#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-shared-message-ids.h"

#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-import-headers.h"
#include "qtwebengine/browser/extensions/webui/extensions_ui_qt.mojom-test-utils.h"


namespace qtwebengine::mojom {
ExtensionInfo::ExtensionInfo()
    : name(),
      description(),
      version(),
      id(),
      isEnabled(),
      isInstalled(),
      isLoaded() {}

ExtensionInfo::ExtensionInfo(
    const std::string& name_in,
    const std::string& description_in,
    const std::string& version_in,
    const std::string& id_in,
    bool isEnabled_in,
    bool isInstalled_in,
    bool isLoaded_in)
    : name(std::move(name_in)),
      description(std::move(description_in)),
      version(std::move(version_in)),
      id(std::move(id_in)),
      isEnabled(std::move(isEnabled_in)),
      isInstalled(std::move(isInstalled_in)),
      isLoaded(std::move(isLoaded_in)) {}

ExtensionInfo::~ExtensionInfo() = default;
size_t ExtensionInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->description);
  seed = mojo::internal::Hash(seed, this->version);
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->isEnabled);
  seed = mojo::internal::Hash(seed, this->isInstalled);
  seed = mojo::internal::Hash(seed, this->isLoaded);
  return seed;
}

void ExtensionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isEnabled"), this->isEnabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isInstalled"), this->isInstalled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isLoaded"), this->isLoaded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtensionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ExtensionsUIHandlerFactory::IPCStableHashFunction ExtensionsUIHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ExtensionsUIHandlerFactory>(message.name())) {
    case messages::ExtensionsUIHandlerFactory::kCreatePageHandler: {
      return &ExtensionsUIHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ExtensionsUIHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ExtensionsUIHandlerFactory>(message.name())) {
      case messages::ExtensionsUIHandlerFactory::kCreatePageHandler:
            return "Receive qtwebengine::mojom::ExtensionsUIHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::ExtensionsUIHandlerFactory>(message.name())) {
      case messages::ExtensionsUIHandlerFactory::kCreatePageHandler:
            return "Receive reply qtwebengine::mojom::ExtensionsUIHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ExtensionsUIHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbbc5325e;  // IPCStableHash for qtwebengine::mojom::ExtensionsUIHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ExtensionsUIHandlerFactoryProxy::ExtensionsUIHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ExtensionsUIHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::ExtensionsUIHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionsUIHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::ExtensionsUIHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::qtwebengine::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in ExtensionsUIHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::qtwebengine::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in ExtensionsUIHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionsUIHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ExtensionsUIHandlerFactoryStubDispatch::Accept(
    ExtensionsUIHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ExtensionsUIHandlerFactory>(message->header()->name)) {
    case messages::ExtensionsUIHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::ExtensionsUIHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::ExtensionsUIHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionsUIHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      ExtensionsUIHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionsUIHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool ExtensionsUIHandlerFactoryStubDispatch::AcceptWithResponder(
    ExtensionsUIHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ExtensionsUIHandlerFactory>(message->header()->name)) {
    case messages::ExtensionsUIHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kExtensionsUIHandlerFactoryValidationInfo[] = {
    {base::to_underlying(messages::ExtensionsUIHandlerFactory::kCreatePageHandler),
     { &internal::ExtensionsUIHandlerFactory_CreatePageHandler_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ExtensionsUIHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::qtwebengine::mojom::ExtensionsUIHandlerFactory::Name_,
    kExtensionsUIHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetAllExtensionInfo: {
      return &PageHandler::GetAllExtensionInfo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kLoadExtension: {
      return &PageHandler::LoadExtension_Sym::IPCStableHash;
    }
    case messages::PageHandler::kInstallExtension: {
      return &PageHandler::InstallExtension_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUninstallExtension: {
      return &PageHandler::UninstallExtension_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUnloadExtension: {
      return &PageHandler::UnloadExtension_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetExtensionEnabled: {
      return &PageHandler::SetExtensionEnabled_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetAllExtensionInfo:
            return "Receive qtwebengine::mojom::PageHandler::GetAllExtensionInfo";
      case messages::PageHandler::kLoadExtension:
            return "Receive qtwebengine::mojom::PageHandler::LoadExtension";
      case messages::PageHandler::kInstallExtension:
            return "Receive qtwebengine::mojom::PageHandler::InstallExtension";
      case messages::PageHandler::kUninstallExtension:
            return "Receive qtwebengine::mojom::PageHandler::UninstallExtension";
      case messages::PageHandler::kUnloadExtension:
            return "Receive qtwebengine::mojom::PageHandler::UnloadExtension";
      case messages::PageHandler::kSetExtensionEnabled:
            return "Receive qtwebengine::mojom::PageHandler::SetExtensionEnabled";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetAllExtensionInfo:
            return "Receive reply qtwebengine::mojom::PageHandler::GetAllExtensionInfo";
      case messages::PageHandler::kLoadExtension:
            return "Receive reply qtwebengine::mojom::PageHandler::LoadExtension";
      case messages::PageHandler::kInstallExtension:
            return "Receive reply qtwebengine::mojom::PageHandler::InstallExtension";
      case messages::PageHandler::kUninstallExtension:
            return "Receive reply qtwebengine::mojom::PageHandler::UninstallExtension";
      case messages::PageHandler::kUnloadExtension:
            return "Receive reply qtwebengine::mojom::PageHandler::UnloadExtension";
      case messages::PageHandler::kSetExtensionEnabled:
            return "Receive reply qtwebengine::mojom::PageHandler::SetExtensionEnabled";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetAllExtensionInfo_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x495ed8c7;  // IPCStableHash for qtwebengine::mojom::PageHandler::GetAllExtensionInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::LoadExtension_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2453044;  // IPCStableHash for qtwebengine::mojom::PageHandler::LoadExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::InstallExtension_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0defdfda;  // IPCStableHash for qtwebengine::mojom::PageHandler::InstallExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UninstallExtension_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd93378b1;  // IPCStableHash for qtwebengine::mojom::PageHandler::UninstallExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UnloadExtension_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeba470bb;  // IPCStableHash for qtwebengine::mojom::PageHandler::UnloadExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetExtensionEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a9274b8;  // IPCStableHash for qtwebengine::mojom::PageHandler::SetExtensionEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetAllExtensionInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetAllExtensionInfo_ForwardToCallback(
      PageHandler::GetAllExtensionInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetAllExtensionInfo_ForwardToCallback(const PageHandler_GetAllExtensionInfo_ForwardToCallback&) = delete;
  PageHandler_GetAllExtensionInfo_ForwardToCallback& operator=(const PageHandler_GetAllExtensionInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAllExtensionInfoCallback callback_;
};

class PageHandler_UninstallExtension_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_UninstallExtension_ForwardToCallback(
      PageHandler::UninstallExtensionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_UninstallExtension_ForwardToCallback(const PageHandler_UninstallExtension_ForwardToCallback&) = delete;
  PageHandler_UninstallExtension_ForwardToCallback& operator=(const PageHandler_UninstallExtension_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::UninstallExtensionCallback callback_;
};

class PageHandler_UnloadExtension_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_UnloadExtension_ForwardToCallback(
      PageHandler::UnloadExtensionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_UnloadExtension_ForwardToCallback(const PageHandler_UnloadExtension_ForwardToCallback&) = delete;
  PageHandler_UnloadExtension_ForwardToCallback& operator=(const PageHandler_UnloadExtension_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::UnloadExtensionCallback callback_;
};

class PageHandler_SetExtensionEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_SetExtensionEnabled_ForwardToCallback(
      PageHandler::SetExtensionEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_SetExtensionEnabled_ForwardToCallback(const PageHandler_SetExtensionEnabled_ForwardToCallback&) = delete;
  PageHandler_SetExtensionEnabled_ForwardToCallback& operator=(const PageHandler_SetExtensionEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::SetExtensionEnabledCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetAllExtensionInfo(
    GetAllExtensionInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send qtwebengine::mojom::PageHandler::GetAllExtensionInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllExtensionInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_GetAllExtensionInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllExtensionInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetAllExtensionInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::LoadExtension(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send qtwebengine::mojom::PageHandler::LoadExtension");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLoadExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_LoadExtension_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LoadExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::InstallExtension(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send qtwebengine::mojom::PageHandler::InstallExtension");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kInstallExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_InstallExtension_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("InstallExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UninstallExtension(
    const std::string& in_id, UninstallExtensionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::PageHandler::UninstallExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUninstallExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_UninstallExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.UninstallExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UninstallExtension");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_UninstallExtension_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::UnloadExtension(
    const std::string& in_id, UnloadExtensionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::PageHandler::UnloadExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUnloadExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_UnloadExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.UnloadExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UnloadExtension");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_UnloadExtension_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetExtensionEnabled(
    const std::string& in_id, bool in_isEnabled, SetExtensionEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::PageHandler::SetExtensionEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isEnabled"), in_isEnabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetExtensionEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_SetExtensionEnabled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.SetExtensionEnabled request");

  params->isEnabled = in_isEnabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetExtensionEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_SetExtensionEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_GetAllExtensionInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAllExtensionInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetAllExtensionInfo_ProxyToResponder> proxy(
        new PageHandler_GetAllExtensionInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetAllExtensionInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetAllExtensionInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetAllExtensionInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::GetAllExtensionInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ExtensionInfoPtr> in_reports);
};

bool PageHandler_GetAllExtensionInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetAllExtensionInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetAllExtensionInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  std::vector<ExtensionInfoPtr> p_reports{};
  PageHandler_GetAllExtensionInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReports(&p_reports))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_reports));
  }
  return true;
}

void PageHandler_GetAllExtensionInfo_ProxyToResponder::Run(
    std::vector<ExtensionInfoPtr> in_reports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply qtwebengine::mojom::PageHandler::GetAllExtensionInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reports"), in_reports,
                        "<value of type std::vector<ExtensionInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetAllExtensionInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_GetAllExtensionInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reports)::BaseType>
      reports_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& reports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::qtwebengine::mojom::ExtensionInfoDataView>>(
    in_reports,
    reports_fragment,
    &reports_validate_params);

  params->reports.Set(
      reports_fragment.is_null() ? nullptr : reports_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reports.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reports in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetAllExtensionInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_UninstallExtension_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::UninstallExtensionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_UninstallExtension_ProxyToResponder> proxy(
        new PageHandler_UninstallExtension_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_UninstallExtension_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_UninstallExtension_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_UninstallExtension_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::UninstallExtensionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_error);
};

bool PageHandler_UninstallExtension_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_UninstallExtension_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_UninstallExtension_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  std::string p_error{};
  PageHandler_UninstallExtension_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void PageHandler_UninstallExtension_ProxyToResponder::Run(
    const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply qtwebengine::mojom::PageHandler::UninstallExtension", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUninstallExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_UninstallExtension_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UninstallExtension");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_UnloadExtension_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::UnloadExtensionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_UnloadExtension_ProxyToResponder> proxy(
        new PageHandler_UnloadExtension_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_UnloadExtension_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_UnloadExtension_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_UnloadExtension_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::UnloadExtensionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_error);
};

bool PageHandler_UnloadExtension_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_UnloadExtension_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_UnloadExtension_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.4
  bool success = true;
  std::string p_error{};
  PageHandler_UnloadExtension_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void PageHandler_UnloadExtension_ProxyToResponder::Run(
    const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply qtwebengine::mojom::PageHandler::UnloadExtension", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUnloadExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_UnloadExtension_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UnloadExtension");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_SetExtensionEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::SetExtensionEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_SetExtensionEnabled_ProxyToResponder> proxy(
        new PageHandler_SetExtensionEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_SetExtensionEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_SetExtensionEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_SetExtensionEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageHandler::SetExtensionEnabledCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PageHandler_SetExtensionEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_SetExtensionEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_SetExtensionEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.5
  bool success = true;
  PageHandler_SetExtensionEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PageHandler_SetExtensionEnabled_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply qtwebengine::mojom::PageHandler::SetExtensionEnabled");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetExtensionEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PageHandler_SetExtensionEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetExtensionEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetAllExtensionInfo: {
      break;
    }
    case messages::PageHandler::kLoadExtension: {
      DCHECK(message->is_serialized());
      internal::PageHandler_LoadExtension_Params_Data* params =
          reinterpret_cast<internal::PageHandler_LoadExtension_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_LoadExtension_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadExtension(        );
      return true;
    }
    case messages::PageHandler::kInstallExtension: {
      DCHECK(message->is_serialized());
      internal::PageHandler_InstallExtension_Params_Data* params =
          reinterpret_cast<internal::PageHandler_InstallExtension_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_InstallExtension_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallExtension(        );
      return true;
    }
    case messages::PageHandler::kUninstallExtension: {
      break;
    }
    case messages::PageHandler::kUnloadExtension: {
      break;
    }
    case messages::PageHandler::kSetExtensionEnabled: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetAllExtensionInfo: {
      internal::PageHandler_GetAllExtensionInfo_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetAllExtensionInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetAllExtensionInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetAllExtensionInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllExtensionInfo(std::move(callback));
      return true;
    }
    case messages::PageHandler::kLoadExtension: {
      break;
    }
    case messages::PageHandler::kInstallExtension: {
      break;
    }
    case messages::PageHandler::kUninstallExtension: {
      internal::PageHandler_UninstallExtension_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_UninstallExtension_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::string p_id{};
      PageHandler_UninstallExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_UninstallExtension_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UninstallExtension(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::PageHandler::kUnloadExtension: {
      internal::PageHandler_UnloadExtension_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_UnloadExtension_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_id{};
      PageHandler_UnloadExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          PageHandler_UnloadExtension_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnloadExtension(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetExtensionEnabled: {
      internal::PageHandler_SetExtensionEnabled_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_SetExtensionEnabled_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      std::string p_id{};
      bool p_isEnabled{};
      PageHandler_SetExtensionEnabled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success)
        p_isEnabled = input_data_view.isEnabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          PageHandler_SetExtensionEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetExtensionEnabled(        
        std::move(p_id), 
        std::move(p_isEnabled), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPageHandlerValidationInfo[] = {
    {base::to_underlying(messages::PageHandler::kGetAllExtensionInfo),
     { &internal::PageHandler_GetAllExtensionInfo_Params_Data::Validate,
      &internal::PageHandler_GetAllExtensionInfo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kLoadExtension),
     { &internal::PageHandler_LoadExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PageHandler::kInstallExtension),
     { &internal::PageHandler_InstallExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PageHandler::kUninstallExtension),
     { &internal::PageHandler_UninstallExtension_Params_Data::Validate,
      &internal::PageHandler_UninstallExtension_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kUnloadExtension),
     { &internal::PageHandler_UnloadExtension_Params_Data::Validate,
      &internal::PageHandler_UnloadExtension_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PageHandler::kSetExtensionEnabled),
     { &internal::PageHandler_SetExtensionEnabled_Params_Data::Validate,
      &internal::PageHandler_SetExtensionEnabled_ResponseParams_Data::Validate}},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::qtwebengine::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::qtwebengine::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);

}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kReloadPage: {
      return &Page::ReloadPage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kReloadPage:
            return "Receive qtwebengine::mojom::Page::ReloadPage";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kReloadPage:
            return "Receive reply qtwebengine::mojom::Page::ReloadPage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::ReloadPage_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f226717;  // IPCStableHash for qtwebengine::mojom::Page::ReloadPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::ReloadPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send qtwebengine::mojom::Page::ReloadPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kReloadPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::Page_ReloadPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ReloadPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kReloadPage: {
      DCHECK(message->is_serialized());
      internal::Page_ReloadPage_Params_Data* params =
          reinterpret_cast<internal::Page_ReloadPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      Page_ReloadPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReloadPage(        );
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kReloadPage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPageValidationInfo[] = {
    {base::to_underlying(messages::Page::kReloadPage),
     { &internal::Page_ReloadPage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::qtwebengine::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // qtwebengine::mojom


namespace mojo {


// static
bool StructTraits<::qtwebengine::mojom::ExtensionInfo::DataView, ::qtwebengine::mojom::ExtensionInfoPtr>::Read(
    ::qtwebengine::mojom::ExtensionInfo::DataView input,
    ::qtwebengine::mojom::ExtensionInfoPtr* output) {
  bool success = true;
  ::qtwebengine::mojom::ExtensionInfoPtr result(::qtwebengine::mojom::ExtensionInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->isEnabled = input.isEnabled();
      if (success)
        result->isInstalled = input.isInstalled();
      if (success)
        result->isLoaded = input.isLoaded();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace qtwebengine::mojom {


void ExtensionsUIHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
ExtensionsUIHandlerFactoryAsyncWaiter::ExtensionsUIHandlerFactoryAsyncWaiter(
    ExtensionsUIHandlerFactory* proxy) : proxy_(proxy) {}

ExtensionsUIHandlerFactoryAsyncWaiter::~ExtensionsUIHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetAllExtensionInfo(GetAllExtensionInfoCallback callback) {
  GetForwardingInterface()->GetAllExtensionInfo(std::move(callback));
}
void PageHandlerInterceptorForTesting::LoadExtension() {
  GetForwardingInterface()->LoadExtension();
}
void PageHandlerInterceptorForTesting::InstallExtension() {
  GetForwardingInterface()->InstallExtension();
}
void PageHandlerInterceptorForTesting::UninstallExtension(const std::string& id, UninstallExtensionCallback callback) {
  GetForwardingInterface()->UninstallExtension(
    std::move(id)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::UnloadExtension(const std::string& id, UnloadExtensionCallback callback) {
  GetForwardingInterface()->UnloadExtension(
    std::move(id)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::SetExtensionEnabled(const std::string& id, bool isEnabled, SetExtensionEnabledCallback callback) {
  GetForwardingInterface()->SetExtensionEnabled(
    std::move(id)
    , 
    std::move(isEnabled)
    , std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetAllExtensionInfo(
    std::vector<ExtensionInfoPtr>* out_reports) {
  base::RunLoop loop;
  proxy_->GetAllExtensionInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ExtensionInfoPtr>* out_reports
,
             std::vector<ExtensionInfoPtr> reports) {*out_reports = std::move(reports);
            loop->Quit();
          },
          &loop,
          out_reports));
  loop.Run();
}

std::vector<ExtensionInfoPtr> PageHandlerAsyncWaiter::GetAllExtensionInfo(
    ) {
  std::vector<ExtensionInfoPtr> async_wait_result;
  GetAllExtensionInfo(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::UninstallExtension(
    const std::string& id, std::string* out_error) {
  base::RunLoop loop;
  proxy_->UninstallExtension(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_error
,
             const std::string& error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

std::string PageHandlerAsyncWaiter::UninstallExtension(
    const std::string& id) {
  std::string async_wait_result;
  UninstallExtension(std::move(id),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::UnloadExtension(
    const std::string& id, std::string* out_error) {
  base::RunLoop loop;
  proxy_->UnloadExtension(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_error
,
             const std::string& error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

std::string PageHandlerAsyncWaiter::UnloadExtension(
    const std::string& id) {
  std::string async_wait_result;
  UnloadExtension(std::move(id),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::SetExtensionEnabled(
    const std::string& id, bool isEnabled) {
  base::RunLoop loop;
  proxy_->SetExtensionEnabled(
      std::move(id),
      std::move(isEnabled),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void PageInterceptorForTesting::ReloadPage() {
  GetForwardingInterface()->ReloadPage();
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // qtwebengine::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif