// gpu/ipc/common/vulkan_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "gpu/ipc/common/vulkan_types.mojom-shared-internal.h"


namespace gpu::mojom {
class VkExtensionPropertiesDataView;

class VkLayerPropertiesDataView;

class VkPhysicalDeviceLimitsDataView;

class VkPhysicalDeviceSparsePropertiesDataView;

class VkPhysicalDevicePropertiesDataView;

class VkPhysicalDeviceFeaturesDataView;

class VkExtent3DDataView;

class VkQueueFamilyPropertiesDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::VkExtensionPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkExtensionProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkLayerPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkLayerProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceLimitsDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceLimits_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDevicePropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceFeaturesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkExtent3DDataView> {
  using Data = ::gpu::mojom::internal::VkExtent3D_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkQueueFamilyPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkQueueFamilyProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class VkPhysicalDeviceType : int32_t {
  
  OTHER = 0,
  
  INTEGRATED_GPU = 1,
  
  DISCRETE_GPU = 2,
  
  VIRTUAL_GPU = 3,
  
  CPU = 4,
  
  INVALID_VALUE = -1,
  kMinValue = -1,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, VkPhysicalDeviceType value);
inline bool IsKnownEnumValue(VkPhysicalDeviceType value) {
  return internal::VkPhysicalDeviceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class VkExtensionPropertiesDataView {
 public:
  VkExtensionPropertiesDataView() = default;

  VkExtensionPropertiesDataView(
      internal::VkExtensionProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionName(UserType* output) {
    
    auto* pointer = data_->extensionName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t specVersion() const {
    return data_->specVersion;
  }
 private:
  internal::VkExtensionProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VkLayerPropertiesDataView {
 public:
  VkLayerPropertiesDataView() = default;

  VkLayerPropertiesDataView(
      internal::VkLayerProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLayerNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerName(UserType* output) {
    
    auto* pointer = data_->layerName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t specVersion() const {
    return data_->specVersion;
  }
  uint32_t implementationVersion() const {
    return data_->implementationVersion;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::VkLayerProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VkPhysicalDeviceLimitsDataView {
 public:
  VkPhysicalDeviceLimitsDataView() = default;

  VkPhysicalDeviceLimitsDataView(
      internal::VkPhysicalDeviceLimits_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t maxImageDimension1D() const {
    return data_->maxImageDimension1D;
  }
  uint32_t maxImageDimension2D() const {
    return data_->maxImageDimension2D;
  }
  uint32_t maxImageDimension3D() const {
    return data_->maxImageDimension3D;
  }
  uint32_t maxImageDimensionCube() const {
    return data_->maxImageDimensionCube;
  }
  uint32_t maxImageArrayLayers() const {
    return data_->maxImageArrayLayers;
  }
  uint32_t maxTexelBufferElements() const {
    return data_->maxTexelBufferElements;
  }
  uint32_t maxUniformBufferRange() const {
    return data_->maxUniformBufferRange;
  }
  uint32_t maxStorageBufferRange() const {
    return data_->maxStorageBufferRange;
  }
  uint32_t maxPushConstantsSize() const {
    return data_->maxPushConstantsSize;
  }
  uint32_t maxMemoryAllocationCount() const {
    return data_->maxMemoryAllocationCount;
  }
  uint32_t maxSamplerAllocationCount() const {
    return data_->maxSamplerAllocationCount;
  }
  uint64_t bufferImageGranularity() const {
    return data_->bufferImageGranularity;
  }
  uint64_t sparseAddressSpaceSize() const {
    return data_->sparseAddressSpaceSize;
  }
  uint32_t maxBoundDescriptorSets() const {
    return data_->maxBoundDescriptorSets;
  }
  uint32_t maxPerStageDescriptorSamplers() const {
    return data_->maxPerStageDescriptorSamplers;
  }
  uint32_t maxPerStageDescriptorUniformBuffers() const {
    return data_->maxPerStageDescriptorUniformBuffers;
  }
  uint32_t maxPerStageDescriptorStorageBuffers() const {
    return data_->maxPerStageDescriptorStorageBuffers;
  }
  uint32_t maxPerStageDescriptorSampledImages() const {
    return data_->maxPerStageDescriptorSampledImages;
  }
  uint32_t maxPerStageDescriptorStorageImages() const {
    return data_->maxPerStageDescriptorStorageImages;
  }
  uint32_t maxPerStageDescriptorInputAttachments() const {
    return data_->maxPerStageDescriptorInputAttachments;
  }
  uint32_t maxPerStageResources() const {
    return data_->maxPerStageResources;
  }
  uint32_t maxDescriptorSetSamplers() const {
    return data_->maxDescriptorSetSamplers;
  }
  uint32_t maxDescriptorSetUniformBuffers() const {
    return data_->maxDescriptorSetUniformBuffers;
  }
  uint32_t maxDescriptorSetUniformBuffersDynamic() const {
    return data_->maxDescriptorSetUniformBuffersDynamic;
  }
  uint32_t maxDescriptorSetStorageBuffers() const {
    return data_->maxDescriptorSetStorageBuffers;
  }
  uint32_t maxDescriptorSetStorageBuffersDynamic() const {
    return data_->maxDescriptorSetStorageBuffersDynamic;
  }
  uint32_t maxDescriptorSetSampledImages() const {
    return data_->maxDescriptorSetSampledImages;
  }
  uint32_t maxDescriptorSetStorageImages() const {
    return data_->maxDescriptorSetStorageImages;
  }
  uint32_t maxDescriptorSetInputAttachments() const {
    return data_->maxDescriptorSetInputAttachments;
  }
  uint32_t maxVertexInputAttributes() const {
    return data_->maxVertexInputAttributes;
  }
  uint32_t maxVertexInputBindings() const {
    return data_->maxVertexInputBindings;
  }
  uint32_t maxVertexInputAttributeOffset() const {
    return data_->maxVertexInputAttributeOffset;
  }
  uint32_t maxVertexInputBindingStride() const {
    return data_->maxVertexInputBindingStride;
  }
  uint32_t maxVertexOutputComponents() const {
    return data_->maxVertexOutputComponents;
  }
  uint32_t maxTessellationGenerationLevel() const {
    return data_->maxTessellationGenerationLevel;
  }
  uint32_t maxTessellationPatchSize() const {
    return data_->maxTessellationPatchSize;
  }
  uint32_t maxTessellationControlPerVertexInputComponents() const {
    return data_->maxTessellationControlPerVertexInputComponents;
  }
  uint32_t maxTessellationControlPerVertexOutputComponents() const {
    return data_->maxTessellationControlPerVertexOutputComponents;
  }
  uint32_t maxTessellationControlPerPatchOutputComponents() const {
    return data_->maxTessellationControlPerPatchOutputComponents;
  }
  uint32_t maxTessellationControlTotalOutputComponents() const {
    return data_->maxTessellationControlTotalOutputComponents;
  }
  uint32_t maxTessellationEvaluationInputComponents() const {
    return data_->maxTessellationEvaluationInputComponents;
  }
  uint32_t maxTessellationEvaluationOutputComponents() const {
    return data_->maxTessellationEvaluationOutputComponents;
  }
  uint32_t maxGeometryShaderInvocations() const {
    return data_->maxGeometryShaderInvocations;
  }
  uint32_t maxGeometryInputComponents() const {
    return data_->maxGeometryInputComponents;
  }
  uint32_t maxGeometryOutputComponents() const {
    return data_->maxGeometryOutputComponents;
  }
  uint32_t maxGeometryOutputVertices() const {
    return data_->maxGeometryOutputVertices;
  }
  uint32_t maxGeometryTotalOutputComponents() const {
    return data_->maxGeometryTotalOutputComponents;
  }
  uint32_t maxFragmentInputComponents() const {
    return data_->maxFragmentInputComponents;
  }
  uint32_t maxFragmentOutputAttachments() const {
    return data_->maxFragmentOutputAttachments;
  }
  uint32_t maxFragmentDualSrcAttachments() const {
    return data_->maxFragmentDualSrcAttachments;
  }
  uint32_t maxFragmentCombinedOutputResources() const {
    return data_->maxFragmentCombinedOutputResources;
  }
  uint32_t maxComputeSharedMemorySize() const {
    return data_->maxComputeSharedMemorySize;
  }
  inline void GetMaxComputeWorkGroupCountDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxComputeWorkGroupCount(UserType* output) {
    
    auto* pointer = data_->maxComputeWorkGroupCount.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  uint32_t maxComputeWorkGroupInvocations() const {
    return data_->maxComputeWorkGroupInvocations;
  }
  inline void GetMaxComputeWorkGroupSizeDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxComputeWorkGroupSize(UserType* output) {
    
    auto* pointer = data_->maxComputeWorkGroupSize.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  uint32_t subPixelPrecisionBits() const {
    return data_->subPixelPrecisionBits;
  }
  uint32_t subTexelPrecisionBits() const {
    return data_->subTexelPrecisionBits;
  }
  uint32_t mipmapPrecisionBits() const {
    return data_->mipmapPrecisionBits;
  }
  uint32_t maxDrawIndexedIndexValue() const {
    return data_->maxDrawIndexedIndexValue;
  }
  uint32_t maxDrawIndirectCount() const {
    return data_->maxDrawIndirectCount;
  }
  float maxSamplerLodBias() const {
    return data_->maxSamplerLodBias;
  }
  float maxSamplerAnisotropy() const {
    return data_->maxSamplerAnisotropy;
  }
  uint32_t maxViewports() const {
    return data_->maxViewports;
  }
  inline void GetMaxViewportDimensionsDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxViewportDimensions(UserType* output) {
    
    auto* pointer = data_->maxViewportDimensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetViewportBoundsRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportBoundsRange(UserType* output) {
    
    auto* pointer = data_->viewportBoundsRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  uint32_t viewportSubPixelBits() const {
    return data_->viewportSubPixelBits;
  }
  uint64_t minMemoryMapAlignment() const {
    return data_->minMemoryMapAlignment;
  }
  uint64_t minTexelBufferOffsetAlignment() const {
    return data_->minTexelBufferOffsetAlignment;
  }
  uint64_t minUniformBufferOffsetAlignment() const {
    return data_->minUniformBufferOffsetAlignment;
  }
  uint64_t minStorageBufferOffsetAlignment() const {
    return data_->minStorageBufferOffsetAlignment;
  }
  int32_t minTexelOffset() const {
    return data_->minTexelOffset;
  }
  uint32_t maxTexelOffset() const {
    return data_->maxTexelOffset;
  }
  int32_t minTexelGatherOffset() const {
    return data_->minTexelGatherOffset;
  }
  uint32_t maxTexelGatherOffset() const {
    return data_->maxTexelGatherOffset;
  }
  float minInterpolationOffset() const {
    return data_->minInterpolationOffset;
  }
  float maxInterpolationOffset() const {
    return data_->maxInterpolationOffset;
  }
  uint32_t subPixelInterpolationOffsetBits() const {
    return data_->subPixelInterpolationOffsetBits;
  }
  uint32_t maxFramebufferWidth() const {
    return data_->maxFramebufferWidth;
  }
  uint32_t maxFramebufferHeight() const {
    return data_->maxFramebufferHeight;
  }
  uint32_t maxFramebufferLayers() const {
    return data_->maxFramebufferLayers;
  }
  uint32_t framebufferColorSampleCounts() const {
    return data_->framebufferColorSampleCounts;
  }
  uint32_t framebufferDepthSampleCounts() const {
    return data_->framebufferDepthSampleCounts;
  }
  uint32_t framebufferStencilSampleCounts() const {
    return data_->framebufferStencilSampleCounts;
  }
  uint32_t framebufferNoAttachmentsSampleCounts() const {
    return data_->framebufferNoAttachmentsSampleCounts;
  }
  uint32_t maxColorAttachments() const {
    return data_->maxColorAttachments;
  }
  uint32_t sampledImageColorSampleCounts() const {
    return data_->sampledImageColorSampleCounts;
  }
  uint32_t sampledImageIntegerSampleCounts() const {
    return data_->sampledImageIntegerSampleCounts;
  }
  uint32_t sampledImageDepthSampleCounts() const {
    return data_->sampledImageDepthSampleCounts;
  }
  uint32_t sampledImageStencilSampleCounts() const {
    return data_->sampledImageStencilSampleCounts;
  }
  uint32_t storageImageSampleCounts() const {
    return data_->storageImageSampleCounts;
  }
  uint32_t maxSampleMaskWords() const {
    return data_->maxSampleMaskWords;
  }
  bool timestampComputeAndGraphics() const {
    return data_->timestampComputeAndGraphics;
  }
  float timestampPeriod() const {
    return data_->timestampPeriod;
  }
  uint32_t maxClipDistances() const {
    return data_->maxClipDistances;
  }
  uint32_t maxCullDistances() const {
    return data_->maxCullDistances;
  }
  uint32_t maxCombinedClipAndCullDistances() const {
    return data_->maxCombinedClipAndCullDistances;
  }
  uint32_t discreteQueuePriorities() const {
    return data_->discreteQueuePriorities;
  }
  inline void GetPointSizeRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointSizeRange(UserType* output) {
    
    auto* pointer = data_->pointSizeRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetLineWidthRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLineWidthRange(UserType* output) {
    
    auto* pointer = data_->lineWidthRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  float pointSizeGranularity() const {
    return data_->pointSizeGranularity;
  }
  float lineWidthGranularity() const {
    return data_->lineWidthGranularity;
  }
  bool strictLines() const {
    return data_->strictLines;
  }
  bool standardSampleLocations() const {
    return data_->standardSampleLocations;
  }
  uint64_t optimalBufferCopyOffsetAlignment() const {
    return data_->optimalBufferCopyOffsetAlignment;
  }
  uint64_t optimalBufferCopyRowPitchAlignment() const {
    return data_->optimalBufferCopyRowPitchAlignment;
  }
  uint64_t nonCoherentAtomSize() const {
    return data_->nonCoherentAtomSize;
  }
 private:
  internal::VkPhysicalDeviceLimits_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VkPhysicalDeviceSparsePropertiesDataView {
 public:
  VkPhysicalDeviceSparsePropertiesDataView() = default;

  VkPhysicalDeviceSparsePropertiesDataView(
      internal::VkPhysicalDeviceSparseProperties_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool residencyStandard2DBlockShape() const {
    return data_->residencyStandard2DBlockShape;
  }
  bool residencyStandard2DMultisampleBlockShape() const {
    return data_->residencyStandard2DMultisampleBlockShape;
  }
  bool residencyStandard3DBlockShape() const {
    return data_->residencyStandard3DBlockShape;
  }
  bool residencyAlignedMipSize() const {
    return data_->residencyAlignedMipSize;
  }
  bool residencyNonResidentStrict() const {
    return data_->residencyNonResidentStrict;
  }
 private:
  internal::VkPhysicalDeviceSparseProperties_Data* data_ = nullptr;
};


class VkPhysicalDevicePropertiesDataView {
 public:
  VkPhysicalDevicePropertiesDataView() = default;

  VkPhysicalDevicePropertiesDataView(
      internal::VkPhysicalDeviceProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t apiVersion() const {
    return data_->apiVersion;
  }
  uint32_t driverVersion() const {
    return data_->driverVersion;
  }
  uint32_t vendorID() const {
    return data_->vendorID;
  }
  uint32_t deviceID() const {
    return data_->deviceID;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeviceType(UserType* output) const {
    auto data_value = data_->deviceType;
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceType>(
        data_value, output);
  }
  VkPhysicalDeviceType deviceType() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::VkPhysicalDeviceType>(data_->deviceType));
  }
  inline void GetDeviceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceName(UserType* output) {
    
    auto* pointer = data_->deviceName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPipelineCacheUuidDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPipelineCacheUuid(UserType* output) {
    
    auto* pointer = data_->pipelineCacheUUID.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetLimitsDataView(
      VkPhysicalDeviceLimitsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLimits(UserType* output) {
    
    auto* pointer = data_->limits.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceLimitsDataView>(
        pointer, output, message_);
  }
  inline void GetSparsePropertiesDataView(
      VkPhysicalDeviceSparsePropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSparseProperties(UserType* output) {
    
    auto* pointer = data_->sparseProperties.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::VkPhysicalDeviceProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VkPhysicalDeviceFeaturesDataView {
 public:
  VkPhysicalDeviceFeaturesDataView() = default;

  VkPhysicalDeviceFeaturesDataView(
      internal::VkPhysicalDeviceFeatures_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool robustBufferAccess() const {
    return data_->robustBufferAccess;
  }
  bool fullDrawIndexUint32() const {
    return data_->fullDrawIndexUint32;
  }
  bool imageCubeArray() const {
    return data_->imageCubeArray;
  }
  bool independentBlend() const {
    return data_->independentBlend;
  }
  bool geometryShader() const {
    return data_->geometryShader;
  }
  bool tessellationShader() const {
    return data_->tessellationShader;
  }
  bool sampleRateShading() const {
    return data_->sampleRateShading;
  }
  bool dualSrcBlend() const {
    return data_->dualSrcBlend;
  }
  bool logicOp() const {
    return data_->logicOp;
  }
  bool multiDrawIndirect() const {
    return data_->multiDrawIndirect;
  }
  bool drawIndirectFirstInstance() const {
    return data_->drawIndirectFirstInstance;
  }
  bool depthClamp() const {
    return data_->depthClamp;
  }
  bool depthBiasClamp() const {
    return data_->depthBiasClamp;
  }
  bool fillModeNonSolid() const {
    return data_->fillModeNonSolid;
  }
  bool depthBounds() const {
    return data_->depthBounds;
  }
  bool wideLines() const {
    return data_->wideLines;
  }
  bool largePoints() const {
    return data_->largePoints;
  }
  bool alphaToOne() const {
    return data_->alphaToOne;
  }
  bool multiViewport() const {
    return data_->multiViewport;
  }
  bool samplerAnisotropy() const {
    return data_->samplerAnisotropy;
  }
  bool textureCompressionETC2() const {
    return data_->textureCompressionETC2;
  }
  bool textureCompressionASTC_LDR() const {
    return data_->textureCompressionASTC_LDR;
  }
  bool textureCompressionBC() const {
    return data_->textureCompressionBC;
  }
  bool occlusionQueryPrecise() const {
    return data_->occlusionQueryPrecise;
  }
  bool pipelineStatisticsQuery() const {
    return data_->pipelineStatisticsQuery;
  }
  bool vertexPipelineStoresAndAtomics() const {
    return data_->vertexPipelineStoresAndAtomics;
  }
  bool fragmentStoresAndAtomics() const {
    return data_->fragmentStoresAndAtomics;
  }
  bool shaderTessellationAndGeometryPointSize() const {
    return data_->shaderTessellationAndGeometryPointSize;
  }
  bool shaderImageGatherExtended() const {
    return data_->shaderImageGatherExtended;
  }
  bool shaderStorageImageExtendedFormats() const {
    return data_->shaderStorageImageExtendedFormats;
  }
  bool shaderStorageImageMultisample() const {
    return data_->shaderStorageImageMultisample;
  }
  bool shaderStorageImageReadWithoutFormat() const {
    return data_->shaderStorageImageReadWithoutFormat;
  }
  bool shaderStorageImageWriteWithoutFormat() const {
    return data_->shaderStorageImageWriteWithoutFormat;
  }
  bool shaderUniformBufferArrayDynamicIndexing() const {
    return data_->shaderUniformBufferArrayDynamicIndexing;
  }
  bool shaderSampledImageArrayDynamicIndexing() const {
    return data_->shaderSampledImageArrayDynamicIndexing;
  }
  bool shaderStorageBufferArrayDynamicIndexing() const {
    return data_->shaderStorageBufferArrayDynamicIndexing;
  }
  bool shaderStorageImageArrayDynamicIndexing() const {
    return data_->shaderStorageImageArrayDynamicIndexing;
  }
  bool shaderClipDistance() const {
    return data_->shaderClipDistance;
  }
  bool shaderCullDistance() const {
    return data_->shaderCullDistance;
  }
  bool shaderFloat64() const {
    return data_->shaderFloat64;
  }
  bool shaderInt64() const {
    return data_->shaderInt64;
  }
  bool shaderInt16() const {
    return data_->shaderInt16;
  }
  bool shaderResourceResidency() const {
    return data_->shaderResourceResidency;
  }
  bool shaderResourceMinLod() const {
    return data_->shaderResourceMinLod;
  }
  bool sparseBinding() const {
    return data_->sparseBinding;
  }
  bool sparseResidencyBuffer() const {
    return data_->sparseResidencyBuffer;
  }
  bool sparseResidencyImage2D() const {
    return data_->sparseResidencyImage2D;
  }
  bool sparseResidencyImage3D() const {
    return data_->sparseResidencyImage3D;
  }
  bool sparseResidency2Samples() const {
    return data_->sparseResidency2Samples;
  }
  bool sparseResidency4Samples() const {
    return data_->sparseResidency4Samples;
  }
  bool sparseResidency8Samples() const {
    return data_->sparseResidency8Samples;
  }
  bool sparseResidency16Samples() const {
    return data_->sparseResidency16Samples;
  }
  bool sparseResidencyAliased() const {
    return data_->sparseResidencyAliased;
  }
  bool variableMultisampleRate() const {
    return data_->variableMultisampleRate;
  }
  bool inheritedQueries() const {
    return data_->inheritedQueries;
  }
 private:
  internal::VkPhysicalDeviceFeatures_Data* data_ = nullptr;
};


class VkExtent3DDataView {
 public:
  VkExtent3DDataView() = default;

  VkExtent3DDataView(
      internal::VkExtent3D_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
  uint32_t depth() const {
    return data_->depth;
  }
 private:
  internal::VkExtent3D_Data* data_ = nullptr;
};


class VkQueueFamilyPropertiesDataView {
 public:
  VkQueueFamilyPropertiesDataView() = default;

  VkQueueFamilyPropertiesDataView(
      internal::VkQueueFamilyProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t queueFlags() const {
    return data_->queueFlags;
  }
  uint32_t queueCount() const {
    return data_->queueCount;
  }
  uint32_t timestampValidBits() const {
    return data_->timestampValidBits;
  }
  inline void GetMinImageTransferGranularityDataView(
      VkExtent3DDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinImageTransferGranularity(UserType* output) {
    
    auto* pointer = data_->minImageTransferGranularity.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkExtent3DDataView>(
        pointer, output, message_);
  }
 private:
  internal::VkQueueFamilyProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_DATA_VIEW_H_