// gpu/ipc/common/sync_token.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/sync_token.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/sync_token.mojom-params-data.h"
namespace gpu {
namespace mojom {

NOINLINE static const char* CommandBufferNamespaceToStringHelper(CommandBufferNamespace value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CommandBufferNamespace::INVALID:
      return "INVALID";
    case CommandBufferNamespace::GPU_IO:
      return "GPU_IO";
    case CommandBufferNamespace::IN_PROCESS:
      return "IN_PROCESS";
    case CommandBufferNamespace::VIZ_SKIA_OUTPUT_SURFACE:
      return "VIZ_SKIA_OUTPUT_SURFACE";
    case CommandBufferNamespace::VIZ_SKIA_OUTPUT_SURFACE_NON_DDL:
      return "VIZ_SKIA_OUTPUT_SURFACE_NON_DDL";
    case CommandBufferNamespace::GPU_CHANNEL_SHARED_IMAGE_INTERFACE:
      return "GPU_CHANNEL_SHARED_IMAGE_INTERFACE";
    case CommandBufferNamespace::WEBNN_CONTEXT_INTERFACE:
      return "WEBNN_CONTEXT_INTERFACE";
    default:
      return nullptr;
  }
}

std::string CommandBufferNamespaceToString(CommandBufferNamespace value) {
  const char *str = CommandBufferNamespaceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CommandBufferNamespace value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CommandBufferNamespace value) {
  return os << CommandBufferNamespaceToString(value);
}

namespace internal {


// static
bool SyncToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SyncToken_Data* object =
      static_cast<const SyncToken_Data*>(data);


  if (!::gpu::mojom::internal::CommandBufferNamespace_Data
        ::Validate(object->namespace_id, validation_context))
    return false;

  return true;
}

SyncToken_Data::SyncToken_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::CommandBufferNamespace>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::CommandBufferNamespace value) {
  return std::move(context).WriteString(::gpu::mojom::CommandBufferNamespaceToString(value));
}

} // namespace perfetto