// extensions/common/mojom/renderer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/renderer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/renderer.mojom-params-data.h"
namespace extensions {
namespace mojom {

namespace internal {


// static
bool ExtensionLoadedParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionLoadedParams_Data* object =
      static_cast<const ExtensionLoadedParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->manifest, validation_context))
    return false;


  if (!::extensions::mojom::internal::ManifestLocation_Data
        ::Validate(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->active_permissions, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->active_permissions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->withheld_permissions, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->withheld_permissions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_specific_permissions, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_specific_permissions_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->tab_specific_permissions, validation_context,
                                         &tab_specific_permissions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_blocked_hosts, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_blocked_hosts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_allowed_hosts, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_allowed_hosts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->worker_activation_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& guid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }

  return true;
}

ExtensionLoadedParams_Data::ExtensionLoadedParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserScriptWorldInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserScriptWorldInfo_Data* object =
      static_cast<const UserScriptWorldInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& world_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->world_id, validation_context,
                                         &world_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& csp_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->csp, validation_context,
                                         &csp_validate_params)) {
    return false;
  }

  return true;
}

UserScriptWorldInfo_Data::UserScriptWorldInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_ActivateExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_ActivateExtension_Params_Data* object =
      static_cast<const Renderer_ActivateExtension_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  return true;
}

Renderer_ActivateExtension_Params_Data::Renderer_ActivateExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetActivityLoggingEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetActivityLoggingEnabled_Params_Data* object =
      static_cast<const Renderer_SetActivityLoggingEnabled_Params_Data*>(data);

  return true;
}

Renderer_SetActivityLoggingEnabled_Params_Data::Renderer_SetActivityLoggingEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_LoadExtensions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_LoadExtensions_Params_Data* object =
      static_cast<const Renderer_LoadExtensions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->params, validation_context,
                                         &params_validate_params)) {
    return false;
  }

  return true;
}

Renderer_LoadExtensions_Params_Data::Renderer_LoadExtensions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UnloadExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UnloadExtension_Params_Data* object =
      static_cast<const Renderer_UnloadExtension_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  return true;
}

Renderer_UnloadExtension_Params_Data::Renderer_UnloadExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SuspendExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SuspendExtension_Params_Data* object =
      static_cast<const Renderer_SuspendExtension_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  return true;
}

Renderer_SuspendExtension_Params_Data::Renderer_SuspendExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SuspendExtension_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SuspendExtension_ResponseParams_Data* object =
      static_cast<const Renderer_SuspendExtension_ResponseParams_Data*>(data);

  return true;
}

Renderer_SuspendExtension_ResponseParams_Data::Renderer_SuspendExtension_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_CancelSuspendExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_CancelSuspendExtension_Params_Data* object =
      static_cast<const Renderer_CancelSuspendExtension_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  return true;
}

Renderer_CancelSuspendExtension_Params_Data::Renderer_CancelSuspendExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetDeveloperMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetDeveloperMode_Params_Data* object =
      static_cast<const Renderer_SetDeveloperMode_Params_Data*>(data);

  return true;
}

Renderer_SetDeveloperMode_Params_Data::Renderer_SetDeveloperMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetUserScriptsAllowed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetUserScriptsAllowed_Params_Data* object =
      static_cast<const Renderer_SetUserScriptsAllowed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  return true;
}

Renderer_SetUserScriptsAllowed_Params_Data::Renderer_SetUserScriptsAllowed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetSessionInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetSessionInfo_Params_Data* object =
      static_cast<const Renderer_SetSessionInfo_Params_Data*>(data);


  if (!::extensions::mojom::internal::Channel_Data
        ::Validate(object->channel, validation_context))
    return false;


  if (!::extensions::mojom::internal::FeatureSessionType_Data
        ::Validate(object->session, validation_context))
    return false;

  return true;
}

Renderer_SetSessionInfo_Params_Data::Renderer_SetSessionInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetSystemFont_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetSystemFont_Params_Data* object =
      static_cast<const Renderer_SetSystemFont_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font_family, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& font_family_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->font_family, validation_context,
                                         &font_family_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font_size, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& font_size_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->font_size, validation_context,
                                         &font_size_validate_params)) {
    return false;
  }

  return true;
}

Renderer_SetSystemFont_Params_Data::Renderer_SetSystemFont_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetWebViewPartitionID_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetWebViewPartitionID_Params_Data* object =
      static_cast<const Renderer_SetWebViewPartitionID_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->partition_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& partition_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->partition_id, validation_context,
                                         &partition_id_validate_params)) {
    return false;
  }

  return true;
}

Renderer_SetWebViewPartitionID_Params_Data::Renderer_SetWebViewPartitionID_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetScriptingAllowlist_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_SetScriptingAllowlist_Params_Data* object =
      static_cast<const Renderer_SetScriptingAllowlist_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_ids, validation_context,
                                         &extension_ids_validate_params)) {
    return false;
  }

  return true;
}

Renderer_SetScriptingAllowlist_Params_Data::Renderer_SetScriptingAllowlist_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdateUserScriptWorlds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UpdateUserScriptWorlds_Params_Data* object =
      static_cast<const Renderer_UpdateUserScriptWorlds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->infos, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->infos, validation_context,
                                         &infos_validate_params)) {
    return false;
  }

  return true;
}

Renderer_UpdateUserScriptWorlds_Params_Data::Renderer_UpdateUserScriptWorlds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_ClearUserScriptWorldConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_ClearUserScriptWorldConfig_Params_Data* object =
      static_cast<const Renderer_ClearUserScriptWorldConfig_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& world_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->world_id, validation_context,
                                         &world_id_validate_params)) {
    return false;
  }

  return true;
}

Renderer_ClearUserScriptWorldConfig_Params_Data::Renderer_ClearUserScriptWorldConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_ShouldSuspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_ShouldSuspend_Params_Data* object =
      static_cast<const Renderer_ShouldSuspend_Params_Data*>(data);

  return true;
}

Renderer_ShouldSuspend_Params_Data::Renderer_ShouldSuspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_ShouldSuspend_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_ShouldSuspend_ResponseParams_Data* object =
      static_cast<const Renderer_ShouldSuspend_ResponseParams_Data*>(data);

  return true;
}

Renderer_ShouldSuspend_ResponseParams_Data::Renderer_ShouldSuspend_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_TransferBlobs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_TransferBlobs_Params_Data* object =
      static_cast<const Renderer_TransferBlobs_Params_Data*>(data);

  return true;
}

Renderer_TransferBlobs_Params_Data::Renderer_TransferBlobs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_TransferBlobs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_TransferBlobs_ResponseParams_Data* object =
      static_cast<const Renderer_TransferBlobs_ResponseParams_Data*>(data);

  return true;
}

Renderer_TransferBlobs_ResponseParams_Data::Renderer_TransferBlobs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdatePermissions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UpdatePermissions_Params_Data* object =
      static_cast<const Renderer_UpdatePermissions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->active_permissions, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->active_permissions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->withheld_permissions, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->withheld_permissions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_blocked_hosts, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_blocked_hosts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_allowed_hosts, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_allowed_hosts, validation_context))
    return false;

  return true;
}

Renderer_UpdatePermissions_Params_Data::Renderer_UpdatePermissions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data* object =
      static_cast<const Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_policy_blocked_hosts, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_policy_blocked_hosts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_policy_allowed_hosts, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_policy_allowed_hosts, validation_context))
    return false;

  return true;
}

Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdateUserHostRestrictions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UpdateUserHostRestrictions_Params_Data* object =
      static_cast<const Renderer_UpdateUserHostRestrictions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_blocked_hosts, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_blocked_hosts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_allowed_hosts, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_allowed_hosts, validation_context))
    return false;

  return true;
}

Renderer_UpdateUserHostRestrictions_Params_Data::Renderer_UpdateUserHostRestrictions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdateTabSpecificPermissions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UpdateTabSpecificPermissions_Params_Data* object =
      static_cast<const Renderer_UpdateTabSpecificPermissions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_hosts, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_hosts, validation_context))
    return false;

  return true;
}

Renderer_UpdateTabSpecificPermissions_Params_Data::Renderer_UpdateTabSpecificPermissions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdateUserScripts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_UpdateUserScripts_Params_Data* object =
      static_cast<const Renderer_UpdateUserScripts_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->owner, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->owner, validation_context))
    return false;

  return true;
}

Renderer_UpdateUserScripts_Params_Data::Renderer_UpdateUserScripts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_ClearTabSpecificPermissions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_ClearTabSpecificPermissions_Params_Data* object =
      static_cast<const Renderer_ClearTabSpecificPermissions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_ids, validation_context,
                                         &extension_ids_validate_params)) {
    return false;
  }

  return true;
}

Renderer_ClearTabSpecificPermissions_Params_Data::Renderer_ClearTabSpecificPermissions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_WatchPages_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Renderer_WatchPages_Params_Data* object =
      static_cast<const Renderer_WatchPages_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->css_selectors, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& css_selectors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->css_selectors, validation_context,
                                         &css_selectors_validate_params)) {
    return false;
  }

  return true;
}

Renderer_WatchPages_Params_Data::Renderer_WatchPages_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions