// extensions/common/mojom/code_injection.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/code_injection.mojom-shared-internal.h"
#include "extensions/common/mojom/css_origin.mojom-shared.h"
#include "extensions/common/mojom/execution_world.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_evaluation_params.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "extensions/common/mojom/code_injection.mojom-data-view.h"




namespace std {

template <>
struct hash<::extensions::mojom::CSSInjection_Operation>
    : public mojo::internal::EnumHashImpl<::extensions::mojom::CSSInjection_Operation> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::CSSInjection_Operation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::extensions::mojom::CSSInjection_Operation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::extensions::mojom::CSSInjection_Operation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::JSSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::JSSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::JSSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::code(input)) in_code = Traits::code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code)::BaseType> code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_code,
      code_fragment);

    fragment->code.Set(
        code_fragment.is_null() ? nullptr : code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null code in JSSource struct");

    decltype(Traits::script_url(input)) in_script_url = Traits::script_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script_url)::BaseType> script_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_url,
      script_url_fragment);

    fragment->script_url.Set(
        script_url_fragment.is_null() ? nullptr : script_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->script_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_url in JSSource struct");
  }

  static bool Deserialize(::extensions::mojom::internal::JSSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::JSSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::CSSSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::CSSSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::CSSSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::code(input)) in_code = Traits::code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code)::BaseType> code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_code,
      code_fragment);

    fragment->code.Set(
        code_fragment.is_null() ? nullptr : code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null code in CSSSource struct");

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());
  }

  static bool Deserialize(::extensions::mojom::internal::CSSSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::CSSSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::JSInjectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::JSInjectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::JSInjection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::JSSourceDataView>>(
      in_sources,
      sources_fragment,
      &sources_validate_params);

    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sources in JSInjection struct");

    
    mojo::internal::Serialize<::extensions::mojom::ExecutionWorld>(
      Traits::world(input),
      &fragment->world);

    decltype(Traits::world_id(input)) in_world_id = Traits::world_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->world_id)::BaseType> world_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_world_id,
      world_id_fragment);

    fragment->world_id.Set(
        world_id_fragment.is_null() ? nullptr : world_id_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::WantResultOption>(
      Traits::wants_result(input),
      &fragment->wants_result);

    
    mojo::internal::Serialize<::blink::mojom::UserActivationOption>(
      Traits::user_gesture(input),
      &fragment->user_gesture);

    
    mojo::internal::Serialize<::blink::mojom::PromiseResultOption>(
      Traits::wait_for_promise(input),
      &fragment->wait_for_promise);
  }

  static bool Deserialize(::extensions::mojom::internal::JSInjection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::JSInjectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::CSSInjectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::CSSInjectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::CSSInjection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::CSSSourceDataView>>(
      in_sources,
      sources_fragment,
      &sources_validate_params);

    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sources in CSSInjection struct");

    
    mojo::internal::Serialize<::extensions::mojom::CSSOrigin>(
      Traits::css_origin(input),
      &fragment->css_origin);

    
    mojo::internal::Serialize<::extensions::mojom::CSSInjection_Operation>(
      Traits::operation(input),
      &fragment->operation);
  }

  static bool Deserialize(::extensions::mojom::internal::CSSInjection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::CSSInjectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::CodeInjectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::extensions::mojom::CodeInjectionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::extensions::mojom::internal::CodeInjection_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::extensions::mojom::CodeInjectionDataView::Tag::kCss: {
    decltype(Traits::css(input))
    in_css = Traits::css(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_css)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::extensions::mojom::CSSInjectionDataView>(
  in_css,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null css in CodeInjection union");
    fragment->data.f_css.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::extensions::mojom::CodeInjectionDataView::Tag::kJs: {
    decltype(Traits::js(input))
    in_js = Traits::js(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_js)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::extensions::mojom::JSInjectionDataView>(
  in_js,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null js in CodeInjection union");
    fragment->data.f_js.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::extensions::mojom::internal::CodeInjection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::CodeInjectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void JSSourceDataView::GetCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void JSSourceDataView::GetScriptUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->script_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void CSSSourceDataView::GetCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSSSourceDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void JSInjectionDataView::GetSourcesDataView(
    mojo::ArrayDataView<JSSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<JSSourceDataView>(pointer, message_);
}
inline void JSInjectionDataView::GetWorldIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->world_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CSSInjectionDataView::GetSourcesDataView(
    mojo::ArrayDataView<CSSSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<CSSSourceDataView>(pointer, message_);
}


inline void CodeInjectionDataView::GetCssDataView(
    CSSInjectionDataView* output) const {
  CHECK(is_css());
  *output = CSSInjectionDataView(data_->data.f_css.Get(), message_);
}
inline void CodeInjectionDataView::GetJsDataView(
    JSInjectionDataView* output) const {
  CHECK(is_js());
  *output = JSInjectionDataView(data_->data.f_js.Get(), message_);
}


}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::extensions::mojom::CSSInjection_Operation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::extensions::mojom::CSSInjection_Operation value);
};

} // namespace perfetto

#endif  // EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_H_