// content/common/renderer.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_PARAMS_DATA_H_
#define CONTENT_COMMON_RENDERER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace content::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_CreateAgentSchedulingGroup_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data bootstrap;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Renderer_CreateAgentSchedulingGroup_Params_Data>;

  Renderer_CreateAgentSchedulingGroup_Params_Data();
  ~Renderer_CreateAgentSchedulingGroup_Params_Data() = delete;
};
static_assert(sizeof(Renderer_CreateAgentSchedulingGroup_Params_Data) == 16,
              "Bad sizeof(Renderer_CreateAgentSchedulingGroup_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data agent_scheduling_group;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data>;

  Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data();
  ~Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data() = delete;
};
static_assert(sizeof(Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data) == 16,
              "Bad sizeof(Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_TransferSharedLastForegroundTime_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> last_foreground_time_region;

 private:
  friend class mojo::internal::MessageFragment<Renderer_TransferSharedLastForegroundTime_Params_Data>;

  Renderer_TransferSharedLastForegroundTime_Params_Data();
  ~Renderer_TransferSharedLastForegroundTime_Params_Data() = delete;
};
static_assert(sizeof(Renderer_TransferSharedLastForegroundTime_Params_Data) == 16,
              "Bad sizeof(Renderer_TransferSharedLastForegroundTime_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_OnNetworkConnectionChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t connection_type;
  uint8_t pad0_[4];
  double max_bandwidth_mbps;

 private:
  friend class mojo::internal::MessageFragment<Renderer_OnNetworkConnectionChanged_Params_Data>;

  Renderer_OnNetworkConnectionChanged_Params_Data();
  ~Renderer_OnNetworkConnectionChanged_Params_Data() = delete;
};
static_assert(sizeof(Renderer_OnNetworkConnectionChanged_Params_Data) == 24,
              "Bad sizeof(Renderer_OnNetworkConnectionChanged_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_OnNetworkQualityChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t effective_connection_type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> http_rtt;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> transport_rtt;
  double bandwidth_kbps;

 private:
  friend class mojo::internal::MessageFragment<Renderer_OnNetworkQualityChanged_Params_Data>;

  Renderer_OnNetworkQualityChanged_Params_Data();
  ~Renderer_OnNetworkQualityChanged_Params_Data() = delete;
};
static_assert(sizeof(Renderer_OnNetworkQualityChanged_Params_Data) == 40,
              "Bad sizeof(Renderer_OnNetworkQualityChanged_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetWebKitSharedTimersSuspended_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t suspend : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetWebKitSharedTimersSuspended_Params_Data>;

  Renderer_SetWebKitSharedTimersSuspended_Params_Data();
  ~Renderer_SetWebKitSharedTimersSuspended_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetWebKitSharedTimersSuspended_Params_Data) == 16,
              "Bad sizeof(Renderer_SetWebKitSharedTimersSuspended_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_UpdateScrollbarTheme_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::UpdateScrollbarThemeParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<Renderer_UpdateScrollbarTheme_Params_Data>;

  Renderer_UpdateScrollbarTheme_Params_Data();
  ~Renderer_UpdateScrollbarTheme_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateScrollbarTheme_Params_Data) == 16,
              "Bad sizeof(Renderer_UpdateScrollbarTheme_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_OnSystemColorsChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t aqua_color_variant;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Renderer_OnSystemColorsChanged_Params_Data>;

  Renderer_OnSystemColorsChanged_Params_Data();
  ~Renderer_OnSystemColorsChanged_Params_Data() = delete;
};
static_assert(sizeof(Renderer_OnSystemColorsChanged_Params_Data) == 16,
              "Bad sizeof(Renderer_OnSystemColorsChanged_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_UpdateSystemColorInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::UpdateSystemColorInfoParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<Renderer_UpdateSystemColorInfo_Params_Data>;

  Renderer_UpdateSystemColorInfo_Params_Data();
  ~Renderer_UpdateSystemColorInfo_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateSystemColorInfo_Params_Data) == 16,
              "Bad sizeof(Renderer_UpdateSystemColorInfo_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_PurgePluginListCache_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t reload_pages : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_PurgePluginListCache_Params_Data>;

  Renderer_PurgePluginListCache_Params_Data();
  ~Renderer_PurgePluginListCache_Params_Data() = delete;
};
static_assert(sizeof(Renderer_PurgePluginListCache_Params_Data) == 16,
              "Bad sizeof(Renderer_PurgePluginListCache_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_PurgeResourceCache_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_PurgeResourceCache_Params_Data>;

  Renderer_PurgeResourceCache_Params_Data();
  ~Renderer_PurgeResourceCache_Params_Data() = delete;
};
static_assert(sizeof(Renderer_PurgeResourceCache_Params_Data) == 8,
              "Bad sizeof(Renderer_PurgeResourceCache_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_PurgeResourceCache_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_PurgeResourceCache_ResponseParams_Data>;

  Renderer_PurgeResourceCache_ResponseParams_Data();
  ~Renderer_PurgeResourceCache_ResponseParams_Data() = delete;
};
static_assert(sizeof(Renderer_PurgeResourceCache_ResponseParams_Data) == 8,
              "Bad sizeof(Renderer_PurgeResourceCache_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetProcessState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t process_priority;
  int32_t visible_state;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetProcessState_Params_Data>;

  Renderer_SetProcessState_Params_Data();
  ~Renderer_SetProcessState_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetProcessState_Params_Data) == 16,
              "Bad sizeof(Renderer_SetProcessState_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetIsLockedToSite_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetIsLockedToSite_Params_Data>;

  Renderer_SetIsLockedToSite_Params_Data();
  ~Renderer_SetIsLockedToSite_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetIsLockedToSite_Params_Data) == 8,
              "Bad sizeof(Renderer_SetIsLockedToSite_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetIsCrossOriginIsolated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t value : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetIsCrossOriginIsolated_Params_Data>;

  Renderer_SetIsCrossOriginIsolated_Params_Data();
  ~Renderer_SetIsCrossOriginIsolated_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetIsCrossOriginIsolated_Params_Data) == 16,
              "Bad sizeof(Renderer_SetIsCrossOriginIsolated_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetIsWebSecurityDisabled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t value : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetIsWebSecurityDisabled_Params_Data>;

  Renderer_SetIsWebSecurityDisabled_Params_Data();
  ~Renderer_SetIsWebSecurityDisabled_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetIsWebSecurityDisabled_Params_Data) == 16,
              "Bad sizeof(Renderer_SetIsWebSecurityDisabled_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetIsIsolatedContext_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t value : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetIsIsolatedContext_Params_Data>;

  Renderer_SetIsIsolatedContext_Params_Data();
  ~Renderer_SetIsIsolatedContext_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetIsIsolatedContext_Params_Data) == 16,
              "Bad sizeof(Renderer_SetIsIsolatedContext_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<::url::mojom::internal::Url_Data>, int32_t>> resource_map;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data>;

  Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data();
  ~Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data) == 16,
              "Bad sizeof(Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) Renderer_InitializeRenderer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> user_agent;
  mojo::internal::Pointer<::blink::mojom::internal::UserAgentMetadata_Data> metadata;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> cors_exempt_header_list;
  mojo::internal::Pointer<::blink::mojom::internal::OriginTrialsSettings_Data> origin_trials_settings;
  uint64_t trace_id;

 private:
  friend class mojo::internal::MessageFragment<Renderer_InitializeRenderer_Params_Data>;

  Renderer_InitializeRenderer_Params_Data();
  ~Renderer_InitializeRenderer_Params_Data() = delete;
};
static_assert(sizeof(Renderer_InitializeRenderer_Params_Data) == 48,
              "Bad sizeof(Renderer_InitializeRenderer_Params_Data)");

}  // namespace internal


class Renderer_CreateAgentSchedulingGroup_ParamsDataView {
 public:
  Renderer_CreateAgentSchedulingGroup_ParamsDataView() = default;

  Renderer_CreateAgentSchedulingGroup_ParamsDataView(
      internal::Renderer_CreateAgentSchedulingGroup_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBootstrap() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::IPC::mojom::ChannelBootstrapInterfaceBase>>(
            &data_->bootstrap, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Renderer_CreateAgentSchedulingGroup_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_CreateAssociatedAgentSchedulingGroup_ParamsDataView {
 public:
  Renderer_CreateAssociatedAgentSchedulingGroup_ParamsDataView() = default;

  Renderer_CreateAssociatedAgentSchedulingGroup_ParamsDataView(
      internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeAgentSchedulingGroup() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::AgentSchedulingGroupAssociatedRequestDataView>(
            &data_->agent_scheduling_group, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Renderer_CreateAssociatedAgentSchedulingGroup_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_TransferSharedLastForegroundTime_ParamsDataView {
 public:
  Renderer_TransferSharedLastForegroundTime_ParamsDataView() = default;

  Renderer_TransferSharedLastForegroundTime_ParamsDataView(
      internal::Renderer_TransferSharedLastForegroundTime_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLastForegroundTimeRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastForegroundTimeRegion(UserType* output) {
    
    auto* pointer = data_->last_foreground_time_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_TransferSharedLastForegroundTime_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_OnNetworkConnectionChanged_ParamsDataView {
 public:
  Renderer_OnNetworkConnectionChanged_ParamsDataView() = default;

  Renderer_OnNetworkConnectionChanged_ParamsDataView(
      internal::Renderer_OnNetworkConnectionChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadConnectionType(UserType* output) const {
    auto data_value = data_->connection_type;
    return mojo::internal::Deserialize<::content::mojom::NetworkConnectionType>(
        data_value, output);
  }
  ::content::mojom::NetworkConnectionType connection_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::NetworkConnectionType>(data_->connection_type));
  }
  double max_bandwidth_mbps() const {
    return data_->max_bandwidth_mbps;
  }
 private:
  internal::Renderer_OnNetworkConnectionChanged_Params_Data* data_ = nullptr;
};


class Renderer_OnNetworkQualityChanged_ParamsDataView {
 public:
  Renderer_OnNetworkQualityChanged_ParamsDataView() = default;

  Renderer_OnNetworkQualityChanged_ParamsDataView(
      internal::Renderer_OnNetworkQualityChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveConnectionType(UserType* output) const {
    auto data_value = data_->effective_connection_type;
    return mojo::internal::Deserialize<::network::mojom::EffectiveConnectionType>(
        data_value, output);
  }
  ::network::mojom::EffectiveConnectionType effective_connection_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::EffectiveConnectionType>(data_->effective_connection_type));
  }
  inline void GetHttpRttDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpRtt(UserType* output) {
    
    auto* pointer = data_->http_rtt.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTransportRttDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransportRtt(UserType* output) {
    
    auto* pointer = data_->transport_rtt.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  double bandwidth_kbps() const {
    return data_->bandwidth_kbps;
  }
 private:
  internal::Renderer_OnNetworkQualityChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SetWebKitSharedTimersSuspended_ParamsDataView {
 public:
  Renderer_SetWebKitSharedTimersSuspended_ParamsDataView() = default;

  Renderer_SetWebKitSharedTimersSuspended_ParamsDataView(
      internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool suspend() const {
    return data_->suspend;
  }
 private:
  internal::Renderer_SetWebKitSharedTimersSuspended_Params_Data* data_ = nullptr;
};


class Renderer_UpdateScrollbarTheme_ParamsDataView {
 public:
  Renderer_UpdateScrollbarTheme_ParamsDataView() = default;

  Renderer_UpdateScrollbarTheme_ParamsDataView(
      internal::Renderer_UpdateScrollbarTheme_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      UpdateScrollbarThemeParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::UpdateScrollbarThemeParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_UpdateScrollbarTheme_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_OnSystemColorsChanged_ParamsDataView {
 public:
  Renderer_OnSystemColorsChanged_ParamsDataView() = default;

  Renderer_OnSystemColorsChanged_ParamsDataView(
      internal::Renderer_OnSystemColorsChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t aqua_color_variant() const {
    return data_->aqua_color_variant;
  }
 private:
  internal::Renderer_OnSystemColorsChanged_Params_Data* data_ = nullptr;
};


class Renderer_UpdateSystemColorInfo_ParamsDataView {
 public:
  Renderer_UpdateSystemColorInfo_ParamsDataView() = default;

  Renderer_UpdateSystemColorInfo_ParamsDataView(
      internal::Renderer_UpdateSystemColorInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      UpdateSystemColorInfoParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::UpdateSystemColorInfoParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_UpdateSystemColorInfo_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_PurgePluginListCache_ParamsDataView {
 public:
  Renderer_PurgePluginListCache_ParamsDataView() = default;

  Renderer_PurgePluginListCache_ParamsDataView(
      internal::Renderer_PurgePluginListCache_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool reload_pages() const {
    return data_->reload_pages;
  }
 private:
  internal::Renderer_PurgePluginListCache_Params_Data* data_ = nullptr;
};


class Renderer_PurgeResourceCache_ParamsDataView {
 public:
  Renderer_PurgeResourceCache_ParamsDataView() = default;

  Renderer_PurgeResourceCache_ParamsDataView(
      internal::Renderer_PurgeResourceCache_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_PurgeResourceCache_Params_Data* data_ = nullptr;
};


class Renderer_PurgeResourceCache_ResponseParamsDataView {
 public:
  Renderer_PurgeResourceCache_ResponseParamsDataView() = default;

  Renderer_PurgeResourceCache_ResponseParamsDataView(
      internal::Renderer_PurgeResourceCache_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_PurgeResourceCache_ResponseParams_Data* data_ = nullptr;
};


class Renderer_SetProcessState_ParamsDataView {
 public:
  Renderer_SetProcessState_ParamsDataView() = default;

  Renderer_SetProcessState_ParamsDataView(
      internal::Renderer_SetProcessState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProcessPriority(UserType* output) const {
    auto data_value = data_->process_priority;
    return mojo::internal::Deserialize<::mojo_base::mojom::ProcessPriority>(
        data_value, output);
  }
  ::mojo_base::mojom::ProcessPriority process_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::ProcessPriority>(data_->process_priority));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVisibleState(UserType* output) const {
    auto data_value = data_->visible_state;
    return mojo::internal::Deserialize<::content::mojom::RenderProcessVisibleState>(
        data_value, output);
  }
  RenderProcessVisibleState visible_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::RenderProcessVisibleState>(data_->visible_state));
  }
 private:
  internal::Renderer_SetProcessState_Params_Data* data_ = nullptr;
};


class Renderer_SetIsLockedToSite_ParamsDataView {
 public:
  Renderer_SetIsLockedToSite_ParamsDataView() = default;

  Renderer_SetIsLockedToSite_ParamsDataView(
      internal::Renderer_SetIsLockedToSite_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_SetIsLockedToSite_Params_Data* data_ = nullptr;
};


class Renderer_SetIsCrossOriginIsolated_ParamsDataView {
 public:
  Renderer_SetIsCrossOriginIsolated_ParamsDataView() = default;

  Renderer_SetIsCrossOriginIsolated_ParamsDataView(
      internal::Renderer_SetIsCrossOriginIsolated_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool value() const {
    return data_->value;
  }
 private:
  internal::Renderer_SetIsCrossOriginIsolated_Params_Data* data_ = nullptr;
};


class Renderer_SetIsWebSecurityDisabled_ParamsDataView {
 public:
  Renderer_SetIsWebSecurityDisabled_ParamsDataView() = default;

  Renderer_SetIsWebSecurityDisabled_ParamsDataView(
      internal::Renderer_SetIsWebSecurityDisabled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool value() const {
    return data_->value;
  }
 private:
  internal::Renderer_SetIsWebSecurityDisabled_Params_Data* data_ = nullptr;
};


class Renderer_SetIsIsolatedContext_ParamsDataView {
 public:
  Renderer_SetIsIsolatedContext_ParamsDataView() = default;

  Renderer_SetIsIsolatedContext_ParamsDataView(
      internal::Renderer_SetIsIsolatedContext_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool value() const {
    return data_->value;
  }
 private:
  internal::Renderer_SetIsIsolatedContext_Params_Data* data_ = nullptr;
};


class Renderer_SetWebUIResourceUrlToCodeCacheMap_ParamsDataView {
 public:
  Renderer_SetWebUIResourceUrlToCodeCacheMap_ParamsDataView() = default;

  Renderer_SetWebUIResourceUrlToCodeCacheMap_ParamsDataView(
      internal::Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResourceMapDataView(
      mojo::MapDataView<::url::mojom::UrlDataView, int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResourceMap(UserType* output) {
    
    auto* pointer = data_->resource_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::url::mojom::UrlDataView, int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_SetWebUIResourceUrlToCodeCacheMap_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_InitializeRenderer_ParamsDataView {
 public:
  Renderer_InitializeRenderer_ParamsDataView() = default;

  Renderer_InitializeRenderer_ParamsDataView(
      internal::Renderer_InitializeRenderer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserAgentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAgent(UserType* output) {
    
    auto* pointer = data_->user_agent.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      ::blink::mojom::UserAgentMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::blink::mojom::UserAgentMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetCorsExemptHeaderListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsExemptHeaderList(UserType* output) {
    
    auto* pointer = data_->cors_exempt_header_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetOriginTrialsSettingsDataView(
      ::blink::mojom::OriginTrialsSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginTrialsSettings(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::OriginTrialsSettingsDataView, UserType>(),
    "Attempting to read the optional `origin_trials_settings` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOriginTrialsSettings` instead "
    "of `ReadOriginTrialsSettings if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->origin_trials_settings.Get();
    return mojo::internal::Deserialize<::blink::mojom::OriginTrialsSettingsDataView>(
        pointer, output, message_);
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
 private:
  internal::Renderer_InitializeRenderer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};





inline void Renderer_TransferSharedLastForegroundTime_ParamsDataView::GetLastForegroundTimeRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->last_foreground_time_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}




inline void Renderer_OnNetworkQualityChanged_ParamsDataView::GetHttpRttDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->http_rtt.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void Renderer_OnNetworkQualityChanged_ParamsDataView::GetTransportRttDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->transport_rtt.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}




inline void Renderer_UpdateScrollbarTheme_ParamsDataView::GetParamsDataView(
    UpdateScrollbarThemeParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = UpdateScrollbarThemeParamsDataView(pointer, message_);
}




inline void Renderer_UpdateSystemColorInfo_ParamsDataView::GetParamsDataView(
    UpdateSystemColorInfoParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = UpdateSystemColorInfoParamsDataView(pointer, message_);
}


















inline void Renderer_SetWebUIResourceUrlToCodeCacheMap_ParamsDataView::GetResourceMapDataView(
    mojo::MapDataView<::url::mojom::UrlDataView, int32_t>* output) {
  auto pointer = data_->resource_map.Get();
  *output = mojo::MapDataView<::url::mojom::UrlDataView, int32_t>(pointer, message_);
}


inline void Renderer_InitializeRenderer_ParamsDataView::GetUserAgentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_agent.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void Renderer_InitializeRenderer_ParamsDataView::GetMetadataDataView(
    ::blink::mojom::UserAgentMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::blink::mojom::UserAgentMetadataDataView(pointer, message_);
}
inline void Renderer_InitializeRenderer_ParamsDataView::GetCorsExemptHeaderListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cors_exempt_header_list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void Renderer_InitializeRenderer_ParamsDataView::GetOriginTrialsSettingsDataView(
    ::blink::mojom::OriginTrialsSettingsDataView* output) {
  auto pointer = data_->origin_trials_settings.Get();
  *output = ::blink::mojom::OriginTrialsSettingsDataView(pointer, message_);
}



}  // content::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_COMMON_RENDERER_MOJOM_PARAMS_DATA_H_