// content/common/associated_interfaces.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/associated_interfaces.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/associated_interfaces.mojom-params-data.h"
#include "content/common/associated_interfaces.mojom-shared-message-ids.h"

#include "content/common/associated_interfaces.mojom-import-headers.h"
#include "content/common/associated_interfaces.mojom-test-utils.h"


namespace content::mojom {
// The declaration includes the definition on other builds.

RouteProvider::IPCStableHashFunction RouteProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RouteProvider>(message.name())) {
    case messages::RouteProvider::kGetRoute: {
      return &RouteProvider::GetRoute_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RouteProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RouteProvider>(message.name())) {
      case messages::RouteProvider::kGetRoute:
            return "Receive content::mojom::RouteProvider::GetRoute";
    }
  } else {
    switch (static_cast<messages::RouteProvider>(message.name())) {
      case messages::RouteProvider::kGetRoute:
            return "Receive reply content::mojom::RouteProvider::GetRoute";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RouteProvider::GetRoute_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc120468;  // IPCStableHash for content::mojom::RouteProvider::GetRoute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RouteProviderProxy::RouteProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RouteProviderProxy::GetRoute(
    const ::blink::LocalFrameToken& in_frame_token, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::RouteProvider::GetRoute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RouteProvider::kGetRoute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RouteProvider_GetRoute_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_frame_token,
    frame_token_fragment);

  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_token in RouteProvider.GetRoute request");

  
  mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in RouteProvider.GetRoute request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RouteProvider::Name_);
  message.set_method_name("GetRoute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RouteProviderStubDispatch::Accept(
    RouteProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RouteProvider>(message->header()->name)) {
    case messages::RouteProvider::kGetRoute: {
      DCHECK(message->is_serialized());
      internal::RouteProvider_GetRoute_Params_Data* params =
          reinterpret_cast<internal::RouteProvider_GetRoute_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RouteProvider.0
      bool success = true;
      ::blink::LocalFrameToken p_frame_token{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> p_receiver{};
      RouteProvider_GetRoute_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameToken(&p_frame_token))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RouteProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRoute(        
        std::move(p_frame_token), 
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool RouteProviderStubDispatch::AcceptWithResponder(
    RouteProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RouteProvider>(message->header()->name)) {
    case messages::RouteProvider::kGetRoute: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRouteProviderValidationInfo[] = {
    {base::to_underlying(messages::RouteProvider::kGetRoute),
     { &internal::RouteProvider_GetRoute_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RouteProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::content::mojom::RouteProvider::Name_,
    kRouteProviderValidationInfo);
}



}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void RouteProviderInterceptorForTesting::GetRoute(const ::blink::LocalFrameToken& frame_token, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> receiver) {
  GetForwardingInterface()->GetRoute(
    std::move(frame_token)
    , 
    std::move(receiver)
    );
}
RouteProviderAsyncWaiter::RouteProviderAsyncWaiter(
    RouteProvider* proxy) : proxy_(proxy) {}

RouteProviderAsyncWaiter::~RouteProviderAsyncWaiter() = default;







}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif