// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_WebAuthn_h
#define content_protocol_WebAuthn_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace WebAuthn {
using AuthenticatorId = String;
using AuthenticatorProtocol = String;
using Ctap2Version = String;
using AuthenticatorTransport = String;
class VirtualAuthenticatorOptions;
class Credential;

// ------------- Forward and enum declarations.

namespace AuthenticatorProtocolEnum {
CONTENT_EXPORT extern const char U2f[];
CONTENT_EXPORT extern const char Ctap2[];
} // namespace AuthenticatorProtocolEnum

namespace Ctap2VersionEnum {
CONTENT_EXPORT extern const char Ctap2_0[];
CONTENT_EXPORT extern const char Ctap2_1[];
} // namespace Ctap2VersionEnum

namespace AuthenticatorTransportEnum {
CONTENT_EXPORT extern const char Usb[];
CONTENT_EXPORT extern const char Nfc[];
CONTENT_EXPORT extern const char Ble[];
CONTENT_EXPORT extern const char Cable[];
CONTENT_EXPORT extern const char Internal[];
} // namespace AuthenticatorTransportEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT VirtualAuthenticatorOptions : public ::crdtp::ProtocolObject<VirtualAuthenticatorOptions> {
public:
    ~VirtualAuthenticatorOptions() override { }

    String GetProtocol() { return m_protocol; }
    void SetProtocol(const String& value) { m_protocol = value; }

    bool HasCtap2Version() { return !!m_ctap2Version; }
    String GetCtap2Version(const String& defaultValue) const {
       return m_ctap2Version.value_or(defaultValue);
    }
    const std::optional<String>& GetCtap2Version() const {
       return m_ctap2Version;
    }
    void SetCtap2Version(const String& value) { m_ctap2Version = value; }

    String GetTransport() { return m_transport; }
    void SetTransport(const String& value) { m_transport = value; }

    bool HasHasResidentKey() { return !!m_hasResidentKey; }
    bool GetHasResidentKey(bool defaultValue) const {
       return m_hasResidentKey.value_or(defaultValue);
    }
    const std::optional<bool>& GetHasResidentKey() const {
       return m_hasResidentKey;
    }
    void SetHasResidentKey(bool value) { m_hasResidentKey = value; }

    bool HasHasUserVerification() { return !!m_hasUserVerification; }
    bool GetHasUserVerification(bool defaultValue) const {
       return m_hasUserVerification.value_or(defaultValue);
    }
    const std::optional<bool>& GetHasUserVerification() const {
       return m_hasUserVerification;
    }
    void SetHasUserVerification(bool value) { m_hasUserVerification = value; }

    bool HasHasLargeBlob() { return !!m_hasLargeBlob; }
    bool GetHasLargeBlob(bool defaultValue) const {
       return m_hasLargeBlob.value_or(defaultValue);
    }
    const std::optional<bool>& GetHasLargeBlob() const {
       return m_hasLargeBlob;
    }
    void SetHasLargeBlob(bool value) { m_hasLargeBlob = value; }

    bool HasHasCredBlob() { return !!m_hasCredBlob; }
    bool GetHasCredBlob(bool defaultValue) const {
       return m_hasCredBlob.value_or(defaultValue);
    }
    const std::optional<bool>& GetHasCredBlob() const {
       return m_hasCredBlob;
    }
    void SetHasCredBlob(bool value) { m_hasCredBlob = value; }

    bool HasHasMinPinLength() { return !!m_hasMinPinLength; }
    bool GetHasMinPinLength(bool defaultValue) const {
       return m_hasMinPinLength.value_or(defaultValue);
    }
    const std::optional<bool>& GetHasMinPinLength() const {
       return m_hasMinPinLength;
    }
    void SetHasMinPinLength(bool value) { m_hasMinPinLength = value; }

    bool HasHasPrf() { return !!m_hasPrf; }
    bool GetHasPrf(bool defaultValue) const {
       return m_hasPrf.value_or(defaultValue);
    }
    const std::optional<bool>& GetHasPrf() const {
       return m_hasPrf;
    }
    void SetHasPrf(bool value) { m_hasPrf = value; }

    bool HasAutomaticPresenceSimulation() { return !!m_automaticPresenceSimulation; }
    bool GetAutomaticPresenceSimulation(bool defaultValue) const {
       return m_automaticPresenceSimulation.value_or(defaultValue);
    }
    const std::optional<bool>& GetAutomaticPresenceSimulation() const {
       return m_automaticPresenceSimulation;
    }
    void SetAutomaticPresenceSimulation(bool value) { m_automaticPresenceSimulation = value; }

    bool HasIsUserVerified() { return !!m_isUserVerified; }
    bool GetIsUserVerified(bool defaultValue) const {
       return m_isUserVerified.value_or(defaultValue);
    }
    const std::optional<bool>& GetIsUserVerified() const {
       return m_isUserVerified;
    }
    void SetIsUserVerified(bool value) { m_isUserVerified = value; }

    bool HasDefaultBackupEligibility() { return !!m_defaultBackupEligibility; }
    bool GetDefaultBackupEligibility(bool defaultValue) const {
       return m_defaultBackupEligibility.value_or(defaultValue);
    }
    const std::optional<bool>& GetDefaultBackupEligibility() const {
       return m_defaultBackupEligibility;
    }
    void SetDefaultBackupEligibility(bool value) { m_defaultBackupEligibility = value; }

    bool HasDefaultBackupState() { return !!m_defaultBackupState; }
    bool GetDefaultBackupState(bool defaultValue) const {
       return m_defaultBackupState.value_or(defaultValue);
    }
    const std::optional<bool>& GetDefaultBackupState() const {
       return m_defaultBackupState;
    }
    void SetDefaultBackupState(bool value) { m_defaultBackupState = value; }

    template<int STATE>
    class VirtualAuthenticatorOptionsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            TransportSet = 1 << 2,
            AllFieldsSet = (ProtocolSet | TransportSet | 0)};


        VirtualAuthenticatorOptionsBuilder<STATE | ProtocolSet>& SetProtocol(const String& value)
        {
            static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
            m_result->SetProtocol(value);
            return castState<ProtocolSet>();
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetCtap2Version(const String& value)
        {
            m_result->SetCtap2Version(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE | TransportSet>& SetTransport(const String& value)
        {
            static_assert(!(STATE & TransportSet), "property transport should not be set yet");
            m_result->SetTransport(value);
            return castState<TransportSet>();
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetHasResidentKey(bool value)
        {
            m_result->SetHasResidentKey(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetHasUserVerification(bool value)
        {
            m_result->SetHasUserVerification(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetHasLargeBlob(bool value)
        {
            m_result->SetHasLargeBlob(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetHasCredBlob(bool value)
        {
            m_result->SetHasCredBlob(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetHasMinPinLength(bool value)
        {
            m_result->SetHasMinPinLength(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetHasPrf(bool value)
        {
            m_result->SetHasPrf(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetAutomaticPresenceSimulation(bool value)
        {
            m_result->SetAutomaticPresenceSimulation(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetIsUserVerified(bool value)
        {
            m_result->SetIsUserVerified(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetDefaultBackupEligibility(bool value)
        {
            m_result->SetDefaultBackupEligibility(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetDefaultBackupState(bool value)
        {
            m_result->SetDefaultBackupState(value);
            return *this;
        }

        std::unique_ptr<VirtualAuthenticatorOptions> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VirtualAuthenticatorOptions;
        VirtualAuthenticatorOptionsBuilder() : m_result(new VirtualAuthenticatorOptions()) { }

        template<int STEP> VirtualAuthenticatorOptionsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VirtualAuthenticatorOptionsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAuthn::VirtualAuthenticatorOptions> m_result;
    };

    static VirtualAuthenticatorOptionsBuilder<0> Create()
    {
        return VirtualAuthenticatorOptionsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VirtualAuthenticatorOptions()
    {
    }

    String m_protocol;
    std::optional<String> m_ctap2Version;
    String m_transport;
    std::optional<bool> m_hasResidentKey;
    std::optional<bool> m_hasUserVerification;
    std::optional<bool> m_hasLargeBlob;
    std::optional<bool> m_hasCredBlob;
    std::optional<bool> m_hasMinPinLength;
    std::optional<bool> m_hasPrf;
    std::optional<bool> m_automaticPresenceSimulation;
    std::optional<bool> m_isUserVerified;
    std::optional<bool> m_defaultBackupEligibility;
    std::optional<bool> m_defaultBackupState;
};


class CONTENT_EXPORT Credential : public ::crdtp::ProtocolObject<Credential> {
public:
    ~Credential() override { }

    Binary GetCredentialId() { return m_credentialId; }
    void SetCredentialId(const Binary& value) { m_credentialId = value; }

    bool GetIsResidentCredential() { return m_isResidentCredential; }
    void SetIsResidentCredential(bool value) { m_isResidentCredential = value; }

    bool HasRpId() { return !!m_rpId; }
    String GetRpId(const String& defaultValue) const {
       return m_rpId.value_or(defaultValue);
    }
    const std::optional<String>& GetRpId() const {
       return m_rpId;
    }
    void SetRpId(const String& value) { m_rpId = value; }

    Binary GetPrivateKey() { return m_privateKey; }
    void SetPrivateKey(const Binary& value) { m_privateKey = value; }

    bool HasUserHandle() { return !!m_userHandle; }
    Binary GetUserHandle(const Binary& defaultValue) const {
       return m_userHandle.value_or(defaultValue);
    }
    const std::optional<Binary>& GetUserHandle() const {
       return m_userHandle;
    }
    void SetUserHandle(const Binary& value) { m_userHandle = value; }

    int GetSignCount() { return m_signCount; }
    void SetSignCount(int value) { m_signCount = value; }

    bool HasLargeBlob() { return !!m_largeBlob; }
    Binary GetLargeBlob(const Binary& defaultValue) const {
       return m_largeBlob.value_or(defaultValue);
    }
    const std::optional<Binary>& GetLargeBlob() const {
       return m_largeBlob;
    }
    void SetLargeBlob(const Binary& value) { m_largeBlob = value; }

    bool HasBackupEligibility() { return !!m_backupEligibility; }
    bool GetBackupEligibility(bool defaultValue) const {
       return m_backupEligibility.value_or(defaultValue);
    }
    const std::optional<bool>& GetBackupEligibility() const {
       return m_backupEligibility;
    }
    void SetBackupEligibility(bool value) { m_backupEligibility = value; }

    bool HasBackupState() { return !!m_backupState; }
    bool GetBackupState(bool defaultValue) const {
       return m_backupState.value_or(defaultValue);
    }
    const std::optional<bool>& GetBackupState() const {
       return m_backupState;
    }
    void SetBackupState(bool value) { m_backupState = value; }

    bool HasUserName() { return !!m_userName; }
    String GetUserName(const String& defaultValue) const {
       return m_userName.value_or(defaultValue);
    }
    const std::optional<String>& GetUserName() const {
       return m_userName;
    }
    void SetUserName(const String& value) { m_userName = value; }

    bool HasUserDisplayName() { return !!m_userDisplayName; }
    String GetUserDisplayName(const String& defaultValue) const {
       return m_userDisplayName.value_or(defaultValue);
    }
    const std::optional<String>& GetUserDisplayName() const {
       return m_userDisplayName;
    }
    void SetUserDisplayName(const String& value) { m_userDisplayName = value; }

    template<int STATE>
    class CredentialBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CredentialIdSet = 1 << 1,
            IsResidentCredentialSet = 1 << 2,
            PrivateKeySet = 1 << 3,
            SignCountSet = 1 << 4,
            AllFieldsSet = (CredentialIdSet | IsResidentCredentialSet | PrivateKeySet | SignCountSet | 0)};


        CredentialBuilder<STATE | CredentialIdSet>& SetCredentialId(const Binary& value)
        {
            static_assert(!(STATE & CredentialIdSet), "property credentialId should not be set yet");
            m_result->SetCredentialId(value);
            return castState<CredentialIdSet>();
        }

        CredentialBuilder<STATE | IsResidentCredentialSet>& SetIsResidentCredential(bool value)
        {
            static_assert(!(STATE & IsResidentCredentialSet), "property isResidentCredential should not be set yet");
            m_result->SetIsResidentCredential(value);
            return castState<IsResidentCredentialSet>();
        }

        CredentialBuilder<STATE>& SetRpId(const String& value)
        {
            m_result->SetRpId(value);
            return *this;
        }

        CredentialBuilder<STATE | PrivateKeySet>& SetPrivateKey(const Binary& value)
        {
            static_assert(!(STATE & PrivateKeySet), "property privateKey should not be set yet");
            m_result->SetPrivateKey(value);
            return castState<PrivateKeySet>();
        }

        CredentialBuilder<STATE>& SetUserHandle(const Binary& value)
        {
            m_result->SetUserHandle(value);
            return *this;
        }

        CredentialBuilder<STATE | SignCountSet>& SetSignCount(int value)
        {
            static_assert(!(STATE & SignCountSet), "property signCount should not be set yet");
            m_result->SetSignCount(value);
            return castState<SignCountSet>();
        }

        CredentialBuilder<STATE>& SetLargeBlob(const Binary& value)
        {
            m_result->SetLargeBlob(value);
            return *this;
        }

        CredentialBuilder<STATE>& SetBackupEligibility(bool value)
        {
            m_result->SetBackupEligibility(value);
            return *this;
        }

        CredentialBuilder<STATE>& SetBackupState(bool value)
        {
            m_result->SetBackupState(value);
            return *this;
        }

        CredentialBuilder<STATE>& SetUserName(const String& value)
        {
            m_result->SetUserName(value);
            return *this;
        }

        CredentialBuilder<STATE>& SetUserDisplayName(const String& value)
        {
            m_result->SetUserDisplayName(value);
            return *this;
        }

        std::unique_ptr<Credential> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Credential;
        CredentialBuilder() : m_result(new Credential()) { }

        template<int STEP> CredentialBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CredentialBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAuthn::Credential> m_result;
    };

    static CredentialBuilder<0> Create()
    {
        return CredentialBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Credential()
    {
          m_isResidentCredential = false;
          m_signCount = 0;
    }

    Binary m_credentialId;
    bool m_isResidentCredential;
    std::optional<String> m_rpId;
    Binary m_privateKey;
    std::optional<Binary> m_userHandle;
    int m_signCount;
    std::optional<Binary> m_largeBlob;
    std::optional<bool> m_backupEligibility;
    std::optional<bool> m_backupState;
    std::optional<String> m_userName;
    std::optional<String> m_userDisplayName;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Enable(std::optional<bool> in_enableUI) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse AddVirtualAuthenticator(std::unique_ptr<protocol::WebAuthn::VirtualAuthenticatorOptions> in_options, String* out_authenticatorId) = 0;
    virtual DispatchResponse SetResponseOverrideBits(const String& in_authenticatorId, std::optional<bool> in_isBogusSignature, std::optional<bool> in_isBadUV, std::optional<bool> in_isBadUP) = 0;
    virtual DispatchResponse RemoveVirtualAuthenticator(const String& in_authenticatorId) = 0;
    class CONTENT_EXPORT AddCredentialCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~AddCredentialCallback() { }
    };
    virtual void AddCredential(const String& in_authenticatorId, std::unique_ptr<protocol::WebAuthn::Credential> in_credential, std::unique_ptr<AddCredentialCallback> callback) = 0;
    class CONTENT_EXPORT GetCredentialCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::WebAuthn::Credential> credential) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetCredentialCallback() { }
    };
    virtual void GetCredential(const String& in_authenticatorId, const Binary& in_credentialId, std::unique_ptr<GetCredentialCallback> callback) = 0;
    class CONTENT_EXPORT GetCredentialsCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::WebAuthn::Credential>> credentials) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetCredentialsCallback() { }
    };
    virtual void GetCredentials(const String& in_authenticatorId, std::unique_ptr<GetCredentialsCallback> callback) = 0;
    virtual DispatchResponse RemoveCredential(const String& in_authenticatorId, const Binary& in_credentialId) = 0;
    virtual DispatchResponse ClearCredentials(const String& in_authenticatorId) = 0;
    virtual DispatchResponse SetUserVerified(const String& in_authenticatorId, bool in_isUserVerified) = 0;
    virtual DispatchResponse SetAutomaticPresenceSimulation(const String& in_authenticatorId, bool in_enabled) = 0;
    virtual DispatchResponse SetCredentialProperties(const String& in_authenticatorId, const Binary& in_credentialId, std::optional<bool> in_backupEligibility, std::optional<bool> in_backupState) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void CredentialAdded(const String& authenticatorId, std::unique_ptr<protocol::WebAuthn::Credential> credential);
    void CredentialDeleted(const String& authenticatorId, const Binary& credentialId);
    void CredentialUpdated(const String& authenticatorId, std::unique_ptr<protocol::WebAuthn::Credential> credential);
    void CredentialAsserted(const String& authenticatorId, std::unique_ptr<protocol::WebAuthn::Credential> credential);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace WebAuthn
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_WebAuthn_h)
