// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Storage_h
#define content_protocol_Storage_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/browser.h"
#include "content/browser/devtools/protocol/network.h"

namespace content {
namespace protocol {
namespace Storage {
using SerializedStorageKey = String;
using StorageType = String;
class UsageForType;
class TrustTokens;
using InterestGroupAuctionId = String;
using InterestGroupAccessType = String;
using InterestGroupAuctionEventType = String;
using InterestGroupAuctionFetchType = String;
using SharedStorageAccessScope = String;
using SharedStorageAccessMethod = String;
class SharedStorageEntry;
class SharedStorageMetadata;
class SharedStoragePrivateAggregationConfig;
class SharedStorageReportingMetadata;
class SharedStorageUrlWithMetadata;
class SharedStorageAccessParams;
using StorageBucketsDurability = String;
class StorageBucket;
class StorageBucketInfo;
using AttributionReportingSourceType = String;
using UnsignedInt64AsBase10 = String;
using UnsignedInt128AsBase16 = String;
using SignedInt64AsBase10 = String;
class AttributionReportingFilterDataEntry;
class AttributionReportingFilterConfig;
class AttributionReportingFilterPair;
class AttributionReportingAggregationKeysEntry;
class AttributionReportingEventReportWindows;
using AttributionReportingTriggerDataMatching = String;
class AttributionReportingAggregatableDebugReportingData;
class AttributionReportingAggregatableDebugReportingConfig;
class AttributionScopesData;
class AttributionReportingNamedBudgetDef;
class AttributionReportingSourceRegistration;
using AttributionReportingSourceRegistrationResult = String;
using AttributionReportingSourceRegistrationTimeConfig = String;
class AttributionReportingAggregatableValueDictEntry;
class AttributionReportingAggregatableValueEntry;
class AttributionReportingEventTriggerData;
class AttributionReportingAggregatableTriggerData;
class AttributionReportingAggregatableDedupKey;
class AttributionReportingNamedBudgetCandidate;
class AttributionReportingTriggerRegistration;
using AttributionReportingEventLevelResult = String;
using AttributionReportingAggregatableResult = String;
using AttributionReportingReportResult = String;

// ------------- Forward and enum declarations.

namespace StorageTypeEnum {
CONTENT_EXPORT extern const char Cookies[];
CONTENT_EXPORT extern const char File_systems[];
CONTENT_EXPORT extern const char Indexeddb[];
CONTENT_EXPORT extern const char Local_storage[];
CONTENT_EXPORT extern const char Shader_cache[];
CONTENT_EXPORT extern const char Websql[];
CONTENT_EXPORT extern const char Service_workers[];
CONTENT_EXPORT extern const char Cache_storage[];
CONTENT_EXPORT extern const char Interest_groups[];
CONTENT_EXPORT extern const char Shared_storage[];
CONTENT_EXPORT extern const char Storage_buckets[];
CONTENT_EXPORT extern const char All[];
CONTENT_EXPORT extern const char Other[];
} // namespace StorageTypeEnum

namespace InterestGroupAccessTypeEnum {
CONTENT_EXPORT extern const char Join[];
CONTENT_EXPORT extern const char Leave[];
CONTENT_EXPORT extern const char Update[];
CONTENT_EXPORT extern const char Loaded[];
CONTENT_EXPORT extern const char Bid[];
CONTENT_EXPORT extern const char Win[];
CONTENT_EXPORT extern const char AdditionalBid[];
CONTENT_EXPORT extern const char AdditionalBidWin[];
CONTENT_EXPORT extern const char TopLevelBid[];
CONTENT_EXPORT extern const char TopLevelAdditionalBid[];
CONTENT_EXPORT extern const char Clear[];
} // namespace InterestGroupAccessTypeEnum

namespace InterestGroupAuctionEventTypeEnum {
CONTENT_EXPORT extern const char Started[];
CONTENT_EXPORT extern const char ConfigResolved[];
} // namespace InterestGroupAuctionEventTypeEnum

namespace InterestGroupAuctionFetchTypeEnum {
CONTENT_EXPORT extern const char BidderJs[];
CONTENT_EXPORT extern const char BidderWasm[];
CONTENT_EXPORT extern const char SellerJs[];
CONTENT_EXPORT extern const char BidderTrustedSignals[];
CONTENT_EXPORT extern const char SellerTrustedSignals[];
} // namespace InterestGroupAuctionFetchTypeEnum

namespace SharedStorageAccessScopeEnum {
CONTENT_EXPORT extern const char Window[];
CONTENT_EXPORT extern const char SharedStorageWorklet[];
CONTENT_EXPORT extern const char ProtectedAudienceWorklet[];
CONTENT_EXPORT extern const char Header[];
} // namespace SharedStorageAccessScopeEnum

namespace SharedStorageAccessMethodEnum {
CONTENT_EXPORT extern const char AddModule[];
CONTENT_EXPORT extern const char CreateWorklet[];
CONTENT_EXPORT extern const char SelectURL[];
CONTENT_EXPORT extern const char Run[];
CONTENT_EXPORT extern const char BatchUpdate[];
CONTENT_EXPORT extern const char Set[];
CONTENT_EXPORT extern const char Append[];
CONTENT_EXPORT extern const char Delete[];
CONTENT_EXPORT extern const char Clear[];
CONTENT_EXPORT extern const char Get[];
CONTENT_EXPORT extern const char Keys[];
CONTENT_EXPORT extern const char Values[];
CONTENT_EXPORT extern const char Entries[];
CONTENT_EXPORT extern const char Length[];
CONTENT_EXPORT extern const char RemainingBudget[];
} // namespace SharedStorageAccessMethodEnum

namespace StorageBucketsDurabilityEnum {
CONTENT_EXPORT extern const char Relaxed[];
CONTENT_EXPORT extern const char Strict[];
} // namespace StorageBucketsDurabilityEnum

namespace AttributionReportingSourceTypeEnum {
CONTENT_EXPORT extern const char Navigation[];
CONTENT_EXPORT extern const char Event[];
} // namespace AttributionReportingSourceTypeEnum

namespace AttributionReportingTriggerDataMatchingEnum {
CONTENT_EXPORT extern const char Exact[];
CONTENT_EXPORT extern const char Modulus[];
} // namespace AttributionReportingTriggerDataMatchingEnum

namespace AttributionReportingSourceRegistrationResultEnum {
CONTENT_EXPORT extern const char Success[];
CONTENT_EXPORT extern const char InternalError[];
CONTENT_EXPORT extern const char InsufficientSourceCapacity[];
CONTENT_EXPORT extern const char InsufficientUniqueDestinationCapacity[];
CONTENT_EXPORT extern const char ExcessiveReportingOrigins[];
CONTENT_EXPORT extern const char ProhibitedByBrowserPolicy[];
CONTENT_EXPORT extern const char SuccessNoised[];
CONTENT_EXPORT extern const char DestinationReportingLimitReached[];
CONTENT_EXPORT extern const char DestinationGlobalLimitReached[];
CONTENT_EXPORT extern const char DestinationBothLimitsReached[];
CONTENT_EXPORT extern const char ReportingOriginsPerSiteLimitReached[];
CONTENT_EXPORT extern const char ExceedsMaxChannelCapacity[];
CONTENT_EXPORT extern const char ExceedsMaxScopesChannelCapacity[];
CONTENT_EXPORT extern const char ExceedsMaxTriggerStateCardinality[];
CONTENT_EXPORT extern const char ExceedsMaxEventStatesLimit[];
CONTENT_EXPORT extern const char DestinationPerDayReportingLimitReached[];
} // namespace AttributionReportingSourceRegistrationResultEnum

namespace AttributionReportingSourceRegistrationTimeConfigEnum {
CONTENT_EXPORT extern const char Include[];
CONTENT_EXPORT extern const char Exclude[];
} // namespace AttributionReportingSourceRegistrationTimeConfigEnum

namespace AttributionReportingEventLevelResultEnum {
CONTENT_EXPORT extern const char Success[];
CONTENT_EXPORT extern const char SuccessDroppedLowerPriority[];
CONTENT_EXPORT extern const char InternalError[];
CONTENT_EXPORT extern const char NoCapacityForAttributionDestination[];
CONTENT_EXPORT extern const char NoMatchingSources[];
CONTENT_EXPORT extern const char Deduplicated[];
CONTENT_EXPORT extern const char ExcessiveAttributions[];
CONTENT_EXPORT extern const char PriorityTooLow[];
CONTENT_EXPORT extern const char NeverAttributedSource[];
CONTENT_EXPORT extern const char ExcessiveReportingOrigins[];
CONTENT_EXPORT extern const char NoMatchingSourceFilterData[];
CONTENT_EXPORT extern const char ProhibitedByBrowserPolicy[];
CONTENT_EXPORT extern const char NoMatchingConfigurations[];
CONTENT_EXPORT extern const char ExcessiveReports[];
CONTENT_EXPORT extern const char FalselyAttributedSource[];
CONTENT_EXPORT extern const char ReportWindowPassed[];
CONTENT_EXPORT extern const char NotRegistered[];
CONTENT_EXPORT extern const char ReportWindowNotStarted[];
CONTENT_EXPORT extern const char NoMatchingTriggerData[];
} // namespace AttributionReportingEventLevelResultEnum

namespace AttributionReportingAggregatableResultEnum {
CONTENT_EXPORT extern const char Success[];
CONTENT_EXPORT extern const char InternalError[];
CONTENT_EXPORT extern const char NoCapacityForAttributionDestination[];
CONTENT_EXPORT extern const char NoMatchingSources[];
CONTENT_EXPORT extern const char ExcessiveAttributions[];
CONTENT_EXPORT extern const char ExcessiveReportingOrigins[];
CONTENT_EXPORT extern const char NoHistograms[];
CONTENT_EXPORT extern const char InsufficientBudget[];
CONTENT_EXPORT extern const char InsufficientNamedBudget[];
CONTENT_EXPORT extern const char NoMatchingSourceFilterData[];
CONTENT_EXPORT extern const char NotRegistered[];
CONTENT_EXPORT extern const char ProhibitedByBrowserPolicy[];
CONTENT_EXPORT extern const char Deduplicated[];
CONTENT_EXPORT extern const char ReportWindowPassed[];
CONTENT_EXPORT extern const char ExcessiveReports[];
} // namespace AttributionReportingAggregatableResultEnum

namespace AttributionReportingReportResultEnum {
CONTENT_EXPORT extern const char Sent[];
CONTENT_EXPORT extern const char Prohibited[];
CONTENT_EXPORT extern const char FailedToAssemble[];
CONTENT_EXPORT extern const char Expired[];
} // namespace AttributionReportingReportResultEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT UsageForType : public ::crdtp::ProtocolObject<UsageForType> {
public:
    ~UsageForType() override { }

    String GetStorageType() { return m_storageType; }
    void SetStorageType(const String& value) { m_storageType = value; }

    double GetUsage() { return m_usage; }
    void SetUsage(double value) { m_usage = value; }

    template<int STATE>
    class UsageForTypeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StorageTypeSet = 1 << 1,
            UsageSet = 1 << 2,
            AllFieldsSet = (StorageTypeSet | UsageSet | 0)};


        UsageForTypeBuilder<STATE | StorageTypeSet>& SetStorageType(const String& value)
        {
            static_assert(!(STATE & StorageTypeSet), "property storageType should not be set yet");
            m_result->SetStorageType(value);
            return castState<StorageTypeSet>();
        }

        UsageForTypeBuilder<STATE | UsageSet>& SetUsage(double value)
        {
            static_assert(!(STATE & UsageSet), "property usage should not be set yet");
            m_result->SetUsage(value);
            return castState<UsageSet>();
        }

        std::unique_ptr<UsageForType> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UsageForType;
        UsageForTypeBuilder() : m_result(new UsageForType()) { }

        template<int STEP> UsageForTypeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UsageForTypeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::UsageForType> m_result;
    };

    static UsageForTypeBuilder<0> Create()
    {
        return UsageForTypeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UsageForType()
    {
          m_usage = 0;
    }

    String m_storageType;
    double m_usage;
};


class CONTENT_EXPORT TrustTokens : public ::crdtp::ProtocolObject<TrustTokens> {
public:
    ~TrustTokens() override { }

    String GetIssuerOrigin() { return m_issuerOrigin; }
    void SetIssuerOrigin(const String& value) { m_issuerOrigin = value; }

    double GetCount() { return m_count; }
    void SetCount(double value) { m_count = value; }

    template<int STATE>
    class TrustTokensBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IssuerOriginSet = 1 << 1,
            CountSet = 1 << 2,
            AllFieldsSet = (IssuerOriginSet | CountSet | 0)};


        TrustTokensBuilder<STATE | IssuerOriginSet>& SetIssuerOrigin(const String& value)
        {
            static_assert(!(STATE & IssuerOriginSet), "property issuerOrigin should not be set yet");
            m_result->SetIssuerOrigin(value);
            return castState<IssuerOriginSet>();
        }

        TrustTokensBuilder<STATE | CountSet>& SetCount(double value)
        {
            static_assert(!(STATE & CountSet), "property count should not be set yet");
            m_result->SetCount(value);
            return castState<CountSet>();
        }

        std::unique_ptr<TrustTokens> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TrustTokens;
        TrustTokensBuilder() : m_result(new TrustTokens()) { }

        template<int STEP> TrustTokensBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TrustTokensBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::TrustTokens> m_result;
    };

    static TrustTokensBuilder<0> Create()
    {
        return TrustTokensBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TrustTokens()
    {
          m_count = 0;
    }

    String m_issuerOrigin;
    double m_count;
};


class CONTENT_EXPORT SharedStorageEntry : public ::crdtp::ProtocolObject<SharedStorageEntry> {
public:
    ~SharedStorageEntry() override { }

    String GetKey() { return m_key; }
    void SetKey(const String& value) { m_key = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    template<int STATE>
    class SharedStorageEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (KeySet | ValueSet | 0)};


        SharedStorageEntryBuilder<STATE | KeySet>& SetKey(const String& value)
        {
            static_assert(!(STATE & KeySet), "property key should not be set yet");
            m_result->SetKey(value);
            return castState<KeySet>();
        }

        SharedStorageEntryBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<SharedStorageEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageEntry;
        SharedStorageEntryBuilder() : m_result(new SharedStorageEntry()) { }

        template<int STEP> SharedStorageEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageEntry> m_result;
    };

    static SharedStorageEntryBuilder<0> Create()
    {
        return SharedStorageEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageEntry()
    {
    }

    String m_key;
    String m_value;
};


class CONTENT_EXPORT SharedStorageMetadata : public ::crdtp::ProtocolObject<SharedStorageMetadata> {
public:
    ~SharedStorageMetadata() override { }

    double GetCreationTime() { return m_creationTime; }
    void SetCreationTime(double value) { m_creationTime = value; }

    int GetLength() { return m_length; }
    void SetLength(int value) { m_length = value; }

    double GetRemainingBudget() { return m_remainingBudget; }
    void SetRemainingBudget(double value) { m_remainingBudget = value; }

    int GetBytesUsed() { return m_bytesUsed; }
    void SetBytesUsed(int value) { m_bytesUsed = value; }

    template<int STATE>
    class SharedStorageMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CreationTimeSet = 1 << 1,
            LengthSet = 1 << 2,
            RemainingBudgetSet = 1 << 3,
            BytesUsedSet = 1 << 4,
            AllFieldsSet = (CreationTimeSet | LengthSet | RemainingBudgetSet | BytesUsedSet | 0)};


        SharedStorageMetadataBuilder<STATE | CreationTimeSet>& SetCreationTime(double value)
        {
            static_assert(!(STATE & CreationTimeSet), "property creationTime should not be set yet");
            m_result->SetCreationTime(value);
            return castState<CreationTimeSet>();
        }

        SharedStorageMetadataBuilder<STATE | LengthSet>& SetLength(int value)
        {
            static_assert(!(STATE & LengthSet), "property length should not be set yet");
            m_result->SetLength(value);
            return castState<LengthSet>();
        }

        SharedStorageMetadataBuilder<STATE | RemainingBudgetSet>& SetRemainingBudget(double value)
        {
            static_assert(!(STATE & RemainingBudgetSet), "property remainingBudget should not be set yet");
            m_result->SetRemainingBudget(value);
            return castState<RemainingBudgetSet>();
        }

        SharedStorageMetadataBuilder<STATE | BytesUsedSet>& SetBytesUsed(int value)
        {
            static_assert(!(STATE & BytesUsedSet), "property bytesUsed should not be set yet");
            m_result->SetBytesUsed(value);
            return castState<BytesUsedSet>();
        }

        std::unique_ptr<SharedStorageMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageMetadata;
        SharedStorageMetadataBuilder() : m_result(new SharedStorageMetadata()) { }

        template<int STEP> SharedStorageMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageMetadata> m_result;
    };

    static SharedStorageMetadataBuilder<0> Create()
    {
        return SharedStorageMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageMetadata()
    {
          m_creationTime = 0;
          m_length = 0;
          m_remainingBudget = 0;
          m_bytesUsed = 0;
    }

    double m_creationTime;
    int m_length;
    double m_remainingBudget;
    int m_bytesUsed;
};


class CONTENT_EXPORT SharedStoragePrivateAggregationConfig : public ::crdtp::ProtocolObject<SharedStoragePrivateAggregationConfig> {
public:
    ~SharedStoragePrivateAggregationConfig() override { }

    bool HasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String GetAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void SetAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }

    bool HasContextId() { return !!m_contextId; }
    String GetContextId(const String& defaultValue) const {
       return m_contextId.value_or(defaultValue);
    }
    const std::optional<String>& GetContextId() const {
       return m_contextId;
    }
    void SetContextId(const String& value) { m_contextId = value; }

    int GetFilteringIdMaxBytes() { return m_filteringIdMaxBytes; }
    void SetFilteringIdMaxBytes(int value) { m_filteringIdMaxBytes = value; }

    bool HasMaxContributions() { return !!m_maxContributions; }
    int GetMaxContributions(int defaultValue) const {
       return m_maxContributions.value_or(defaultValue);
    }
    const std::optional<int>& GetMaxContributions() const {
       return m_maxContributions;
    }
    void SetMaxContributions(int value) { m_maxContributions = value; }

    template<int STATE>
    class SharedStoragePrivateAggregationConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FilteringIdMaxBytesSet = 1 << 1,
            AllFieldsSet = (FilteringIdMaxBytesSet | 0)};


        SharedStoragePrivateAggregationConfigBuilder<STATE>& SetAggregationCoordinatorOrigin(const String& value)
        {
            m_result->SetAggregationCoordinatorOrigin(value);
            return *this;
        }

        SharedStoragePrivateAggregationConfigBuilder<STATE>& SetContextId(const String& value)
        {
            m_result->SetContextId(value);
            return *this;
        }

        SharedStoragePrivateAggregationConfigBuilder<STATE | FilteringIdMaxBytesSet>& SetFilteringIdMaxBytes(int value)
        {
            static_assert(!(STATE & FilteringIdMaxBytesSet), "property filteringIdMaxBytes should not be set yet");
            m_result->SetFilteringIdMaxBytes(value);
            return castState<FilteringIdMaxBytesSet>();
        }

        SharedStoragePrivateAggregationConfigBuilder<STATE>& SetMaxContributions(int value)
        {
            m_result->SetMaxContributions(value);
            return *this;
        }

        std::unique_ptr<SharedStoragePrivateAggregationConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStoragePrivateAggregationConfig;
        SharedStoragePrivateAggregationConfigBuilder() : m_result(new SharedStoragePrivateAggregationConfig()) { }

        template<int STEP> SharedStoragePrivateAggregationConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStoragePrivateAggregationConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> m_result;
    };

    static SharedStoragePrivateAggregationConfigBuilder<0> Create()
    {
        return SharedStoragePrivateAggregationConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStoragePrivateAggregationConfig()
    {
          m_filteringIdMaxBytes = 0;
    }

    std::optional<String> m_aggregationCoordinatorOrigin;
    std::optional<String> m_contextId;
    int m_filteringIdMaxBytes;
    std::optional<int> m_maxContributions;
};


class CONTENT_EXPORT SharedStorageReportingMetadata : public ::crdtp::ProtocolObject<SharedStorageReportingMetadata> {
public:
    ~SharedStorageReportingMetadata() override { }

    String GetEventType() { return m_eventType; }
    void SetEventType(const String& value) { m_eventType = value; }

    String GetReportingUrl() { return m_reportingUrl; }
    void SetReportingUrl(const String& value) { m_reportingUrl = value; }

    template<int STATE>
    class SharedStorageReportingMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            EventTypeSet = 1 << 1,
            ReportingUrlSet = 1 << 2,
            AllFieldsSet = (EventTypeSet | ReportingUrlSet | 0)};


        SharedStorageReportingMetadataBuilder<STATE | EventTypeSet>& SetEventType(const String& value)
        {
            static_assert(!(STATE & EventTypeSet), "property eventType should not be set yet");
            m_result->SetEventType(value);
            return castState<EventTypeSet>();
        }

        SharedStorageReportingMetadataBuilder<STATE | ReportingUrlSet>& SetReportingUrl(const String& value)
        {
            static_assert(!(STATE & ReportingUrlSet), "property reportingUrl should not be set yet");
            m_result->SetReportingUrl(value);
            return castState<ReportingUrlSet>();
        }

        std::unique_ptr<SharedStorageReportingMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageReportingMetadata;
        SharedStorageReportingMetadataBuilder() : m_result(new SharedStorageReportingMetadata()) { }

        template<int STEP> SharedStorageReportingMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageReportingMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageReportingMetadata> m_result;
    };

    static SharedStorageReportingMetadataBuilder<0> Create()
    {
        return SharedStorageReportingMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageReportingMetadata()
    {
    }

    String m_eventType;
    String m_reportingUrl;
};


class CONTENT_EXPORT SharedStorageUrlWithMetadata : public ::crdtp::ProtocolObject<SharedStorageUrlWithMetadata> {
public:
    ~SharedStorageUrlWithMetadata() override { }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    protocol::Array<protocol::Storage::SharedStorageReportingMetadata>* GetReportingMetadata() { return m_reportingMetadata.get(); }
    void SetReportingMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> value) { m_reportingMetadata = std::move(value); }

    template<int STATE>
    class SharedStorageUrlWithMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            ReportingMetadataSet = 1 << 2,
            AllFieldsSet = (UrlSet | ReportingMetadataSet | 0)};


        SharedStorageUrlWithMetadataBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        SharedStorageUrlWithMetadataBuilder<STATE | ReportingMetadataSet>& SetReportingMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> value)
        {
            static_assert(!(STATE & ReportingMetadataSet), "property reportingMetadata should not be set yet");
            m_result->SetReportingMetadata(std::move(value));
            return castState<ReportingMetadataSet>();
        }

        std::unique_ptr<SharedStorageUrlWithMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageUrlWithMetadata;
        SharedStorageUrlWithMetadataBuilder() : m_result(new SharedStorageUrlWithMetadata()) { }

        template<int STEP> SharedStorageUrlWithMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageUrlWithMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageUrlWithMetadata> m_result;
    };

    static SharedStorageUrlWithMetadataBuilder<0> Create()
    {
        return SharedStorageUrlWithMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageUrlWithMetadata()
    {
    }

    String m_url;
    std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> m_reportingMetadata;
};


class CONTENT_EXPORT SharedStorageAccessParams : public ::crdtp::ProtocolObject<SharedStorageAccessParams> {
public:
    ~SharedStorageAccessParams() override { }

    bool HasScriptSourceUrl() { return !!m_scriptSourceUrl; }
    String GetScriptSourceUrl(const String& defaultValue) const {
       return m_scriptSourceUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetScriptSourceUrl() const {
       return m_scriptSourceUrl;
    }
    void SetScriptSourceUrl(const String& value) { m_scriptSourceUrl = value; }

    bool HasDataOrigin() { return !!m_dataOrigin; }
    String GetDataOrigin(const String& defaultValue) const {
       return m_dataOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetDataOrigin() const {
       return m_dataOrigin;
    }
    void SetDataOrigin(const String& value) { m_dataOrigin = value; }

    bool HasOperationName() { return !!m_operationName; }
    String GetOperationName(const String& defaultValue) const {
       return m_operationName.value_or(defaultValue);
    }
    const std::optional<String>& GetOperationName() const {
       return m_operationName;
    }
    void SetOperationName(const String& value) { m_operationName = value; }

    bool HasOperationId() { return !!m_operationId; }
    String GetOperationId(const String& defaultValue) const {
       return m_operationId.value_or(defaultValue);
    }
    const std::optional<String>& GetOperationId() const {
       return m_operationId;
    }
    void SetOperationId(const String& value) { m_operationId = value; }

    bool HasKeepAlive() { return !!m_keepAlive; }
    bool GetKeepAlive(bool defaultValue) const {
       return m_keepAlive.value_or(defaultValue);
    }
    const std::optional<bool>& GetKeepAlive() const {
       return m_keepAlive;
    }
    void SetKeepAlive(bool value) { m_keepAlive = value; }

    bool HasPrivateAggregationConfig() { return !!m_privateAggregationConfig; }
    protocol::Storage::SharedStoragePrivateAggregationConfig* GetPrivateAggregationConfig(protocol::Storage::SharedStoragePrivateAggregationConfig* defaultValue) {
       return m_privateAggregationConfig ? m_privateAggregationConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig>& GetPrivateAggregationConfig() const {
       return m_privateAggregationConfig;
    }
    void SetPrivateAggregationConfig(std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> value) { m_privateAggregationConfig = std::move(value); }

    bool HasSerializedData() { return !!m_serializedData; }
    String GetSerializedData(const String& defaultValue) const {
       return m_serializedData.value_or(defaultValue);
    }
    const std::optional<String>& GetSerializedData() const {
       return m_serializedData;
    }
    void SetSerializedData(const String& value) { m_serializedData = value; }

    bool HasUrlsWithMetadata() { return !!m_urlsWithMetadata; }
    protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>* GetUrlsWithMetadata(protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>* defaultValue) {
       return m_urlsWithMetadata ? m_urlsWithMetadata.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>>& GetUrlsWithMetadata() const {
       return m_urlsWithMetadata;
    }
    void SetUrlsWithMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> value) { m_urlsWithMetadata = std::move(value); }

    bool HasUrnUuid() { return !!m_urnUuid; }
    String GetUrnUuid(const String& defaultValue) const {
       return m_urnUuid.value_or(defaultValue);
    }
    const std::optional<String>& GetUrnUuid() const {
       return m_urnUuid;
    }
    void SetUrnUuid(const String& value) { m_urnUuid = value; }

    bool HasKey() { return !!m_key; }
    String GetKey(const String& defaultValue) const {
       return m_key.value_or(defaultValue);
    }
    const std::optional<String>& GetKey() const {
       return m_key;
    }
    void SetKey(const String& value) { m_key = value; }

    bool HasValue() { return !!m_value; }
    String GetValue(const String& defaultValue) const {
       return m_value.value_or(defaultValue);
    }
    const std::optional<String>& GetValue() const {
       return m_value;
    }
    void SetValue(const String& value) { m_value = value; }

    bool HasIgnoreIfPresent() { return !!m_ignoreIfPresent; }
    bool GetIgnoreIfPresent(bool defaultValue) const {
       return m_ignoreIfPresent.value_or(defaultValue);
    }
    const std::optional<bool>& GetIgnoreIfPresent() const {
       return m_ignoreIfPresent;
    }
    void SetIgnoreIfPresent(bool value) { m_ignoreIfPresent = value; }

    bool HasWorkletOrdinal() { return !!m_workletOrdinal; }
    int GetWorkletOrdinal(int defaultValue) const {
       return m_workletOrdinal.value_or(defaultValue);
    }
    const std::optional<int>& GetWorkletOrdinal() const {
       return m_workletOrdinal;
    }
    void SetWorkletOrdinal(int value) { m_workletOrdinal = value; }

    bool HasWorkletTargetId() { return !!m_workletTargetId; }
    String GetWorkletTargetId(const String& defaultValue) const {
       return m_workletTargetId.value_or(defaultValue);
    }
    const std::optional<String>& GetWorkletTargetId() const {
       return m_workletTargetId;
    }
    void SetWorkletTargetId(const String& value) { m_workletTargetId = value; }

    bool HasWithLock() { return !!m_withLock; }
    String GetWithLock(const String& defaultValue) const {
       return m_withLock.value_or(defaultValue);
    }
    const std::optional<String>& GetWithLock() const {
       return m_withLock;
    }
    void SetWithLock(const String& value) { m_withLock = value; }

    bool HasBatchUpdateId() { return !!m_batchUpdateId; }
    String GetBatchUpdateId(const String& defaultValue) const {
       return m_batchUpdateId.value_or(defaultValue);
    }
    const std::optional<String>& GetBatchUpdateId() const {
       return m_batchUpdateId;
    }
    void SetBatchUpdateId(const String& value) { m_batchUpdateId = value; }

    bool HasBatchSize() { return !!m_batchSize; }
    int GetBatchSize(int defaultValue) const {
       return m_batchSize.value_or(defaultValue);
    }
    const std::optional<int>& GetBatchSize() const {
       return m_batchSize;
    }
    void SetBatchSize(int value) { m_batchSize = value; }

    template<int STATE>
    class SharedStorageAccessParamsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        SharedStorageAccessParamsBuilder<STATE>& SetScriptSourceUrl(const String& value)
        {
            m_result->SetScriptSourceUrl(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetDataOrigin(const String& value)
        {
            m_result->SetDataOrigin(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetOperationName(const String& value)
        {
            m_result->SetOperationName(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetOperationId(const String& value)
        {
            m_result->SetOperationId(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetKeepAlive(bool value)
        {
            m_result->SetKeepAlive(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetPrivateAggregationConfig(std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> value)
        {
            m_result->SetPrivateAggregationConfig(std::move(value));
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetSerializedData(const String& value)
        {
            m_result->SetSerializedData(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetUrlsWithMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> value)
        {
            m_result->SetUrlsWithMetadata(std::move(value));
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetUrnUuid(const String& value)
        {
            m_result->SetUrnUuid(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetKey(const String& value)
        {
            m_result->SetKey(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetValue(const String& value)
        {
            m_result->SetValue(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetIgnoreIfPresent(bool value)
        {
            m_result->SetIgnoreIfPresent(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetWorkletOrdinal(int value)
        {
            m_result->SetWorkletOrdinal(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetWorkletTargetId(const String& value)
        {
            m_result->SetWorkletTargetId(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetWithLock(const String& value)
        {
            m_result->SetWithLock(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetBatchUpdateId(const String& value)
        {
            m_result->SetBatchUpdateId(value);
            return *this;
        }

        SharedStorageAccessParamsBuilder<STATE>& SetBatchSize(int value)
        {
            m_result->SetBatchSize(value);
            return *this;
        }

        std::unique_ptr<SharedStorageAccessParams> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageAccessParams;
        SharedStorageAccessParamsBuilder() : m_result(new SharedStorageAccessParams()) { }

        template<int STEP> SharedStorageAccessParamsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageAccessParamsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageAccessParams> m_result;
    };

    static SharedStorageAccessParamsBuilder<0> Create()
    {
        return SharedStorageAccessParamsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageAccessParams()
    {
    }

    std::optional<String> m_scriptSourceUrl;
    std::optional<String> m_dataOrigin;
    std::optional<String> m_operationName;
    std::optional<String> m_operationId;
    std::optional<bool> m_keepAlive;
    std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> m_privateAggregationConfig;
    std::optional<String> m_serializedData;
    std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> m_urlsWithMetadata;
    std::optional<String> m_urnUuid;
    std::optional<String> m_key;
    std::optional<String> m_value;
    std::optional<bool> m_ignoreIfPresent;
    std::optional<int> m_workletOrdinal;
    std::optional<String> m_workletTargetId;
    std::optional<String> m_withLock;
    std::optional<String> m_batchUpdateId;
    std::optional<int> m_batchSize;
};


class CONTENT_EXPORT StorageBucket : public ::crdtp::ProtocolObject<StorageBucket> {
public:
    ~StorageBucket() override { }

    String GetStorageKey() { return m_storageKey; }
    void SetStorageKey(const String& value) { m_storageKey = value; }

    bool HasName() { return !!m_name; }
    String GetName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& GetName() const {
       return m_name;
    }
    void SetName(const String& value) { m_name = value; }

    template<int STATE>
    class StorageBucketBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StorageKeySet = 1 << 1,
            AllFieldsSet = (StorageKeySet | 0)};


        StorageBucketBuilder<STATE | StorageKeySet>& SetStorageKey(const String& value)
        {
            static_assert(!(STATE & StorageKeySet), "property storageKey should not be set yet");
            m_result->SetStorageKey(value);
            return castState<StorageKeySet>();
        }

        StorageBucketBuilder<STATE>& SetName(const String& value)
        {
            m_result->SetName(value);
            return *this;
        }

        std::unique_ptr<StorageBucket> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StorageBucket;
        StorageBucketBuilder() : m_result(new StorageBucket()) { }

        template<int STEP> StorageBucketBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StorageBucketBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::StorageBucket> m_result;
    };

    static StorageBucketBuilder<0> Create()
    {
        return StorageBucketBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StorageBucket()
    {
    }

    String m_storageKey;
    std::optional<String> m_name;
};


class CONTENT_EXPORT StorageBucketInfo : public ::crdtp::ProtocolObject<StorageBucketInfo> {
public:
    ~StorageBucketInfo() override { }

    protocol::Storage::StorageBucket* GetBucket() { return m_bucket.get(); }
    void SetBucket(std::unique_ptr<protocol::Storage::StorageBucket> value) { m_bucket = std::move(value); }

    String GetId() { return m_id; }
    void SetId(const String& value) { m_id = value; }

    double GetExpiration() { return m_expiration; }
    void SetExpiration(double value) { m_expiration = value; }

    double GetQuota() { return m_quota; }
    void SetQuota(double value) { m_quota = value; }

    bool GetPersistent() { return m_persistent; }
    void SetPersistent(bool value) { m_persistent = value; }

    String GetDurability() { return m_durability; }
    void SetDurability(const String& value) { m_durability = value; }

    template<int STATE>
    class StorageBucketInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BucketSet = 1 << 1,
            IdSet = 1 << 2,
            ExpirationSet = 1 << 3,
            QuotaSet = 1 << 4,
            PersistentSet = 1 << 5,
            DurabilitySet = 1 << 6,
            AllFieldsSet = (BucketSet | IdSet | ExpirationSet | QuotaSet | PersistentSet | DurabilitySet | 0)};


        StorageBucketInfoBuilder<STATE | BucketSet>& SetBucket(std::unique_ptr<protocol::Storage::StorageBucket> value)
        {
            static_assert(!(STATE & BucketSet), "property bucket should not be set yet");
            m_result->SetBucket(std::move(value));
            return castState<BucketSet>();
        }

        StorageBucketInfoBuilder<STATE | IdSet>& SetId(const String& value)
        {
            static_assert(!(STATE & IdSet), "property id should not be set yet");
            m_result->SetId(value);
            return castState<IdSet>();
        }

        StorageBucketInfoBuilder<STATE | ExpirationSet>& SetExpiration(double value)
        {
            static_assert(!(STATE & ExpirationSet), "property expiration should not be set yet");
            m_result->SetExpiration(value);
            return castState<ExpirationSet>();
        }

        StorageBucketInfoBuilder<STATE | QuotaSet>& SetQuota(double value)
        {
            static_assert(!(STATE & QuotaSet), "property quota should not be set yet");
            m_result->SetQuota(value);
            return castState<QuotaSet>();
        }

        StorageBucketInfoBuilder<STATE | PersistentSet>& SetPersistent(bool value)
        {
            static_assert(!(STATE & PersistentSet), "property persistent should not be set yet");
            m_result->SetPersistent(value);
            return castState<PersistentSet>();
        }

        StorageBucketInfoBuilder<STATE | DurabilitySet>& SetDurability(const String& value)
        {
            static_assert(!(STATE & DurabilitySet), "property durability should not be set yet");
            m_result->SetDurability(value);
            return castState<DurabilitySet>();
        }

        std::unique_ptr<StorageBucketInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StorageBucketInfo;
        StorageBucketInfoBuilder() : m_result(new StorageBucketInfo()) { }

        template<int STEP> StorageBucketInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StorageBucketInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::StorageBucketInfo> m_result;
    };

    static StorageBucketInfoBuilder<0> Create()
    {
        return StorageBucketInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StorageBucketInfo()
    {
          m_expiration = 0;
          m_quota = 0;
          m_persistent = false;
    }

    std::unique_ptr<protocol::Storage::StorageBucket> m_bucket;
    String m_id;
    double m_expiration;
    double m_quota;
    bool m_persistent;
    String m_durability;
};


class CONTENT_EXPORT AttributionReportingFilterDataEntry : public ::crdtp::ProtocolObject<AttributionReportingFilterDataEntry> {
public:
    ~AttributionReportingFilterDataEntry() override { }

    String GetKey() { return m_key; }
    void SetKey(const String& value) { m_key = value; }

    protocol::Array<String>* GetValues() { return m_values.get(); }
    void SetValues(std::unique_ptr<protocol::Array<String>> value) { m_values = std::move(value); }

    template<int STATE>
    class AttributionReportingFilterDataEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValuesSet = 1 << 2,
            AllFieldsSet = (KeySet | ValuesSet | 0)};


        AttributionReportingFilterDataEntryBuilder<STATE | KeySet>& SetKey(const String& value)
        {
            static_assert(!(STATE & KeySet), "property key should not be set yet");
            m_result->SetKey(value);
            return castState<KeySet>();
        }

        AttributionReportingFilterDataEntryBuilder<STATE | ValuesSet>& SetValues(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & ValuesSet), "property values should not be set yet");
            m_result->SetValues(std::move(value));
            return castState<ValuesSet>();
        }

        std::unique_ptr<AttributionReportingFilterDataEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterDataEntry;
        AttributionReportingFilterDataEntryBuilder() : m_result(new AttributionReportingFilterDataEntry()) { }

        template<int STEP> AttributionReportingFilterDataEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterDataEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterDataEntry> m_result;
    };

    static AttributionReportingFilterDataEntryBuilder<0> Create()
    {
        return AttributionReportingFilterDataEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterDataEntry()
    {
    }

    String m_key;
    std::unique_ptr<protocol::Array<String>> m_values;
};


class CONTENT_EXPORT AttributionReportingFilterConfig : public ::crdtp::ProtocolObject<AttributionReportingFilterConfig> {
public:
    ~AttributionReportingFilterConfig() override { }

    protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>* GetFilterValues() { return m_filterValues.get(); }
    void SetFilterValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value) { m_filterValues = std::move(value); }

    bool HasLookbackWindow() { return !!m_lookbackWindow; }
    int GetLookbackWindow(int defaultValue) const {
       return m_lookbackWindow.value_or(defaultValue);
    }
    const std::optional<int>& GetLookbackWindow() const {
       return m_lookbackWindow;
    }
    void SetLookbackWindow(int value) { m_lookbackWindow = value; }

    template<int STATE>
    class AttributionReportingFilterConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FilterValuesSet = 1 << 1,
            AllFieldsSet = (FilterValuesSet | 0)};


        AttributionReportingFilterConfigBuilder<STATE | FilterValuesSet>& SetFilterValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value)
        {
            static_assert(!(STATE & FilterValuesSet), "property filterValues should not be set yet");
            m_result->SetFilterValues(std::move(value));
            return castState<FilterValuesSet>();
        }

        AttributionReportingFilterConfigBuilder<STATE>& SetLookbackWindow(int value)
        {
            m_result->SetLookbackWindow(value);
            return *this;
        }

        std::unique_ptr<AttributionReportingFilterConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterConfig;
        AttributionReportingFilterConfigBuilder() : m_result(new AttributionReportingFilterConfig()) { }

        template<int STEP> AttributionReportingFilterConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterConfig> m_result;
    };

    static AttributionReportingFilterConfigBuilder<0> Create()
    {
        return AttributionReportingFilterConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterConfig()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> m_filterValues;
    std::optional<int> m_lookbackWindow;
};


class CONTENT_EXPORT AttributionReportingFilterPair : public ::crdtp::ProtocolObject<AttributionReportingFilterPair> {
public:
    ~AttributionReportingFilterPair() override { }

    protocol::Array<protocol::Storage::AttributionReportingFilterConfig>* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value) { m_filters = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingFilterConfig>* GetNotFilters() { return m_notFilters.get(); }
    void SetNotFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value) { m_notFilters = std::move(value); }

    template<int STATE>
    class AttributionReportingFilterPairBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            NotFiltersSet = 1 << 2,
            AllFieldsSet = (FiltersSet | NotFiltersSet | 0)};


        AttributionReportingFilterPairBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        AttributionReportingFilterPairBuilder<STATE | NotFiltersSet>& SetNotFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value)
        {
            static_assert(!(STATE & NotFiltersSet), "property notFilters should not be set yet");
            m_result->SetNotFilters(std::move(value));
            return castState<NotFiltersSet>();
        }

        std::unique_ptr<AttributionReportingFilterPair> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterPair;
        AttributionReportingFilterPairBuilder() : m_result(new AttributionReportingFilterPair()) { }

        template<int STEP> AttributionReportingFilterPairBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterPairBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_result;
    };

    static AttributionReportingFilterPairBuilder<0> Create()
    {
        return AttributionReportingFilterPairBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterPair()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> m_filters;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> m_notFilters;
};


class CONTENT_EXPORT AttributionReportingAggregationKeysEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregationKeysEntry> {
public:
    ~AttributionReportingAggregationKeysEntry() override { }

    String GetKey() { return m_key; }
    void SetKey(const String& value) { m_key = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    template<int STATE>
    class AttributionReportingAggregationKeysEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (KeySet | ValueSet | 0)};


        AttributionReportingAggregationKeysEntryBuilder<STATE | KeySet>& SetKey(const String& value)
        {
            static_assert(!(STATE & KeySet), "property key should not be set yet");
            m_result->SetKey(value);
            return castState<KeySet>();
        }

        AttributionReportingAggregationKeysEntryBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<AttributionReportingAggregationKeysEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregationKeysEntry;
        AttributionReportingAggregationKeysEntryBuilder() : m_result(new AttributionReportingAggregationKeysEntry()) { }

        template<int STEP> AttributionReportingAggregationKeysEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregationKeysEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregationKeysEntry> m_result;
    };

    static AttributionReportingAggregationKeysEntryBuilder<0> Create()
    {
        return AttributionReportingAggregationKeysEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregationKeysEntry()
    {
    }

    String m_key;
    String m_value;
};


class CONTENT_EXPORT AttributionReportingEventReportWindows : public ::crdtp::ProtocolObject<AttributionReportingEventReportWindows> {
public:
    ~AttributionReportingEventReportWindows() override { }

    int GetStart() { return m_start; }
    void SetStart(int value) { m_start = value; }

    protocol::Array<int>* GetEnds() { return m_ends.get(); }
    void SetEnds(std::unique_ptr<protocol::Array<int>> value) { m_ends = std::move(value); }

    template<int STATE>
    class AttributionReportingEventReportWindowsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StartSet = 1 << 1,
            EndsSet = 1 << 2,
            AllFieldsSet = (StartSet | EndsSet | 0)};


        AttributionReportingEventReportWindowsBuilder<STATE | StartSet>& SetStart(int value)
        {
            static_assert(!(STATE & StartSet), "property start should not be set yet");
            m_result->SetStart(value);
            return castState<StartSet>();
        }

        AttributionReportingEventReportWindowsBuilder<STATE | EndsSet>& SetEnds(std::unique_ptr<protocol::Array<int>> value)
        {
            static_assert(!(STATE & EndsSet), "property ends should not be set yet");
            m_result->SetEnds(std::move(value));
            return castState<EndsSet>();
        }

        std::unique_ptr<AttributionReportingEventReportWindows> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingEventReportWindows;
        AttributionReportingEventReportWindowsBuilder() : m_result(new AttributionReportingEventReportWindows()) { }

        template<int STEP> AttributionReportingEventReportWindowsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingEventReportWindowsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> m_result;
    };

    static AttributionReportingEventReportWindowsBuilder<0> Create()
    {
        return AttributionReportingEventReportWindowsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingEventReportWindows()
    {
          m_start = 0;
    }

    int m_start;
    std::unique_ptr<protocol::Array<int>> m_ends;
};


class CONTENT_EXPORT AttributionReportingAggregatableDebugReportingData : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDebugReportingData> {
public:
    ~AttributionReportingAggregatableDebugReportingData() override { }

    String GetKeyPiece() { return m_keyPiece; }
    void SetKeyPiece(const String& value) { m_keyPiece = value; }

    double GetValue() { return m_value; }
    void SetValue(double value) { m_value = value; }

    protocol::Array<String>* GetTypes() { return m_types.get(); }
    void SetTypes(std::unique_ptr<protocol::Array<String>> value) { m_types = std::move(value); }

    template<int STATE>
    class AttributionReportingAggregatableDebugReportingDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            ValueSet = 1 << 2,
            TypesSet = 1 << 3,
            AllFieldsSet = (KeyPieceSet | ValueSet | TypesSet | 0)};


        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | KeyPieceSet>& SetKeyPiece(const String& value)
        {
            static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
            m_result->SetKeyPiece(value);
            return castState<KeyPieceSet>();
        }

        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | ValueSet>& SetValue(double value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | TypesSet>& SetTypes(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & TypesSet), "property types should not be set yet");
            m_result->SetTypes(std::move(value));
            return castState<TypesSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableDebugReportingData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDebugReportingData;
        AttributionReportingAggregatableDebugReportingDataBuilder() : m_result(new AttributionReportingAggregatableDebugReportingData()) { }

        template<int STEP> AttributionReportingAggregatableDebugReportingDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDebugReportingDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingData> m_result;
    };

    static AttributionReportingAggregatableDebugReportingDataBuilder<0> Create()
    {
        return AttributionReportingAggregatableDebugReportingDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDebugReportingData()
    {
          m_value = 0;
    }

    String m_keyPiece;
    double m_value;
    std::unique_ptr<protocol::Array<String>> m_types;
};


class CONTENT_EXPORT AttributionReportingAggregatableDebugReportingConfig : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDebugReportingConfig> {
public:
    ~AttributionReportingAggregatableDebugReportingConfig() override { }

    bool HasBudget() { return !!m_budget; }
    double GetBudget(double defaultValue) const {
       return m_budget.value_or(defaultValue);
    }
    const std::optional<double>& GetBudget() const {
       return m_budget;
    }
    void SetBudget(double value) { m_budget = value; }

    String GetKeyPiece() { return m_keyPiece; }
    void SetKeyPiece(const String& value) { m_keyPiece = value; }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>* GetDebugData() { return m_debugData.get(); }
    void SetDebugData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> value) { m_debugData = std::move(value); }

    bool HasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String GetAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void SetAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }

    template<int STATE>
    class AttributionReportingAggregatableDebugReportingConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            DebugDataSet = 1 << 2,
            AllFieldsSet = (KeyPieceSet | DebugDataSet | 0)};


        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>& SetBudget(double value)
        {
            m_result->SetBudget(value);
            return *this;
        }

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | KeyPieceSet>& SetKeyPiece(const String& value)
        {
            static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
            m_result->SetKeyPiece(value);
            return castState<KeyPieceSet>();
        }

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | DebugDataSet>& SetDebugData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> value)
        {
            static_assert(!(STATE & DebugDataSet), "property debugData should not be set yet");
            m_result->SetDebugData(std::move(value));
            return castState<DebugDataSet>();
        }

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>& SetAggregationCoordinatorOrigin(const String& value)
        {
            m_result->SetAggregationCoordinatorOrigin(value);
            return *this;
        }

        std::unique_ptr<AttributionReportingAggregatableDebugReportingConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDebugReportingConfig;
        AttributionReportingAggregatableDebugReportingConfigBuilder() : m_result(new AttributionReportingAggregatableDebugReportingConfig()) { }

        template<int STEP> AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_result;
    };

    static AttributionReportingAggregatableDebugReportingConfigBuilder<0> Create()
    {
        return AttributionReportingAggregatableDebugReportingConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDebugReportingConfig()
    {
    }

    std::optional<double> m_budget;
    String m_keyPiece;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> m_debugData;
    std::optional<String> m_aggregationCoordinatorOrigin;
};


class CONTENT_EXPORT AttributionScopesData : public ::crdtp::ProtocolObject<AttributionScopesData> {
public:
    ~AttributionScopesData() override { }

    protocol::Array<String>* GetValues() { return m_values.get(); }
    void SetValues(std::unique_ptr<protocol::Array<String>> value) { m_values = std::move(value); }

    double GetLimit() { return m_limit; }
    void SetLimit(double value) { m_limit = value; }

    double GetMaxEventStates() { return m_maxEventStates; }
    void SetMaxEventStates(double value) { m_maxEventStates = value; }

    template<int STATE>
    class AttributionScopesDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValuesSet = 1 << 1,
            LimitSet = 1 << 2,
            MaxEventStatesSet = 1 << 3,
            AllFieldsSet = (ValuesSet | LimitSet | MaxEventStatesSet | 0)};


        AttributionScopesDataBuilder<STATE | ValuesSet>& SetValues(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & ValuesSet), "property values should not be set yet");
            m_result->SetValues(std::move(value));
            return castState<ValuesSet>();
        }

        AttributionScopesDataBuilder<STATE | LimitSet>& SetLimit(double value)
        {
            static_assert(!(STATE & LimitSet), "property limit should not be set yet");
            m_result->SetLimit(value);
            return castState<LimitSet>();
        }

        AttributionScopesDataBuilder<STATE | MaxEventStatesSet>& SetMaxEventStates(double value)
        {
            static_assert(!(STATE & MaxEventStatesSet), "property maxEventStates should not be set yet");
            m_result->SetMaxEventStates(value);
            return castState<MaxEventStatesSet>();
        }

        std::unique_ptr<AttributionScopesData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionScopesData;
        AttributionScopesDataBuilder() : m_result(new AttributionScopesData()) { }

        template<int STEP> AttributionScopesDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionScopesDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionScopesData> m_result;
    };

    static AttributionScopesDataBuilder<0> Create()
    {
        return AttributionScopesDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionScopesData()
    {
          m_limit = 0;
          m_maxEventStates = 0;
    }

    std::unique_ptr<protocol::Array<String>> m_values;
    double m_limit;
    double m_maxEventStates;
};


class CONTENT_EXPORT AttributionReportingNamedBudgetDef : public ::crdtp::ProtocolObject<AttributionReportingNamedBudgetDef> {
public:
    ~AttributionReportingNamedBudgetDef() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    int GetBudget() { return m_budget; }
    void SetBudget(int value) { m_budget = value; }

    template<int STATE>
    class AttributionReportingNamedBudgetDefBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            BudgetSet = 1 << 2,
            AllFieldsSet = (NameSet | BudgetSet | 0)};


        AttributionReportingNamedBudgetDefBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        AttributionReportingNamedBudgetDefBuilder<STATE | BudgetSet>& SetBudget(int value)
        {
            static_assert(!(STATE & BudgetSet), "property budget should not be set yet");
            m_result->SetBudget(value);
            return castState<BudgetSet>();
        }

        std::unique_ptr<AttributionReportingNamedBudgetDef> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingNamedBudgetDef;
        AttributionReportingNamedBudgetDefBuilder() : m_result(new AttributionReportingNamedBudgetDef()) { }

        template<int STEP> AttributionReportingNamedBudgetDefBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingNamedBudgetDefBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingNamedBudgetDef> m_result;
    };

    static AttributionReportingNamedBudgetDefBuilder<0> Create()
    {
        return AttributionReportingNamedBudgetDefBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingNamedBudgetDef()
    {
          m_budget = 0;
    }

    String m_name;
    int m_budget;
};


class CONTENT_EXPORT AttributionReportingSourceRegistration : public ::crdtp::ProtocolObject<AttributionReportingSourceRegistration> {
public:
    ~AttributionReportingSourceRegistration() override { }

    double GetTime() { return m_time; }
    void SetTime(double value) { m_time = value; }

    int GetExpiry() { return m_expiry; }
    void SetExpiry(int value) { m_expiry = value; }

    protocol::Array<double>* GetTriggerData() { return m_triggerData.get(); }
    void SetTriggerData(std::unique_ptr<protocol::Array<double>> value) { m_triggerData = std::move(value); }

    protocol::Storage::AttributionReportingEventReportWindows* GetEventReportWindows() { return m_eventReportWindows.get(); }
    void SetEventReportWindows(std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> value) { m_eventReportWindows = std::move(value); }

    int GetAggregatableReportWindow() { return m_aggregatableReportWindow; }
    void SetAggregatableReportWindow(int value) { m_aggregatableReportWindow = value; }

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    String GetSourceOrigin() { return m_sourceOrigin; }
    void SetSourceOrigin(const String& value) { m_sourceOrigin = value; }

    String GetReportingOrigin() { return m_reportingOrigin; }
    void SetReportingOrigin(const String& value) { m_reportingOrigin = value; }

    protocol::Array<String>* GetDestinationSites() { return m_destinationSites.get(); }
    void SetDestinationSites(std::unique_ptr<protocol::Array<String>> value) { m_destinationSites = std::move(value); }

    String GetEventId() { return m_eventId; }
    void SetEventId(const String& value) { m_eventId = value; }

    String GetPriority() { return m_priority; }
    void SetPriority(const String& value) { m_priority = value; }

    protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>* GetFilterData() { return m_filterData.get(); }
    void SetFilterData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value) { m_filterData = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>* GetAggregationKeys() { return m_aggregationKeys.get(); }
    void SetAggregationKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> value) { m_aggregationKeys = std::move(value); }

    bool HasDebugKey() { return !!m_debugKey; }
    String GetDebugKey(const String& defaultValue) const {
       return m_debugKey.value_or(defaultValue);
    }
    const std::optional<String>& GetDebugKey() const {
       return m_debugKey;
    }
    void SetDebugKey(const String& value) { m_debugKey = value; }

    String GetTriggerDataMatching() { return m_triggerDataMatching; }
    void SetTriggerDataMatching(const String& value) { m_triggerDataMatching = value; }

    String GetDestinationLimitPriority() { return m_destinationLimitPriority; }
    void SetDestinationLimitPriority(const String& value) { m_destinationLimitPriority = value; }

    protocol::Storage::AttributionReportingAggregatableDebugReportingConfig* GetAggregatableDebugReportingConfig() { return m_aggregatableDebugReportingConfig.get(); }
    void SetAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value) { m_aggregatableDebugReportingConfig = std::move(value); }

    bool HasScopesData() { return !!m_scopesData; }
    protocol::Storage::AttributionScopesData* GetScopesData(protocol::Storage::AttributionScopesData* defaultValue) {
       return m_scopesData ? m_scopesData.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Storage::AttributionScopesData>& GetScopesData() const {
       return m_scopesData;
    }
    void SetScopesData(std::unique_ptr<protocol::Storage::AttributionScopesData> value) { m_scopesData = std::move(value); }

    int GetMaxEventLevelReports() { return m_maxEventLevelReports; }
    void SetMaxEventLevelReports(int value) { m_maxEventLevelReports = value; }

    protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>* GetNamedBudgets() { return m_namedBudgets.get(); }
    void SetNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> value) { m_namedBudgets = std::move(value); }

    bool GetDebugReporting() { return m_debugReporting; }
    void SetDebugReporting(bool value) { m_debugReporting = value; }

    double GetEventLevelEpsilon() { return m_eventLevelEpsilon; }
    void SetEventLevelEpsilon(double value) { m_eventLevelEpsilon = value; }

    template<int STATE>
    class AttributionReportingSourceRegistrationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TimeSet = 1 << 1,
            ExpirySet = 1 << 2,
            TriggerDataSet = 1 << 3,
            EventReportWindowsSet = 1 << 4,
            AggregatableReportWindowSet = 1 << 5,
            TypeSet = 1 << 6,
            SourceOriginSet = 1 << 7,
            ReportingOriginSet = 1 << 8,
            DestinationSitesSet = 1 << 9,
            EventIdSet = 1 << 10,
            PrioritySet = 1 << 11,
            FilterDataSet = 1 << 12,
            AggregationKeysSet = 1 << 13,
            TriggerDataMatchingSet = 1 << 14,
            DestinationLimitPrioritySet = 1 << 15,
            AggregatableDebugReportingConfigSet = 1 << 16,
            MaxEventLevelReportsSet = 1 << 17,
            NamedBudgetsSet = 1 << 18,
            DebugReportingSet = 1 << 19,
            EventLevelEpsilonSet = 1 << 20,
            AllFieldsSet = (TimeSet | ExpirySet | TriggerDataSet | EventReportWindowsSet | AggregatableReportWindowSet | TypeSet | SourceOriginSet | ReportingOriginSet | DestinationSitesSet | EventIdSet | PrioritySet | FilterDataSet | AggregationKeysSet | TriggerDataMatchingSet | DestinationLimitPrioritySet | AggregatableDebugReportingConfigSet | MaxEventLevelReportsSet | NamedBudgetsSet | DebugReportingSet | EventLevelEpsilonSet | 0)};


        AttributionReportingSourceRegistrationBuilder<STATE | TimeSet>& SetTime(double value)
        {
            static_assert(!(STATE & TimeSet), "property time should not be set yet");
            m_result->SetTime(value);
            return castState<TimeSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | ExpirySet>& SetExpiry(int value)
        {
            static_assert(!(STATE & ExpirySet), "property expiry should not be set yet");
            m_result->SetExpiry(value);
            return castState<ExpirySet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | TriggerDataSet>& SetTriggerData(std::unique_ptr<protocol::Array<double>> value)
        {
            static_assert(!(STATE & TriggerDataSet), "property triggerData should not be set yet");
            m_result->SetTriggerData(std::move(value));
            return castState<TriggerDataSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | EventReportWindowsSet>& SetEventReportWindows(std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> value)
        {
            static_assert(!(STATE & EventReportWindowsSet), "property eventReportWindows should not be set yet");
            m_result->SetEventReportWindows(std::move(value));
            return castState<EventReportWindowsSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | AggregatableReportWindowSet>& SetAggregatableReportWindow(int value)
        {
            static_assert(!(STATE & AggregatableReportWindowSet), "property aggregatableReportWindow should not be set yet");
            m_result->SetAggregatableReportWindow(value);
            return castState<AggregatableReportWindowSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | SourceOriginSet>& SetSourceOrigin(const String& value)
        {
            static_assert(!(STATE & SourceOriginSet), "property sourceOrigin should not be set yet");
            m_result->SetSourceOrigin(value);
            return castState<SourceOriginSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | ReportingOriginSet>& SetReportingOrigin(const String& value)
        {
            static_assert(!(STATE & ReportingOriginSet), "property reportingOrigin should not be set yet");
            m_result->SetReportingOrigin(value);
            return castState<ReportingOriginSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | DestinationSitesSet>& SetDestinationSites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & DestinationSitesSet), "property destinationSites should not be set yet");
            m_result->SetDestinationSites(std::move(value));
            return castState<DestinationSitesSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | EventIdSet>& SetEventId(const String& value)
        {
            static_assert(!(STATE & EventIdSet), "property eventId should not be set yet");
            m_result->SetEventId(value);
            return castState<EventIdSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | PrioritySet>& SetPriority(const String& value)
        {
            static_assert(!(STATE & PrioritySet), "property priority should not be set yet");
            m_result->SetPriority(value);
            return castState<PrioritySet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | FilterDataSet>& SetFilterData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value)
        {
            static_assert(!(STATE & FilterDataSet), "property filterData should not be set yet");
            m_result->SetFilterData(std::move(value));
            return castState<FilterDataSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | AggregationKeysSet>& SetAggregationKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> value)
        {
            static_assert(!(STATE & AggregationKeysSet), "property aggregationKeys should not be set yet");
            m_result->SetAggregationKeys(std::move(value));
            return castState<AggregationKeysSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE>& SetDebugKey(const String& value)
        {
            m_result->SetDebugKey(value);
            return *this;
        }

        AttributionReportingSourceRegistrationBuilder<STATE | TriggerDataMatchingSet>& SetTriggerDataMatching(const String& value)
        {
            static_assert(!(STATE & TriggerDataMatchingSet), "property triggerDataMatching should not be set yet");
            m_result->SetTriggerDataMatching(value);
            return castState<TriggerDataMatchingSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | DestinationLimitPrioritySet>& SetDestinationLimitPriority(const String& value)
        {
            static_assert(!(STATE & DestinationLimitPrioritySet), "property destinationLimitPriority should not be set yet");
            m_result->SetDestinationLimitPriority(value);
            return castState<DestinationLimitPrioritySet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | AggregatableDebugReportingConfigSet>& SetAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value)
        {
            static_assert(!(STATE & AggregatableDebugReportingConfigSet), "property aggregatableDebugReportingConfig should not be set yet");
            m_result->SetAggregatableDebugReportingConfig(std::move(value));
            return castState<AggregatableDebugReportingConfigSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE>& SetScopesData(std::unique_ptr<protocol::Storage::AttributionScopesData> value)
        {
            m_result->SetScopesData(std::move(value));
            return *this;
        }

        AttributionReportingSourceRegistrationBuilder<STATE | MaxEventLevelReportsSet>& SetMaxEventLevelReports(int value)
        {
            static_assert(!(STATE & MaxEventLevelReportsSet), "property maxEventLevelReports should not be set yet");
            m_result->SetMaxEventLevelReports(value);
            return castState<MaxEventLevelReportsSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | NamedBudgetsSet>& SetNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> value)
        {
            static_assert(!(STATE & NamedBudgetsSet), "property namedBudgets should not be set yet");
            m_result->SetNamedBudgets(std::move(value));
            return castState<NamedBudgetsSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | DebugReportingSet>& SetDebugReporting(bool value)
        {
            static_assert(!(STATE & DebugReportingSet), "property debugReporting should not be set yet");
            m_result->SetDebugReporting(value);
            return castState<DebugReportingSet>();
        }

        AttributionReportingSourceRegistrationBuilder<STATE | EventLevelEpsilonSet>& SetEventLevelEpsilon(double value)
        {
            static_assert(!(STATE & EventLevelEpsilonSet), "property eventLevelEpsilon should not be set yet");
            m_result->SetEventLevelEpsilon(value);
            return castState<EventLevelEpsilonSet>();
        }

        std::unique_ptr<AttributionReportingSourceRegistration> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingSourceRegistration;
        AttributionReportingSourceRegistrationBuilder() : m_result(new AttributionReportingSourceRegistration()) { }

        template<int STEP> AttributionReportingSourceRegistrationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingSourceRegistrationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingSourceRegistration> m_result;
    };

    static AttributionReportingSourceRegistrationBuilder<0> Create()
    {
        return AttributionReportingSourceRegistrationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingSourceRegistration()
    {
          m_time = 0;
          m_expiry = 0;
          m_aggregatableReportWindow = 0;
          m_maxEventLevelReports = 0;
          m_debugReporting = false;
          m_eventLevelEpsilon = 0;
    }

    double m_time;
    int m_expiry;
    std::unique_ptr<protocol::Array<double>> m_triggerData;
    std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> m_eventReportWindows;
    int m_aggregatableReportWindow;
    String m_type;
    String m_sourceOrigin;
    String m_reportingOrigin;
    std::unique_ptr<protocol::Array<String>> m_destinationSites;
    String m_eventId;
    String m_priority;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> m_filterData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> m_aggregationKeys;
    std::optional<String> m_debugKey;
    String m_triggerDataMatching;
    String m_destinationLimitPriority;
    std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_aggregatableDebugReportingConfig;
    std::unique_ptr<protocol::Storage::AttributionScopesData> m_scopesData;
    int m_maxEventLevelReports;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> m_namedBudgets;
    bool m_debugReporting;
    double m_eventLevelEpsilon;
};


class CONTENT_EXPORT AttributionReportingAggregatableValueDictEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregatableValueDictEntry> {
public:
    ~AttributionReportingAggregatableValueDictEntry() override { }

    String GetKey() { return m_key; }
    void SetKey(const String& value) { m_key = value; }

    double GetValue() { return m_value; }
    void SetValue(double value) { m_value = value; }

    String GetFilteringId() { return m_filteringId; }
    void SetFilteringId(const String& value) { m_filteringId = value; }

    template<int STATE>
    class AttributionReportingAggregatableValueDictEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            FilteringIdSet = 1 << 3,
            AllFieldsSet = (KeySet | ValueSet | FilteringIdSet | 0)};


        AttributionReportingAggregatableValueDictEntryBuilder<STATE | KeySet>& SetKey(const String& value)
        {
            static_assert(!(STATE & KeySet), "property key should not be set yet");
            m_result->SetKey(value);
            return castState<KeySet>();
        }

        AttributionReportingAggregatableValueDictEntryBuilder<STATE | ValueSet>& SetValue(double value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        AttributionReportingAggregatableValueDictEntryBuilder<STATE | FilteringIdSet>& SetFilteringId(const String& value)
        {
            static_assert(!(STATE & FilteringIdSet), "property filteringId should not be set yet");
            m_result->SetFilteringId(value);
            return castState<FilteringIdSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableValueDictEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableValueDictEntry;
        AttributionReportingAggregatableValueDictEntryBuilder() : m_result(new AttributionReportingAggregatableValueDictEntry()) { }

        template<int STEP> AttributionReportingAggregatableValueDictEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableValueDictEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableValueDictEntry> m_result;
    };

    static AttributionReportingAggregatableValueDictEntryBuilder<0> Create()
    {
        return AttributionReportingAggregatableValueDictEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableValueDictEntry()
    {
          m_value = 0;
    }

    String m_key;
    double m_value;
    String m_filteringId;
};


class CONTENT_EXPORT AttributionReportingAggregatableValueEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregatableValueEntry> {
public:
    ~AttributionReportingAggregatableValueEntry() override { }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>* GetValues() { return m_values.get(); }
    void SetValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> value) { m_values = std::move(value); }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingAggregatableValueEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValuesSet = 1 << 1,
            FiltersSet = 1 << 2,
            AllFieldsSet = (ValuesSet | FiltersSet | 0)};


        AttributionReportingAggregatableValueEntryBuilder<STATE | ValuesSet>& SetValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> value)
        {
            static_assert(!(STATE & ValuesSet), "property values should not be set yet");
            m_result->SetValues(std::move(value));
            return castState<ValuesSet>();
        }

        AttributionReportingAggregatableValueEntryBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableValueEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableValueEntry;
        AttributionReportingAggregatableValueEntryBuilder() : m_result(new AttributionReportingAggregatableValueEntry()) { }

        template<int STEP> AttributionReportingAggregatableValueEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableValueEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableValueEntry> m_result;
    };

    static AttributionReportingAggregatableValueEntryBuilder<0> Create()
    {
        return AttributionReportingAggregatableValueEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableValueEntry()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> m_values;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CONTENT_EXPORT AttributionReportingEventTriggerData : public ::crdtp::ProtocolObject<AttributionReportingEventTriggerData> {
public:
    ~AttributionReportingEventTriggerData() override { }

    String GetData() { return m_data; }
    void SetData(const String& value) { m_data = value; }

    String GetPriority() { return m_priority; }
    void SetPriority(const String& value) { m_priority = value; }

    bool HasDedupKey() { return !!m_dedupKey; }
    String GetDedupKey(const String& defaultValue) const {
       return m_dedupKey.value_or(defaultValue);
    }
    const std::optional<String>& GetDedupKey() const {
       return m_dedupKey;
    }
    void SetDedupKey(const String& value) { m_dedupKey = value; }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingEventTriggerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DataSet = 1 << 1,
            PrioritySet = 1 << 2,
            FiltersSet = 1 << 3,
            AllFieldsSet = (DataSet | PrioritySet | FiltersSet | 0)};


        AttributionReportingEventTriggerDataBuilder<STATE | DataSet>& SetData(const String& value)
        {
            static_assert(!(STATE & DataSet), "property data should not be set yet");
            m_result->SetData(value);
            return castState<DataSet>();
        }

        AttributionReportingEventTriggerDataBuilder<STATE | PrioritySet>& SetPriority(const String& value)
        {
            static_assert(!(STATE & PrioritySet), "property priority should not be set yet");
            m_result->SetPriority(value);
            return castState<PrioritySet>();
        }

        AttributionReportingEventTriggerDataBuilder<STATE>& SetDedupKey(const String& value)
        {
            m_result->SetDedupKey(value);
            return *this;
        }

        AttributionReportingEventTriggerDataBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingEventTriggerData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingEventTriggerData;
        AttributionReportingEventTriggerDataBuilder() : m_result(new AttributionReportingEventTriggerData()) { }

        template<int STEP> AttributionReportingEventTriggerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingEventTriggerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingEventTriggerData> m_result;
    };

    static AttributionReportingEventTriggerDataBuilder<0> Create()
    {
        return AttributionReportingEventTriggerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingEventTriggerData()
    {
    }

    String m_data;
    String m_priority;
    std::optional<String> m_dedupKey;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CONTENT_EXPORT AttributionReportingAggregatableTriggerData : public ::crdtp::ProtocolObject<AttributionReportingAggregatableTriggerData> {
public:
    ~AttributionReportingAggregatableTriggerData() override { }

    String GetKeyPiece() { return m_keyPiece; }
    void SetKeyPiece(const String& value) { m_keyPiece = value; }

    protocol::Array<String>* GetSourceKeys() { return m_sourceKeys.get(); }
    void SetSourceKeys(std::unique_ptr<protocol::Array<String>> value) { m_sourceKeys = std::move(value); }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingAggregatableTriggerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            SourceKeysSet = 1 << 2,
            FiltersSet = 1 << 3,
            AllFieldsSet = (KeyPieceSet | SourceKeysSet | FiltersSet | 0)};


        AttributionReportingAggregatableTriggerDataBuilder<STATE | KeyPieceSet>& SetKeyPiece(const String& value)
        {
            static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
            m_result->SetKeyPiece(value);
            return castState<KeyPieceSet>();
        }

        AttributionReportingAggregatableTriggerDataBuilder<STATE | SourceKeysSet>& SetSourceKeys(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & SourceKeysSet), "property sourceKeys should not be set yet");
            m_result->SetSourceKeys(std::move(value));
            return castState<SourceKeysSet>();
        }

        AttributionReportingAggregatableTriggerDataBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableTriggerData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableTriggerData;
        AttributionReportingAggregatableTriggerDataBuilder() : m_result(new AttributionReportingAggregatableTriggerData()) { }

        template<int STEP> AttributionReportingAggregatableTriggerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableTriggerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableTriggerData> m_result;
    };

    static AttributionReportingAggregatableTriggerDataBuilder<0> Create()
    {
        return AttributionReportingAggregatableTriggerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableTriggerData()
    {
    }

    String m_keyPiece;
    std::unique_ptr<protocol::Array<String>> m_sourceKeys;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CONTENT_EXPORT AttributionReportingAggregatableDedupKey : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDedupKey> {
public:
    ~AttributionReportingAggregatableDedupKey() override { }

    bool HasDedupKey() { return !!m_dedupKey; }
    String GetDedupKey(const String& defaultValue) const {
       return m_dedupKey.value_or(defaultValue);
    }
    const std::optional<String>& GetDedupKey() const {
       return m_dedupKey;
    }
    void SetDedupKey(const String& value) { m_dedupKey = value; }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingAggregatableDedupKeyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AllFieldsSet = (FiltersSet | 0)};


        AttributionReportingAggregatableDedupKeyBuilder<STATE>& SetDedupKey(const String& value)
        {
            m_result->SetDedupKey(value);
            return *this;
        }

        AttributionReportingAggregatableDedupKeyBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingAggregatableDedupKey> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDedupKey;
        AttributionReportingAggregatableDedupKeyBuilder() : m_result(new AttributionReportingAggregatableDedupKey()) { }

        template<int STEP> AttributionReportingAggregatableDedupKeyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDedupKeyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDedupKey> m_result;
    };

    static AttributionReportingAggregatableDedupKeyBuilder<0> Create()
    {
        return AttributionReportingAggregatableDedupKeyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDedupKey()
    {
    }

    std::optional<String> m_dedupKey;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CONTENT_EXPORT AttributionReportingNamedBudgetCandidate : public ::crdtp::ProtocolObject<AttributionReportingNamedBudgetCandidate> {
public:
    ~AttributionReportingNamedBudgetCandidate() override { }

    bool HasName() { return !!m_name; }
    String GetName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& GetName() const {
       return m_name;
    }
    void SetName(const String& value) { m_name = value; }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    template<int STATE>
    class AttributionReportingNamedBudgetCandidateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AllFieldsSet = (FiltersSet | 0)};


        AttributionReportingNamedBudgetCandidateBuilder<STATE>& SetName(const String& value)
        {
            m_result->SetName(value);
            return *this;
        }

        AttributionReportingNamedBudgetCandidateBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        std::unique_ptr<AttributionReportingNamedBudgetCandidate> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingNamedBudgetCandidate;
        AttributionReportingNamedBudgetCandidateBuilder() : m_result(new AttributionReportingNamedBudgetCandidate()) { }

        template<int STEP> AttributionReportingNamedBudgetCandidateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingNamedBudgetCandidateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingNamedBudgetCandidate> m_result;
    };

    static AttributionReportingNamedBudgetCandidateBuilder<0> Create()
    {
        return AttributionReportingNamedBudgetCandidateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingNamedBudgetCandidate()
    {
    }

    std::optional<String> m_name;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CONTENT_EXPORT AttributionReportingTriggerRegistration : public ::crdtp::ProtocolObject<AttributionReportingTriggerRegistration> {
public:
    ~AttributionReportingTriggerRegistration() override { }

    protocol::Storage::AttributionReportingFilterPair* GetFilters() { return m_filters.get(); }
    void SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

    bool HasDebugKey() { return !!m_debugKey; }
    String GetDebugKey(const String& defaultValue) const {
       return m_debugKey.value_or(defaultValue);
    }
    const std::optional<String>& GetDebugKey() const {
       return m_debugKey;
    }
    void SetDebugKey(const String& value) { m_debugKey = value; }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>* GetAggregatableDedupKeys() { return m_aggregatableDedupKeys.get(); }
    void SetAggregatableDedupKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> value) { m_aggregatableDedupKeys = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>* GetEventTriggerData() { return m_eventTriggerData.get(); }
    void SetEventTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> value) { m_eventTriggerData = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>* GetAggregatableTriggerData() { return m_aggregatableTriggerData.get(); }
    void SetAggregatableTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> value) { m_aggregatableTriggerData = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>* GetAggregatableValues() { return m_aggregatableValues.get(); }
    void SetAggregatableValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> value) { m_aggregatableValues = std::move(value); }

    int GetAggregatableFilteringIdMaxBytes() { return m_aggregatableFilteringIdMaxBytes; }
    void SetAggregatableFilteringIdMaxBytes(int value) { m_aggregatableFilteringIdMaxBytes = value; }

    bool GetDebugReporting() { return m_debugReporting; }
    void SetDebugReporting(bool value) { m_debugReporting = value; }

    bool HasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String GetAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void SetAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }

    String GetSourceRegistrationTimeConfig() { return m_sourceRegistrationTimeConfig; }
    void SetSourceRegistrationTimeConfig(const String& value) { m_sourceRegistrationTimeConfig = value; }

    bool HasTriggerContextId() { return !!m_triggerContextId; }
    String GetTriggerContextId(const String& defaultValue) const {
       return m_triggerContextId.value_or(defaultValue);
    }
    const std::optional<String>& GetTriggerContextId() const {
       return m_triggerContextId;
    }
    void SetTriggerContextId(const String& value) { m_triggerContextId = value; }

    protocol::Storage::AttributionReportingAggregatableDebugReportingConfig* GetAggregatableDebugReportingConfig() { return m_aggregatableDebugReportingConfig.get(); }
    void SetAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value) { m_aggregatableDebugReportingConfig = std::move(value); }

    protocol::Array<String>* GetScopes() { return m_scopes.get(); }
    void SetScopes(std::unique_ptr<protocol::Array<String>> value) { m_scopes = std::move(value); }

    protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>* GetNamedBudgets() { return m_namedBudgets.get(); }
    void SetNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> value) { m_namedBudgets = std::move(value); }

    template<int STATE>
    class AttributionReportingTriggerRegistrationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AggregatableDedupKeysSet = 1 << 2,
            EventTriggerDataSet = 1 << 3,
            AggregatableTriggerDataSet = 1 << 4,
            AggregatableValuesSet = 1 << 5,
            AggregatableFilteringIdMaxBytesSet = 1 << 6,
            DebugReportingSet = 1 << 7,
            SourceRegistrationTimeConfigSet = 1 << 8,
            AggregatableDebugReportingConfigSet = 1 << 9,
            ScopesSet = 1 << 10,
            NamedBudgetsSet = 1 << 11,
            AllFieldsSet = (FiltersSet | AggregatableDedupKeysSet | EventTriggerDataSet | AggregatableTriggerDataSet | AggregatableValuesSet | AggregatableFilteringIdMaxBytesSet | DebugReportingSet | SourceRegistrationTimeConfigSet | AggregatableDebugReportingConfigSet | ScopesSet | NamedBudgetsSet | 0)};


        AttributionReportingTriggerRegistrationBuilder<STATE | FiltersSet>& SetFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value)
        {
            static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
            m_result->SetFilters(std::move(value));
            return castState<FiltersSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE>& SetDebugKey(const String& value)
        {
            m_result->SetDebugKey(value);
            return *this;
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableDedupKeysSet>& SetAggregatableDedupKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> value)
        {
            static_assert(!(STATE & AggregatableDedupKeysSet), "property aggregatableDedupKeys should not be set yet");
            m_result->SetAggregatableDedupKeys(std::move(value));
            return castState<AggregatableDedupKeysSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | EventTriggerDataSet>& SetEventTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> value)
        {
            static_assert(!(STATE & EventTriggerDataSet), "property eventTriggerData should not be set yet");
            m_result->SetEventTriggerData(std::move(value));
            return castState<EventTriggerDataSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableTriggerDataSet>& SetAggregatableTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> value)
        {
            static_assert(!(STATE & AggregatableTriggerDataSet), "property aggregatableTriggerData should not be set yet");
            m_result->SetAggregatableTriggerData(std::move(value));
            return castState<AggregatableTriggerDataSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableValuesSet>& SetAggregatableValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> value)
        {
            static_assert(!(STATE & AggregatableValuesSet), "property aggregatableValues should not be set yet");
            m_result->SetAggregatableValues(std::move(value));
            return castState<AggregatableValuesSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableFilteringIdMaxBytesSet>& SetAggregatableFilteringIdMaxBytes(int value)
        {
            static_assert(!(STATE & AggregatableFilteringIdMaxBytesSet), "property aggregatableFilteringIdMaxBytes should not be set yet");
            m_result->SetAggregatableFilteringIdMaxBytes(value);
            return castState<AggregatableFilteringIdMaxBytesSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | DebugReportingSet>& SetDebugReporting(bool value)
        {
            static_assert(!(STATE & DebugReportingSet), "property debugReporting should not be set yet");
            m_result->SetDebugReporting(value);
            return castState<DebugReportingSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE>& SetAggregationCoordinatorOrigin(const String& value)
        {
            m_result->SetAggregationCoordinatorOrigin(value);
            return *this;
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | SourceRegistrationTimeConfigSet>& SetSourceRegistrationTimeConfig(const String& value)
        {
            static_assert(!(STATE & SourceRegistrationTimeConfigSet), "property sourceRegistrationTimeConfig should not be set yet");
            m_result->SetSourceRegistrationTimeConfig(value);
            return castState<SourceRegistrationTimeConfigSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE>& SetTriggerContextId(const String& value)
        {
            m_result->SetTriggerContextId(value);
            return *this;
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableDebugReportingConfigSet>& SetAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value)
        {
            static_assert(!(STATE & AggregatableDebugReportingConfigSet), "property aggregatableDebugReportingConfig should not be set yet");
            m_result->SetAggregatableDebugReportingConfig(std::move(value));
            return castState<AggregatableDebugReportingConfigSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | ScopesSet>& SetScopes(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & ScopesSet), "property scopes should not be set yet");
            m_result->SetScopes(std::move(value));
            return castState<ScopesSet>();
        }

        AttributionReportingTriggerRegistrationBuilder<STATE | NamedBudgetsSet>& SetNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> value)
        {
            static_assert(!(STATE & NamedBudgetsSet), "property namedBudgets should not be set yet");
            m_result->SetNamedBudgets(std::move(value));
            return castState<NamedBudgetsSet>();
        }

        std::unique_ptr<AttributionReportingTriggerRegistration> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingTriggerRegistration;
        AttributionReportingTriggerRegistrationBuilder() : m_result(new AttributionReportingTriggerRegistration()) { }

        template<int STEP> AttributionReportingTriggerRegistrationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingTriggerRegistrationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingTriggerRegistration> m_result;
    };

    static AttributionReportingTriggerRegistrationBuilder<0> Create()
    {
        return AttributionReportingTriggerRegistrationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingTriggerRegistration()
    {
          m_aggregatableFilteringIdMaxBytes = 0;
          m_debugReporting = false;
    }

    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
    std::optional<String> m_debugKey;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> m_aggregatableDedupKeys;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> m_eventTriggerData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> m_aggregatableTriggerData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> m_aggregatableValues;
    int m_aggregatableFilteringIdMaxBytes;
    bool m_debugReporting;
    std::optional<String> m_aggregationCoordinatorOrigin;
    String m_sourceRegistrationTimeConfig;
    std::optional<String> m_triggerContextId;
    std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_aggregatableDebugReportingConfig;
    std::unique_ptr<protocol::Array<String>> m_scopes;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> m_namedBudgets;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse GetStorageKeyForFrame(const String& in_frameId, String* out_storageKey) = 0;
    class CONTENT_EXPORT ClearDataForOriginCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearDataForOriginCallback() { }
    };
    virtual void ClearDataForOrigin(const String& in_origin, const String& in_storageTypes, std::unique_ptr<ClearDataForOriginCallback> callback) = 0;
    class CONTENT_EXPORT ClearDataForStorageKeyCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearDataForStorageKeyCallback() { }
    };
    virtual void ClearDataForStorageKey(const String& in_storageKey, const String& in_storageTypes, std::unique_ptr<ClearDataForStorageKeyCallback> callback) = 0;
    class CONTENT_EXPORT GetCookiesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Network::Cookie>> cookies) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetCookiesCallback() { }
    };
    virtual void GetCookies(std::optional<String> in_browserContextId, std::unique_ptr<GetCookiesCallback> callback) = 0;
    class CONTENT_EXPORT SetCookiesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetCookiesCallback() { }
    };
    virtual void SetCookies(std::unique_ptr<protocol::Array<protocol::Network::CookieParam>> in_cookies, std::optional<String> in_browserContextId, std::unique_ptr<SetCookiesCallback> callback) = 0;
    class CONTENT_EXPORT ClearCookiesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearCookiesCallback() { }
    };
    virtual void ClearCookies(std::optional<String> in_browserContextId, std::unique_ptr<ClearCookiesCallback> callback) = 0;
    class CONTENT_EXPORT GetUsageAndQuotaCallback {
    public:
        virtual void sendSuccess(double usage, double quota, bool overrideActive, std::unique_ptr<protocol::Array<protocol::Storage::UsageForType>> usageBreakdown) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetUsageAndQuotaCallback() { }
    };
    virtual void GetUsageAndQuota(const String& in_origin, std::unique_ptr<GetUsageAndQuotaCallback> callback) = 0;
    class CONTENT_EXPORT OverrideQuotaForOriginCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~OverrideQuotaForOriginCallback() { }
    };
    virtual void OverrideQuotaForOrigin(const String& in_origin, std::optional<double> in_quotaSize, std::unique_ptr<OverrideQuotaForOriginCallback> callback) = 0;
    virtual DispatchResponse TrackCacheStorageForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse TrackCacheStorageForStorageKey(const String& in_storageKey) = 0;
    virtual DispatchResponse TrackIndexedDBForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse TrackIndexedDBForStorageKey(const String& in_storageKey) = 0;
    virtual DispatchResponse UntrackCacheStorageForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse UntrackCacheStorageForStorageKey(const String& in_storageKey) = 0;
    virtual DispatchResponse UntrackIndexedDBForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse UntrackIndexedDBForStorageKey(const String& in_storageKey) = 0;
    class CONTENT_EXPORT GetTrustTokensCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Storage::TrustTokens>> tokens) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetTrustTokensCallback() { }
    };
    virtual void GetTrustTokens(std::unique_ptr<GetTrustTokensCallback> callback) = 0;
    class CONTENT_EXPORT ClearTrustTokensCallback {
    public:
        virtual void sendSuccess(bool didDeleteTokens) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearTrustTokensCallback() { }
    };
    virtual void ClearTrustTokens(const String& in_issuerOrigin, std::unique_ptr<ClearTrustTokensCallback> callback) = 0;
    class CONTENT_EXPORT GetInterestGroupDetailsCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::DictionaryValue> details) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetInterestGroupDetailsCallback() { }
    };
    virtual void GetInterestGroupDetails(const String& in_ownerOrigin, const String& in_name, std::unique_ptr<GetInterestGroupDetailsCallback> callback) = 0;
    virtual DispatchResponse SetInterestGroupTracking(bool in_enable) = 0;
    virtual DispatchResponse SetInterestGroupAuctionTracking(bool in_enable) = 0;
    class CONTENT_EXPORT GetSharedStorageMetadataCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Storage::SharedStorageMetadata> metadata) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetSharedStorageMetadataCallback() { }
    };
    virtual void GetSharedStorageMetadata(const String& in_ownerOrigin, std::unique_ptr<GetSharedStorageMetadataCallback> callback) = 0;
    class CONTENT_EXPORT GetSharedStorageEntriesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageEntry>> entries) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetSharedStorageEntriesCallback() { }
    };
    virtual void GetSharedStorageEntries(const String& in_ownerOrigin, std::unique_ptr<GetSharedStorageEntriesCallback> callback) = 0;
    class CONTENT_EXPORT SetSharedStorageEntryCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetSharedStorageEntryCallback() { }
    };
    virtual void SetSharedStorageEntry(const String& in_ownerOrigin, const String& in_key, const String& in_value, std::optional<bool> in_ignoreIfPresent, std::unique_ptr<SetSharedStorageEntryCallback> callback) = 0;
    class CONTENT_EXPORT DeleteSharedStorageEntryCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DeleteSharedStorageEntryCallback() { }
    };
    virtual void DeleteSharedStorageEntry(const String& in_ownerOrigin, const String& in_key, std::unique_ptr<DeleteSharedStorageEntryCallback> callback) = 0;
    class CONTENT_EXPORT ClearSharedStorageEntriesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearSharedStorageEntriesCallback() { }
    };
    virtual void ClearSharedStorageEntries(const String& in_ownerOrigin, std::unique_ptr<ClearSharedStorageEntriesCallback> callback) = 0;
    class CONTENT_EXPORT ResetSharedStorageBudgetCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ResetSharedStorageBudgetCallback() { }
    };
    virtual void ResetSharedStorageBudget(const String& in_ownerOrigin, std::unique_ptr<ResetSharedStorageBudgetCallback> callback) = 0;
    virtual DispatchResponse SetSharedStorageTracking(bool in_enable) = 0;
    virtual DispatchResponse SetStorageBucketTracking(const String& in_storageKey, bool in_enable) = 0;
    virtual DispatchResponse DeleteStorageBucket(std::unique_ptr<protocol::Storage::StorageBucket> in_bucket) = 0;
    class CONTENT_EXPORT SetAttributionReportingLocalTestingModeCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetAttributionReportingLocalTestingModeCallback() { }
    };
    virtual void SetAttributionReportingLocalTestingMode(bool in_enabled, std::unique_ptr<SetAttributionReportingLocalTestingModeCallback> callback) = 0;
    virtual DispatchResponse SetAttributionReportingTracking(bool in_enable) = 0;
    class CONTENT_EXPORT SendPendingAttributionReportsCallback {
    public:
        virtual void sendSuccess(int numSent) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SendPendingAttributionReportsCallback() { }
    };
    virtual void SendPendingAttributionReports(std::unique_ptr<SendPendingAttributionReportsCallback> callback) = 0;
    virtual DispatchResponse SetProtectedAudienceKAnonymity(const String& in_owner, const String& in_name, std::unique_ptr<protocol::Array<Binary>> in_hashes) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void CacheStorageContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& cacheName);
    void CacheStorageListUpdated(const String& origin, const String& storageKey, const String& bucketId);
    void IndexedDBContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& databaseName, const String& objectStoreName);
    void IndexedDBListUpdated(const String& origin, const String& storageKey, const String& bucketId);
    void InterestGroupAccessed(double accessTime, const String& type, const String& ownerOrigin, const String& name, std::optional<String> componentSellerOrigin = {}, std::optional<double> bid = {}, std::optional<String> bidCurrency = {}, std::optional<String> uniqueAuctionId = {});
    void InterestGroupAuctionEventOccurred(double eventTime, const String& type, const String& uniqueAuctionId, std::optional<String> parentAuctionId = {}, std::unique_ptr<protocol::DictionaryValue> auctionConfig = {});
    void InterestGroupAuctionNetworkRequestCreated(const String& type, const String& requestId, std::unique_ptr<protocol::Array<String>> auctions);
    void SharedStorageAccessed(double accessTime, const String& scope, const String& method, const String& mainFrameId, const String& ownerOrigin, const String& ownerSite, std::unique_ptr<protocol::Storage::SharedStorageAccessParams> params);
    void SharedStorageWorkletOperationExecutionFinished(double finishedTime, int executionTime, const String& method, const String& operationId, const String& workletTargetId, const String& mainFrameId, const String& ownerOrigin);
    void StorageBucketCreatedOrUpdated(std::unique_ptr<protocol::Storage::StorageBucketInfo> bucketInfo);
    void StorageBucketDeleted(const String& bucketId);
    void AttributionReportingSourceRegistered(std::unique_ptr<protocol::Storage::AttributionReportingSourceRegistration> registration, const String& result);
    void AttributionReportingTriggerRegistered(std::unique_ptr<protocol::Storage::AttributionReportingTriggerRegistration> registration, const String& eventLevel, const String& aggregatable);
    void AttributionReportingReportSent(const String& url, std::unique_ptr<protocol::DictionaryValue> body, const String& result, std::optional<int> netError = {}, std::optional<String> netErrorName = {}, std::optional<int> httpStatusCode = {});
    void AttributionReportingVerboseDebugReportSent(const String& url, std::unique_ptr<protocol::Array<protocol::DictionaryValue>> body = {}, std::optional<int> netError = {}, std::optional<String> netErrorName = {}, std::optional<int> httpStatusCode = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Storage
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Storage_h)
