// components/services/storage/public/mojom/service_worker_database.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/service_worker_database.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/service_worker_database.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/service_worker_database.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-forward.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_ancestor_frame_type.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace storage::mojom {









class  ServiceWorkerRegistrationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRegistrationData, T>::value>;
  using DataView = ServiceWorkerRegistrationDataDataView;
  using Data_ = internal::ServiceWorkerRegistrationData_Data;

  template <typename... Args>
  static ServiceWorkerRegistrationDataPtr New(Args&&... args) {
    return ServiceWorkerRegistrationDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRegistrationDataPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRegistrationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRegistrationData>::Convert(*this);
  }


  ServiceWorkerRegistrationData();

  ServiceWorkerRegistrationData(
      int64_t registration_id,
      const ::GURL& scope,
      const ::blink::StorageKey& key,
      const ::GURL& script,
      ::blink::mojom::ScriptType script_type,
      ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache,
      int64_t version_id,
      bool is_active,
      ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type,
      ::base::Time last_update_check,
      ::base::Time script_response_time,
      const std::optional<base::flat_map<std::string, std::vector<std::string>>>& origin_trial_tokens,
      ::blink::mojom::NavigationPreloadStatePtr navigation_preload_state,
      std::vector<::blink::mojom::WebFeature> used_features,
      int64_t resources_total_size_bytes,
      ::blink::mojom::PolicyContainerPoliciesPtr policy_container_policies,
      ::blink::mojom::AncestorFrameType ancestor_frame_type,
      const std::optional<::blink::ServiceWorkerRouterRules>& router_rules,
      bool has_hid_event_handlers,
      bool has_usb_event_handlers);

ServiceWorkerRegistrationData(const ServiceWorkerRegistrationData&) = delete;
ServiceWorkerRegistrationData& operator=(const ServiceWorkerRegistrationData&) = delete;

  ~ServiceWorkerRegistrationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRegistrationDataPtr>
  ServiceWorkerRegistrationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRegistrationData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRegistrationData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRegistrationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRegistrationData_UnserializedMessageContext<
            UserType, ServiceWorkerRegistrationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRegistrationData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRegistrationData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRegistrationData_UnserializedMessageContext<
            UserType, ServiceWorkerRegistrationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRegistrationData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t registration_id;
  
  ::GURL scope;
  
  ::blink::StorageKey key;
  
  ::GURL script;
  
  ::blink::mojom::ScriptType script_type;
  
  ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache;
  
  int64_t version_id;
  
  bool is_active;
  
  ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type;
  
  ::base::Time last_update_check;
  
  ::base::Time script_response_time;
  
  std::optional<base::flat_map<std::string, std::vector<std::string>>> origin_trial_tokens;
  
  ::blink::mojom::NavigationPreloadStatePtr navigation_preload_state;
  
  std::vector<::blink::mojom::WebFeature> used_features;
  
  int64_t resources_total_size_bytes;
  
  ::blink::mojom::PolicyContainerPoliciesPtr policy_container_policies;
  
  ::blink::mojom::AncestorFrameType ancestor_frame_type;
  
  std::optional<::blink::ServiceWorkerRouterRules> router_rules;
  
  bool has_hid_event_handlers;
  
  bool has_usb_event_handlers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ServiceWorkerResourceRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerResourceRecord, T>::value>;
  using DataView = ServiceWorkerResourceRecordDataView;
  using Data_ = internal::ServiceWorkerResourceRecord_Data;

  template <typename... Args>
  static ServiceWorkerResourceRecordPtr New(Args&&... args) {
    return ServiceWorkerResourceRecordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerResourceRecordPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerResourceRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerResourceRecord>::Convert(*this);
  }


  ServiceWorkerResourceRecord();

  ServiceWorkerResourceRecord(
      int64_t resource_id,
      const ::GURL& url,
      int64_t size_bytes,
      const std::optional<std::string>& sha256_checksum);


  ~ServiceWorkerResourceRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerResourceRecordPtr>
  ServiceWorkerResourceRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerResourceRecord::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerResourceRecord::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerResourceRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerResourceRecord_UnserializedMessageContext<
            UserType, ServiceWorkerResourceRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerResourceRecord::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerResourceRecord::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerResourceRecord_UnserializedMessageContext<
            UserType, ServiceWorkerResourceRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerResourceRecord::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t resource_id;
  
  ::GURL url;
  
  int64_t size_bytes;
  
  std::optional<std::string> sha256_checksum;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerRegistrationDataPtr ServiceWorkerRegistrationData::Clone() const {
  return New(
      mojo::Clone(registration_id),
      mojo::Clone(scope),
      mojo::Clone(key),
      mojo::Clone(script),
      mojo::Clone(script_type),
      mojo::Clone(update_via_cache),
      mojo::Clone(version_id),
      mojo::Clone(is_active),
      mojo::Clone(fetch_handler_type),
      mojo::Clone(last_update_check),
      mojo::Clone(script_response_time),
      mojo::Clone(origin_trial_tokens),
      mojo::Clone(navigation_preload_state),
      mojo::Clone(used_features),
      mojo::Clone(resources_total_size_bytes),
      mojo::Clone(policy_container_policies),
      mojo::Clone(ancestor_frame_type),
      mojo::Clone(router_rules),
      mojo::Clone(has_hid_event_handlers),
      mojo::Clone(has_usb_event_handlers)
  );
}

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>*>
bool ServiceWorkerRegistrationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration_id, other_struct.registration_id))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->script, other_struct.script))
    return false;
  if (!mojo::Equals(this->script_type, other_struct.script_type))
    return false;
  if (!mojo::Equals(this->update_via_cache, other_struct.update_via_cache))
    return false;
  if (!mojo::Equals(this->version_id, other_struct.version_id))
    return false;
  if (!mojo::Equals(this->is_active, other_struct.is_active))
    return false;
  if (!mojo::Equals(this->fetch_handler_type, other_struct.fetch_handler_type))
    return false;
  if (!mojo::Equals(this->last_update_check, other_struct.last_update_check))
    return false;
  if (!mojo::Equals(this->script_response_time, other_struct.script_response_time))
    return false;
  if (!mojo::Equals(this->origin_trial_tokens, other_struct.origin_trial_tokens))
    return false;
  if (!mojo::Equals(this->navigation_preload_state, other_struct.navigation_preload_state))
    return false;
  if (!mojo::Equals(this->used_features, other_struct.used_features))
    return false;
  if (!mojo::Equals(this->resources_total_size_bytes, other_struct.resources_total_size_bytes))
    return false;
  if (!mojo::Equals(this->policy_container_policies, other_struct.policy_container_policies))
    return false;
  if (!mojo::Equals(this->ancestor_frame_type, other_struct.ancestor_frame_type))
    return false;
  if (!mojo::Equals(this->router_rules, other_struct.router_rules))
    return false;
  if (!mojo::Equals(this->has_hid_event_handlers, other_struct.has_hid_event_handlers))
    return false;
  if (!mojo::Equals(this->has_usb_event_handlers, other_struct.has_usb_event_handlers))
    return false;
  return true;
}

template <typename T, ServiceWorkerRegistrationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.registration_id < rhs.registration_id)
    return true;
  if (rhs.registration_id < lhs.registration_id)
    return false;
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.script < rhs.script)
    return true;
  if (rhs.script < lhs.script)
    return false;
  if (lhs.script_type < rhs.script_type)
    return true;
  if (rhs.script_type < lhs.script_type)
    return false;
  if (lhs.update_via_cache < rhs.update_via_cache)
    return true;
  if (rhs.update_via_cache < lhs.update_via_cache)
    return false;
  if (lhs.version_id < rhs.version_id)
    return true;
  if (rhs.version_id < lhs.version_id)
    return false;
  if (lhs.is_active < rhs.is_active)
    return true;
  if (rhs.is_active < lhs.is_active)
    return false;
  if (lhs.fetch_handler_type < rhs.fetch_handler_type)
    return true;
  if (rhs.fetch_handler_type < lhs.fetch_handler_type)
    return false;
  if (lhs.last_update_check < rhs.last_update_check)
    return true;
  if (rhs.last_update_check < lhs.last_update_check)
    return false;
  if (lhs.script_response_time < rhs.script_response_time)
    return true;
  if (rhs.script_response_time < lhs.script_response_time)
    return false;
  if (lhs.origin_trial_tokens < rhs.origin_trial_tokens)
    return true;
  if (rhs.origin_trial_tokens < lhs.origin_trial_tokens)
    return false;
  if (lhs.navigation_preload_state < rhs.navigation_preload_state)
    return true;
  if (rhs.navigation_preload_state < lhs.navigation_preload_state)
    return false;
  if (lhs.used_features < rhs.used_features)
    return true;
  if (rhs.used_features < lhs.used_features)
    return false;
  if (lhs.resources_total_size_bytes < rhs.resources_total_size_bytes)
    return true;
  if (rhs.resources_total_size_bytes < lhs.resources_total_size_bytes)
    return false;
  if (lhs.policy_container_policies < rhs.policy_container_policies)
    return true;
  if (rhs.policy_container_policies < lhs.policy_container_policies)
    return false;
  if (lhs.ancestor_frame_type < rhs.ancestor_frame_type)
    return true;
  if (rhs.ancestor_frame_type < lhs.ancestor_frame_type)
    return false;
  if (lhs.router_rules < rhs.router_rules)
    return true;
  if (rhs.router_rules < lhs.router_rules)
    return false;
  if (lhs.has_hid_event_handlers < rhs.has_hid_event_handlers)
    return true;
  if (rhs.has_hid_event_handlers < lhs.has_hid_event_handlers)
    return false;
  if (lhs.has_usb_event_handlers < rhs.has_usb_event_handlers)
    return true;
  if (rhs.has_usb_event_handlers < lhs.has_usb_event_handlers)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerResourceRecordPtr ServiceWorkerResourceRecord::Clone() const {
  return New(
      mojo::Clone(resource_id),
      mojo::Clone(url),
      mojo::Clone(size_bytes),
      mojo::Clone(sha256_checksum)
  );
}

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>*>
bool ServiceWorkerResourceRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->size_bytes, other_struct.size_bytes))
    return false;
  if (!mojo::Equals(this->sha256_checksum, other_struct.sha256_checksum))
    return false;
  return true;
}

template <typename T, ServiceWorkerResourceRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resource_id < rhs.resource_id)
    return true;
  if (rhs.resource_id < lhs.resource_id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.size_bytes < rhs.size_bytes)
    return true;
  if (rhs.size_bytes < lhs.size_bytes)
    return false;
  if (lhs.sha256_checksum < rhs.sha256_checksum)
    return true;
  if (rhs.sha256_checksum < lhs.sha256_checksum)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerRegistrationData::DataView,
                                         ::storage::mojom::ServiceWorkerRegistrationDataPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerRegistrationDataPtr* output) { output->reset(); }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::registration_id) registration_id(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->registration_id;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::scope)& scope(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->scope;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::key)& key(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->key;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::script)& script(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->script;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::script_type) script_type(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->script_type;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::update_via_cache) update_via_cache(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->update_via_cache;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::version_id) version_id(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->version_id;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::is_active) is_active(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->is_active;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::fetch_handler_type) fetch_handler_type(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->fetch_handler_type;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::last_update_check)& last_update_check(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->last_update_check;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::script_response_time)& script_response_time(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->script_response_time;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::origin_trial_tokens)& origin_trial_tokens(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->origin_trial_tokens;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::navigation_preload_state)& navigation_preload_state(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->navigation_preload_state;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::used_features)& used_features(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->used_features;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::resources_total_size_bytes) resources_total_size_bytes(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->resources_total_size_bytes;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::policy_container_policies)& policy_container_policies(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->policy_container_policies;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::ancestor_frame_type) ancestor_frame_type(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->ancestor_frame_type;
  }

  static const decltype(::storage::mojom::ServiceWorkerRegistrationData::router_rules)& router_rules(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->router_rules;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::has_hid_event_handlers) has_hid_event_handlers(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->has_hid_event_handlers;
  }

  static decltype(::storage::mojom::ServiceWorkerRegistrationData::has_usb_event_handlers) has_usb_event_handlers(
      const ::storage::mojom::ServiceWorkerRegistrationDataPtr& input) {
    return input->has_usb_event_handlers;
  }

  static bool Read(::storage::mojom::ServiceWorkerRegistrationData::DataView input, ::storage::mojom::ServiceWorkerRegistrationDataPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerResourceRecord::DataView,
                                         ::storage::mojom::ServiceWorkerResourceRecordPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerResourceRecordPtr* output) { output->reset(); }

  static decltype(::storage::mojom::ServiceWorkerResourceRecord::resource_id) resource_id(
      const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) {
    return input->resource_id;
  }

  static const decltype(::storage::mojom::ServiceWorkerResourceRecord::url)& url(
      const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) {
    return input->url;
  }

  static decltype(::storage::mojom::ServiceWorkerResourceRecord::size_bytes) size_bytes(
      const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) {
    return input->size_bytes;
  }

  static const decltype(::storage::mojom::ServiceWorkerResourceRecord::sha256_checksum)& sha256_checksum(
      const ::storage::mojom::ServiceWorkerResourceRecordPtr& input) {
    return input->sha256_checksum;
  }

  static bool Read(::storage::mojom::ServiceWorkerResourceRecord::DataView input, ::storage::mojom::ServiceWorkerResourceRecordPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_H_