// components/services/storage/public/mojom/buckets/bucket_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_INFO_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/buckets/bucket_info.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/buckets/bucket_info.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/buckets/bucket_info.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom-forward.h"
#include <string>
#include <vector>




#include "components/services/storage/public/mojom/buckets/bucket_id_mojom_traits.h"
#include "components/services/storage/public/mojom/buckets/bucket_info_mojom_traits.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator_mojom_traits.h"




namespace storage::mojom {








class  BucketInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BucketInfo, T>::value>;
  using DataView = BucketInfoDataView;
  using Data_ = internal::BucketInfo_Data;

  template <typename... Args>
  static BucketInfoPtr New(Args&&... args) {
    return BucketInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BucketInfoPtr From(const U& u) {
    return mojo::TypeConverter<BucketInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BucketInfo>::Convert(*this);
  }


  BucketInfo();

  BucketInfo(
      int64_t id,
      const ::blink::StorageKey& storage_key,
      const std::string& name,
      ::base::Time expiration,
      uint64_t quota,
      bool persistent,
      ::blink::mojom::BucketDurability durability);


  ~BucketInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BucketInfoPtr>
  BucketInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BucketInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BucketInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BucketInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BucketInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BucketInfo_UnserializedMessageContext<
            UserType, BucketInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BucketInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BucketInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BucketInfo_UnserializedMessageContext<
            UserType, BucketInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BucketInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::blink::StorageKey storage_key;
  
  std::string name;
  
  ::base::Time expiration;
  
  uint64_t quota;
  
  bool persistent;
  
  ::blink::mojom::BucketDurability durability;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BucketInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BucketInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BucketInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BucketInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BucketInfoPtr BucketInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(storage_key),
      mojo::Clone(name),
      mojo::Clone(expiration),
      mojo::Clone(quota),
      mojo::Clone(persistent),
      mojo::Clone(durability)
  );
}

template <typename T, BucketInfo::EnableIfSame<T>*>
bool BucketInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->storage_key, other_struct.storage_key))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->expiration, other_struct.expiration))
    return false;
  if (!mojo::Equals(this->quota, other_struct.quota))
    return false;
  if (!mojo::Equals(this->persistent, other_struct.persistent))
    return false;
  if (!mojo::Equals(this->durability, other_struct.durability))
    return false;
  return true;
}

template <typename T, BucketInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.storage_key < rhs.storage_key)
    return true;
  if (rhs.storage_key < lhs.storage_key)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.expiration < rhs.expiration)
    return true;
  if (rhs.expiration < lhs.expiration)
    return false;
  if (lhs.quota < rhs.quota)
    return true;
  if (rhs.quota < lhs.quota)
    return false;
  if (lhs.persistent < rhs.persistent)
    return true;
  if (rhs.persistent < lhs.persistent)
    return false;
  if (lhs.durability < rhs.durability)
    return true;
  if (rhs.durability < lhs.durability)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::BucketInfo::DataView,
                                         ::storage::mojom::BucketInfoPtr> {
  static bool IsNull(const ::storage::mojom::BucketInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::BucketInfoPtr* output) { output->reset(); }

  static decltype(::storage::mojom::BucketInfo::id) id(
      const ::storage::mojom::BucketInfoPtr& input) {
    return input->id;
  }

  static const decltype(::storage::mojom::BucketInfo::storage_key)& storage_key(
      const ::storage::mojom::BucketInfoPtr& input) {
    return input->storage_key;
  }

  static const decltype(::storage::mojom::BucketInfo::name)& name(
      const ::storage::mojom::BucketInfoPtr& input) {
    return input->name;
  }

  static const decltype(::storage::mojom::BucketInfo::expiration)& expiration(
      const ::storage::mojom::BucketInfoPtr& input) {
    return input->expiration;
  }

  static decltype(::storage::mojom::BucketInfo::quota) quota(
      const ::storage::mojom::BucketInfoPtr& input) {
    return input->quota;
  }

  static decltype(::storage::mojom::BucketInfo::persistent) persistent(
      const ::storage::mojom::BucketInfoPtr& input) {
    return input->persistent;
  }

  static decltype(::storage::mojom::BucketInfo::durability) durability(
      const ::storage::mojom::BucketInfoPtr& input) {
    return input->durability;
  }

  static bool Read(::storage::mojom::BucketInfo::DataView input, ::storage::mojom::BucketInfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_INFO_MOJOM_H_