// components/services/font/public/mojom/font_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/font/public/mojom/font_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"


namespace font_service::mojom {
class TypefaceStyleDataView;

class FontIdentityDataView;

class FontRenderStyleDataView;



}  // font_service::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::font_service::mojom::TypefaceStyleDataView> {
  using Data = ::font_service::mojom::internal::TypefaceStyle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_service::mojom::FontIdentityDataView> {
  using Data = ::font_service::mojom::internal::FontIdentity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_service::mojom::FontRenderStyleDataView> {
  using Data = ::font_service::mojom::internal::FontRenderStyle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace font_service::mojom {


enum class TypefaceSlant : int32_t {
  
  ROMAN = 0,
  
  ITALIC = 1,
  
  OBLIQUE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TypefaceSlant value);
inline bool IsKnownEnumValue(TypefaceSlant value) {
  return internal::TypefaceSlant_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RenderStyleSwitch : int32_t {
  
  OFF = 0,
  
  ON = 1,
  
  NO_PREFERENCE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RenderStyleSwitch value);
inline bool IsKnownEnumValue(RenderStyleSwitch value) {
  return internal::RenderStyleSwitch_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FontServiceInterfaceBase {};

using FontServicePtrDataView =
    mojo::InterfacePtrDataView<FontServiceInterfaceBase>;
using FontServiceRequestDataView =
    mojo::InterfaceRequestDataView<FontServiceInterfaceBase>;
using FontServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FontServiceInterfaceBase>;
using FontServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FontServiceInterfaceBase>;


class TypefaceStyleDataView {
 public:
  TypefaceStyleDataView() = default;

  TypefaceStyleDataView(
      internal::TypefaceStyle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t weight() const {
    return data_->weight;
  }
  uint8_t width() const {
    return data_->width;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSlant(UserType* output) const {
    auto data_value = data_->slant;
    return mojo::internal::Deserialize<::font_service::mojom::TypefaceSlant>(
        data_value, output);
  }
  TypefaceSlant slant() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::TypefaceSlant>(data_->slant));
  }
 private:
  internal::TypefaceStyle_Data* data_ = nullptr;
};


class FontIdentityDataView {
 public:
  FontIdentityDataView() = default;

  FontIdentityDataView(
      internal::FontIdentity_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t id() const {
    return data_->id;
  }
  int32_t ttc_index() const {
    return data_->ttc_index;
  }
  inline void GetFilepathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilepath(UserType* output) {
    
    auto* pointer = data_->filepath.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::FontIdentity_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FontRenderStyleDataView {
 public:
  FontRenderStyleDataView() = default;

  FontRenderStyleDataView(
      internal::FontRenderStyle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadUseBitmaps(UserType* output) const {
    auto data_value = data_->use_bitmaps;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_bitmaps() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_bitmaps));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseAutohint(UserType* output) const {
    auto data_value = data_->use_autohint;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_autohint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_autohint));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseHinting(UserType* output) const {
    auto data_value = data_->use_hinting;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_hinting() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_hinting));
  }
  uint8_t hint_style() const {
    return data_->hint_style;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseAntialias(UserType* output) const {
    auto data_value = data_->use_antialias;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_antialias() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_antialias));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseSubpixelRendering(UserType* output) const {
    auto data_value = data_->use_subpixel_rendering;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_subpixel_rendering() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_subpixel_rendering));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseSubpixelPositioning(UserType* output) const {
    auto data_value = data_->use_subpixel_positioning;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_subpixel_positioning() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_subpixel_positioning));
  }
 private:
  internal::FontRenderStyle_Data* data_ = nullptr;
};


}  // font_service::mojom

#endif  // COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_DATA_VIEW_H_