// components/metrics/public/mojom/histogram_fetcher.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_PUBLIC_MOJOM_HISTOGRAM_FETCHER_MOJOM_H_
#define COMPONENTS_METRICS_PUBLIC_MOJOM_HISTOGRAM_FETCHER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/metrics/public/mojom/histogram_fetcher.mojom-features.h"  // IWYU pragma: export
#include "components/metrics/public/mojom/histogram_fetcher.mojom-shared.h"  // IWYU pragma: export
#include "components/metrics/public/mojom/histogram_fetcher.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace metrics::mojom {

class ChildHistogramFetcherFactoryProxy;

template <typename ImplRefTraits>
class ChildHistogramFetcherFactoryStub;

class ChildHistogramFetcherFactoryRequestValidator;


class ChildHistogramFetcherFactory
    : public ChildHistogramFetcherFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "metrics.mojom.ChildHistogramFetcherFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChildHistogramFetcherFactoryInterfaceBase;
  using Proxy_ = ChildHistogramFetcherFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChildHistogramFetcherFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ChildHistogramFetcherFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateFetcherMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateFetcher_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChildHistogramFetcherFactory() = default;

  virtual void CreateFetcher(::base::UnsafeSharedMemoryRegion shared_memory, ::mojo::PendingReceiver<ChildHistogramFetcher> child_histogram_fetcher) = 0;
};

class ChildHistogramFetcherProxy;

template <typename ImplRefTraits>
class ChildHistogramFetcherStub;

class ChildHistogramFetcherRequestValidator;
class ChildHistogramFetcherResponseValidator;


class ChildHistogramFetcher
    : public ChildHistogramFetcherInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "metrics.mojom.ChildHistogramFetcher";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChildHistogramFetcherInterfaceBase;
  using Proxy_ = ChildHistogramFetcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChildHistogramFetcherStub<ImplRefTraits>;

  using RequestValidator_ = ChildHistogramFetcherRequestValidator;
  using ResponseValidator_ = ChildHistogramFetcherResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetChildNonPersistentHistogramDataMinVersion = 0,
    kPingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetChildNonPersistentHistogramData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChildHistogramFetcher() = default;

  using GetChildNonPersistentHistogramDataCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  using GetChildNonPersistentHistogramDataMojoCallback = base::OnceCallback<void(const std::vector<std::string>&)>;

  virtual void GetChildNonPersistentHistogramData(GetChildNonPersistentHistogramDataCallback callback) = 0;

  using PingCallback = base::OnceCallback<void()>;
  using PingMojoCallback = base::OnceCallback<void()>;

  virtual void Ping(UmaPingCallSource call_source, PingCallback callback) = 0;
};



class  ChildHistogramFetcherFactoryProxy
    : public ChildHistogramFetcherFactory {
 public:
  using InterfaceType = ChildHistogramFetcherFactory;

  explicit ChildHistogramFetcherFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateFetcher(::base::UnsafeSharedMemoryRegion shared_memory, ::mojo::PendingReceiver<ChildHistogramFetcher> child_histogram_fetcher) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ChildHistogramFetcherProxy
    : public ChildHistogramFetcher {
 public:
  using InterfaceType = ChildHistogramFetcher;

  explicit ChildHistogramFetcherProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetChildNonPersistentHistogramData(GetChildNonPersistentHistogramDataCallback callback) final;
  
  void Ping(UmaPingCallSource call_source, PingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ChildHistogramFetcherFactoryStubDispatch {
 public:
  static bool Accept(ChildHistogramFetcherFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChildHistogramFetcherFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChildHistogramFetcherFactory>>
class ChildHistogramFetcherFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChildHistogramFetcherFactoryStub() = default;
  ~ChildHistogramFetcherFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildHistogramFetcherFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildHistogramFetcherFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ChildHistogramFetcherStubDispatch {
 public:
  static bool Accept(ChildHistogramFetcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChildHistogramFetcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChildHistogramFetcher>>
class ChildHistogramFetcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChildHistogramFetcherStub() = default;
  ~ChildHistogramFetcherStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildHistogramFetcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildHistogramFetcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ChildHistogramFetcherFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ChildHistogramFetcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ChildHistogramFetcherResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // metrics::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_METRICS_PUBLIC_MOJOM_HISTOGRAM_FETCHER_MOJOM_H_