// components/download/public/common/download_stream.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_H_
#define COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/download/public/common/download_stream.mojom-features.h"  // IWYU pragma: export
#include "components/download/public/common/download_stream.mojom-shared.h"  // IWYU pragma: export
#include "components/download/public/common/download_stream.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/download/public/common/download_export.h"




namespace download::mojom {

class DownloadStreamClientProxy;

template <typename ImplRefTraits>
class DownloadStreamClientStub;

class DownloadStreamClientRequestValidator;


class COMPONENTS_DOWNLOAD_EXPORT DownloadStreamClient
    : public DownloadStreamClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "download.mojom.DownloadStreamClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DownloadStreamClientInterfaceBase;
  using Proxy_ = DownloadStreamClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DownloadStreamClientStub<ImplRefTraits>;

  using RequestValidator_ = DownloadStreamClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnStreamCompletedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnStreamCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DownloadStreamClient() = default;

  virtual void OnStreamCompleted(NetworkRequestStatus status) = 0;
};



class COMPONENTS_DOWNLOAD_EXPORT DownloadStreamClientProxy
    : public DownloadStreamClient {
 public:
  using InterfaceType = DownloadStreamClient;

  explicit DownloadStreamClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnStreamCompleted(NetworkRequestStatus status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENTS_DOWNLOAD_EXPORT DownloadStreamClientStubDispatch {
 public:
  static bool Accept(DownloadStreamClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DownloadStreamClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DownloadStreamClient>>
class DownloadStreamClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DownloadStreamClientStub() = default;
  ~DownloadStreamClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DownloadStreamClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DownloadStreamClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENTS_DOWNLOAD_EXPORT DownloadStreamClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENTS_DOWNLOAD_EXPORT DownloadStreamHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DownloadStreamHandle, T>::value>;
  using DataView = DownloadStreamHandleDataView;
  using Data_ = internal::DownloadStreamHandle_Data;

  template <typename... Args>
  static DownloadStreamHandlePtr New(Args&&... args) {
    return DownloadStreamHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DownloadStreamHandlePtr From(const U& u) {
    return mojo::TypeConverter<DownloadStreamHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DownloadStreamHandle>::Convert(*this);
  }


  DownloadStreamHandle();

  DownloadStreamHandle(
      ::mojo::ScopedDataPipeConsumerHandle stream,
      ::mojo::PendingReceiver<DownloadStreamClient> client_receiver);

DownloadStreamHandle(const DownloadStreamHandle&) = delete;
DownloadStreamHandle& operator=(const DownloadStreamHandle&) = delete;

  ~DownloadStreamHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DownloadStreamHandlePtr>
  DownloadStreamHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DownloadStreamHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DownloadStreamHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DownloadStreamHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DownloadStreamHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DownloadStreamHandle_UnserializedMessageContext<
            UserType, DownloadStreamHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DownloadStreamHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DownloadStreamHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DownloadStreamHandle_UnserializedMessageContext<
            UserType, DownloadStreamHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DownloadStreamHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::ScopedDataPipeConsumerHandle stream;
  
  ::mojo::PendingReceiver<DownloadStreamClient> client_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DownloadStreamHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DownloadStreamHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DownloadStreamHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DownloadStreamHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DownloadStreamHandlePtr DownloadStreamHandle::Clone() const {
  return New(
      mojo::Clone(stream),
      mojo::Clone(client_receiver)
  );
}

template <typename T, DownloadStreamHandle::EnableIfSame<T>*>
bool DownloadStreamHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stream, other_struct.stream))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  return true;
}

template <typename T, DownloadStreamHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stream < rhs.stream)
    return true;
  if (rhs.stream < lhs.stream)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  return false;
}


}  // download::mojom

namespace mojo {


template <>
struct COMPONENTS_DOWNLOAD_EXPORT StructTraits<::download::mojom::DownloadStreamHandle::DataView,
                                         ::download::mojom::DownloadStreamHandlePtr> {
  static bool IsNull(const ::download::mojom::DownloadStreamHandlePtr& input) { return !input; }
  static void SetToNull(::download::mojom::DownloadStreamHandlePtr* output) { output->reset(); }

  static  decltype(::download::mojom::DownloadStreamHandle::stream)& stream(
       ::download::mojom::DownloadStreamHandlePtr& input) {
    return input->stream;
  }

  static  decltype(::download::mojom::DownloadStreamHandle::client_receiver)& client_receiver(
       ::download::mojom::DownloadStreamHandlePtr& input) {
    return input->client_receiver;
  }

  static bool Read(::download::mojom::DownloadStreamHandle::DataView input, ::download::mojom::DownloadStreamHandlePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_H_