// components/content_settings/core/common/content_settings.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/content_settings/core/common/content_settings.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/content_settings/core/common/content_settings.mojom-params-data.h"
namespace content_settings {
namespace mojom {

NOINLINE static const char* ContentSettingToStringHelper(ContentSetting value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContentSetting::DEFAULT:
      return "DEFAULT";
    case ContentSetting::ALLOW:
      return "ALLOW";
    case ContentSetting::BLOCK:
      return "BLOCK";
    case ContentSetting::ASK:
      return "ASK";
    case ContentSetting::SESSION_ONLY:
      return "SESSION_ONLY";
    default:
      return nullptr;
  }
}

std::string ContentSettingToString(ContentSetting value) {
  const char *str = ContentSettingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContentSetting value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContentSetting value) {
  return os << ContentSettingToString(value);
}

namespace internal {


// static
bool PatternParts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PatternParts_Data* object =
      static_cast<const PatternParts_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scheme_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& port_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->port, validation_context,
                                         &port_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  return true;
}

PatternParts_Data::PatternParts_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSettingsPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentSettingsPattern_Data* object =
      static_cast<const ContentSettingsPattern_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parts, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parts, validation_context))
    return false;

  return true;
}

ContentSettingsPattern_Data::ContentSettingsPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RuleMetaData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RuleMetaData_Data* object =
      static_cast<const RuleMetaData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_modified, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_modified, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_used, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_used, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_visited, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_visited, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiration, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiration, validation_context))
    return false;


  if (!::content_settings::mojom::internal::SessionModel_Data
        ::Validate(object->session_model, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lifetime, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lifetime, validation_context))
    return false;


  if (!::content_settings::mojom::internal::TpcdMetadataRuleSource_Data
        ::Validate(object->tpcd_metadata_rule_source, validation_context))
    return false;


  if (!::content_settings::mojom::internal::TpcdMetadataCohort_Data
        ::Validate(object->tpcd_metadata_cohort, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->rule_options, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->rule_options, validation_context))
    return false;

  return true;
}

RuleMetaData_Data::RuleMetaData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSettingPatternSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentSettingPatternSource_Data* object =
      static_cast<const ContentSettingPatternSource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_pattern, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->primary_pattern, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->secondary_pattern, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->secondary_pattern, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->setting_value, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->setting_value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;


  if (!::content_settings::mojom::internal::ProviderType_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

ContentSettingPatternSource_Data::ContentSettingPatternSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererContentSettingRules_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RendererContentSettingRules_Data* object =
      static_cast<const RendererContentSettingRules_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mixed_content_rules, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mixed_content_rules_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mixed_content_rules, validation_context,
                                         &mixed_content_rules_validate_params)) {
    return false;
  }

  return true;
}

RendererContentSettingRules_Data::RendererContentSettingRules_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content_settings

namespace perfetto {

// static
void TraceFormatTraits<::content_settings::mojom::ContentSetting>::WriteIntoTrace(
   perfetto::TracedValue context, ::content_settings::mojom::ContentSetting value) {
  return std::move(context).WriteString(::content_settings::mojom::ContentSettingToString(value));
}

} // namespace perfetto