/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "meta-dbus-a11y.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__BOOLEAN_UINT_UINT_UINT_UINT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_BooleanUintUintUintUintFunc)
       (void *data1,
        gboolean arg_released,
        guint arg_state,
        guint arg_keysym,
        guint arg_unichar,
        guint16 arg_keycode,
        void *data2);
  _GDbusCodegenMarshalVoid_BooleanUintUintUintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_BooleanUintUintUintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_boolean (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            g_marshal_value_peek_uint (param_values + 3),
            g_marshal_value_peek_uint (param_values + 4),
            g_marshal_value_peek_uint (param_values + 5),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_modifiers,
        GVariant *arg_keystrokes,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.a11y.KeyboardMonitor
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDBusKeyboardMonitor
 * @title: MetaDBusKeyboardMonitor
 * @short_description: Generated C code for the org.freedesktop.a11y.KeyboardMonitor D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-a11y-KeyboardMonitor.top_of_page">org.freedesktop.a11y.KeyboardMonitor</link> D-Bus interface in C.
 */

enum
{
  META_DBUS__KEYBOARD_MONITOR_KEY_EVENT,
};

static unsigned META_DBUS__KEYBOARD_MONITOR_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.a11y.KeyboardMonitor ---- */

static const _ExtendedGDBusMethodInfo _meta_dbus_keyboard_monitor_method_info_grab_keyboard =
{
  {
    -1,
    (gchar *) "GrabKeyboard",
    NULL,
    NULL,
    NULL
  },
  "handle-grab-keyboard",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_keyboard_monitor_method_info_ungrab_keyboard =
{
  {
    -1,
    (gchar *) "UngrabKeyboard",
    NULL,
    NULL,
    NULL
  },
  "handle-ungrab-keyboard",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_keyboard_monitor_method_info_watch_keyboard =
{
  {
    -1,
    (gchar *) "WatchKeyboard",
    NULL,
    NULL,
    NULL
  },
  "handle-watch-keyboard",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_keyboard_monitor_method_info_unwatch_keyboard =
{
  {
    -1,
    (gchar *) "UnwatchKeyboard",
    NULL,
    NULL,
    NULL
  },
  "handle-unwatch-keyboard",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_keyboard_monitor_method_info_set_key_grabs_IN_ARG_modifiers =
{
  {
    -1,
    (gchar *) "modifiers",
    (gchar *) "au",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_keyboard_monitor_method_info_set_key_grabs_IN_ARG_keystrokes =
{
  {
    -1,
    (gchar *) "keystrokes",
    (gchar *) "a(uu)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_keyboard_monitor_method_info_set_key_grabs_IN_ARG_pointers[] =
{
  &_meta_dbus_keyboard_monitor_method_info_set_key_grabs_IN_ARG_modifiers.parent_struct,
  &_meta_dbus_keyboard_monitor_method_info_set_key_grabs_IN_ARG_keystrokes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_keyboard_monitor_method_info_set_key_grabs =
{
  {
    -1,
    (gchar *) "SetKeyGrabs",
    (GDBusArgInfo **) &_meta_dbus_keyboard_monitor_method_info_set_key_grabs_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-key-grabs",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_keyboard_monitor_method_info_pointers[] =
{
  &_meta_dbus_keyboard_monitor_method_info_grab_keyboard.parent_struct,
  &_meta_dbus_keyboard_monitor_method_info_ungrab_keyboard.parent_struct,
  &_meta_dbus_keyboard_monitor_method_info_watch_keyboard.parent_struct,
  &_meta_dbus_keyboard_monitor_method_info_unwatch_keyboard.parent_struct,
  &_meta_dbus_keyboard_monitor_method_info_set_key_grabs.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_keyboard_monitor_signal_info_key_event_ARG_released =
{
  {
    -1,
    (gchar *) "released",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_keyboard_monitor_signal_info_key_event_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_keyboard_monitor_signal_info_key_event_ARG_keysym =
{
  {
    -1,
    (gchar *) "keysym",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_keyboard_monitor_signal_info_key_event_ARG_unichar =
{
  {
    -1,
    (gchar *) "unichar",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_keyboard_monitor_signal_info_key_event_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_keyboard_monitor_signal_info_key_event_ARG_pointers[] =
{
  &_meta_dbus_keyboard_monitor_signal_info_key_event_ARG_released.parent_struct,
  &_meta_dbus_keyboard_monitor_signal_info_key_event_ARG_state.parent_struct,
  &_meta_dbus_keyboard_monitor_signal_info_key_event_ARG_keysym.parent_struct,
  &_meta_dbus_keyboard_monitor_signal_info_key_event_ARG_unichar.parent_struct,
  &_meta_dbus_keyboard_monitor_signal_info_key_event_ARG_keycode.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_keyboard_monitor_signal_info_key_event =
{
  {
    -1,
    (gchar *) "KeyEvent",
    (GDBusArgInfo **) &_meta_dbus_keyboard_monitor_signal_info_key_event_ARG_pointers,
    NULL
  },
  "key-event"
};

static const GDBusSignalInfo * const _meta_dbus_keyboard_monitor_signal_info_pointers[] =
{
  &_meta_dbus_keyboard_monitor_signal_info_key_event.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_keyboard_monitor_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.a11y.KeyboardMonitor",
    (GDBusMethodInfo **) &_meta_dbus_keyboard_monitor_method_info_pointers,
    (GDBusSignalInfo **) &_meta_dbus_keyboard_monitor_signal_info_pointers,
    NULL,
    NULL
  },
  "keyboard-monitor",
};


/**
 * meta_dbus_keyboard_monitor_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-a11y-KeyboardMonitor.top_of_page">org.freedesktop.a11y.KeyboardMonitor</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_keyboard_monitor_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_keyboard_monitor_interface_info.parent_struct;
}

/**
 * meta_dbus_keyboard_monitor_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDBusKeyboardMonitor interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_keyboard_monitor_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
meta_dbus_keyboard_monitor_signal_marshal_key_event (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__BOOLEAN_UINT_UINT_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_keyboard_monitor_method_marshal_grab_keyboard (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_keyboard_monitor_method_marshal_ungrab_keyboard (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_keyboard_monitor_method_marshal_watch_keyboard (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_keyboard_monitor_method_marshal_unwatch_keyboard (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_keyboard_monitor_method_marshal_set_key_grabs (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDBusKeyboardMonitor:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-KeyboardMonitor.top_of_page">org.freedesktop.a11y.KeyboardMonitor</link>.
 */

/**
 * MetaDBusKeyboardMonitorIface:
 * @parent_iface: The parent interface.
 * @handle_grab_keyboard: Handler for the #MetaDBusKeyboardMonitor::handle-grab-keyboard signal.
 * @handle_set_key_grabs: Handler for the #MetaDBusKeyboardMonitor::handle-set-key-grabs signal.
 * @handle_ungrab_keyboard: Handler for the #MetaDBusKeyboardMonitor::handle-ungrab-keyboard signal.
 * @handle_unwatch_keyboard: Handler for the #MetaDBusKeyboardMonitor::handle-unwatch-keyboard signal.
 * @handle_watch_keyboard: Handler for the #MetaDBusKeyboardMonitor::handle-watch-keyboard signal.
 * @key_event: Handler for the #MetaDBusKeyboardMonitor::key-event signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-KeyboardMonitor.top_of_page">org.freedesktop.a11y.KeyboardMonitor</link>.
 */

typedef MetaDBusKeyboardMonitorIface MetaDBusKeyboardMonitorInterface;
G_DEFINE_INTERFACE (MetaDBusKeyboardMonitor, meta_dbus_keyboard_monitor, G_TYPE_OBJECT)

static void
meta_dbus_keyboard_monitor_default_init (MetaDBusKeyboardMonitorIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDBusKeyboardMonitor::handle-grab-keyboard:
   * @object: A #MetaDBusKeyboardMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.GrabKeyboard">GrabKeyboard()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_keyboard_monitor_complete_grab_keyboard() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-grab-keyboard",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusKeyboardMonitorIface, handle_grab_keyboard),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_keyboard_monitor_method_marshal_grab_keyboard,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusKeyboardMonitor::handle-ungrab-keyboard:
   * @object: A #MetaDBusKeyboardMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.UngrabKeyboard">UngrabKeyboard()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_keyboard_monitor_complete_ungrab_keyboard() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-ungrab-keyboard",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusKeyboardMonitorIface, handle_ungrab_keyboard),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_keyboard_monitor_method_marshal_ungrab_keyboard,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusKeyboardMonitor::handle-watch-keyboard:
   * @object: A #MetaDBusKeyboardMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.WatchKeyboard">WatchKeyboard()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_keyboard_monitor_complete_watch_keyboard() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-watch-keyboard",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusKeyboardMonitorIface, handle_watch_keyboard),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_keyboard_monitor_method_marshal_watch_keyboard,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusKeyboardMonitor::handle-unwatch-keyboard:
   * @object: A #MetaDBusKeyboardMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.UnwatchKeyboard">UnwatchKeyboard()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_keyboard_monitor_complete_unwatch_keyboard() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unwatch-keyboard",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusKeyboardMonitorIface, handle_unwatch_keyboard),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_keyboard_monitor_method_marshal_unwatch_keyboard,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusKeyboardMonitor::handle-set-key-grabs:
   * @object: A #MetaDBusKeyboardMonitor.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_modifiers: Argument passed by remote caller.
   * @arg_keystrokes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.SetKeyGrabs">SetKeyGrabs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_keyboard_monitor_complete_set_key_grabs() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-key-grabs",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusKeyboardMonitorIface, handle_set_key_grabs),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_keyboard_monitor_method_marshal_set_key_grabs,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * MetaDBusKeyboardMonitor::key-event:
   * @object: A #MetaDBusKeyboardMonitor.
   * @arg_released: Argument.
   * @arg_state: Argument.
   * @arg_keysym: Argument.
   * @arg_unichar: Argument.
   * @arg_keycode: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-a11y-KeyboardMonitor.KeyEvent">"KeyEvent"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__KEYBOARD_MONITOR_SIGNALS[META_DBUS__KEYBOARD_MONITOR_KEY_EVENT] =
    g_signal_new ("key-event",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusKeyboardMonitorIface, key_event),
      NULL,
      NULL,
      meta_dbus_keyboard_monitor_signal_marshal_key_event,
      G_TYPE_NONE,
      5, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);

}

/**
 * meta_dbus_keyboard_monitor_emit_key_event:
 * @object: A #MetaDBusKeyboardMonitor.
 * @arg_released: Argument to pass with the signal.
 * @arg_state: Argument to pass with the signal.
 * @arg_keysym: Argument to pass with the signal.
 * @arg_unichar: Argument to pass with the signal.
 * @arg_keycode: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-a11y-KeyboardMonitor.KeyEvent">"KeyEvent"</link> D-Bus signal.
 */
void
meta_dbus_keyboard_monitor_emit_key_event (
    MetaDBusKeyboardMonitor *object,
    gboolean arg_released,
    guint arg_state,
    guint arg_keysym,
    guint arg_unichar,
    guint16 arg_keycode)
{
  g_signal_emit (object, META_DBUS__KEYBOARD_MONITOR_SIGNALS[META_DBUS__KEYBOARD_MONITOR_KEY_EVENT], 0, arg_released, arg_state, arg_keysym, arg_unichar, arg_keycode);
}

/**
 * meta_dbus_keyboard_monitor_call_grab_keyboard:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.GrabKeyboard">GrabKeyboard()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_keyboard_monitor_call_grab_keyboard_finish() to get the result of the operation.
 *
 * See meta_dbus_keyboard_monitor_call_grab_keyboard_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_keyboard_monitor_call_grab_keyboard (
    MetaDBusKeyboardMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GrabKeyboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_keyboard_monitor_call_grab_keyboard_finish:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_keyboard_monitor_call_grab_keyboard().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_keyboard_monitor_call_grab_keyboard().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_grab_keyboard_finish (
    MetaDBusKeyboardMonitor *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_grab_keyboard_sync:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.GrabKeyboard">GrabKeyboard()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_keyboard_monitor_call_grab_keyboard() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_grab_keyboard_sync (
    MetaDBusKeyboardMonitor *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GrabKeyboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_ungrab_keyboard:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.UngrabKeyboard">UngrabKeyboard()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_keyboard_monitor_call_ungrab_keyboard_finish() to get the result of the operation.
 *
 * See meta_dbus_keyboard_monitor_call_ungrab_keyboard_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_keyboard_monitor_call_ungrab_keyboard (
    MetaDBusKeyboardMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UngrabKeyboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_keyboard_monitor_call_ungrab_keyboard_finish:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_keyboard_monitor_call_ungrab_keyboard().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_keyboard_monitor_call_ungrab_keyboard().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_ungrab_keyboard_finish (
    MetaDBusKeyboardMonitor *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_ungrab_keyboard_sync:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.UngrabKeyboard">UngrabKeyboard()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_keyboard_monitor_call_ungrab_keyboard() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_ungrab_keyboard_sync (
    MetaDBusKeyboardMonitor *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UngrabKeyboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_watch_keyboard:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.WatchKeyboard">WatchKeyboard()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_keyboard_monitor_call_watch_keyboard_finish() to get the result of the operation.
 *
 * See meta_dbus_keyboard_monitor_call_watch_keyboard_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_keyboard_monitor_call_watch_keyboard (
    MetaDBusKeyboardMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "WatchKeyboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_keyboard_monitor_call_watch_keyboard_finish:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_keyboard_monitor_call_watch_keyboard().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_keyboard_monitor_call_watch_keyboard().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_watch_keyboard_finish (
    MetaDBusKeyboardMonitor *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_watch_keyboard_sync:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.WatchKeyboard">WatchKeyboard()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_keyboard_monitor_call_watch_keyboard() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_watch_keyboard_sync (
    MetaDBusKeyboardMonitor *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "WatchKeyboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_unwatch_keyboard:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.UnwatchKeyboard">UnwatchKeyboard()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_keyboard_monitor_call_unwatch_keyboard_finish() to get the result of the operation.
 *
 * See meta_dbus_keyboard_monitor_call_unwatch_keyboard_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_keyboard_monitor_call_unwatch_keyboard (
    MetaDBusKeyboardMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnwatchKeyboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_keyboard_monitor_call_unwatch_keyboard_finish:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_keyboard_monitor_call_unwatch_keyboard().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_keyboard_monitor_call_unwatch_keyboard().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_unwatch_keyboard_finish (
    MetaDBusKeyboardMonitor *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_unwatch_keyboard_sync:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.UnwatchKeyboard">UnwatchKeyboard()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_keyboard_monitor_call_unwatch_keyboard() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_unwatch_keyboard_sync (
    MetaDBusKeyboardMonitor *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnwatchKeyboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_set_key_grabs:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @arg_modifiers: Argument to pass with the method invocation.
 * @arg_keystrokes: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.SetKeyGrabs">SetKeyGrabs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_keyboard_monitor_call_set_key_grabs_finish() to get the result of the operation.
 *
 * See meta_dbus_keyboard_monitor_call_set_key_grabs_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_keyboard_monitor_call_set_key_grabs (
    MetaDBusKeyboardMonitor *proxy,
    GVariant *arg_modifiers,
    GVariant *arg_keystrokes,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetKeyGrabs",
    g_variant_new ("(@au@a(uu))",
                   arg_modifiers,
                   arg_keystrokes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_keyboard_monitor_call_set_key_grabs_finish:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_keyboard_monitor_call_set_key_grabs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_keyboard_monitor_call_set_key_grabs().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_set_key_grabs_finish (
    MetaDBusKeyboardMonitor *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_call_set_key_grabs_sync:
 * @proxy: A #MetaDBusKeyboardMonitorProxy.
 * @arg_modifiers: Argument to pass with the method invocation.
 * @arg_keystrokes: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.SetKeyGrabs">SetKeyGrabs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_keyboard_monitor_call_set_key_grabs() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_keyboard_monitor_call_set_key_grabs_sync (
    MetaDBusKeyboardMonitor *proxy,
    GVariant *arg_modifiers,
    GVariant *arg_keystrokes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetKeyGrabs",
    g_variant_new ("(@au@a(uu))",
                   arg_modifiers,
                   arg_keystrokes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_keyboard_monitor_complete_grab_keyboard:
 * @object: A #MetaDBusKeyboardMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.GrabKeyboard">GrabKeyboard()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_keyboard_monitor_complete_grab_keyboard (
    MetaDBusKeyboardMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_keyboard_monitor_complete_ungrab_keyboard:
 * @object: A #MetaDBusKeyboardMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.UngrabKeyboard">UngrabKeyboard()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_keyboard_monitor_complete_ungrab_keyboard (
    MetaDBusKeyboardMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_keyboard_monitor_complete_watch_keyboard:
 * @object: A #MetaDBusKeyboardMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.WatchKeyboard">WatchKeyboard()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_keyboard_monitor_complete_watch_keyboard (
    MetaDBusKeyboardMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_keyboard_monitor_complete_unwatch_keyboard:
 * @object: A #MetaDBusKeyboardMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.UnwatchKeyboard">UnwatchKeyboard()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_keyboard_monitor_complete_unwatch_keyboard (
    MetaDBusKeyboardMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_keyboard_monitor_complete_set_key_grabs:
 * @object: A #MetaDBusKeyboardMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-a11y-KeyboardMonitor.SetKeyGrabs">SetKeyGrabs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_keyboard_monitor_complete_set_key_grabs (
    MetaDBusKeyboardMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDBusKeyboardMonitorProxy:
 *
 * The #MetaDBusKeyboardMonitorProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusKeyboardMonitorProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusKeyboardMonitorProxy.
 */

struct _MetaDBusKeyboardMonitorProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_keyboard_monitor_proxy_iface_init (MetaDBusKeyboardMonitorIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusKeyboardMonitorProxy, meta_dbus_keyboard_monitor_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDBusKeyboardMonitorProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_KEYBOARD_MONITOR, meta_dbus_keyboard_monitor_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusKeyboardMonitorProxy, meta_dbus_keyboard_monitor_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_KEYBOARD_MONITOR, meta_dbus_keyboard_monitor_proxy_iface_init))

#endif
static void
meta_dbus_keyboard_monitor_proxy_finalize (GObject *object)
{
  MetaDBusKeyboardMonitorProxy *proxy = META_DBUS_KEYBOARD_MONITOR_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_keyboard_monitor_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_keyboard_monitor_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_keyboard_monitor_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_keyboard_monitor_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_keyboard_monitor_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_KEYBOARD_MONITOR);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_KEYBOARD_MONITOR);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_keyboard_monitor_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDBusKeyboardMonitorProxy *proxy = META_DBUS_KEYBOARD_MONITOR_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_keyboard_monitor_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_keyboard_monitor_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
meta_dbus_keyboard_monitor_proxy_init (MetaDBusKeyboardMonitorProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_keyboard_monitor_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_KEYBOARD_MONITOR_PROXY, MetaDBusKeyboardMonitorProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_keyboard_monitor_interface_info ());
}

static void
meta_dbus_keyboard_monitor_proxy_class_init (MetaDBusKeyboardMonitorProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_keyboard_monitor_proxy_finalize;
  gobject_class->get_property = meta_dbus_keyboard_monitor_proxy_get_property;
  gobject_class->set_property = meta_dbus_keyboard_monitor_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_keyboard_monitor_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_keyboard_monitor_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusKeyboardMonitorProxyPrivate));
#endif
}

static void
meta_dbus_keyboard_monitor_proxy_iface_init (MetaDBusKeyboardMonitorIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_keyboard_monitor_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-KeyboardMonitor.top_of_page">org.freedesktop.a11y.KeyboardMonitor</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_keyboard_monitor_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_keyboard_monitor_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_keyboard_monitor_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_KEYBOARD_MONITOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.a11y.KeyboardMonitor", NULL);
}

/**
 * meta_dbus_keyboard_monitor_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_keyboard_monitor_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_keyboard_monitor_proxy_new().
 *
 * Returns: (transfer full) (type MetaDBusKeyboardMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusKeyboardMonitor *
meta_dbus_keyboard_monitor_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_KEYBOARD_MONITOR (ret);
  else
    return NULL;
}

/**
 * meta_dbus_keyboard_monitor_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-KeyboardMonitor.top_of_page">org.freedesktop.a11y.KeyboardMonitor</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_keyboard_monitor_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusKeyboardMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusKeyboardMonitor *
meta_dbus_keyboard_monitor_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_KEYBOARD_MONITOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.a11y.KeyboardMonitor", NULL);
  if (ret != NULL)
    return META_DBUS_KEYBOARD_MONITOR (ret);
  else
    return NULL;
}


/**
 * meta_dbus_keyboard_monitor_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_keyboard_monitor_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_keyboard_monitor_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_keyboard_monitor_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_keyboard_monitor_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_KEYBOARD_MONITOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.a11y.KeyboardMonitor", NULL);
}

/**
 * meta_dbus_keyboard_monitor_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_keyboard_monitor_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_keyboard_monitor_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDBusKeyboardMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusKeyboardMonitor *
meta_dbus_keyboard_monitor_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_KEYBOARD_MONITOR (ret);
  else
    return NULL;
}

/**
 * meta_dbus_keyboard_monitor_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_keyboard_monitor_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_keyboard_monitor_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusKeyboardMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusKeyboardMonitor *
meta_dbus_keyboard_monitor_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_KEYBOARD_MONITOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.a11y.KeyboardMonitor", NULL);
  if (ret != NULL)
    return META_DBUS_KEYBOARD_MONITOR (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDBusKeyboardMonitorSkeleton:
 *
 * The #MetaDBusKeyboardMonitorSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusKeyboardMonitorSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusKeyboardMonitorSkeleton.
 */

struct _MetaDBusKeyboardMonitorSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_keyboard_monitor_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDBusKeyboardMonitorSkeleton *skeleton = META_DBUS_KEYBOARD_MONITOR_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_KEYBOARD_MONITOR);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_KEYBOARD_MONITOR);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_keyboard_monitor_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDBusKeyboardMonitorSkeleton *skeleton = META_DBUS_KEYBOARD_MONITOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_keyboard_monitor_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_keyboard_monitor_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDBusKeyboardMonitorSkeleton *skeleton = META_DBUS_KEYBOARD_MONITOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_keyboard_monitor_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_keyboard_monitor_skeleton_vtable =
{
  _meta_dbus_keyboard_monitor_skeleton_handle_method_call,
  _meta_dbus_keyboard_monitor_skeleton_handle_get_property,
  _meta_dbus_keyboard_monitor_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_keyboard_monitor_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_keyboard_monitor_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_keyboard_monitor_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_keyboard_monitor_skeleton_vtable;
}

static GVariant *
meta_dbus_keyboard_monitor_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusKeyboardMonitorSkeleton *skeleton = META_DBUS_KEYBOARD_MONITOR_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_meta_dbus_keyboard_monitor_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_keyboard_monitor_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_keyboard_monitor_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_keyboard_monitor_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.a11y.KeyboardMonitor", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
meta_dbus_keyboard_monitor_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_meta_dbus_keyboard_monitor_on_signal_key_event (
    MetaDBusKeyboardMonitor *object,
    gboolean arg_released,
    guint arg_state,
    guint arg_keysym,
    guint arg_unichar,
    guint16 arg_keycode)
{
  MetaDBusKeyboardMonitorSkeleton *skeleton = META_DBUS_KEYBOARD_MONITOR_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(buuuq)",
                   arg_released,
                   arg_state,
                   arg_keysym,
                   arg_unichar,
                   arg_keycode));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.a11y.KeyboardMonitor", "KeyEvent",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void meta_dbus_keyboard_monitor_skeleton_iface_init (MetaDBusKeyboardMonitorIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusKeyboardMonitorSkeleton, meta_dbus_keyboard_monitor_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDBusKeyboardMonitorSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_KEYBOARD_MONITOR, meta_dbus_keyboard_monitor_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusKeyboardMonitorSkeleton, meta_dbus_keyboard_monitor_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_KEYBOARD_MONITOR, meta_dbus_keyboard_monitor_skeleton_iface_init))

#endif
static void
meta_dbus_keyboard_monitor_skeleton_finalize (GObject *object)
{
  MetaDBusKeyboardMonitorSkeleton *skeleton = META_DBUS_KEYBOARD_MONITOR_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_keyboard_monitor_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_keyboard_monitor_skeleton_init (MetaDBusKeyboardMonitorSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_keyboard_monitor_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_KEYBOARD_MONITOR_SKELETON, MetaDBusKeyboardMonitorSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
meta_dbus_keyboard_monitor_skeleton_class_init (MetaDBusKeyboardMonitorSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_keyboard_monitor_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_keyboard_monitor_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_keyboard_monitor_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_keyboard_monitor_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_keyboard_monitor_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusKeyboardMonitorSkeletonPrivate));
#endif
}

static void
meta_dbus_keyboard_monitor_skeleton_iface_init (MetaDBusKeyboardMonitorIface *iface)
{
  iface->key_event = _meta_dbus_keyboard_monitor_on_signal_key_event;
}

/**
 * meta_dbus_keyboard_monitor_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-KeyboardMonitor.top_of_page">org.freedesktop.a11y.KeyboardMonitor</link>.
 *
 * Returns: (transfer full) (type MetaDBusKeyboardMonitorSkeleton): The skeleton object.
 */
MetaDBusKeyboardMonitor *
meta_dbus_keyboard_monitor_skeleton_new (void)
{
  return META_DBUS_KEYBOARD_MONITOR (g_object_new (META_DBUS_TYPE_KEYBOARD_MONITOR_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.a11y.PointerLocator
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDBusPointerLocator
 * @title: MetaDBusPointerLocator
 * @short_description: Generated C code for the org.freedesktop.a11y.PointerLocator D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-a11y-PointerLocator.top_of_page">org.freedesktop.a11y.PointerLocator</link> D-Bus interface in C.
 */

enum
{
  META_DBUS__POINTER_LOCATOR_POINTER_POSITION_CHANGED,
};

static unsigned META_DBUS__POINTER_LOCATOR_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.a11y.PointerLocator ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_pointer_locator_method_info_query_pointer_OUT_ARG_app_data =
{
  {
    -1,
    (gchar *) "app_data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_pointer_locator_method_info_query_pointer_OUT_ARG_rel_x =
{
  {
    -1,
    (gchar *) "rel_x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_pointer_locator_method_info_query_pointer_OUT_ARG_rel_y =
{
  {
    -1,
    (gchar *) "rel_y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_pointer_locator_method_info_query_pointer_OUT_ARG_pointers[] =
{
  &_meta_dbus_pointer_locator_method_info_query_pointer_OUT_ARG_app_data.parent_struct,
  &_meta_dbus_pointer_locator_method_info_query_pointer_OUT_ARG_rel_x.parent_struct,
  &_meta_dbus_pointer_locator_method_info_query_pointer_OUT_ARG_rel_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_pointer_locator_method_info_query_pointer =
{
  {
    -1,
    (gchar *) "QueryPointer",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_pointer_locator_method_info_query_pointer_OUT_ARG_pointers,
    NULL
  },
  "handle-query-pointer",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_pointer_locator_method_info_pointers[] =
{
  &_meta_dbus_pointer_locator_method_info_query_pointer.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_pointer_locator_signal_info_pointer_position_changed =
{
  {
    -1,
    (gchar *) "PointerPositionChanged",
    NULL,
    NULL
  },
  "pointer-position-changed"
};

static const GDBusSignalInfo * const _meta_dbus_pointer_locator_signal_info_pointers[] =
{
  &_meta_dbus_pointer_locator_signal_info_pointer_position_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_pointer_locator_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.a11y.PointerLocator",
    (GDBusMethodInfo **) &_meta_dbus_pointer_locator_method_info_pointers,
    (GDBusSignalInfo **) &_meta_dbus_pointer_locator_signal_info_pointers,
    NULL,
    NULL
  },
  "pointer-locator",
};


/**
 * meta_dbus_pointer_locator_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-a11y-PointerLocator.top_of_page">org.freedesktop.a11y.PointerLocator</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_pointer_locator_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_pointer_locator_interface_info.parent_struct;
}

/**
 * meta_dbus_pointer_locator_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDBusPointerLocator interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_pointer_locator_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
meta_dbus_pointer_locator_signal_marshal_pointer_position_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_pointer_locator_method_marshal_query_pointer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDBusPointerLocator:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-PointerLocator.top_of_page">org.freedesktop.a11y.PointerLocator</link>.
 */

/**
 * MetaDBusPointerLocatorIface:
 * @parent_iface: The parent interface.
 * @handle_query_pointer: Handler for the #MetaDBusPointerLocator::handle-query-pointer signal.
 * @pointer_position_changed: Handler for the #MetaDBusPointerLocator::pointer-position-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-PointerLocator.top_of_page">org.freedesktop.a11y.PointerLocator</link>.
 */

typedef MetaDBusPointerLocatorIface MetaDBusPointerLocatorInterface;
G_DEFINE_INTERFACE (MetaDBusPointerLocator, meta_dbus_pointer_locator, G_TYPE_OBJECT)

static void
meta_dbus_pointer_locator_default_init (MetaDBusPointerLocatorIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDBusPointerLocator::handle-query-pointer:
   * @object: A #MetaDBusPointerLocator.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-a11y-PointerLocator.QueryPointer">QueryPointer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_pointer_locator_complete_query_pointer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query-pointer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusPointerLocatorIface, handle_query_pointer),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_pointer_locator_method_marshal_query_pointer,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * MetaDBusPointerLocator::pointer-position-changed:
   * @object: A #MetaDBusPointerLocator.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-a11y-PointerLocator.PointerPositionChanged">"PointerPositionChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__POINTER_LOCATOR_SIGNALS[META_DBUS__POINTER_LOCATOR_POINTER_POSITION_CHANGED] =
    g_signal_new ("pointer-position-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusPointerLocatorIface, pointer_position_changed),
      NULL,
      NULL,
      meta_dbus_pointer_locator_signal_marshal_pointer_position_changed,
      G_TYPE_NONE,
      0);

}

/**
 * meta_dbus_pointer_locator_emit_pointer_position_changed:
 * @object: A #MetaDBusPointerLocator.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-a11y-PointerLocator.PointerPositionChanged">"PointerPositionChanged"</link> D-Bus signal.
 */
void
meta_dbus_pointer_locator_emit_pointer_position_changed (
    MetaDBusPointerLocator *object)
{
  g_signal_emit (object, META_DBUS__POINTER_LOCATOR_SIGNALS[META_DBUS__POINTER_LOCATOR_POINTER_POSITION_CHANGED], 0);
}

/**
 * meta_dbus_pointer_locator_call_query_pointer:
 * @proxy: A #MetaDBusPointerLocatorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-PointerLocator.QueryPointer">QueryPointer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_pointer_locator_call_query_pointer_finish() to get the result of the operation.
 *
 * See meta_dbus_pointer_locator_call_query_pointer_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_pointer_locator_call_query_pointer (
    MetaDBusPointerLocator *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueryPointer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_pointer_locator_call_query_pointer_finish:
 * @proxy: A #MetaDBusPointerLocatorProxy.
 * @out_app_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_rel_x: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_rel_y: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_pointer_locator_call_query_pointer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_pointer_locator_call_query_pointer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_pointer_locator_call_query_pointer_finish (
    MetaDBusPointerLocator *proxy,
    GVariant ** out_app_data,
    gdouble* out_rel_x,
    gdouble* out_rel_y,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv}dd)",
                 out_app_data,
                 out_rel_x,
                 out_rel_y);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_pointer_locator_call_query_pointer_sync:
 * @proxy: A #MetaDBusPointerLocatorProxy.
 * @out_app_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_rel_x: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_rel_y: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-a11y-PointerLocator.QueryPointer">QueryPointer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_pointer_locator_call_query_pointer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_pointer_locator_call_query_pointer_sync (
    MetaDBusPointerLocator *proxy,
    GVariant ** out_app_data,
    gdouble* out_rel_x,
    gdouble* out_rel_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueryPointer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv}dd)",
                 out_app_data,
                 out_rel_x,
                 out_rel_y);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_pointer_locator_complete_query_pointer:
 * @object: A #MetaDBusPointerLocator.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @app_data: Parameter to return.
 * @rel_x: Parameter to return.
 * @rel_y: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-a11y-PointerLocator.QueryPointer">QueryPointer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_pointer_locator_complete_query_pointer (
    MetaDBusPointerLocator *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *app_data,
    gdouble rel_x,
    gdouble rel_y)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv}dd)",
                   app_data,
                   rel_x,
                   rel_y));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDBusPointerLocatorProxy:
 *
 * The #MetaDBusPointerLocatorProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusPointerLocatorProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusPointerLocatorProxy.
 */

struct _MetaDBusPointerLocatorProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_pointer_locator_proxy_iface_init (MetaDBusPointerLocatorIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusPointerLocatorProxy, meta_dbus_pointer_locator_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDBusPointerLocatorProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_POINTER_LOCATOR, meta_dbus_pointer_locator_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusPointerLocatorProxy, meta_dbus_pointer_locator_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_POINTER_LOCATOR, meta_dbus_pointer_locator_proxy_iface_init))

#endif
static void
meta_dbus_pointer_locator_proxy_finalize (GObject *object)
{
  MetaDBusPointerLocatorProxy *proxy = META_DBUS_POINTER_LOCATOR_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_pointer_locator_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_pointer_locator_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_pointer_locator_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_pointer_locator_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_pointer_locator_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_POINTER_LOCATOR);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_POINTER_LOCATOR);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_pointer_locator_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDBusPointerLocatorProxy *proxy = META_DBUS_POINTER_LOCATOR_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_pointer_locator_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_pointer_locator_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
meta_dbus_pointer_locator_proxy_init (MetaDBusPointerLocatorProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_pointer_locator_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_POINTER_LOCATOR_PROXY, MetaDBusPointerLocatorProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_pointer_locator_interface_info ());
}

static void
meta_dbus_pointer_locator_proxy_class_init (MetaDBusPointerLocatorProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_pointer_locator_proxy_finalize;
  gobject_class->get_property = meta_dbus_pointer_locator_proxy_get_property;
  gobject_class->set_property = meta_dbus_pointer_locator_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_pointer_locator_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_pointer_locator_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusPointerLocatorProxyPrivate));
#endif
}

static void
meta_dbus_pointer_locator_proxy_iface_init (MetaDBusPointerLocatorIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_pointer_locator_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-PointerLocator.top_of_page">org.freedesktop.a11y.PointerLocator</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_pointer_locator_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_pointer_locator_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_pointer_locator_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_POINTER_LOCATOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.a11y.PointerLocator", NULL);
}

/**
 * meta_dbus_pointer_locator_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_pointer_locator_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_pointer_locator_proxy_new().
 *
 * Returns: (transfer full) (type MetaDBusPointerLocatorProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusPointerLocator *
meta_dbus_pointer_locator_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_POINTER_LOCATOR (ret);
  else
    return NULL;
}

/**
 * meta_dbus_pointer_locator_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-PointerLocator.top_of_page">org.freedesktop.a11y.PointerLocator</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_pointer_locator_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusPointerLocatorProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusPointerLocator *
meta_dbus_pointer_locator_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_POINTER_LOCATOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.a11y.PointerLocator", NULL);
  if (ret != NULL)
    return META_DBUS_POINTER_LOCATOR (ret);
  else
    return NULL;
}


/**
 * meta_dbus_pointer_locator_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_pointer_locator_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_pointer_locator_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_pointer_locator_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_pointer_locator_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_POINTER_LOCATOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.a11y.PointerLocator", NULL);
}

/**
 * meta_dbus_pointer_locator_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_pointer_locator_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_pointer_locator_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDBusPointerLocatorProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusPointerLocator *
meta_dbus_pointer_locator_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_POINTER_LOCATOR (ret);
  else
    return NULL;
}

/**
 * meta_dbus_pointer_locator_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_pointer_locator_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_pointer_locator_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusPointerLocatorProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusPointerLocator *
meta_dbus_pointer_locator_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_POINTER_LOCATOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.a11y.PointerLocator", NULL);
  if (ret != NULL)
    return META_DBUS_POINTER_LOCATOR (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDBusPointerLocatorSkeleton:
 *
 * The #MetaDBusPointerLocatorSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusPointerLocatorSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusPointerLocatorSkeleton.
 */

struct _MetaDBusPointerLocatorSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_pointer_locator_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDBusPointerLocatorSkeleton *skeleton = META_DBUS_POINTER_LOCATOR_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_POINTER_LOCATOR);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_POINTER_LOCATOR);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_pointer_locator_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDBusPointerLocatorSkeleton *skeleton = META_DBUS_POINTER_LOCATOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_pointer_locator_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_pointer_locator_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDBusPointerLocatorSkeleton *skeleton = META_DBUS_POINTER_LOCATOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_pointer_locator_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_pointer_locator_skeleton_vtable =
{
  _meta_dbus_pointer_locator_skeleton_handle_method_call,
  _meta_dbus_pointer_locator_skeleton_handle_get_property,
  _meta_dbus_pointer_locator_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_pointer_locator_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_pointer_locator_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_pointer_locator_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_pointer_locator_skeleton_vtable;
}

static GVariant *
meta_dbus_pointer_locator_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusPointerLocatorSkeleton *skeleton = META_DBUS_POINTER_LOCATOR_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_meta_dbus_pointer_locator_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_pointer_locator_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_pointer_locator_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_pointer_locator_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.a11y.PointerLocator", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
meta_dbus_pointer_locator_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_meta_dbus_pointer_locator_on_signal_pointer_position_changed (
    MetaDBusPointerLocator *object)
{
  MetaDBusPointerLocatorSkeleton *skeleton = META_DBUS_POINTER_LOCATOR_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.a11y.PointerLocator", "PointerPositionChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void meta_dbus_pointer_locator_skeleton_iface_init (MetaDBusPointerLocatorIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusPointerLocatorSkeleton, meta_dbus_pointer_locator_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDBusPointerLocatorSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_POINTER_LOCATOR, meta_dbus_pointer_locator_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusPointerLocatorSkeleton, meta_dbus_pointer_locator_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_POINTER_LOCATOR, meta_dbus_pointer_locator_skeleton_iface_init))

#endif
static void
meta_dbus_pointer_locator_skeleton_finalize (GObject *object)
{
  MetaDBusPointerLocatorSkeleton *skeleton = META_DBUS_POINTER_LOCATOR_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_pointer_locator_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_pointer_locator_skeleton_init (MetaDBusPointerLocatorSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_pointer_locator_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_POINTER_LOCATOR_SKELETON, MetaDBusPointerLocatorSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
meta_dbus_pointer_locator_skeleton_class_init (MetaDBusPointerLocatorSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_pointer_locator_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_pointer_locator_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_pointer_locator_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_pointer_locator_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_pointer_locator_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusPointerLocatorSkeletonPrivate));
#endif
}

static void
meta_dbus_pointer_locator_skeleton_iface_init (MetaDBusPointerLocatorIface *iface)
{
  iface->pointer_position_changed = _meta_dbus_pointer_locator_on_signal_pointer_position_changed;
}

/**
 * meta_dbus_pointer_locator_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-a11y-PointerLocator.top_of_page">org.freedesktop.a11y.PointerLocator</link>.
 *
 * Returns: (transfer full) (type MetaDBusPointerLocatorSkeleton): The skeleton object.
 */
MetaDBusPointerLocator *
meta_dbus_pointer_locator_skeleton_new (void)
{
  return META_DBUS_POINTER_LOCATOR (g_object_new (META_DBUS_TYPE_POINTER_LOCATOR_SKELETON, NULL));
}

