/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agui;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.agui.BaseEvent;

public class RunFinishedEvent
extends BaseEvent {
    public static final String TYPE = "RUN_FINISHED";
    private String threadId;
    private String runId;
    private Object result;

    public RunFinishedEvent(String threadId, String runId, Object result) {
        super(TYPE, System.currentTimeMillis(), null);
        this.threadId = threadId;
        this.runId = runId;
        this.result = result;
    }

    public RunFinishedEvent(StreamInput input) throws IOException {
        super(input);
        this.threadId = input.readString();
        this.runId = input.readString();
        if (input.readBoolean()) {
            this.result = input.readGenericValue();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.threadId);
        out.writeString(this.runId);
        if (this.result != null) {
            out.writeBoolean(true);
            out.writeGenericValue(this.result);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void addEventSpecificFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("threadId", this.threadId);
        builder.field("runId", this.runId);
        if (this.result != null) {
            builder.field("result", this.result);
        }
    }

    @Generated
    public String getThreadId() {
        return this.threadId;
    }

    @Generated
    public String getRunId() {
        return this.runId;
    }

    @Generated
    public Object getResult() {
        return this.result;
    }

    @Generated
    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    @Generated
    public void setRunId(String runId) {
        this.runId = runId;
    }

    @Generated
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    @Generated
    public String toString() {
        return "RunFinishedEvent(threadId=" + this.getThreadId() + ", runId=" + this.getRunId() + ", result=" + String.valueOf(this.getResult()) + ")";
    }

    @Generated
    public RunFinishedEvent() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunFinishedEvent)) {
            return false;
        }
        RunFinishedEvent other = (RunFinishedEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$threadId = this.getThreadId();
        String other$threadId = other.getThreadId();
        if (this$threadId == null ? other$threadId != null : !this$threadId.equals(other$threadId)) {
            return false;
        }
        String this$runId = this.getRunId();
        String other$runId = other.getRunId();
        if (this$runId == null ? other$runId != null : !this$runId.equals(other$runId)) {
            return false;
        }
        Object this$result = this.getResult();
        Object other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RunFinishedEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $threadId = this.getThreadId();
        result = result * 59 + ($threadId == null ? 43 : $threadId.hashCode());
        String $runId = this.getRunId();
        result = result * 59 + ($runId == null ? 43 : $runId.hashCode());
        Object $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }
}

