/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.implementation.ImplUtils;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class UrlSanitizer {
    private final Predicate<String> canLogQueryParam;

    public UrlSanitizer(Collection<String> allowedQueryParamNames) {
        if (CoreUtils.isNullOrEmpty(allowedQueryParamNames)) {
            this.canLogQueryParam = "api-version"::equalsIgnoreCase;
        } else {
            Set lowercasedAllowedQueryParamNames = allowedQueryParamNames.stream().map(queryParamName -> queryParamName.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            lowercasedAllowedQueryParamNames.add("api-version");
            this.canLogQueryParam = paramName -> lowercasedAllowedQueryParamNames.contains(paramName.toLowerCase(Locale.ROOT));
        }
    }

    public String getRedactedUrl(URL url) {
        String query = url.getQuery();
        if (CoreUtils.isNullOrEmpty(query)) {
            return url.toString();
        }
        UrlBuilder urlBuilder = ImplUtils.parseUrl(url, false);
        CoreUtils.parseQueryParameters(query).forEachRemaining(queryParam -> {
            if (this.canLogQueryParam.test((String)queryParam.getKey())) {
                urlBuilder.addQueryParameter((String)queryParam.getKey(), (String)queryParam.getValue());
            } else {
                urlBuilder.addQueryParameter((String)queryParam.getKey(), "REDACTED");
            }
        });
        return urlBuilder.toString();
    }
}

