/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.transport.TransportResponse;

public class InitializeExtensionResponse
extends TransportResponse {
    private String name;
    private List<String> implementedInterfaces;

    public InitializeExtensionResponse(String name, List<String> implementedInterfaces) {
        this.name = name;
        this.implementedInterfaces = implementedInterfaces;
    }

    public InitializeExtensionResponse(StreamInput in) throws IOException {
        this.name = in.readString();
        this.implementedInterfaces = Arrays.asList(in.readStringArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringArray(this.implementedInterfaces.toArray(new String[0]));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public String toString() {
        return "InitializeExtensionResponse{name = " + this.name + " , implementedInterfaces = " + String.valueOf(this.implementedInterfaces) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InitializeExtensionResponse that = (InitializeExtensionResponse)((Object)o);
        return Objects.equals(this.name, that.name) && Objects.equals(this.implementedInterfaces, that.implementedInterfaces);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.implementedInterfaces);
    }
}

