/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.AbstractHash;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.BitMixer;
import org.opensearch.common.util.LongArray;

public final class LongLongHash
extends AbstractHash {
    private LongArray keys;

    public LongLongHash(long capacity, BigArrays bigArrays) {
        this(capacity, 0.6f, bigArrays);
    }

    public LongLongHash(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        this.keys = bigArrays.newLongArray(2L * capacity, false);
    }

    public long getKey1(long id) {
        return this.keys.get(2L * id);
    }

    public long getKey2(long id) {
        return this.keys.get(2L * id + 1L);
    }

    public long find(long key1, long key2) {
        long slot;
        long index = slot = LongLongHash.slot(LongLongHash.hash(key1, key2), this.mask);
        while (true) {
            long id = this.id(index);
            long keyOffset = 2L * id;
            if (id == -1L || this.keys.get(keyOffset) == key1 && this.keys.get(keyOffset + 1L) == key2) {
                return id;
            }
            index = LongLongHash.nextSlot(index, this.mask);
        }
    }

    private long set(long key1, long key2, long id) {
        long slot;
        assert (this.size < this.maxSize);
        long index = slot = LongLongHash.slot(LongLongHash.hash(key1, key2), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) {
                this.id(index, id);
                this.append(id, key1, key2);
                ++this.size;
                return id;
            }
            long keyOffset = 2L * curId;
            if (this.keys.get(keyOffset) == key1 && this.keys.get(keyOffset + 1L) == key2) {
                return -1L - curId;
            }
            index = LongLongHash.nextSlot(index, this.mask);
        }
    }

    private void append(long id, long key1, long key2) {
        long keyOffset = 2L * id;
        this.keys = this.bigArrays.grow(this.keys, keyOffset + 2L);
        this.keys.set(keyOffset, key1);
        this.keys.set(keyOffset + 1L, key2);
    }

    private void reset(long key1, long key2, long id) {
        long slot;
        long index = slot = LongLongHash.slot(LongLongHash.hash(key1, key2), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) break;
            index = LongLongHash.nextSlot(index, this.mask);
        }
        this.id(index, id);
        this.append(id, key1, key2);
    }

    public long add(long key1, long key2) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key1, key2, this.size);
    }

    @Override
    protected void removeAndAdd(long index) {
        long id = this.id(index, -1L);
        assert (id >= 0L);
        long keyOffset = id * 2L;
        long key1 = this.keys.set(keyOffset, 0L);
        long key2 = this.keys.set(keyOffset + 1L, 0L);
        this.reset(key1, key2, id);
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.keys, () -> super.close()});
    }

    static long hash(long key1, long key2) {
        return 31 * BitMixer.mix((long)key1) + BitMixer.mix((long)key2);
    }
}

