<?php

declare(strict_types=1);

namespace Webauthn\CeremonyStep;

use Webauthn\AuthenticatorAssertionResponse;
use Webauthn\AuthenticatorAttestationResponse;
use Webauthn\Exception\AuthenticatorResponseVerificationException;
use Webauthn\PublicKeyCredentialCreationOptions;
use Webauthn\PublicKeyCredentialRequestOptions;
use Webauthn\PublicKeyCredentialSource;

final class CheckChallenge implements CeremonyStep
{
    public function process(
        PublicKeyCredentialSource $publicKeyCredentialSource,
        AuthenticatorAssertionResponse|AuthenticatorAttestationResponse $authenticatorResponse,
        PublicKeyCredentialRequestOptions|PublicKeyCredentialCreationOptions $publicKeyCredentialOptions,
        ?string $userHandle,
        string $host
    ): void {
        $publicKeyCredentialOptions->challenge !== '' || throw AuthenticatorResponseVerificationException::create(
            'Invalid challenge.'
        );
        hash_equals(
            $publicKeyCredentialOptions->challenge,
            $authenticatorResponse->clientDataJSON->challenge
        ) || throw AuthenticatorResponseVerificationException::create('Invalid challenge.');
    }
}
