/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jmol.awt.JmolFrame;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

public class DisplayPanel
extends JPanel
implements JmolFrame,
ComponentListener,
Printable {
    protected Viewer vwr;
    protected String displaySpeed;
    protected Dimension startupDim;
    protected boolean haveDisplay;
    protected JFrame frame;
    protected JmolPanel jmolPanel;
    protected boolean showPaintTime = true;
    protected final Dimension dimSize = new Dimension();
    protected final Rectangle rectClip = new Rectangle();
    public AbstractButton buttonRotate;
    public AbstractButton buttonModelkit;
    ButtonGroup toolbarButtonGroup = new ButtonGroup();
    protected HomeAction homeAction = new HomeAction();
    protected DefineCenterAction defineCenterAction = new DefineCenterAction();
    protected Action frontAction = new MoveToAction("front", "moveto 2.0 front");
    protected Action topAction = new MoveToAction("top", "moveto 1.0 front;moveto 2.0 top");
    protected Action bottomAction = new MoveToAction("bottom", "moveto 1.0 front;moveto 2.0 bottom");
    protected Action rightAction = new MoveToAction("right", "moveto 1.0 front;moveto 2.0 right");
    protected Action leftAction = new MoveToAction("left", "moveto 1.0 front;moveto 2.0 left");
    protected Action hydrogensAction = new CheckBoxMenuItemAction("hydrogensCheck", "set showHydrogens");
    protected Action measurementsAction = new CheckBoxMenuItemAction("measurementsCheck", "set showMeasurements");
    protected Action perspectiveAction = new CheckBoxMenuItemAction("perspectiveCheck", "set PerspectiveDepth");
    protected Action axesAction = new CheckBoxMenuItemAction("axesCheck", "set showAxes");
    protected Action boundboxAction = new CheckBoxMenuItemAction("boundboxCheck", "set showBoundBox");
    protected Action deleteAction = new SetStatusAction("delete", GT.$("Delete atoms"));
    protected Action zoomAction = new SetStatusAction("zoom", null);
    protected Action xlateAction = new SetStatusAction("xlate", null);
    protected static int timeLast = 0;
    protected static int timeCount;
    protected static int timeTotal;
    protected long timeBegin;
    protected int lastMotionEventNumber;

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    protected DisplayPanel(JmolPanel jmolPanel) {
        this.jmolPanel = jmolPanel;
        this.vwr = jmolPanel.vwr;
        this.frame = jmolPanel.frame;
        this.haveDisplay = jmolPanel.jmolApp.haveDisplay;
        this.startupDim = new Dimension(jmolPanel.startupWidth, jmolPanel.startupHeight);
        this.setMinimumSize(this.startupDim);
        this.setPreferredSize(this.startupDim);
        this.setMaximumSize(this.startupDim);
        this.setFocusable(true);
        if (System.getProperty("painttime", "false").equals("true")) {
            this.showPaintTime = true;
        }
        this.displaySpeed = System.getProperty("display.speed");
        if (this.displaySpeed == null) {
            this.displaySpeed = "ms";
        }
        this.setDoubleBuffered(false);
    }

    public void say(String msg) {
        this.jmolPanel.say(msg);
    }

    public void setViewer(Viewer vwr) {
        this.vwr = vwr;
        this.updateSize(false);
    }

    public void start() {
        this.addComponentListener(this);
    }

    boolean isRotateMode() {
        return this.buttonRotate != null && this.buttonRotate.isSelected();
    }

    void setRotateMode() {
        if (this.buttonRotate != null && !this.isRotateMode()) {
            this.buttonRotate.setSelected(true);
            this.vwr.setSelectionHalosEnabled(false);
        }
    }

    void setModelkitMode() {
        if (this.buttonModelkit != null) {
            this.buttonModelkit.setSelected(true);
        }
        this.vwr.setSelectionHalosEnabled(false);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateSize(true);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateSize(true);
    }

    protected void updateSize(boolean doAll) {
        if (this.haveDisplay) {
            this.getSize(this.dimSize);
            if (this.dimSize.width == 0) {
                return;
            }
            this.vwr.setScreenDimension(this.dimSize.width, this.dimSize.height);
        } else {
            this.vwr.setScreenDimension(this.startupDim.width, this.startupDim.height);
        }
        if (!doAll) {
            return;
        }
        this.setRotateMode();
        if (this.haveDisplay) {
            this.jmolPanel.setStatus(2, this.dimSize.width + " x " + this.dimSize.height);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.updateSize(false);
        if (this.dimSize.width == 0) {
            return;
        }
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        this.vwr.renderScreenImage((Object)g, this.dimSize.width, this.dimSize.height);
        if (this.showPaintTime) {
            this.stopPaintClock();
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        int pageHeight;
        float scaleHeight;
        float scale;
        Graphics2D g2 = (Graphics2D)g;
        if (pageIndex > 0) {
            return 1;
        }
        this.rectClip.y = 0;
        this.rectClip.x = 0;
        int screenWidth = this.rectClip.width = this.vwr.getScreenWidth();
        int screenHeight = this.rectClip.height = this.vwr.getScreenHeight();
        Object image = this.vwr.getScreenImage();
        int pageX = (int)pf.getImageableX();
        int pageY = (int)pf.getImageableY();
        int pageWidth = (int)pf.getImageableWidth();
        float scaleWidth = (float)pageWidth / (float)screenWidth;
        float f = scale = scaleWidth < (scaleHeight = (float)(pageHeight = (int)pf.getImageableHeight()) / (float)screenHeight) ? scaleWidth : scaleHeight;
        if (scale < 1.0f) {
            int width = (int)((float)screenWidth * scale);
            int height = (int)((float)screenHeight * scale);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage((Image)image, pageX, pageY, width, height, null);
        } else {
            g2.drawImage((Image)image, pageX, pageY, null);
        }
        this.vwr.releaseScreenImage();
        return 0;
    }

    public void addActions(List<Action> actions) {
        Action[] a = new Action[]{this.deleteAction, this.zoomAction, this.xlateAction, this.frontAction, this.topAction, this.bottomAction, this.rightAction, this.leftAction, this.defineCenterAction, this.hydrogensAction, this.measurementsAction, this.homeAction, this.perspectiveAction, this.axesAction, this.boundboxAction};
        actions.addAll(Arrays.asList(a));
    }

    protected void resetTimes() {
        timeTotal = 0;
        timeCount = 0;
        timeLast = -1;
    }

    protected void recordTime(int time) {
        if (timeLast != -1) {
            timeTotal += timeLast;
            ++timeCount;
        }
        timeLast = time;
    }

    protected void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int motionEventNumber = this.vwr.getMotionEventNumber();
        if (this.lastMotionEventNumber != motionEventNumber) {
            this.lastMotionEventNumber = motionEventNumber;
            this.resetTimes();
        }
    }

    protected void stopPaintClock() {
        int time = (int)(System.currentTimeMillis() - this.timeBegin);
        this.recordTime(time);
        this.showTimes();
    }

    protected String fmt(int num) {
        if (num < 0) {
            return "---";
        }
        if (num < 10) {
            return "  " + num;
        }
        if (num < 100) {
            return " " + num;
        }
        return "" + num;
    }

    protected void showTimes() {
        int timeAverage = timeCount == 0 ? -1 : (timeTotal + timeCount / 2) / timeCount;
        this.jmolPanel.setStatus(3, this.displaySpeed.equalsIgnoreCase("fps") ? this.fmt(1000 / timeLast) + "FPS : " + this.fmt(1000 / timeAverage) + "FPS" : this.vwr.getP("_memory") + " Mb; " + this.fmt(timeLast) + "/" + timeAverage + " ms");
    }

    public void setJmolSize(Dimension d) {
        this.dimSize.width = d.width;
        this.dimSize.height = d.height;
        this.setPreferredSize(d);
    }

    protected class CheckBoxMenuItemAction
    extends AbstractAction {
        protected final String action;

        public CheckBoxMenuItemAction(String name, String action) {
            super(name);
            this.action = action;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            DisplayPanel.this.vwr.evalStringQuiet(this.action + " " + cbmi.isSelected());
        }
    }

    class HomeAction
    extends AbstractAction {
        public HomeAction() {
            super("home");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.vwr.homePosition();
            DisplayPanel.this.setRotateMode();
        }
    }

    class DefineCenterAction
    extends AbstractAction {
        public DefineCenterAction() {
            super("definecenter");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.vwr.evalStringQuiet("center (selected)");
            DisplayPanel.this.setRotateMode();
        }
    }

    protected class MoveToAction
    extends AbstractAction {
        protected final String action;

        public MoveToAction(String name, String action) {
            super(name);
            this.action = action;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DisplayPanel.this.vwr.getShowBbcage() || DisplayPanel.this.vwr.getBooleanProperty("showUnitCell")) {
                DisplayPanel.this.vwr.evalStringQuiet(this.action);
            } else {
                DisplayPanel.this.vwr.evalStringQuiet("boundbox on;" + this.action + ";delay 1;boundbox off");
            }
        }
    }

    protected class SetStatusAction
    extends AbstractAction {
        protected final String statusText;

        public SetStatusAction(String name, String status) {
            super(name);
            this.statusText = status;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.vwr.setSelectionHalosEnabled(false);
            DisplayPanel.this.jmolPanel.setStatus(1, this.statusText == null ? ((JComponent)e.getSource()).getToolTipText() : this.statusText);
        }
    }
}

