import { EditorMode, QueryFormat } from './types.js';
import { createFunctionField, setGroupByField } from './utils/sql.utils.js';

function applyQueryDefaults(q) {
  let editorMode = (q == null ? undefined : q.editorMode) || EditorMode.Builder;
  if ((q == null ? undefined : q.editorMode) === undefined && (q == null ? undefined : q.rawSql) !== undefined) {
    editorMode = EditorMode.Code;
  }
  const result = {
    ...q,
    refId: (q == null ? undefined : q.refId) || "A",
    format: (q == null ? undefined : q.format) !== undefined ? q.format : QueryFormat.Table,
    rawSql: (q == null ? undefined : q.rawSql) || "",
    editorMode,
    sql: (q == null ? undefined : q.sql) || {
      columns: [createFunctionField()],
      groupBy: [setGroupByField()],
      limit: 50
    }
  };
  return result;
}

export { applyQueryDefaults };
//# sourceMappingURL=defaults.js.map
