---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: マージリクエストのレビューを使用して、コードをプロジェクトにマージする前に、コードについて話し合い、改善します。
title: マージリクエストのレビュー
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マージリクエストのレビュープロセスにより、専門家がマージ前に提案された変更をレビューすることが保証されます。レビュアーは、マージリクエストにレビューコメントを追加し、[変更を提案](suggestions.md)します。作成者は、GitLab UIから直接適用できます。

レビュアーは、次のいずれかのツールを使用してマージリクエストをレビューできます:

- GitLabユーザーインターフェース。
- Visual Studio Code（[VS Code用GitLab Workflow拡張機能](../../../../editor_extensions/visual_studio_code/_index.md)を使用）。
- ターミナルウィンドウと[GitLab CLI](../../../../editor_extensions/gitlab_cli/_index.md)。

承認は、マージリクエストが実際に準備ができたときにのみマージされるようにする、いくつかのマージチェックの1つです。プロジェクトの設定によっては、レビュアーが**変更の要求**を設定することにより、マージリクエストがマージされないようにブロックすることもできます。

GitLab PremiumとUltimateは、レビュアーを見つけるのに役立つ詳細情報が記載された**レビュアーをアサインする**ドロワーを提供します[承認ルール](#find-reviewers-who-fulfill-approval-rules)を満たすレビュアーを見つけるのに役立つ情報が記載されています:

![このマージリクエストには4つの承認が必要ですが、3つの承認要件が満たされていません。](img/reviewer_drawer_v18_2.png)

[定義されたレビューフロー](#start-a-review)に従うことで、各レビュアーはマージリクエストを受け入れるか拒否するかを決定します。右側のサイドバーには、レビュアーのリストと（レビューフローに従っている場合）レビューステータスが表示されます:

![さまざまなレビュー状態のレビュアーの例。](img/reviewer_list_v18_2.png)

- {{< icon name="dash-circle" >}}レビューはまだ開始されていません。
- {{< icon name="status_running" >}}レビューが進行中です。
- {{< icon name="check-circle" >}}レビュー済みで承認されました。
- {{< icon name="comment-lines" >}}レビュー済、変更を要求済、変更が行われるまで[このマージリクエストをブロックしました](#prevent-merge-when-you-request-changes)。このブロックは[バイパスできます](#prevent-merge-when-you-request-changes)。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>概要については、[マージリクエストのレビュー](https://www.youtube.com/watch?v=2MayfXKpU08&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=183)をご覧ください。
<!-- Video published on 2023-04-29 -->

## レビューするマージリクエストを見つける {#find-merge-requests-to-review}

[マージリクエストホームページ](../homepage.md)には、進行中のマージリクエストと、レビュアーからのレビューを待っているマージリクエストが表示されます。レビューが必要なマージリクエストは、**リクエストしたレビュー**カテゴリにあります。注意が必要なすべてのマージリクエストを表示するには、次のいずれかの方法を使用します:

- <kbd>Shift</kbd>+<kbd>m</kbd>の[キーボードショートカット](../../../shortcuts.md)を押します。
- 左側のサイドバーで、**マージリクエスト**（{{< icon name="merge-request">}}）を選択します。
- 左側のサイドバーで、**検索または移動先**を選択し、ドロップダウンリストから**現在作業中のマージリクエスト**を選択します。

## マージリクエストのレビュー状態を表示する {#view-the-review-status-of-a-merge-request}

これを行うには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択して、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. [マージリクエストウィジェット](../widgets.md)までスクロールして、マージリクエストのマージ可能性と承認状態を確認します。たとえば、必要な承認がない場合、このマージリクエストはブロックされます:

   ![マージリクエストウィジェットに「必要な承認はすべて付与されている必要があります」と表示されます。](img/reviews_missing_v17_3.png)

## レビューをリクエストする {#request-a-review}

{{< history >}}

- **レビュアーをアサインする**ドロワーは、GitLab 17.5で[フラグ](../../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/12878)されました`reviewer_assign_drawer`。
- GitLab 17.5のGitLab.comとGitLab Self-Managedでドロワーが[有効](https://gitlab.com/gitlab-org/gitlab/-/issues/467205)になりました。
- [機能フラグ](https://gitlab.com/gitlab-org/gitlab/-/issues/467205)`reviewer_assign_drawer`は、GitLab 17.8で削除されました。

{{< /history >}}

変更の準備が完了したら、レビューをリクエストします。マージリクエストにレビュアーを割り当てるには、テキストフィールドで`/assign_reviewer @user`[クイックアクション](../../quick_actions.md#issues-merge-requests-and-epics)を使用するか、以下を使用します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択して、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. 名前でレビュアーを見つけるには、右側のサイドバーの**レビュアー**セクションで**編集**を選択します。
1. GitLab PremiumとUltimateで承認ルールを満たすレビュアーを見つけるには、次のようにします:
   1. 右側のサイドバーの**レビュアー**セクションで**アサイン**を選択して、**レビュアーをアサインする**ドロワーを開きます。
   1. 承認ルールごとに、**編集**を選択して、その承認ルールを満たすレビュアーを見つけます。

GitLabは、マージリクエストをユーザーのレビューリクエストに追加します。

### 承認ルールを満たすレビュアーを見つける {#find-reviewers-who-fulfill-approval-rules}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLab PremiumとUltimateは、マージリクエストに最適なレビュアーをより迅速に見つけるのに役立ちます。**レビュアーをアサインする**ドロワーを使用して、レビュアーのリストをフィルタリングします。マージリクエストで変更されたファイルのコードオーナーと、プロジェクトの承認ルールを満たすユーザーを確認します。

この例では、マージリクエストには3つのコードオーナーの承認が必要ですが、これまでのところ承認はありません:

![3つのコードオーナーの承認を必要とするが、承認がないマージリクエストのレビュアーのアサインドロワー。コードオーナーのルールごとに1行、承認ルールごとに1行が表示されます。各ルールに対してレビュアーを選択できます。](img/select_good_reviewers_v17_5.png)

マージリクエストで対象となる承認者を割り当てるには、次のようにします:

1. **レビュアー**セクションで**アサイン**を選択します。
1. オプションの承認ルールまたはコードオーナーを表示するには、**Optional approval rules**（オプションの承認ルール）（{{< icon name="chevron-lg-up" >}}）を選択して表示します。
1. 必要なレビュアータイプの横にある**編集**を選択します:
   - **コードオーナー**には、そのファイルタイプのコードオーナーのみが表示されます。
   - **承認ルール**には、その承認ルールを満たすユーザーのみが表示されます。
1. 目的のレビュアーを選択します:（GitLab PremiumとUltimateでは、複数のレビュアーを選択できます。）
1. 必要な**コードオーナー**および**Approval rule**（承認ルール）項目ごとに繰り返します。
1. レビュアーを選択したら、右上にある**閉じる**（{{< icon name="close" >}}）を選択して、**レビュアーをアサインする**ドロワーを非表示にします。

### レビューを再リクエストする {#re-request-a-review}

レビュアーが[マージリクエストのレビュー](../../../discussions/_index.md)を完了した後、マージリクエストの作成者はレビュアーに新しいレビューを要求することができます。これを行うには、マージリクエストのテキストフィールドで`/request_review @user`クイックアクションを使用するか、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択して、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. マージリクエストで右側のサイドバーを折りたたんでいる場合は、{{< icon name="chevron-double-lg-left" >}} **Expand Sidebar**（サイドバーを展開）を選択して展開します。
1. **レビュアー**セクションで、レビュアーの名前の横にある**Re-request a review**（レビューを再リクエスト）アイコン（{{< icon name="redo" >}}）を選択します。

GitLabは、レビュアーの新しい[To Doアイテム](../../../todos.md)を作成し、通知メールを送信します。

## レビューを開始する {#start-a-review}

{{< history >}}

- **レビュアーをアサインする**ドロワーは、GitLab 17.11で[フラグ](../../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185795)されました`improved_review_experience`。デフォルトでは無効になっています。
- **レビュアーをアサインする**ドロワーは、GitLab 18.1で[デフォルトで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/535461)になっています。

{{< /history >}}

マージリクエストをレビューするときは、個々のコメントを残す代わりに、レビュープロセスに従ってください。**レビューを開始**を選択すると、右側のサイドバーの**レビュアー**セクションの状態が、**レビュー待ち**（{{< icon name="dash-circle">}}）から**レビュアーがレビューを開始**（{{< icon name="comment-dots">}}）に更新されます。

マージリクエストのレビューを開始するには、次のようにします:

1. 次のいずれかの操作を行います:
   - <kbd>Shift</kbd> + <kbd>r</kbd>を押して、**Review requests**（レビューリクエスト）ページに移動します。
   - 左側のサイドバーで、**マージリクエスト**（{{< icon name="merge-request" >}}）>**Review requests**（レビューリクエスト）を選択します。
<!-- When the feature flag paneled_view is removed, refer only to the button icon -->

1. マージリクエストを見つけ、マージリクエストのタイトルを選択して表示します。
1. マージリクエストの説明とコメントを読んで、マージリクエストについて学びます。
1. **変更**を選択して、提案された変更の差分を表示します。**変更**ページの詳細は、[マージリクエストの変更](../changes.md)をご覧ください。
1. 必要に応じて[複数行または1行の変更を提案](suggestions.md)します。最初のレビューコメントを保存する準備ができたら、**レビューを開始**を選択して、次のようにします:

   - 右側のサイドバーの状態を**レビュアーがレビューを開始**（{{< icon name="comment-dots">}}）に更新します。
   - 次のように、レビューコメントを保存しますが、公開せずにそのままにします:

     ![未公開の複数行のレビューコメントが「保留中」と表示されています。](img/pending_state_v18_1.png)

   **レビューを開始**する代わりに**今すぐコメントを追加**を選択すると、GitLabはすぐにコメントを公開します。

1. **変更**タブまたは**概要**タブでレビューコメントの書き込みを続行します。**レビューに追加する**を選択すると、レビューを送信するまで公開されません:

   ![新しいスレッド](img/mr_review_new_comment_v16_6.png)

次に、レビューを送信します。

### コメントでスレッドを解決するか、再開します {#resolve-or-reopen-thread-with-a-comment}

コメントは、コメントスレッドを解決するか、再開することもできます。コメントに返信する際にスレッドを解決するか、または未解決にするには:

1. コメントテキストエリアに、コメントを書き込みます。
1. **スレッドを解決にする**または**スレッドを再オープン**を選択またはクリアします。
1. **今すぐコメントを追加**または**レビューに追加する**を選択します。

保留中のコメントには、遅延したアクションに関する情報が表示されます。これらのアクションは、レビューを送信するときに実行されます。

## レビューを送信する {#submit-a-review}

{{< history >}}

- **承認する**を使用して保留中のレビューコメントを送信すると、GitLab 18.6で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/562579)。

{{< /history >}}

レビューを送信すると、GitLabは次のようになります:

- レビューのコメントを公開します。
- レビューコメントを添付して、マージリクエストのすべての通知可能なユーザーに1通のメールを送信します。このメールに返信すると、マージリクエストに新しいコメントが作成されます。
- レビューのコメントに追加したクイックアクションを実行します。
- レビューの結果を表示します。

マージリクエストのレビューをすばやく送信するには、次のようにします:

- マージリクエストウィジェットに移動し、**承認する**を選択します。マージリクエストも作成者によって承認されます。
- レビュー以外のコメントのテキストで、`/submit_review`[クイックアクション](../../quick_actions.md)を使用します。

レビューを送信するときに、レビューコメントを読んで編集するには、次のようにします:

1. 右上にある**あなたのレビュー**を選択して、レビューの詳細を表示します:

   ![進行中のレビューを示すレビュードロワー。単一行のレビューコメントと、2行のコード行にまたがるコメントが含まれています。](img/review_drawer_v18_3.png)

1. 保留中のコメントをレビューします。必要に応じて編集します。
1. レビューの結果を選択します。

   - **承認する**: フィードバックを残して、変更を承認します。
   - **コメント**: 明示的な承認または変更リクエストなしで、一般的なフィードバックを残します。
   - **変更の要求**: 作成者がフィードバックに対応するまで、マージリクエストがマージされないようにブロックします。

1. オプション。レビューの概要を作成します。GitLab PremiumおよびUltimateのユーザーは、**概要を追加する**（{{< icon name="tanuki-ai">}}）を選択して、概要を作成できます。実行するクイックアクションを追加します。

### 保留中のレビューを破棄します {#discard-your-pending-review}

レビューを破棄すると、未公開のコメントが削除され、復元できなくなります。これを行うには、次の手順に従います:

1. 右上にある**あなたのレビュー**を選択して、レビューの詳細を表示します:

   ![進行中のレビューを示すレビュードロワー。単一行のレビューコメントと、2行のコード行にまたがるコメントが含まれています。](img/review_drawer_v18_3.png)

1. **レビューを破棄**を選択します。

### 変更をリクエストするときにマージを防ぐ {#prevent-merge-when-you-request-changes}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.11で`mr_reviewer_requests_changes`[フラグ](../../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/430728)されました。デフォルトでは無効になっています。
- GitLab 17.2の[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/451211)および[GitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158226)でデフォルトで有効になりました。
- [機能フラグ](https://gitlab.com/gitlab-org/gitlab/-/issues/451211)は、GitLab 17.3で削除されました。

{{< /history >}}

[レビュアー](#submit-a-review)が変更をリクエストすると、マージリクエストはマージされなくなります。この場合、マージリクエストレポート領域には、**Change requests must be approved by the requesting user**（変更リクエストは、リクエストしているユーザーが承認する必要があります）というメッセージが表示されます。マージリクエストのブロックを解除するには、変更をリクエストしたレビュー担当者がマージリクエストを[再レビューして承認](#re-request-a-review)する必要があります。

### 変更リクエストを削除する {#remove-a-change-request}

{{< history >}}

- GitLab 17.8で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/480412)されました。

{{< /history >}}

以前に変更をリクエストした場合は、変更リクエストを削除できます。次の両方が当てはまる場合は、これが必要になる場合があります:

- マージリクエストを承認できなくなった。
- 変更リクエストをキャンセルしたいが、新しいレビューを送信したくない。

新しいレビューを送信せずに変更リクエストを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択して、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. マージリクエストの**概要**で、マージリクエストレポート領域までスクロールします。
1. **Change requests must be approved by the requesting user**（変更リクエストは、リクエストしているユーザーが承認する必要があります）の横にある**削除**を選択します:

   ![ユーザーが変更をリクエストしたためブロックされているマージリクエスト](img/remove_v17_8.png)

### 変更のリクエストをバイパスする {#bypass-a-request-for-changes}

変更をリクエストしたユーザーが再レビューまたは承認できない場合、マージリクエストをマージする権限を持つ別のユーザーがこのチェックを上書きできます:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択して、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. マージリクエストの**概要**で、マージリクエストレポート領域までスクロールします。
1. **Change requests must be approved by the requesting user**（変更リクエストは、リクエストしているユーザーが承認する必要があります）の横にある**バイパス**を選択します:

   ![ユーザーが変更をリクエストしたためブロックされているマージリクエスト](img/bypass_v17_2.png)

1. マージレポート領域に`Merge with caution: Override added`が表示されます。ユーザーがバイパスしたチェックを確認するには、**マージチェックを展開**（{{< icon name="chevron-lg-down" >}}）を選択し、警告（{{< icon name="status_warning" >}}）アイコンが含まれているチェックを見つけます。この例では、作成者は**Change requests must be approved by the requesting user**（変更リクエストは、リクエストしているユーザーが承認する必要があります）を回避するしました:

   ![このマージリクエストにはバイパスされたチェックが含まれており、注意してマージする必要があります。](img/status_warning_v17_4.png)

## マージリクエストの変更をダウンロードする {#download-merge-request-changes}

マージリクエストからの変更は、差分ファイルまたはパッチファイルとしてダウンロードできます。詳細と例については、[マージリクエストの変更をダウンロード](../changes.md#download-merge-request-changes)を参照してください。

## 関連機能 {#associated-features}

マージリクエストは、次の機能に関連しています:

- [Cherry-pickの変更](../cherry_pick_changes.md): GitLab UIで、マージされたマージリクエストまたはコミットで**cherry-pick**を選択して、cherry-pickします。
- [変更を比較](../changes.md): マージリクエストに含まれる変更の差分を表示およびダウンロードします。
- [早送りマージリクエスト](../methods/_index.md#fast-forward-merge): 線形Git履歴とマージコミットを作成せずにマージリクエストを受け入れる方法については
- [変更を導入したマージリクエストを見つける](../versions.md): コミット詳細ページを表示すると、GitLabはそのコミットを含むマージリクエストにリンクします。
- [マージリクエストバージョン](../versions.md): マージリクエストの差分の異なるバージョンを選択して比較する
- [競合の解決](../conflicts.md): GitLabは、GitLab UIで特定のマージリクエストの競合を解決するオプションを提供できます。
- [変更の取り消し](../revert_changes.md): マージリクエストから任意のコミットの変更を取り消します。
- [キーボードショートカット](../../../shortcuts.md#merge-requests): キーボードコマンドを使用して、マージリクエストの特定の部分にアクセスして変更します。
- [バリューストリーム分析](../../../group/value_stream_analytics/_index.md): 主要なマージリクエストの手順（`reviewed`や`approved`など）を追跡して、ソフトウェア開発ライフサイクルで最も時間が費やされている場所を特定します。この情報は、グループやプロジェクトのマージリクエストのワークフローを最適化し、全体的なデベロッパーの生産性を向上させるための、実行可能なインサイトを明らかにするのに役立ちます。[バリューストリーム分析でMRレビュー時間を削減した方法](https://about.gitlab.com/blog/2025/02/20/how-we-reduced-mr-review-time-with-value-stream-management/)について、詳しくはこちらをご覧ください。

## 関連トピック {#related-topics}

- [マージリクエストの変更の比較](../changes.md)
- [リビジョンを比較する](../../repository/compare_revisions.md)
- [マージ方法](../methods/_index.md)
- [ドラフトノートAPI](../../../../api/draft_notes.md)
