/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.transform.HyperbolicTransformer;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.MagnifyTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.MutableTransformerDecorator;
import org.jungrapht.visualization.transform.shape.HyperbolicShapeTransformer;
import org.jungrapht.visualization.transform.shape.MagnifyShapeTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensTransformSupport<V, E>
extends TransformSupport<V, E> {
    private static final Logger log = LoggerFactory.getLogger(LensTransformSupport.class);

    @Override
    public Point2D inverseTransform(VisualizationServer<V, E> vv, Point2D p) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        if (viewTransformer instanceof LensTransformer) {
            LensTransformer lensTransformer = (LensTransformer)viewTransformer;
            MutableTransformer delegateTransformer = lensTransformer.getDelegate();
            if (viewTransformer instanceof MagnifyShapeTransformer) {
                MagnifyTransformer ht = new MagnifyTransformer(lensTransformer.getLens(), layoutTransformer);
                p = delegateTransformer.inverseTransform(p);
                p = ht.inverseTransform(p);
            } else if (viewTransformer instanceof HyperbolicShapeTransformer) {
                LensTransformer ht = ((HyperbolicTransformer.Builder)HyperbolicTransformer.builder(lensTransformer.getLens()).delegate(layoutTransformer)).build();
                p = delegateTransformer.inverseTransform(p);
                p = ((HyperbolicTransformer)ht).inverseTransform(p);
            }
        } else {
            p = multiLayerTransformer.inverseTransform(p);
        }
        return p;
    }

    @Override
    public Shape transform(VisualizationServer<V, E> vv, Shape shape) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        VisualizationModel<V, E> model = vv.getVisualizationModel();
        if (viewTransformer instanceof LensTransformer) {
            shape = multiLayerTransformer.transform(shape);
        } else if (layoutTransformer instanceof LensTransformer) {
            LayoutModel<V> layoutModel = model.getLayoutModel();
            Dimension d = new Dimension(layoutModel.getWidth(), layoutModel.getHeight());
            HyperbolicTransformer shapeChanger = ((HyperbolicShapeTransformer.Builder)HyperbolicShapeTransformer.builder(d).delegate(viewTransformer)).build();
            LensTransformer lensTransformer = (LensTransformer)layoutTransformer;
            shapeChanger.getLens().setLensShape(lensTransformer.getLens().getLensShape());
            MutableTransformer layoutDelegate = ((MutableTransformerDecorator)layoutTransformer).getDelegate();
            shape = ((HyperbolicShapeTransformer)shapeChanger).transform(layoutDelegate.transform(shape));
        } else {
            shape = multiLayerTransformer.transform(MultiLayerTransformer.Layer.LAYOUT, shape);
        }
        return shape;
    }

    @Override
    public Shape transform(VisualizationServer<V, E> vv, Shape shape, MultiLayerTransformer.Layer layer) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        VisualizationModel<V, E> model = vv.getVisualizationModel();
        if (viewTransformer instanceof LensTransformer) {
            shape = multiLayerTransformer.transform(shape);
        } else if (layoutTransformer instanceof LensTransformer) {
            LayoutModel<V> layoutModel = model.getLayoutModel();
            Dimension d = new Dimension(layoutModel.getWidth(), layoutModel.getHeight());
            HyperbolicTransformer shapeChanger = ((HyperbolicShapeTransformer.Builder)HyperbolicShapeTransformer.builder(d).delegate(viewTransformer)).build();
            LensTransformer lensTransformer = (LensTransformer)layoutTransformer;
            shapeChanger.getLens().setLensShape(lensTransformer.getLens().getLensShape());
            MutableTransformer layoutDelegate = ((MutableTransformerDecorator)layoutTransformer).getDelegate();
            shape = ((HyperbolicShapeTransformer)shapeChanger).transform(layoutDelegate.transform(shape));
        } else {
            shape = super.transform(vv, shape, layer);
        }
        return shape;
    }

    @Override
    public Point2D transform(VisualizationServer<V, E> vv, Point2D p) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        VisualizationModel<V, E> model = vv.getVisualizationModel();
        if (viewTransformer instanceof LensTransformer) {
            p = multiLayerTransformer.transform(p);
        } else if (layoutTransformer instanceof LensTransformer) {
            LayoutModel<V> layoutModel = model.getLayoutModel();
            Dimension d = new Dimension(layoutModel.getWidth(), layoutModel.getHeight());
            HyperbolicTransformer shapeChanger = ((HyperbolicShapeTransformer.Builder)HyperbolicShapeTransformer.builder(d).delegate(viewTransformer)).build();
            LensTransformer lensTransformer = (LensTransformer)layoutTransformer;
            shapeChanger.getLens().setLensShape(lensTransformer.getLens().getLensShape());
            MutableTransformer layoutDelegate = ((MutableTransformerDecorator)layoutTransformer).getDelegate();
            p = shapeChanger.transform(layoutDelegate.transform(p));
        } else {
            p = multiLayerTransformer.transform(MultiLayerTransformer.Layer.LAYOUT, p);
        }
        return p;
    }

    @Override
    public Point2D transform(VisualizationServer<V, E> vv, Point2D p, MultiLayerTransformer.Layer layer) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        VisualizationModel<V, E> model = vv.getVisualizationModel();
        if (viewTransformer instanceof LensTransformer) {
            p = multiLayerTransformer.transform(p);
        } else if (layoutTransformer instanceof LensTransformer) {
            LayoutModel<V> layoutModel = model.getLayoutModel();
            Dimension d = new Dimension(layoutModel.getWidth(), layoutModel.getHeight());
            HyperbolicTransformer shapeChanger = ((HyperbolicShapeTransformer.Builder)HyperbolicShapeTransformer.builder(d).delegate(viewTransformer)).build();
            LensTransformer lensTransformer = (LensTransformer)layoutTransformer;
            shapeChanger.getLens().setLensShape(lensTransformer.getLens().getLensShape());
            MutableTransformer layoutDelegate = ((MutableTransformerDecorator)layoutTransformer).getDelegate();
            p = shapeChanger.transform(layoutDelegate.transform(p));
        } else {
            p = multiLayerTransformer.transform(layer, p);
        }
        return p;
    }

    @Override
    public Shape inverseTransform(VisualizationServer<V, E> vv, Shape shape) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        if (layoutTransformer instanceof LensTransformer) {
            LayoutModel<V> layoutModel = vv.getVisualizationModel().getLayoutModel();
            Dimension d = new Dimension(layoutModel.getWidth(), layoutModel.getHeight());
            HyperbolicTransformer shapeChanger = ((HyperbolicShapeTransformer.Builder)HyperbolicShapeTransformer.builder(d).delegate(viewTransformer)).build();
            LensTransformer lensTransformer = (LensTransformer)layoutTransformer;
            shapeChanger.getLens().setLensShape(lensTransformer.getLens().getLensShape());
            MutableTransformer layoutDelegate = ((MutableTransformerDecorator)layoutTransformer).getDelegate();
            shape = layoutDelegate.inverseTransform(((HyperbolicShapeTransformer)shapeChanger).inverseTransform(shape));
        } else {
            shape = multiLayerTransformer.inverseTransform(shape);
        }
        return shape;
    }
}

