/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class TriageDump
implements StructConverter {
    public static final String NAME = "PAGEDUMP_TRIAGE";
    private int servicePackBuild;
    private long sizeOfDump;
    private int validOffset;
    private int contextOffset;
    private int exceptionOffset;
    private int mmOffset;
    private int unloadedDriversOffset;
    private int prcbOffset;
    private int processOffset;
    private int threadOffset;
    private int callStackOffset;
    private int callStackSize;
    private int driverListOffset;
    private int driverCount;
    private int stringPoolOffset;
    private int stringPoolSize;
    private int brokenDriverOffset;
    private int triageOptions;
    private long topOfStack;
    private int bStoreOffset;
    private int bStoreSize;
    private long bStoreLimit;
    private long dataPageAddress;
    private int dataPageOffset;
    private int dataPageSize;
    private int debuggerDataOffset;
    private int debuggerDataSize;
    private int dataBlocksOffset;
    private int dataBlocksCount;
    private DumpFileReader reader;
    private long index;
    private int psz;
    private boolean is32Bit;

    TriageDump(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.is32Bit = this.psz == 4;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setServicePackBuild(this.reader.readNextInt());
        this.setSizeOfDump(this.reader.readNextUnsignedInt());
        this.setValidOffset(this.reader.readNextInt());
        this.setContextOffset(this.reader.readNextInt());
        this.setExceptionOffset(this.reader.readNextInt());
        this.setMmOffset(this.reader.readNextInt());
        this.setUnloadedDriversOffset(this.reader.readNextInt());
        this.setPrcbOffset(this.reader.readNextInt());
        this.setProcessOffset(this.reader.readNextInt());
        this.setThreadOffset(this.reader.readNextInt());
        this.setCallStackOffset(this.reader.readNextInt());
        this.setCallStackSize(this.reader.readNextInt());
        this.setDriverListOffset(this.reader.readNextInt());
        this.setDriverCount(this.reader.readNextInt());
        this.setStringPoolOffset(this.reader.readNextInt());
        this.setStringPoolSize(this.reader.readNextInt());
        this.setBrokenDriverOffset(this.reader.readNextInt());
        this.setTriageOptions(this.reader.readNextInt());
        this.setTopOfStack(this.reader.readNextPointer());
        this.setBStoreOffset(this.reader.readNextInt());
        this.setBStoreSize(this.reader.readNextInt());
        this.setBStoreLimit(this.reader.readNextPointer());
        if (!this.is32Bit) {
            this.setDataPageAddress(this.reader.readNextLong());
            this.setDataPageOffset(this.reader.readNextInt());
            this.setDataPageSize(this.reader.readNextInt());
        }
        this.setDebuggerDataOffset(this.reader.readNextInt());
        this.setDebuggerDataSize(this.reader.readNextInt());
        this.setDataBlocksOffset(this.reader.readNextInt());
        this.setDataBlocksCount(this.reader.readNextInt());
    }

    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "ServicePackBuild", null);
        struct.add(DWORD, 4, "SizeOfDump", null);
        struct.add(DWORD, 4, "ValidOffset", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "ContextOffset", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "ExceptionOffset", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "MmOffset", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "UnloadedDriversOffset", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "PrcbOffset", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "ProcessOffset", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "ThreadOffset", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "CallStackOffset", null);
        struct.add(DWORD, 4, "CallStackSize", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "DriverListOffset", null);
        struct.add(DWORD, 4, "DriverCount", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "StringPoolOffset", null);
        struct.add(DWORD, 4, "StringPoolSize", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "BrokenDriverOffset", null);
        struct.add(DWORD, 4, "TriageOptions", null);
        struct.add(POINTER, this.psz, "TopOfStack", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "BStoreOffset", null);
        struct.add(DWORD, 4, "BStoreSize", null);
        struct.add(POINTER, this.psz, "BStoreLimit", null);
        if (!this.is32Bit) {
            struct.add(POINTER, this.psz, "DataPageAddress", null);
            struct.add((DataType)Pointer32DataType.dataType, 4, "DataPageOffset", null);
            struct.add(DWORD, 4, "DataPageSize", null);
        }
        struct.add((DataType)Pointer32DataType.dataType, 4, "DebuggerDataOffset", null);
        struct.add(DWORD, 4, "DebuggerDataSize", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "DataBlocksOffset", null);
        struct.add(DWORD, 4, "DataBlocksCount", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public int getServicePackBuild() {
        return this.servicePackBuild;
    }

    public void setServicePackBuild(int servicePackBuild) {
        this.servicePackBuild = servicePackBuild;
    }

    public long getSizeOfDump() {
        return this.sizeOfDump;
    }

    public void setSizeOfDump(long sizeOfDump) {
        this.sizeOfDump = sizeOfDump;
    }

    public int getValidOffset() {
        return this.validOffset;
    }

    public void setValidOffset(int validOffset) {
        this.validOffset = validOffset;
    }

    public int getContextOffset() {
        return this.contextOffset;
    }

    public void setContextOffset(int contextOffset) {
        this.contextOffset = contextOffset;
    }

    public int getExceptionOffset() {
        return this.exceptionOffset;
    }

    public void setExceptionOffset(int exceptionOffset) {
        this.exceptionOffset = exceptionOffset;
    }

    public int getMmOffset() {
        return this.mmOffset;
    }

    public void setMmOffset(int mmOffset) {
        this.mmOffset = mmOffset;
    }

    public int getUnloadedDriversOffset() {
        return this.unloadedDriversOffset;
    }

    public void setUnloadedDriversOffset(int unloadedDriversOffset) {
        this.unloadedDriversOffset = unloadedDriversOffset;
    }

    public int getPrcbOffset() {
        return this.prcbOffset;
    }

    public void setPrcbOffset(int prcbOffset) {
        this.prcbOffset = prcbOffset;
    }

    public int getProcessOffset() {
        return this.processOffset;
    }

    public void setProcessOffset(int processOffset) {
        this.processOffset = processOffset;
    }

    public int getThreadOffset() {
        return this.threadOffset;
    }

    public void setThreadOffset(int threadOffset) {
        this.threadOffset = threadOffset;
    }

    public int getCallStackOffset() {
        return this.callStackOffset;
    }

    public void setCallStackOffset(int callStackOffset) {
        this.callStackOffset = callStackOffset;
    }

    public int getCallStackSize() {
        return this.callStackSize;
    }

    public void setCallStackSize(int callStackSize) {
        this.callStackSize = callStackSize;
    }

    public int getDriverListOffset() {
        return this.driverListOffset;
    }

    public void setDriverListOffset(int driverListOffset) {
        this.driverListOffset = driverListOffset;
    }

    public int getDriverCount() {
        return this.driverCount;
    }

    public void setDriverCount(int driverCount) {
        this.driverCount = driverCount;
    }

    public int getStringPoolOffset() {
        return this.stringPoolOffset;
    }

    public void setStringPoolOffset(int stringPoolOffset) {
        this.stringPoolOffset = stringPoolOffset;
    }

    public int getStringPoolSize() {
        return this.stringPoolSize;
    }

    public void setStringPoolSize(int stringPoolSize) {
        this.stringPoolSize = stringPoolSize;
    }

    public int getBrokenDriverOffset() {
        return this.brokenDriverOffset;
    }

    public void setBrokenDriverOffset(int brokenDriverOffset) {
        this.brokenDriverOffset = brokenDriverOffset;
    }

    public int getTriageOptions() {
        return this.triageOptions;
    }

    public void setTriageOptions(int triageOptions) {
        this.triageOptions = triageOptions;
    }

    public long getTopOfStack() {
        return this.topOfStack;
    }

    public void setTopOfStack(long topOfStack) {
        this.topOfStack = topOfStack;
    }

    public int getDebuggerDataOffset() {
        return this.debuggerDataOffset;
    }

    public void setDebuggerDataOffset(int debuggerDataOffset) {
        this.debuggerDataOffset = debuggerDataOffset;
    }

    public int getDebuggerDataSize() {
        return this.debuggerDataSize;
    }

    public void setDebuggerDataSize(int debuggerDataSize) {
        this.debuggerDataSize = debuggerDataSize;
    }

    public int getDataBlocksOffset() {
        return this.dataBlocksOffset;
    }

    public void setDataBlocksOffset(int dataBlocksOffset) {
        this.dataBlocksOffset = dataBlocksOffset;
    }

    public int getDataBlocksCount() {
        return this.dataBlocksCount;
    }

    public void setDataBlocksCount(int dataBlocksCount) {
        this.dataBlocksCount = dataBlocksCount;
    }

    public int getBStoreOffset() {
        return this.bStoreOffset;
    }

    public void setBStoreOffset(int bStoreOffset) {
        this.bStoreOffset = bStoreOffset;
    }

    public int getBStoreSize() {
        return this.bStoreSize;
    }

    public void setBStoreSize(int bStoreSize) {
        this.bStoreSize = bStoreSize;
    }

    public long getBStoreLimit() {
        return this.bStoreLimit;
    }

    public void setBStoreLimit(long bStoreLimit) {
        this.bStoreLimit = bStoreLimit;
    }

    public long getDataPageAddress() {
        return this.dataPageAddress;
    }

    public void setDataPageAddress(long dataPageAddress) {
        this.dataPageAddress = dataPageAddress;
    }

    public int getDataPageOffset() {
        return this.dataPageOffset;
    }

    public void setDataPageOffset(int dataPageOffset) {
        this.dataPageOffset = dataPageOffset;
    }

    public int getDataPageSize() {
        return this.dataPageSize;
    }

    public void setDataPageSize(int dataPageSize) {
        this.dataPageSize = dataPageSize;
    }
}

