/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.EventType;
import java.util.BitSet;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class DomainObjectChangedEvent
extends EventObject
implements Iterable<DomainObjectChangeRecord> {
    private static final long serialVersionUID = 1L;
    private List<DomainObjectChangeRecord> subEvents;
    private BitSet eventBits = new BitSet(255);

    public DomainObjectChangedEvent(DomainObject src, List<DomainObjectChangeRecord> subEvents) {
        super(src);
        this.subEvents = subEvents;
        for (DomainObjectChangeRecord record : subEvents) {
            this.eventBits.set(record.getEventType().getId());
        }
    }

    public int numRecords() {
        return this.subEvents.size();
    }

    public boolean contains(EventType eventType) {
        return this.eventBits.get(eventType.getId());
    }

    public boolean contains(EventType ... types) {
        for (EventType eventType : types) {
            if (!this.eventBits.get(eventType.getId())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean containsEvent(EventType eventType) {
        return this.eventBits.get(eventType.getId());
    }

    public DomainObjectChangeRecord getChangeRecord(int i) {
        return this.subEvents.get(i);
    }

    @Override
    public Iterator<DomainObjectChangeRecord> iterator() {
        return this.subEvents.iterator();
    }

    public void forEach(EventType type, Consumer<DomainObjectChangeRecord> consumer) {
        if (!this.contains(type)) {
            return;
        }
        for (DomainObjectChangeRecord docr : this.subEvents) {
            if (docr.getEventType() != type) continue;
            consumer.accept(docr);
        }
    }

    public DomainObjectChangeRecord findFirst(EventType eventType) {
        for (DomainObjectChangeRecord docr : this.subEvents) {
            if (docr.getEventType() != eventType) continue;
            return docr;
        }
        return null;
    }
}

