/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.action.MenuData;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkedDomainFile;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;

public class ProjectDataSelectRealFileOrFolderAction
extends FrontendProjectTreeAction {
    private FrontEndPlugin plugin;

    public ProjectDataSelectRealFileOrFolderAction(FrontEndPlugin plugin, String group) {
        super("Select Real File or Folder", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Select Real File"}, group));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Select_Real_File_or_Folder"));
    }

    protected void actionPerformed(ProjectDataContext context) {
        boolean isFolder = false;
        try {
            String pathname;
            if (context.getFolderCount() == 1 && context.getFileCount() == 0) {
                DomainFolder folder = context.getSelectedFolders().get(0);
                if (!(folder instanceof LinkedDomainFolder)) {
                    return;
                }
                LinkedDomainFolder linkedFolder = (LinkedDomainFolder)folder;
                isFolder = true;
                pathname = linkedFolder.getRealFolder().getPathname();
            } else if (context.getFileCount() == 1 && context.getFolderCount() == 0) {
                DomainFile file = context.getSelectedFiles().get(0);
                if (!(file instanceof LinkedDomainFile)) {
                    return;
                }
                LinkedDomainFile linkedFile = (LinkedDomainFile)file;
                isFolder = false;
                pathname = linkedFile.getRealFile().getPathname();
            } else {
                return;
            }
            this.plugin.showInProjectTree(context.getProjectData(), pathname, isFolder);
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Linked Content Error", (Object)("Failed to resolve linked " + (isFolder ? "folder" : "file")), (Throwable)e);
            return;
        }
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataContext context) {
        boolean enabled = false;
        String contentType = "Content";
        if (context.getComponent() instanceof DataTree) {
            DomainFile file;
            if (context.getFolderCount() == 1 && context.getFileCount() == 0) {
                DomainFolder folder = context.getSelectedFolders().get(0);
                if (folder instanceof LinkedDomainFolder) {
                    contentType = "Folder";
                    enabled = true;
                }
            } else if (context.getFileCount() == 1 && context.getFolderCount() == 0 && (file = context.getSelectedFiles().get(0)) instanceof LinkedDomainFile) {
                contentType = "File";
                enabled = true;
            }
        }
        if (enabled) {
            this.setPopupMenuData(new MenuData(new String[]{"Select Real " + contentType}, this.getPopupMenuData().getMenuGroup()));
        }
        return enabled;
    }
}

