/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.plugin;

import docking.widgets.list.GComboBoxCellRenderer;
import ghidra.features.base.codecompare.model.FunctionComparisonModel;
import ghidra.features.base.codecompare.model.FunctionComparisonModelListener;
import ghidra.features.base.codecompare.panel.CodeComparisonView;
import ghidra.features.base.codecompare.panel.FunctionComparisonPanel;
import ghidra.features.base.codecompare.panel.FunctionComparisonState;
import ghidra.features.codecompare.plugin.FunctionComparisonProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.util.datastruct.Duo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class MultiFunctionComparisonPanel
extends FunctionComparisonPanel
implements FunctionComparisonModelListener {
    public static final String HELP_TOPIC = "FunctionComparison";
    private FunctionComparisonModel model;
    private Duo<JComboBox<Function>> comboBoxes;
    private Duo<ItemListener> comboListeners;

    public MultiFunctionComparisonPanel(FunctionComparisonProvider provider, PluginTool tool, FunctionComparisonModel model, FunctionComparisonState state) {
        super(tool, provider.getName(), state);
        this.model = model;
        model.addFunctionComparisonModelListener((FunctionComparisonModelListener)this);
        this.buildComboPanels();
        this.getComparisonView().forEach(p -> p.setShowDataTitles(false));
        this.setPreferredSize(new Dimension(1200, 600));
        this.modelDataChanged();
    }

    public void activeFunctionChanged(Duo.Side side, Function function) {
        this.updateComboBoxSelectIfNeeded(side, function);
        this.loadFunctions(this.model.getActiveFunction(Duo.Side.LEFT), this.model.getActiveFunction(Duo.Side.RIGHT));
    }

    public void modelDataChanged() {
        this.intializeComboBox(Duo.Side.LEFT);
        this.intializeComboBox(Duo.Side.RIGHT);
        this.loadFunctions(this.model.getActiveFunction(Duo.Side.LEFT), this.model.getActiveFunction(Duo.Side.RIGHT));
    }

    public void dispose() {
        this.model.removeFunctionComparisonModelListener((FunctionComparisonModelListener)this);
        super.dispose();
    }

    Duo.Side getActiveSide() {
        CodeComparisonView currentComponent = this.getCurrentView();
        return currentComponent.getActiveSide();
    }

    boolean canCompareNextFunction() {
        Duo.Side activeSide = this.getActiveSide();
        JComboBox combo = (JComboBox)this.comboBoxes.get(activeSide);
        int index = combo.getSelectedIndex();
        return index < combo.getModel().getSize() - 1;
    }

    boolean canComparePreviousFunction() {
        Duo.Side activeSide = this.getActiveSide();
        JComboBox combo = (JComboBox)this.comboBoxes.get(activeSide);
        int index = combo.getSelectedIndex();
        return index > 0;
    }

    void compareNextFunction() {
        Duo.Side activeSide = this.getActiveSide();
        JComboBox combo = (JComboBox)this.comboBoxes.get(activeSide);
        int index = combo.getSelectedIndex();
        combo.setSelectedIndex(index + 1);
    }

    void comparePreviousFunction() {
        Duo.Side activeSide = this.getActiveSide();
        JComboBox combo = (JComboBox)this.comboBoxes.get(activeSide);
        int index = combo.getSelectedIndex();
        combo.setSelectedIndex(index - 1);
    }

    boolean canRemoveActiveFunction() {
        Duo.Side activeSide = this.getActiveSide();
        return this.model.getActiveFunction(activeSide) != null;
    }

    void removeActiveFunction() {
        Duo.Side activeSide = this.getActiveSide();
        this.model.removeFunction(this.model.getActiveFunction(activeSide));
    }

    private void buildComboPanels() {
        JPanel choicePanel = new JPanel(new GridLayout(1, 2));
        this.createComboBoxes();
        choicePanel.add(this.createPanel(Duo.Side.LEFT));
        choicePanel.add(this.createPanel(Duo.Side.RIGHT));
        this.add(choicePanel, "North");
    }

    private void intializeComboBox(Duo.Side side) {
        JComboBox comboBox = (JComboBox)this.comboBoxes.get(side);
        comboBox.removeItemListener((ItemListener)this.comboListeners.get(side));
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)comboBox.getModel();
        comboModel.removeAllElements();
        comboModel.addAll(this.model.getFunctions(side));
        Function activeFunction = this.model.getActiveFunction(side);
        if (activeFunction != null) {
            comboBox.setSelectedItem(activeFunction);
        }
        comboBox.addItemListener((ItemListener)this.comboListeners.get(side));
    }

    private void createComboBoxes() {
        this.createComboBoxListeners();
        JComboBox<Function> leftComboBox = this.buildComboBox(Duo.Side.LEFT);
        JComboBox<Function> rightComboBox = this.buildComboBox(Duo.Side.RIGHT);
        this.comboBoxes = new Duo(leftComboBox, rightComboBox);
    }

    private void createComboBoxListeners() {
        ItemListener leftListener = e -> this.comboChanged(e, Duo.Side.LEFT);
        ItemListener rightListener = e -> this.comboChanged(e, Duo.Side.RIGHT);
        this.comboListeners = new Duo((Object)leftListener, (Object)rightListener);
    }

    private void comboChanged(ItemEvent e, Duo.Side side) {
        if (e.getStateChange() == 2) {
            return;
        }
        this.model.setActiveFunction(side, (Function)e.getItem());
    }

    private JComboBox<Function> buildComboBox(Duo.Side side) {
        DefaultComboBoxModel leftModel = new DefaultComboBoxModel();
        JComboBox<Function> comboBox = new JComboBox<Function>(leftModel);
        comboBox.setName(String.valueOf(side) + "FunctionComboBox");
        comboBox.setRenderer((ListCellRenderer<Function>)((Object)new FunctionListCellRenderer()));
        comboBox.addItemListener((ItemListener)this.comboListeners.get(side));
        return comboBox;
    }

    private JPanel createPanel(Duo.Side side) {
        JPanel panel = new JPanel(new BorderLayout());
        JComboBox comboBox = (JComboBox)this.comboBoxes.get(side);
        panel.add((Component)comboBox, "Center");
        return panel;
    }

    private void updateComboBoxSelectIfNeeded(Duo.Side side, Function function) {
        JComboBox combo = (JComboBox)this.comboBoxes.get(side);
        if (combo.getSelectedItem() == function) {
            return;
        }
        combo.removeItemListener((ItemListener)this.comboListeners.get(side));
        combo.setSelectedItem(function);
        combo.addItemListener((ItemListener)this.comboListeners.get(side));
    }

    private class FunctionListCellRenderer
    extends GComboBoxCellRenderer<Object> {
        private FunctionListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            Function f = (Function)value;
            String functionName = f.getName();
            String functionPathToProgram = f.getProgram().getDomainFile().getPathname();
            Address functionAddress = f.getEntryPoint();
            String text = functionName + "@" + String.valueOf(functionAddress) + " (" + functionPathToProgram + ")";
            return super.getListCellRendererComponent(list, (Object)text, index, isSelected, cellHasFocus);
        }
    }
}

